/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.artifact.ArtifactManager;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.ml.MLCache;
import org.apache.spark.sql.connect.planner.PythonStreamingQueryListener;
import org.apache.spark.sql.connect.planner.StreamingForeachBatchHelper;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.ServerSideListenerHolder;
import org.apache.spark.sql.connect.service.SessionEventsManager;
import org.apache.spark.sql.connect.service.SessionHolder$;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SessionStatus;
import org.apache.spark.sql.connect.service.SessionStatus$Pending$;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.util.Clock;
import org.apache.spark.util.CollectionAccumulator;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.base.Ticker;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011%b\u0001\u0002*T\u0001\u0002D\u0001\u0002 \u0001\u0003\u0016\u0004%\t! \u0005\n\u0003\u001b\u0001!\u0011#Q\u0001\nyD\u0011\"a\u0004\u0001\u0005+\u0007I\u0011A?\t\u0013\u0005E\u0001A!E!\u0002\u0013q\bBCA\n\u0001\tU\r\u0011\"\u0001\u0002\u0016!Q\u00111\u0005\u0001\u0003\u0012\u0003\u0006I!a\u0006\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!Q\u00111\u0007\u0001\t\u0006\u0004%I!!\u000e\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0004\u0002CAA\u0001\u0001\u0006I!a\u001f\t\u0013\u0005\r\u0005\u00011A\u0005\n\u0005e\u0004\"CAC\u0001\u0001\u0007I\u0011BAD\u0011!\t\u0019\n\u0001Q!\n\u0005m\u0004\"CAO\u0001\u0001\u0007I\u0011BAP\u0011%\t\u0019\u000b\u0001a\u0001\n\u0013\t)\u000b\u0003\u0005\u0002*\u0002\u0001\u000b\u0015BAQ\u0011%\ti\u000b\u0001a\u0001\n\u0013\ty\nC\u0005\u00020\u0002\u0001\r\u0011\"\u0003\u00022\"A\u0011Q\u0017\u0001!B\u0013\t\t\u000bC\u0005\u0002:\u0002\u0011\r\u0011\"\u0003\u0002<\"A\u0011q\u001b\u0001!\u0002\u0013\ti\f\u0003\u0006\u0002Z\u0002\u0011\r\u0011\"\u0001V\u00037D\u0001\"!:\u0001A\u0003%\u0011Q\u001c\u0005\n\u0003O\u0004!\u0019!C\u0001\u0003SD\u0001\"!=\u0001A\u0003%\u00111\u001e\u0005\f\u0003g\u0004\u0001R1A\u0005\u0002e\u000b)\u0010C\u0006\u0003\u0016\u0001A)\u0019!C\u0001+\n]\u0001B\u0003B\u0013\u0001!\u0015\r\u0011\"\u0003\u0003(!Y!q\u0007\u0001\t\u0006\u0004%\t!\u0016B\u001d\u0011-\u0011y\u0005\u0001EC\u0002\u0013\u0005QK!\u0015\t\u000f\te\u0003\u0001\"\u0001\u0003\\!1!1\r\u0001\u0005\u0002uD\u0001B!\u001a\u0001\t\u0003\u0019&q\r\u0005\t\u0005[\u0002A\u0011A*\u0003p!A!1\u000f\u0001\u0005\u0002M\u0013)\b\u0003\u0005\u0003~\u0001!\ta\u0015B@\u0011!\u0011)\t\u0001C\u0001'\n\u001d\u0005\u0002\u0003BF\u0001\u0011\u0005QK!$\t\u0011\tm\u0005\u0001\"\u0001V\u0005;CqA!0\u0001\t\u0003\u0011y\f\u0003\u0005\u0003N\u0002!\t!\u0016Bh\u0011!\u0011\t\u000e\u0001C\u0001+\nM\u0007\u0002\u0003Bm\u0001\u0011\u0005QKa4\t\u0011\tm\u0007\u0001\"\u0001V\u0005\u001fDqA!8\u0001\t\u0003\u0011y\u000eC\u0004\u0004\u0004\u0001!\ta!\u0002\t\u0011\r5\u0001\u0001\"\u0001V\u0007\u001fA\u0001b!\u0007\u0001\t\u0003)61\u0004\u0005\t\u0007?\u0001A\u0011A+\u0004\"!A1Q\u0005\u0001\u0005\u0002U\u001b9\u0003\u0003\u0005\u00042\u0001!\t!VB\u001a\u0011!\u0019I\u0004\u0001C\u0001+\u000em\u0002bBB \u0001\u0011%!q\u001a\u0005\t\u0007\u0003\u0002A\u0011A+\u0003v!Q11\t\u0001C\u0002\u0013\u0005Qk!\u0012\t\u0011\r\u001d\u0004\u0001)A\u0005\u0007\u000fB\u0001b!\u001b\u0001\t\u0003)61\u000e\u0005\t\u0007{\u0002A\u0011A*\u00026!I1q\u0010\u0001\u0002\u0002\u0013\u00051\u0011\u0011\u0005\n\u0007\u0013\u0003\u0011\u0013!C\u0001\u0007\u0017C\u0011b!)\u0001#\u0003%\taa#\t\u0013\r\r\u0006!%A\u0005\u0002\r\u0015\u0006\"CBU\u0001\u0005\u0005I\u0011IBV\u0011%\u0019\t\fAA\u0001\n\u0003\u0019\u0019\fC\u0005\u0004<\u0002\t\t\u0011\"\u0001\u0004>\"I1\u0011\u0019\u0001\u0002\u0002\u0013\u000531\u0019\u0005\n\u0007#\u0004\u0011\u0011!C\u0001\u0007'D\u0011ba6\u0001\u0003\u0003%\te!7\t\u0013\ru\u0007!!A\u0005B\r}\u0007\"CBq\u0001\u0005\u0005I\u0011IBr\u0011%\u0019)\u000fAA\u0001\n\u0003\u001a9oB\u0004\u0004lNC\ta!<\u0007\rI\u001b\u0006\u0012ABx\u0011\u001d\t)#\u0013C\u0001\u0007wD\u0011b!@J\u0005\u0004%Iaa-\t\u0011\r}\u0018\n)A\u0005\u0007kC\u0011\u0002\"\u0001J\u0005\u0004%Iaa-\t\u0011\u0011\r\u0011\n)A\u0005\u0007kC\u0011\u0002\"\u0002J\u0003\u0003%\t\tb\u0002\t\u0013\u0011=\u0011*!A\u0005\u0002\u0012E\u0001\"\u0003C\u0010\u0013\u0006\u0005I\u0011\u0002C\u0011\u00055\u0019Vm]:j_:Du\u000e\u001c3fe*\u0011A+V\u0001\bg\u0016\u0014h/[2f\u0015\t1v+A\u0004d_:tWm\u0019;\u000b\u0005aK\u0016aA:rY*\u0011!lW\u0001\u0006gB\f'o\u001b\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\tw-\u001c9\u0011\u0005\t,W\"A2\u000b\u0003\u0011\fQa]2bY\u0006L!AZ2\u0003\r\u0005s\u0017PU3g!\tA7.D\u0001j\u0015\tQ\u0017,\u0001\u0005j]R,'O\\1m\u0013\ta\u0017NA\u0004M_\u001e<\u0017N\\4\u0011\u0005\tt\u0017BA8d\u0005\u001d\u0001&o\u001c3vGR\u0004\"!]=\u000f\u0005I<hBA:w\u001b\u0005!(BA;`\u0003\u0019a$o\\8u}%\tA-\u0003\u0002yG\u00069\u0001/Y2lC\u001e,\u0017B\u0001>|\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tA8-\u0001\u0004vg\u0016\u0014\u0018\nZ\u000b\u0002}B\u0019q0a\u0002\u000f\t\u0005\u0005\u00111\u0001\t\u0003g\u000eL1!!\u0002d\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011QA2\u0002\u000fU\u001cXM]%eA\u0005I1/Z:tS>t\u0017\nZ\u0001\u000bg\u0016\u001c8/[8o\u0013\u0012\u0004\u0013aB:fgNLwN\\\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;9\u0016aB2mCN\u001c\u0018nY\u0005\u0005\u0003C\tYB\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}QA\u0011\u0011FA\u0017\u0003_\t\t\u0004E\u0002\u0002,\u0001i\u0011a\u0015\u0005\u0006y\u001e\u0001\rA \u0005\u0007\u0003\u001f9\u0001\u0019\u0001@\t\u000f\u0005Mq\u00011\u0001\u0002\u0018\u0005I\u0001\u000f\\1o\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003o\u0001RAYA\u001d\u0003{I1!a\u000fd\u0005\u0019y\u0005\u000f^5p]BA\u0011qHA)\u0003+\n\u0019'\u0004\u0002\u0002B)!\u00111IA#\u0003\u0015\u0019\u0017m\u00195f\u0015\u0011\t9%!\u0013\u0002\r\r|W.\\8o\u0015\u0011\tY%!\u0014\u0002\r\u001d|wn\u001a7f\u0015\t\ty%A\u0002d_6LA!a\u0015\u0002B\t)1)Y2iKB!\u0011qKA0\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013!\u00029s_R|'B\u0001,Z\u0013\u0011\t\t'!\u0017\u0003\u0011I+G.\u0019;j_:\u0004B!!\u001a\u0002t5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0004m_\u001eL7-\u00197\u000b\t\u00055\u0014qN\u0001\u0006a2\fgn\u001d\u0006\u0004\u0003c:\u0016\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005U\u0014q\r\u0002\f\u0019><\u0017nY1m!2\fg.A\u0006ti\u0006\u0014H\u000fV5nK6\u001bXCAA>!\r\u0011\u0017QP\u0005\u0004\u0003\u007f\u001a'\u0001\u0002'p]\u001e\fAb\u001d;beR$\u0016.\\3Ng\u0002\n\u0001\u0003\\1ti\u0006\u001b7-Z:t)&lW-T:\u0002)1\f7\u000f^!dG\u0016\u001c8\u000fV5nK6\u001bx\fJ3r)\u0011\tI)a$\u0011\u0007\t\fY)C\u0002\u0002\u000e\u000e\u0014A!\u00168ji\"I\u0011\u0011\u0013\u0007\u0002\u0002\u0003\u0007\u00111P\u0001\u0004q\u0012\n\u0014!\u00057bgR\f5mY3tgRKW.Z'tA!\u001aQ\"a&\u0011\u0007\t\fI*C\u0002\u0002\u001c\u000e\u0014\u0001B^8mCRLG.Z\u0001\rG2|7/\u001a3US6,Wj]\u000b\u0003\u0003C\u0003RAYA\u001d\u0003w\n\u0001c\u00197pg\u0016$G+[7f\u001bN|F%Z9\u0015\t\u0005%\u0015q\u0015\u0005\n\u0003#{\u0011\u0011!a\u0001\u0003C\u000bQb\u00197pg\u0016$G+[7f\u001bN\u0004\u0003f\u0001\t\u0002\u0018\u000692-^:u_6Le.Y2uSZ,G+[7f_V$Xj]\u0001\u001cGV\u001cHo\\7J]\u0006\u001cG/\u001b<f)&lWm\\;u\u001bN|F%Z9\u0015\t\u0005%\u00151\u0017\u0005\n\u0003#\u0013\u0012\u0011!a\u0001\u0003C\u000b\u0001dY;ti>l\u0017J\\1di&4X\rV5nK>,H/T:!Q\r\u0019\u0012qS\u0001\r_B,'/\u0019;j_:LEm]\u000b\u0003\u0003{\u0003r!a0\u0002Nz\f\t.\u0004\u0002\u0002B*!\u00111YAc\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u000f\fI-\u0001\u0003vi&d'BAAf\u0003\u0011Q\u0017M^1\n\t\u0005=\u0017\u0011\u0019\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0011\u0007\t\f\u0019.C\u0002\u0002V\u000e\u0014qAQ8pY\u0016\fg.A\u0007pa\u0016\u0014\u0018\r^5p]&#7\u000fI\u0001\u000fKJ\u0014xN]%e)>,%O]8s+\t\ti\u000eE\u0004\u0002@\u0005Ec0a8\u0011\u0007E\f\t/C\u0002\u0002dn\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0002\u001f\u0015\u0014(o\u001c:JIR{WI\u001d:pe\u0002\nA\"\u001a<f]Rl\u0015M\\1hKJ,\"!a;\u0011\t\u0005-\u0012Q^\u0005\u0004\u0003_\u001c&\u0001F*fgNLwN\\#wK:$8/T1oC\u001e,'/A\u0007fm\u0016tG/T1oC\u001e,'\u000fI\u0001\u000fI\u0006$\u0018M\u0012:b[\u0016\u001c\u0015m\u00195f+\t\t9\u0010E\u0004\u0002@\u00065g0!?\u0011\t\u0005m(q\u0002\b\u0005\u0003{\u0014iA\u0004\u0003\u0002\u0000\n-a\u0002\u0002B\u0001\u0005\u0013qAAa\u0001\u0003\b9\u00191O!\u0002\n\u0003yK!\u0001X/\n\u0005i[\u0016B\u0001-Z\u0013\tAx+\u0003\u0003\u0003\u0012\tM!!\u0003#bi\u00064%/Y7f\u0015\tAx+A\u0004nY\u000e\u000b7\r[3\u0016\u0005\te\u0001\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\u0007\t}Q+\u0001\u0002nY&!!1\u0005B\u000f\u0005\u001diEjQ1dQ\u0016\fQ\u0002\\5ti\u0016tWM]\"bG\",WC\u0001B\u0015!\u001d\ty,!4\u007f\u0005W\u0001BA!\f\u000345\u0011!q\u0006\u0006\u0004\u0005c9\u0016!C:ue\u0016\fW.\u001b8h\u0013\u0011\u0011)Da\f\u0003-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJ\fqe\u001d;sK\u0006l\u0017N\\4G_J,\u0017m\u00195CCR\u001c\u0007NU;o]\u0016\u00148\t\\3b]\u0016\u00148)Y2iKV\u0011!1\b\t\u0005\u0005{\u0011IE\u0004\u0003\u0003@\t\u0015SB\u0001B!\u0015\r\u0011\u0019%V\u0001\ba2\fgN\\3s\u0013\u0011\u00119E!\u0011\u00027M#(/Z1nS:<gi\u001c:fC\u000eD')\u0019;dQ\"+G\u000e]3s\u0013\u0011\u0011YE!\u0014\u0003\u0019\rcW-\u00198fe\u000e\u000b7\r[3\u000b\t\t\u001d#\u0011I\u0001\"gR\u0014X-Y7j]\u001e\u001cVM\u001d<feNLG-\u001a'jgR,g.\u001a:I_2$WM]\u000b\u0003\u0005'\u0002B!a\u000b\u0003V%\u0019!qK*\u00031M+'O^3s'&$W\rT5ti\u0016tWM\u001d%pY\u0012,'/A\u0002lKf,\"A!\u0018\u0011\t\u0005-\"qL\u0005\u0004\u0005C\u001a&AC*fgNLwN\\&fs\u0006y1/\u001a:wKJ\u001cVm]:j_:LE-\u0001\bbI\u0012|\u0005/\u001a:bi&|g.\u00133\u0015\t\u0005%%\u0011\u000e\u0005\u0007\u0005W\n\u0003\u0019\u0001@\u0002\u0017=\u0004XM]1uS>t\u0017\nZ\u0001\u0012e\u0016lwN^3Pa\u0016\u0014\u0018\r^5p]&#G\u0003BAE\u0005cBaAa\u001b#\u0001\u0004q\u0018\u0001D5oi\u0016\u0014(/\u001e9u\u00032dGC\u0001B<!\u0011\t(\u0011\u0010@\n\u0007\tm4PA\u0002TKF\fA\"\u001b8uKJ\u0014X\u000f\u001d;UC\u001e$BAa\u001e\u0003\u0002\"1!1\u0011\u0013A\u0002y\f1\u0001^1h\u0003IIg\u000e^3seV\u0004Ho\u00149fe\u0006$\u0018n\u001c8\u0015\t\t]$\u0011\u0012\u0005\u0007\u0005W*\u0003\u0019\u0001@\u0002\u001f\u0005\u0014H/\u001b4bGRl\u0015M\\1hKJ,\"Aa$\u0011\t\tE%qS\u0007\u0003\u0005'S1A!&X\u0003!\t'\u000f^5gC\u000e$\u0018\u0002\u0002BM\u0005'\u0013q\"\u0011:uS\u001a\f7\r^'b]\u0006<WM]\u0001\fC\u0012$\u0017I\u001d;jM\u0006\u001cG\u000f\u0006\u0005\u0002\n\n}%1\u0017B\\\u0011\u001d\u0011\tk\na\u0001\u0005G\u000b!C]3n_R,'+\u001a7bi&4X\rU1uQB!!Q\u0015BX\u001b\t\u00119K\u0003\u0003\u0003*\n-\u0016\u0001\u00024jY\u0016TAA!,\u0002J\u0006\u0019a.[8\n\t\tE&q\u0015\u0002\u0005!\u0006$\b\u000eC\u0004\u00036\u001e\u0002\rAa)\u0002-M,'O^3s\u0019>\u001c\u0017\r\\*uC\u001eLgn\u001a)bi\"DqA!/(\u0001\u0004\u0011Y,\u0001\u0005ge\u0006<W.\u001a8u!\u0011\u0011\u0017\u0011\b@\u0002\u0017\rd\u0017m]:m_\u0006$WM]\u000b\u0003\u0005\u0003\u0004BAa1\u0003J6\u0011!Q\u0019\u0006\u0005\u0005\u000f\fI-\u0001\u0003mC:<\u0017\u0002\u0002Bf\u0005\u000b\u00141b\u00117bgNdu.\u00193fe\u0006\u0001R\u000f\u001d3bi\u0016\f5mY3tgRKW.\u001a\u000b\u0003\u0003\u0013\u000b!d]3u\u0007V\u001cHo\\7J]\u0006\u001cG/\u001b<f)&lWm\\;u\u001bN$B!!#\u0003V\"9!q\u001b\u0016A\u0002\u0005\u0005\u0016\u0001\u00068fo&s\u0017m\u0019;jm\u0016$\u0016.\\3pkRl5/A\tj]&$\u0018.\u00197ju\u0016\u001cVm]:j_:\fQa\u00197pg\u0016\f1b^5uQN+7o]5p]V!!\u0011\u001dBt)\u0011\u0011\u0019O!?\u0011\t\t\u0015(q\u001d\u0007\u0001\t\u001d\u0011I/\fb\u0001\u0005W\u0014\u0011\u0001V\t\u0005\u0005[\u0014\u0019\u0010E\u0002c\u0005_L1A!=d\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0019B{\u0013\r\u00119p\u0019\u0002\u0004\u0003:L\bb\u0002B~[\u0001\u0007!Q`\u0001\u0002MB9!Ma@\u0002\u0018\t\r\u0018bAB\u0001G\nIa)\u001e8di&|g.M\u0001\u0015O\u0016$8+Z:tS>t\u0007j\u001c7eKJLeNZ8\u0016\u0005\r\u001d\u0001\u0003BA\u0016\u0007\u0013I1aa\u0003T\u0005E\u0019Vm]:j_:Du\u000e\u001c3fe&sgm\\\u0001\u0013G\u0006\u001c\u0007.\u001a#bi\u00064%/Y7f\u0005fLE\r\u0006\u0004\u0002\n\u000eE1Q\u0003\u0005\u0007\u0007'y\u0003\u0019\u0001@\u0002\t\u00114\u0017\n\u001a\u0005\b\u0007/y\u0003\u0019AA}\u0003\t!g-A\nhKR$\u0015\r^1Ge\u0006lWm\u0014:UQJ|w\u000f\u0006\u0003\u0002z\u000eu\u0001BBB\na\u0001\u0007a0A\u000bsK6|g/Z\"bG\",G\rR1uC\u001a\u0013\u0018-\\3\u0015\t\u0005e81\u0005\u0005\u0007\u0007'\t\u0004\u0019\u0001@\u0002#\r\f7\r[3MSN$XM\\3s\u0005fLE\r\u0006\u0004\u0002\n\u000e%2Q\u0006\u0005\u0007\u0007W\u0011\u0004\u0019\u0001@\u0002\u0005%$\u0007bBB\u0018e\u0001\u0007!1F\u0001\tY&\u001cH/\u001a8fe\u0006Yq-\u001a;MSN$XM\\3s)\u0011\u0019)da\u000e\u0011\u000b\t\fIDa\u000b\t\r\r-2\u00071\u0001\u007f\u0003Q\u0011X-\\8wK\u000e\u000b7\r[3e\u0019&\u001cH/\u001a8feR!\u0011\u0011RB\u001f\u0011\u0019\u0019Y\u0003\u000ea\u0001}\u0006\u0011\"/Z7pm\u0016\fE\u000e\u001c'jgR,g.\u001a:t\u0003=a\u0017n\u001d;MSN$XM\\3s\u0013\u0012\u001c\u0018!\u00059zi\"|g.Q2dk6,H.\u0019;peV\u00111q\t\t\u0006E\u0006e2\u0011\n\t\u0005\u0007\u0017\u001a\tG\u0004\u0003\u0004N\rmc\u0002BB(\u0007+rA!a@\u0004R%\u001911K-\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0004X\re\u0013A\u00029zi\"|gNC\u0002\u0004TeKAa!\u0018\u0004`\u0005q\u0001+\u001f;i_:4UO\\2uS>t'\u0002BB,\u00073JAaa\u0019\u0004f\t\t\u0002+\u001f;i_:\f5mY;nk2\fGo\u001c:\u000b\t\ru3qL\u0001\u0013af$\bn\u001c8BG\u000e,X.\u001e7bi>\u0014\b%\u0001\u0007vg\u0016\u0004F.\u00198DC\u000eDW\r\u0006\u0004\u0004n\rU4\u0011\u0010\u000b\u0005\u0003G\u001ay\u0007C\u0004\u0004re\u0002\raa\u001d\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007c\u00022\u0003\u0000\u0006U\u00131\r\u0005\b\u0007oJ\u0004\u0019AA+\u0003\r\u0011X\r\u001c\u0005\b\u0007wJ\u0004\u0019AAi\u0003%\u0019\u0017m\u00195f!2\fg.\u0001\u0007hKR\u0004F.\u00198DC\u000eDW-\u0001\u0003d_BLH\u0003CA\u0015\u0007\u0007\u001b)ia\"\t\u000fq\\\u0004\u0013!a\u0001}\"A\u0011qB\u001e\u0011\u0002\u0003\u0007a\u0010C\u0005\u0002\u0014m\u0002\n\u00111\u0001\u0002\u0018\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCABGU\rq8qR\u0016\u0003\u0007#\u0003Baa%\u0004\u001e6\u00111Q\u0013\u0006\u0005\u0007/\u001bI*A\u0005v]\u000eDWmY6fI*\u001911T2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004 \u000eU%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0007OSC!a\u0006\u0004\u0010\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"a!,\u0011\t\t\r7qV\u0005\u0005\u0003\u0013\u0011)-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00046B\u0019!ma.\n\u0007\re6MA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003t\u000e}\u0006\"CAI\u0003\u0006\u0005\t\u0019AB[\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCABc!\u0019\u00199m!4\u0003t6\u00111\u0011\u001a\u0006\u0004\u0007\u0017\u001c\u0017AC2pY2,7\r^5p]&!1qZBe\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E7Q\u001b\u0005\n\u0003#\u001b\u0015\u0011!a\u0001\u0005g\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!1QVBn\u0011%\t\t\nRA\u0001\u0002\u0004\u0019),\u0001\u0005iCND7i\u001c3f)\t\u0019),\u0001\u0005u_N#(/\u001b8h)\t\u0019i+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\u001cI\u000fC\u0005\u0002\u0012\u001e\u000b\t\u00111\u0001\u0003t\u0006i1+Z:tS>t\u0007j\u001c7eKJ\u00042!a\u000bJ'\u0011I\u0015m!=\u0011\t\rM8\u0011`\u0007\u0003\u0007kTAaa>\u0002J\u0006\u0011\u0011n\\\u0005\u0004u\u000eUHCABw\u0003A)%KU(S?\u000e\u000b5\tS#`'&SV)A\tF%J{%kX\"B\u0007\"+ulU%[\u000b\u0002\nq#\u0012*S\u001fJ{6)Q\"I\u000b~#\u0016*T#P+R{6+R\"\u00021\u0015\u0013&k\u0014*`\u0007\u0006\u001b\u0005*R0U\u00136+u*\u0016+`'\u0016\u001b\u0005%A\u0003baBd\u0017\u0010\u0006\u0005\u0002*\u0011%A1\u0002C\u0007\u0011\u0015ax\n1\u0001\u007f\u0011\u0019\tya\u0014a\u0001}\"9\u00111C(A\u0002\u0005]\u0011aB;oCB\u0004H.\u001f\u000b\u0005\t'!Y\u0002E\u0003c\u0003s!)\u0002E\u0004c\t/qh0a\u0006\n\u0007\u0011e1M\u0001\u0004UkBdWm\r\u0005\n\t;\u0001\u0016\u0011!a\u0001\u0003S\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t!\u0019\u0003\u0005\u0003\u0003D\u0012\u0015\u0012\u0002\u0002C\u0014\u0005\u000b\u0014aa\u00142kK\u000e$\b")
public class SessionHolder
implements Logging,
Product,
Serializable {
    private Option<Cache<Relation, LogicalPlan>> planCache;
    private ConcurrentMap<String, Dataset<Row>> dataFrameCache;
    private MLCache mlCache;
    private ConcurrentMap<String, StreamingQueryListener> listenerCache;
    private StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache;
    private ServerSideListenerHolder streamingServersideListenerHolder;
    private final String userId;
    private final String sessionId;
    private final org.apache.spark.sql.classic.SparkSession session;
    private final long startTimeMs;
    private volatile long lastAccessTimeMs;
    private volatile Option<Object> closedTimeMs;
    private volatile Option<Object> customInactiveTimeoutMs;
    private final ConcurrentMap<String, Object> operationIds;
    private final Cache<String, Throwable> errorIdToError;
    private final SessionEventsManager eventManager;
    private final Option<CollectionAccumulator<byte[]>> pythonAccumulator;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<Tuple3<String, String, org.apache.spark.sql.classic.SparkSession>> unapply(SessionHolder x$0) {
        return SessionHolder$.MODULE$.unapply(x$0);
    }

    public static SessionHolder apply(String userId, String sessionId, org.apache.spark.sql.classic.SparkSession session) {
        return SessionHolder$.MODULE$.apply(userId, sessionId, session);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String userId() {
        return this.userId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public org.apache.spark.sql.classic.SparkSession session() {
        return this.session;
    }

    private Option<Cache<Relation, LogicalPlan>> planCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Some some;
                if (BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE())) <= 0) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session plan cache is disabled due to non-positive cache size."}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" Current value of "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE().key()), new MDC((LogKey)LogKeys.CACHE_SIZE$.MODULE$, SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE()))})))));
                    some = None$.MODULE$;
                } else {
                    some = new Some(CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE()))).build());
                }
                this.planCache = some;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.planCache;
    }

    private Option<Cache<Relation, LogicalPlan>> planCache() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.planCache$lzycompute();
        }
        return this.planCache;
    }

    private long startTimeMs() {
        return this.startTimeMs;
    }

    private long lastAccessTimeMs() {
        return this.lastAccessTimeMs;
    }

    private void lastAccessTimeMs_$eq(long x$1) {
        this.lastAccessTimeMs = x$1;
    }

    private Option<Object> closedTimeMs() {
        return this.closedTimeMs;
    }

    private void closedTimeMs_$eq(Option<Object> x$1) {
        this.closedTimeMs = x$1;
    }

    private Option<Object> customInactiveTimeoutMs() {
        return this.customInactiveTimeoutMs;
    }

    private void customInactiveTimeoutMs_$eq(Option<Object> x$1) {
        this.customInactiveTimeoutMs = x$1;
    }

    private ConcurrentMap<String, Object> operationIds() {
        return this.operationIds;
    }

    public Cache<String, Throwable> errorIdToError() {
        return this.errorIdToError;
    }

    public SessionEventsManager eventManager() {
        return this.eventManager;
    }

    private ConcurrentMap<String, Dataset<Row>> dataFrameCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dataFrameCache = new ConcurrentHashMap<String, Dataset<Row>>();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataFrameCache;
    }

    public ConcurrentMap<String, Dataset<Row>> dataFrameCache() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataFrameCache$lzycompute();
        }
        return this.dataFrameCache;
    }

    private MLCache mlCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.mlCache = new MLCache();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.mlCache;
    }

    public MLCache mlCache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.mlCache$lzycompute();
        }
        return this.mlCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.listenerCache = new ConcurrentHashMap<String, StreamingQueryListener>();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.listenerCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.listenerCache$lzycompute();
        }
        return this.listenerCache;
    }

    private StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.streamingForeachBatchRunnerCleanerCache = new StreamingForeachBatchHelper.CleanerCache(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.streamingForeachBatchRunnerCleanerCache;
    }

    public StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.streamingForeachBatchRunnerCleanerCache$lzycompute();
        }
        return this.streamingForeachBatchRunnerCleanerCache;
    }

    private ServerSideListenerHolder streamingServersideListenerHolder$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.streamingServersideListenerHolder = new ServerSideListenerHolder(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.streamingServersideListenerHolder;
    }

    public ServerSideListenerHolder streamingServersideListenerHolder() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.streamingServersideListenerHolder$lzycompute();
        }
        return this.streamingServersideListenerHolder;
    }

    public SessionKey key() {
        return new SessionKey(this.userId(), this.sessionId());
    }

    public String serverSessionId() {
        if (Utils$.MODULE$.isTesting() && this.session() == null) {
            return "";
        }
        String string = this.session().sessionUUID();
        String string2 = this.sessionId();
        Predef$.MODULE$.assert(string == null ? string2 != null : !string.equals(string2));
        return this.session().sessionUUID();
    }

    public void addOperationId(String operationId) {
        if (this.closedTimeMs().isDefined()) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)this.sessionId())})));
        }
        boolean alreadyExists = BoxesRunTime.unboxToBoolean((Object)this.operationIds().putIfAbsent(operationId, BoxesRunTime.boxToBoolean((boolean)true)));
        if (alreadyExists) {
            throw new IllegalStateException("ExecuteHolder with opId=" + operationId + " already exists!");
        }
    }

    public void removeOperationId(String operationId) {
        this.operationIds().remove(operationId);
    }

    public Seq<String> interruptAll() {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        Seq<String> operationsIds = SparkConnectService$.MODULE$.streamingSessionManager().cleanupRunningQueries(this, false);
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.operationIds()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            SessionHolder.$anonfun$interruptAll$1(this, interruptedIds, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)interruptedIds.toSeq().$plus$plus(operationsIds);
    }

    public Seq<String> interruptTag(String tag) {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        Seq<SparkConnectStreamingQueryCache.QueryCacheValue> queries = SparkConnectService$.MODULE$.streamingSessionManager().getTaggedQuery(tag, (SparkSession)this.session());
        queries.foreach((Function1 & Serializable)q -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> q.query().stop(), (ExecutionContext)ExecutionContext$.MODULE$.global()));
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.operationIds()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            SessionHolder.$anonfun$interruptTag$3(this, tag, interruptedIds, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)interruptedIds.toSeq().$plus$plus((IterableOnce)queries.map((Function1 & Serializable)x$1 -> x$1.operationId()));
    }

    public Seq<String> interruptOperation(String operationId) {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        ExecuteKey executeKey = new ExecuteKey(this.userId(), this.sessionId(), operationId);
        SparkConnectService$.MODULE$.executionManager().getExecuteHolder(executeKey).foreach((Function1 & Serializable)executeHolder -> {
            if (executeHolder.interrupt()) {
                return interruptedIds.$plus$eq((Object)operationId);
            }
            return BoxedUnit.UNIT;
        });
        return interruptedIds.toSeq();
    }

    public ArtifactManager artifactManager() {
        return this.session().artifactManager();
    }

    public void addArtifact(Path remoteRelativePath, Path serverLocalStagingPath, Option<String> fragment) {
        ArtifactManager qual$1 = this.artifactManager();
        Path x$1 = remoteRelativePath;
        Path x$2 = serverLocalStagingPath;
        Option<String> x$3 = fragment;
        boolean x$4 = qual$1.addArtifact$default$4();
        qual$1.addArtifact(x$1, x$2, x$3, x$4);
    }

    public ClassLoader classloader() {
        return this.artifactManager().classloader();
    }

    public void updateAccessTime() {
        this.lastAccessTimeMs_$eq(System.currentTimeMillis());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session with userId: ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)this.userId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId: ", " accessed,"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)this.sessionId())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.LAST_ACCESS_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.lastAccessTimeMs()))})))));
    }

    public void setCustomInactiveTimeoutMs(Option<Object> newInactiveTimeoutMs) {
        this.customInactiveTimeoutMs_$eq(newInactiveTimeoutMs);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session with userId: ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)this.userId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId: ", " inactive timeout set to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)this.sessionId())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIMEOUT$.MODULE$, this.customInactiveTimeoutMs())})))));
    }

    public void initializeSession() {
        this.eventManager().postStarted();
    }

    public void close() {
        if (this.closedTimeMs().isDefined()) {
            throw new IllegalStateException("Session " + this.key() + " is already closed.");
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Closing session with userId: ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)this.userId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)this.sessionId())})))));
        this.closedTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        if (Utils$.MODULE$.isTesting()) {
            SessionStatus sessionStatus = this.eventManager().status();
            SessionStatus$Pending$ sessionStatus$Pending$ = SessionStatus$Pending$.MODULE$;
            if (!(sessionStatus != null ? !sessionStatus.equals(sessionStatus$Pending$) : sessionStatus$Pending$ != null)) {
                return;
            }
        }
        this.artifactManager().close();
        SparkConnectService$.MODULE$.streamingSessionManager().cleanupRunningQueries(this, true);
        this.streamingForeachBatchRunnerCleanerCache().cleanUpAll();
        this.removeAllListeners();
        if (this.streamingServersideListenerHolder().isServerSideListenerRegistered()) {
            this.streamingServersideListenerHolder().cleanUp();
        }
        SparkConnectService$.MODULE$.executionManager().removeAllExecutionsForSession(this.key());
        this.mlCache().clear();
        this.eventManager().postClosed();
    }

    public <T> T withSession(Function1<org.apache.spark.sql.classic.SparkSession, T> f) {
        return (T)this.artifactManager().withResources((Function0 & Serializable)() -> this.session().withActive((Function0 & Serializable)() -> f.apply((Object)this.session())));
    }

    public SessionHolderInfo getSessionHolderInfo() {
        String x$1 = this.userId();
        String x$2 = this.sessionId();
        String x$3 = this.serverSessionId();
        SessionStatus x$4 = this.eventManager().status();
        long x$5 = this.startTimeMs();
        long x$6 = this.lastAccessTimeMs();
        Option<Object> x$7 = this.customInactiveTimeoutMs();
        Option<Object> x$8 = this.closedTimeMs();
        return new SessionHolderInfo(x$1, x$2, x$3, x$4, x$7, x$5, x$6, x$8);
    }

    public void cacheDataFrameById(String dfId, Dataset<Row> df) {
        if (this.dataFrameCache().putIfAbsent(dfId, df) != null) {
            throw SparkException$.MODULE$.internalError("A dataframe is already associated with id " + dfId);
        }
    }

    public Dataset<Row> getDataFrameOrThrow(String dfId) {
        return (Dataset)Option$.MODULE$.apply(this.dataFrameCache().get(dfId)).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidPlanInput("No DataFrame with id " + dfId + " is found in the session " + this.sessionId(), InvalidPlanInput$.MODULE$.apply$default$2());
        });
    }

    public Dataset<Row> removeCachedDataFrame(String dfId) {
        return (Dataset)this.dataFrameCache().remove(dfId);
    }

    public void cacheListenerById(String id, StreamingQueryListener listener) {
        if (this.listenerCache().putIfAbsent(id, listener) != null) {
            throw SparkException$.MODULE$.internalError("A listener is already associated with id " + id);
        }
    }

    public Option<StreamingQueryListener> getListener(String id) {
        return Option$.MODULE$.apply(this.listenerCache().get(id));
    }

    public void removeCachedListener(String id) {
        Some some;
        StreamingQueryListener pyListener;
        Option option = Option$.MODULE$.apply(this.listenerCache().remove(id));
        if (option instanceof Some && (pyListener = (StreamingQueryListener)(some = (Some)option).value()) instanceof PythonStreamingQueryListener) {
            PythonStreamingQueryListener pythonStreamingQueryListener = (PythonStreamingQueryListener)pyListener;
            pythonStreamingQueryListener.stopListenerProcess();
            return;
        }
    }

    private void removeAllListeners() {
        this.listenerCache().forEach((id, listener) -> {
            this.session().streams().removeListener(listener);
            this.removeCachedListener((String)id);
        });
    }

    public Seq<String> listListenerIds() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.listenerCache().keySet()).asScala().toSeq();
    }

    public Option<CollectionAccumulator<byte[]>> pythonAccumulator() {
        return this.pythonAccumulator;
    }

    public LogicalPlan usePlanCache(Relation rel, boolean cachePlan, Function1<Relation, LogicalPlan> transform) {
        boolean planCacheEnabled = Option$.MODULE$.apply((Object)this.session()).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SessionHolder.$anonfun$usePlanCache$1(x$2)));
        boolean hasPlanId = rel.hasCommon() && rel.getCommon().hasPlanId();
        return (LogicalPlan)this.getPlanCache$1(rel, planCacheEnabled, hasPlanId).getOrElse((Function0 & Serializable)() -> {
            LogicalPlan plan;
            block0: {
                plan = (LogicalPlan)transform.apply((Object)rel);
                if (!cachePlan) break block0;
                this.putPlanCache$1(rel, plan, planCacheEnabled, hasPlanId);
            }
            return plan;
        });
    }

    public Option<Cache<Relation, LogicalPlan>> getPlanCache() {
        return this.planCache();
    }

    public SessionHolder copy(String userId, String sessionId, org.apache.spark.sql.classic.SparkSession session) {
        return new SessionHolder(userId, sessionId, session);
    }

    public String copy$default$1() {
        return this.userId();
    }

    public String copy$default$2() {
        return this.sessionId();
    }

    public org.apache.spark.sql.classic.SparkSession copy$default$3() {
        return this.session();
    }

    public String productPrefix() {
        return "SessionHolder";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.userId();
            }
            case 1: {
                return this.sessionId();
            }
            case 2: {
                return this.session();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionHolder;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "userId";
            }
            case 1: {
                return "sessionId";
            }
            case 2: {
                return "session";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionHolder)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionHolder sessionHolder = (SessionHolder)x$1;
        String string = this.userId();
        String string2 = sessionHolder.userId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.sessionId();
        String string4 = sessionHolder.sessionId();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        org.apache.spark.sql.classic.SparkSession sparkSession = this.session();
        org.apache.spark.sql.classic.SparkSession sparkSession2 = sessionHolder.session();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!sessionHolder.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$interruptAll$1(SessionHolder $this, ArrayBuffer interruptedIds$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String operationId = (String)tuple2._1();
            ExecuteKey executeKey = new ExecuteKey($this.userId(), $this.sessionId(), operationId);
            SparkConnectService$.MODULE$.executionManager().getExecuteHolder(executeKey).foreach((Function1 & Serializable)executeHolder -> {
                if (executeHolder.interrupt()) {
                    return interruptedIds$1.$plus$eq((Object)operationId);
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$interruptTag$3(SessionHolder $this, String tag$1, ArrayBuffer interruptedIds$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String operationId = (String)tuple2._1();
            ExecuteKey executeKey = new ExecuteKey($this.userId(), $this.sessionId(), operationId);
            SparkConnectService$.MODULE$.executionManager().getExecuteHolder(executeKey).foreach((Function1 & Serializable)executeHolder -> {
                if (executeHolder.sparkSessionTags().contains((Object)tag$1)) {
                    if (executeHolder.interrupt()) {
                        return interruptedIds$2.$plus$eq((Object)operationId);
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$usePlanCache$1(org.apache.spark.sql.classic.SparkSession x$2) {
        return BoxesRunTime.unboxToBoolean((Object)x$2.sessionState().conf().getConf(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    private final Option getPlanCache$1(Relation rel, boolean planCacheEnabled$1, boolean hasPlanId$1) {
        Option<Cache<Relation, LogicalPlan>> option = this.planCache();
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            if (planCacheEnabled$1 && hasPlanId$1) {
                Option option2 = Option$.MODULE$.apply(cache.getIfPresent(rel));
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    LogicalPlan plan = (LogicalPlan)some2.value();
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using cached plan for relation '" + rel + "': " + plan);
                    return new Some((Object)plan);
                }
                if (None$.MODULE$.equals(option2)) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option2);
            }
        }
        return None$.MODULE$;
    }

    private final void putPlanCache$1(Relation rel, LogicalPlan plan, boolean planCacheEnabled$1, boolean hasPlanId$1) {
        Option<Cache<Relation, LogicalPlan>> option = this.planCache();
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            if (planCacheEnabled$1 && hasPlanId$1) {
                cache.put(rel, plan);
                return;
            }
        }
    }

    public SessionHolder(String userId, String sessionId, org.apache.spark.sql.classic.SparkSession session) {
        this.userId = userId;
        this.sessionId = sessionId;
        this.session = session;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.startTimeMs = System.currentTimeMillis();
        this.lastAccessTimeMs = System.currentTimeMillis();
        this.closedTimeMs = None$.MODULE$;
        this.customInactiveTimeoutMs = None$.MODULE$;
        this.operationIds = new ConcurrentHashMap<String, Object>();
        this.errorIdToError = CacheBuilder.newBuilder().ticker(Ticker.systemTicker()).maximumSize(SessionHolder$.MODULE$.org$apache$spark$sql$connect$service$SessionHolder$$ERROR_CACHE_SIZE()).expireAfterAccess(SessionHolder$.MODULE$.org$apache$spark$sql$connect$service$SessionHolder$$ERROR_CACHE_TIMEOUT_SEC(), TimeUnit.SECONDS).build();
        this.eventManager = new SessionEventsManager(this, (Clock)new SystemClock());
        this.pythonAccumulator = Try$.MODULE$.apply((Function0 & Serializable)() -> this.session().sparkContext().collectionAccumulator()).toOption();
    }
}

