/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.concurrent.impl;

import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.concurrent.BlockContext;
import coursierapi.shaded.scala.concurrent.CanAwait;
import coursierapi.shaded.scala.concurrent.ExecutionContext;
import coursierapi.shaded.scala.concurrent.ExecutionContextExecutor;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;

public class ExecutionContextImpl
implements ExecutionContextExecutor {
    private final Executor executor;
    private final Function1<Throwable, BoxedUnit> reporter;

    @Override
    public ExecutionContext prepare() {
        return ExecutionContext.prepare$(this);
    }

    public final Executor executor() {
        return this.executor;
    }

    public final Function1<Throwable, BoxedUnit> reporter() {
        return this.reporter;
    }

    @Override
    public final void execute(Runnable runnable) {
        this.executor().execute(runnable);
    }

    @Override
    public final void reportFailure(Throwable t) {
        this.reporter().apply(t);
    }

    public ExecutionContextImpl(Executor executor, Function1<Throwable, BoxedUnit> reporter) {
        this.executor = executor;
        this.reporter = reporter;
        if (!(executor != null)) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Executor must not be null").toString());
        }
    }

    public static final class DefaultThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory,
    ThreadFactory {
        private final boolean daemonic;
        private final int maxBlockers;
        private final String prefix;
        private final Thread.UncaughtExceptionHandler uncaught;
        private final Semaphore scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits;

        public final boolean daemonic() {
            return this.daemonic;
        }

        public final String prefix() {
            return this.prefix;
        }

        public final Thread.UncaughtExceptionHandler uncaught() {
            return this.uncaught;
        }

        public final Semaphore scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits() {
            return this.scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits;
        }

        public <T extends Thread> T wire(T thread) {
            thread.setDaemon(this.daemonic());
            thread.setUncaughtExceptionHandler(this.uncaught());
            thread.setName(new StringBuilder(1).append(this.prefix()).append("-").append(thread.getId()).toString());
            return thread;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return this.wire(new Thread(runnable));
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool fjp) {
            return this.wire(new BlockContext(this, fjp){
                private boolean isBlocked;
                private final /* synthetic */ DefaultThreadFactory $outer;

                public final <T> T blockOn(Function0<T> thunk, CanAwait permission) {
                    if (Thread.currentThread() == this && !this.isBlocked && this.$outer.scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits().tryAcquire()) {
                        R r;
                        try {
                            ForkJoinPool.ManagedBlocker b = new ForkJoinPool.ManagedBlocker(null, thunk){
                                private T result;
                                private boolean done;
                                private final Function0 thunk$1;

                                public boolean apply$mcZ$sp() {
                                    return Function0.apply$mcZ$sp$(this);
                                }

                                public int apply$mcI$sp() {
                                    return Function0.apply$mcI$sp$(this);
                                }

                                public void apply$mcV$sp() {
                                    Function0.apply$mcV$sp$(this);
                                }

                                public String toString() {
                                    return Function0.toString$(this);
                                }

                                public final boolean block() {
                                    if (!this.done) {
                                        this.result = this.thunk$1.apply();
                                        this.done = true;
                                    }
                                    return this.isReleasable();
                                }

                                public final boolean isReleasable() {
                                    return this.done;
                                }

                                public final T apply() {
                                    return this.result;
                                }
                                {
                                    this.thunk$1 = thunk$1;
                                    this.result = null;
                                    this.done = false;
                                }
                            };
                            this.isBlocked = true;
                            ForkJoinPool.managedBlock(b);
                            r = b.apply();
                        }
                        finally {
                            this.isBlocked = false;
                            this.$outer.scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits().release();
                        }
                        return (T)r;
                    }
                    return thunk.apply();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super(fjp$1);
                    this.isBlocked = false;
                }
            });
        }

        public DefaultThreadFactory(boolean daemonic, int maxBlockers, String prefix, Thread.UncaughtExceptionHandler uncaught) {
            this.daemonic = daemonic;
            this.maxBlockers = maxBlockers;
            this.prefix = prefix;
            this.uncaught = uncaught;
            if (!(prefix != null)) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"DefaultThreadFactory.prefix must be non null").toString());
            }
            if (!(maxBlockers >= 0)) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"DefaultThreadFactory.maxBlockers must be greater-or-equal-to 0").toString());
            }
            this.scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$blockerPermits = new Semaphore(maxBlockers);
        }
    }
}

