/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.FieldSelectorRequirement;
import io.fabric8.kubernetes.api.model.authorization.v1.FieldSelectorAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FieldSelectorAttributesFluent<A extends FieldSelectorAttributesFluent<A>>
extends BaseFluent<A> {
    private String rawSelector;
    private List<FieldSelectorRequirement> requirements = new ArrayList<FieldSelectorRequirement>();
    private Map<String, Object> additionalProperties;

    public FieldSelectorAttributesFluent() {
    }

    public FieldSelectorAttributesFluent(FieldSelectorAttributes instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FieldSelectorAttributes instance) {
        FieldSelectorAttributes fieldSelectorAttributes = instance = instance != null ? instance : new FieldSelectorAttributes();
        if (instance != null) {
            this.withRawSelector(instance.getRawSelector());
            this.withRequirements(instance.getRequirements());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getRawSelector() {
        return this.rawSelector;
    }

    public A withRawSelector(String rawSelector) {
        this.rawSelector = rawSelector;
        return (A)((Object)this);
    }

    public boolean hasRawSelector() {
        return this.rawSelector != null;
    }

    public A addToRequirements(int index, FieldSelectorRequirement item) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<FieldSelectorRequirement>();
        }
        this.requirements.add(index, item);
        return (A)((Object)this);
    }

    public A setToRequirements(int index, FieldSelectorRequirement item) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<FieldSelectorRequirement>();
        }
        this.requirements.set(index, item);
        return (A)((Object)this);
    }

    public A addToRequirements(FieldSelectorRequirement ... items) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<FieldSelectorRequirement>();
        }
        for (FieldSelectorRequirement item : items) {
            this.requirements.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRequirements(Collection<FieldSelectorRequirement> items) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<FieldSelectorRequirement>();
        }
        for (FieldSelectorRequirement item : items) {
            this.requirements.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRequirements(FieldSelectorRequirement ... items) {
        if (this.requirements == null) {
            return (A)((Object)this);
        }
        for (FieldSelectorRequirement item : items) {
            this.requirements.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRequirements(Collection<FieldSelectorRequirement> items) {
        if (this.requirements == null) {
            return (A)((Object)this);
        }
        for (FieldSelectorRequirement item : items) {
            this.requirements.remove(item);
        }
        return (A)((Object)this);
    }

    public List<FieldSelectorRequirement> getRequirements() {
        return this.requirements;
    }

    public FieldSelectorRequirement getRequirement(int index) {
        return this.requirements.get(index);
    }

    public FieldSelectorRequirement getFirstRequirement() {
        return this.requirements.get(0);
    }

    public FieldSelectorRequirement getLastRequirement() {
        return this.requirements.get(this.requirements.size() - 1);
    }

    public FieldSelectorRequirement getMatchingRequirement(Predicate<FieldSelectorRequirement> predicate) {
        for (FieldSelectorRequirement item : this.requirements) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequirement(Predicate<FieldSelectorRequirement> predicate) {
        for (FieldSelectorRequirement item : this.requirements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequirements(List<FieldSelectorRequirement> requirements) {
        if (requirements != null) {
            this.requirements = new ArrayList<FieldSelectorRequirement>();
            for (FieldSelectorRequirement item : requirements) {
                this.addToRequirements(item);
            }
        } else {
            this.requirements = null;
        }
        return (A)((Object)this);
    }

    public A withRequirements(FieldSelectorRequirement ... requirements) {
        if (this.requirements != null) {
            this.requirements.clear();
            this._visitables.remove((Object)"requirements");
        }
        if (requirements != null) {
            for (FieldSelectorRequirement item : requirements) {
                this.addToRequirements(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldSelectorAttributesFluent that = (FieldSelectorAttributesFluent)((Object)o);
        if (!Objects.equals(this.rawSelector, that.rawSelector)) {
            return false;
        }
        if (!Objects.equals(this.requirements, that.requirements)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.rawSelector, this.requirements, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rawSelector != null) {
            sb.append("rawSelector:");
            sb.append(this.rawSelector + ",");
        }
        if (this.requirements != null && !this.requirements.isEmpty()) {
            sb.append("requirements:");
            sb.append(this.requirements + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

