/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class StringSubstrColStartLen
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int startIdx;
    private int colNum;
    private int length;
    private int outputColumn;
    private final transient int[] offsetArray = new int[2];
    private static transient byte[] EMPTY_STRING;

    public StringSubstrColStartLen(int colNum, int startIdx, int length, int outputColumn) {
        this();
        this.colNum = colNum;
        this.startIdx = startIdx >= 1 ? startIdx - 1 : (startIdx == 0 ? 0 : startIdx);
        this.length = length;
        this.outputColumn = outputColumn;
    }

    public StringSubstrColStartLen() {
    }

    static void populateSubstrOffsets(byte[] utf8String, int start, int len, int substrStart, int substrLength, int[] offsetArray) {
        int i;
        int curIdx = -1;
        offsetArray[0] = -1;
        offsetArray[1] = -1;
        int end = start + len;
        if (substrStart < 0) {
            int length = 0;
            for (i = start; i != end; ++i) {
                if ((utf8String[i] & 0xC0) == 128) continue;
                ++length;
            }
            if (-substrStart > length) {
                return;
            }
            substrStart = length + substrStart;
        }
        if (substrLength == 0) {
            return;
        }
        int endIdx = substrStart + substrLength - 1;
        for (i = start; i != end; ++i) {
            if ((utf8String[i] & 0xC0) == 128) continue;
            if (++curIdx == substrStart) {
                offsetArray[0] = i;
                continue;
            }
            if (curIdx - 1 != endIdx) continue;
            offsetArray[1] = i - offsetArray[0];
        }
        if (offsetArray[1] == -1) {
            offsetArray[1] = end - offsetArray[0];
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.colNum];
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        int n = batch.size;
        if (n == 0) {
            return;
        }
        byte[][] vector = inV.vector;
        int[] sel = batch.selected;
        int[] len = inV.length;
        int[] start = inV.start;
        outV.initBuffer();
        if (inV.isRepeating) {
            outV.isRepeating = true;
            if (!inV.noNulls && inV.isNull[0]) {
                outV.isNull[0] = true;
                outV.noNulls = false;
                outV.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
                return;
            }
            outV.noNulls = true;
            StringSubstrColStartLen.populateSubstrOffsets(vector[0], start[0], len[0], this.startIdx, this.length, this.offsetArray);
            if (this.offsetArray[0] != -1) {
                outV.setVal(0, vector[0], this.offsetArray[0], this.offsetArray[1]);
            } else {
                outV.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
            }
        } else {
            outV.isRepeating = false;
            if (batch.selectedInUse) {
                if (!inV.noNulls) {
                    outV.noNulls = false;
                    for (int i = 0; i != n; ++i) {
                        int selected = sel[i];
                        if (!inV.isNull[selected]) {
                            outV.isNull[selected] = false;
                            StringSubstrColStartLen.populateSubstrOffsets(vector[selected], start[selected], len[selected], this.startIdx, this.length, this.offsetArray);
                            if (this.offsetArray[0] != -1) {
                                outV.setVal(selected, vector[selected], this.offsetArray[0], this.offsetArray[1]);
                                continue;
                            }
                            outV.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                            continue;
                        }
                        outV.isNull[selected] = true;
                    }
                } else {
                    outV.noNulls = true;
                    for (int i = 0; i != n; ++i) {
                        int selected = sel[i];
                        outV.isNull[selected] = false;
                        StringSubstrColStartLen.populateSubstrOffsets(vector[selected], start[selected], len[selected], this.startIdx, this.length, this.offsetArray);
                        if (this.offsetArray[0] != -1) {
                            outV.setVal(selected, vector[selected], this.offsetArray[0], this.offsetArray[1]);
                            continue;
                        }
                        outV.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                    }
                }
            } else if (!inV.noNulls) {
                System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
                outV.noNulls = false;
                for (int i = 0; i != n; ++i) {
                    if (inV.isNull[i]) continue;
                    StringSubstrColStartLen.populateSubstrOffsets(vector[i], start[i], len[i], this.startIdx, this.length, this.offsetArray);
                    if (this.offsetArray[0] != -1) {
                        outV.setVal(i, vector[i], this.offsetArray[0], this.offsetArray[1]);
                        continue;
                    }
                    outV.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            } else {
                outV.noNulls = true;
                for (int i = 0; i != n; ++i) {
                    outV.isNull[i] = false;
                    StringSubstrColStartLen.populateSubstrOffsets(vector[i], start[i], len[i], this.startIdx, this.length, this.offsetArray);
                    if (this.offsetArray[0] != -1) {
                        outV.setVal(i, vector[i], this.offsetArray[0], this.offsetArray[1]);
                        continue;
                    }
                    outV.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "string";
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public void setStartIdx(int startIdx) {
        this.startIdx = startIdx;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", start " + this.startIdx + ", length " + this.length;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }

    static {
        try {
            EMPTY_STRING = "".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

