/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.util.Arrays;
import org.sparkproject.guava.base.Preconditions;

class ArrayWrappers {
    ArrayWrappers() {
    }

    public static Comparable<Object> forArray(Object a) {
        Comparable<ComparableIntArray> ret;
        Preconditions.checkArgument((boolean)a.getClass().isArray());
        if (a instanceof int[]) {
            int[] ia = (int[])a;
            ret = new ComparableIntArray(ia);
        } else if (a instanceof long[]) {
            long[] la = (long[])a;
            ret = new ComparableLongArray(la);
        } else if (a instanceof byte[]) {
            byte[] ba = (byte[])a;
            ret = new ComparableByteArray(ba);
        } else {
            Preconditions.checkArgument((!a.getClass().getComponentType().isPrimitive() ? 1 : 0) != 0);
            ret = new ComparableObjectArray((Object[])a);
        }
        return ret;
    }

    private static class ComparableIntArray
    implements Comparable<ComparableIntArray> {
        private final int[] array;

        ComparableIntArray(int[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableIntArray)) {
                return false;
            }
            ComparableIntArray comparableIntArray = (ComparableIntArray)other;
            return Arrays.equals(this.array, comparableIntArray.array);
        }

        public int hashCode() {
            int code = 0;
            for (int j : this.array) {
                code = code * 31 + j;
            }
            return code;
        }

        @Override
        public int compareTo(ComparableIntArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                int diff = this.array[i] - other.array[i];
                if (diff == 0) continue;
                return diff;
            }
            return this.array.length - other.array.length;
        }
    }

    private static class ComparableLongArray
    implements Comparable<ComparableLongArray> {
        private final long[] array;

        ComparableLongArray(long[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableLongArray)) {
                return false;
            }
            ComparableLongArray comparableLongArray = (ComparableLongArray)other;
            return Arrays.equals(this.array, comparableLongArray.array);
        }

        public int hashCode() {
            int code = 0;
            for (long l : this.array) {
                code = code * 31 + (int)l;
            }
            return code;
        }

        @Override
        public int compareTo(ComparableLongArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                long diff = this.array[i] - other.array[i];
                if (diff == 0L) continue;
                return diff > 0L ? 1 : -1;
            }
            return this.array.length - other.array.length;
        }
    }

    private static class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        private final byte[] array;

        ComparableByteArray(byte[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableByteArray)) {
                return false;
            }
            ComparableByteArray comparableByteArray = (ComparableByteArray)other;
            return Arrays.equals(this.array, comparableByteArray.array);
        }

        public int hashCode() {
            int code = 0;
            for (byte b : this.array) {
                code = code * 31 + b;
            }
            return code;
        }

        @Override
        public int compareTo(ComparableByteArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                int diff = this.array[i] - other.array[i];
                if (diff == 0) continue;
                return diff;
            }
            return this.array.length - other.array.length;
        }
    }

    private static class ComparableObjectArray
    implements Comparable<ComparableObjectArray> {
        private final Object[] array;

        ComparableObjectArray(Object[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableObjectArray)) {
                return false;
            }
            ComparableObjectArray comparableObjectArray = (ComparableObjectArray)other;
            return Arrays.equals(this.array, comparableObjectArray.array);
        }

        public int hashCode() {
            int code = 0;
            for (Object o : this.array) {
                code = code * 31 + o.hashCode();
            }
            return code;
        }

        @Override
        public int compareTo(ComparableObjectArray other) {
            int len = Math.min(this.array.length, other.array.length);
            for (int i = 0; i < len; ++i) {
                int diff = ((Comparable)this.array[i]).compareTo(other.array[i]);
                if (diff == 0) continue;
                return diff;
            }
            return this.array.length - other.array.length;
        }
    }
}

