/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.api.resource.ResourceDiscoveryPlugin;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceAllocation;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceRequest;
import org.apache.spark.resource.ResourceRequirement;
import org.apache.spark.resource.TaskResourceRequest;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class ResourceUtils$
implements Logging {
    public static final ResourceUtils$ MODULE$ = new ResourceUtils$();
    private static final String DISCOVERY_SCRIPT;
    private static final String VENDOR;
    private static final String AMOUNT;
    private static final String GPU;
    private static final String FPGA;
    private static final String RESOURCE_PREFIX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DISCOVERY_SCRIPT = "discoveryScript";
        VENDOR = "vendor";
        AMOUNT = "amount";
        GPU = "gpu";
        FPGA = "fpga";
        RESOURCE_PREFIX = "resource";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String DISCOVERY_SCRIPT() {
        return DISCOVERY_SCRIPT;
    }

    public String VENDOR() {
        return VENDOR;
    }

    public String AMOUNT() {
        return AMOUNT;
    }

    public ResourceRequest parseResourceRequest(SparkConf sparkConf, ResourceID resourceId) {
        scala.collection.immutable.Map settings = Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAllWithPrefix(resourceId.confPrefix())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int amount = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)settings.getOrElse((Object)this.AMOUNT(), (Function0 & Serializable)() -> {
            throw new SparkException("You must specify an amount for " + resourceId.resourceName());
        })));
        Optional<Object> discoveryScript = Optional.ofNullable(settings.get((Object)this.DISCOVERY_SCRIPT()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Optional<Object> vendor = Optional.ofNullable(settings.get((Object)this.VENDOR()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return new ResourceRequest(resourceId, amount, discoveryScript, vendor);
    }

    public scala.collection.immutable.Seq<ResourceID> listResourceIds(SparkConf sparkConf, String componentName) {
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(componentName + "." + this.RESOURCE_PREFIX() + ".")), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                int index = key.indexOf(46);
                if (index < 0) {
                    throw new SparkException("You must specify an amount config for resource: " + key + " config: " + componentName + "." + MODULE$.RESOURCE_PREFIX() + "." + key);
                }
                return key.substring(0, index);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))))), (Function1 & Serializable)name -> new ResourceID(componentName, (String)name), ClassTag$.MODULE$.apply(ResourceID.class))).toImmutableArraySeq();
    }

    public scala.collection.immutable.Seq<ResourceRequest> parseAllResourceRequests(SparkConf sparkConf, String componentName) {
        return (scala.collection.immutable.Seq)((IterableOps)this.listResourceIds(sparkConf, componentName).map((Function1 & Serializable)id -> MODULE$.parseResourceRequest(sparkConf, (ResourceID)id))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$parseAllResourceRequests$2(x$1)));
    }

    public Tuple2<Object, Object> calculateAmountAndPartsForFraction(double doubleAmount) {
        int n;
        if (doubleAmount <= 1.0) {
            n = (int)Math.floor(1.0 / doubleAmount);
        } else {
            if (doubleAmount % 1.0 != 0.0) {
                throw new SparkException("The resource amount " + doubleAmount + " must be either <= 1.0, or a whole number.");
            }
            n = 1;
        }
        int parts = n;
        return new Tuple2.mcII.sp((int)Math.ceil(doubleAmount), parts);
    }

    public void addTaskResourceRequests(SparkConf sparkConf, TaskResourceRequests treqs) {
        scala.collection.immutable.Map nonZeroTaskReqs = (scala.collection.immutable.Map)((IterableOnceOps)this.listResourceIds(sparkConf, org.apache.spark.internal.config.package$.MODULE$.SPARK_TASK_PREFIX()).map((Function1 & Serializable)resourceId -> {
            scala.collection.immutable.Map settings = Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAllWithPrefix(resourceId.confPrefix())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            double amountDouble = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)settings.getOrElse((Object)MODULE$.AMOUNT(), (Function0 & Serializable)() -> {
                throw new SparkException("You must specify an amount for " + resourceId.resourceName());
            })));
            return new Tuple2((Object)resourceId.resourceName(), (Object)BoxesRunTime.boxToDouble((double)amountDouble));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$addTaskResourceRequests$3(x0$1)));
        nonZeroTaskReqs.foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String resourceName = (String)tuple2._1();
                double amount = tuple2._2$mcD$sp();
                return treqs.resource(resourceName, amount);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public scala.collection.immutable.Seq<ResourceRequirement> parseResourceRequirements(SparkConf sparkConf, String componentName) {
        scala.collection.immutable.Seq<ResourceID> resourceIds = this.listResourceIds(sparkConf, componentName);
        scala.collection.immutable.Seq rnamesAndAmounts = (scala.collection.immutable.Seq)resourceIds.map((Function1 & Serializable)resourceId -> {
            scala.collection.immutable.Map settings = Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAllWithPrefix(resourceId.confPrefix())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            double amountDouble = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString((String)settings.getOrElse((Object)MODULE$.AMOUNT(), (Function0 & Serializable)() -> {
                throw new SparkException("You must specify an amount for " + resourceId.resourceName());
            })));
            return new Tuple2((Object)resourceId.resourceName(), (Object)BoxesRunTime.boxToDouble((double)amountDouble));
        });
        return (scala.collection.immutable.Seq)((IterableOps)rnamesAndAmounts.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$parseResourceRequirements$3(x0$1)))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2.mcII.sp sp2;
                String rName = (String)tuple2._1();
                double amountDouble = tuple2._2$mcD$sp();
                if (componentName.equalsIgnoreCase(org.apache.spark.internal.config.package$.MODULE$.SPARK_TASK_PREFIX())) {
                    v0 = MODULE$.calculateAmountAndPartsForFraction(amountDouble);
                } else {
                    if (amountDouble % 1.0 != 0.0) {
                        throw new SparkException("Only tasks support fractional resources, please check your " + componentName + " settings");
                    }
                    v0 = sp2 = new Tuple2.mcII.sp((int)amountDouble, 1);
                }
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                int amount = sp2._1$mcI$sp();
                int parts = sp2._2$mcI$sp();
                Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(amount, parts);
                int amount2 = sp3._1$mcI$sp();
                int parts2 = sp3._2$mcI$sp();
                return new ResourceRequirement(rName, amount2, parts2);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public scala.collection.immutable.Seq<ResourceRequirement> executorResourceRequestToRequirement(scala.collection.immutable.Seq<ExecutorResourceRequest> resourceRequest) {
        return (scala.collection.immutable.Seq)resourceRequest.map((Function1 & Serializable)request -> new ResourceRequirement(request.resourceName(), (int)request.amount(), 1));
    }

    public boolean resourcesMeetRequirements(scala.collection.immutable.Map<String, Object> resourcesFree, scala.collection.immutable.Seq<ResourceRequirement> resourceRequirements) {
        return resourceRequirements.forall((Function1 & Serializable)req -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$resourcesMeetRequirements$1(resourcesFree, req)));
    }

    public <T> scala.collection.immutable.Seq<T> withResourcesJson(String resourcesFile, Function1<String, scala.collection.immutable.Seq<T>> extract) {
        scala.collection.immutable.Seq seq;
        String json = new String(Files.readAllBytes(Paths.get(resourcesFile, new String[0])));
        try {
            seq = (scala.collection.immutable.Seq)extract.apply((Object)json);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new SparkException("Error parsing resources file " + resourcesFile, throwable2);
            }
            throw throwable;
        }
        return seq;
    }

    public scala.collection.immutable.Seq<ResourceAllocation> parseAllocatedFromJsonFile(String resourcesFile) {
        return this.withResourcesJson(resourcesFile, (Function1 & Serializable)json -> {
            DefaultFormats$ formats = DefaultFormats$.MODULE$;
            return (scala.collection.immutable.Seq)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(json, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())), (Formats)formats, ManifestFactory$.MODULE$.classType(scala.collection.immutable.Seq.class, ManifestFactory$.MODULE$.classType(ResourceAllocation.class), (scala.collection.immutable.Seq)Nil$.MODULE$));
        });
    }

    public scala.collection.immutable.Seq<ResourceAllocation> parseAllocated(Option<String> resourcesFileOpt, String componentName) {
        return (scala.collection.immutable.Seq)((IterableOps)Option$.MODULE$.option2Iterable(resourcesFileOpt).toSeq().flatMap((Function1 & Serializable)resourcesFile -> MODULE$.parseAllocatedFromJsonFile((String)resourcesFile))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$parseAllocated$2(componentName, x$3)));
    }

    private scala.collection.immutable.Seq<ResourceAllocation> parseAllocatedOrDiscoverResources(SparkConf sparkConf, String componentName, Option<String> resourcesFileOpt) {
        scala.collection.immutable.Seq<ResourceAllocation> allocated = this.parseAllocated(resourcesFileOpt, componentName);
        scala.collection.immutable.Seq otherResourceIds = (scala.collection.immutable.Seq)this.listResourceIds(sparkConf, componentName).diff((Seq)allocated.map((Function1 & Serializable)x$4 -> x$4.id()));
        scala.collection.immutable.Seq otherResources = (scala.collection.immutable.Seq)otherResourceIds.flatMap((Function1 & Serializable)id -> {
            ResourceRequest request = MODULE$.parseResourceRequest(sparkConf, (ResourceID)id);
            if (request.amount() > 0L) {
                return new Some((Object)new ResourceAllocation((ResourceID)id, (scala.collection.immutable.Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)MODULE$.discoverResource(sparkConf, request).addresses()).toImmutableArraySeq()));
            }
            return None$.MODULE$;
        });
        return (scala.collection.immutable.Seq)allocated.$plus$plus((IterableOnce)otherResources);
    }

    private void assertResourceAllocationMeetsRequest(ResourceAllocation allocation, ResourceRequest request) {
        ResourceID resourceID = allocation.id();
        ResourceID resourceID2 = request.id();
        Predef$.MODULE$.require(!(resourceID != null ? !((Object)resourceID).equals(resourceID2) : resourceID2 != null) && (long)allocation.addresses().size() >= request.amount(), (Function0 & Serializable)() -> "Resource: " + allocation.id().resourceName() + ", with addresses: " + allocation.addresses().mkString(",") + " is less than what the user requested: " + request.amount() + ")");
    }

    private void assertAllResourceAllocationsMeetRequests(scala.collection.immutable.Seq<ResourceAllocation> allocations, scala.collection.immutable.Seq<ResourceRequest> requests) {
        scala.collection.immutable.Map allocated = ((IterableOnceOps)allocations.map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.id()), x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        requests.foreach((Function1 & Serializable)r -> {
            ResourceUtils$.MODULE$.assertResourceAllocationMeetsRequest((ResourceAllocation)allocated.apply((Object)r.id()), r);
            return BoxedUnit.UNIT;
        });
    }

    private void assertAllResourceAllocationsMatchResourceProfile(scala.collection.immutable.Map<String, ResourceInformation> allocations, scala.collection.immutable.Map<String, ExecutorResourceRequest> execReqs) {
        execReqs.foreach((Function1 & Serializable)x0$1 -> {
            ResourceUtils$.$anonfun$assertAllResourceAllocationsMatchResourceProfile$1(allocations, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Map<String, ResourceInformation> getOrDiscoverAllResources(SparkConf sparkConf, String componentName, Option<String> resourcesFileOpt) {
        scala.collection.immutable.Seq<ResourceRequest> requests = this.parseAllResourceRequests(sparkConf, componentName);
        scala.collection.immutable.Seq<ResourceAllocation> allocations = this.parseAllocatedOrDiscoverResources(sparkConf, componentName, resourcesFileOpt);
        this.assertAllResourceAllocationsMeetRequests(allocations, requests);
        scala.collection.immutable.Map resourceInfoMap = ((IterableOnceOps)allocations.map((Function1 & Serializable)a -> new Tuple2((Object)a.id().resourceName(), (Object)a.toResourceInformation()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return resourceInfoMap;
    }

    private Optional<String> emptyStringToOptional(String optStr) {
        if (optStr.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(optStr);
    }

    public scala.collection.immutable.Map<String, ResourceInformation> getOrDiscoverAllResourcesForResourceProfile(Option<String> resourcesFileOpt, String componentName, ResourceProfile resourceProfile, SparkConf sparkConf) {
        scala.collection.immutable.Seq<ResourceAllocation> fileAllocated = this.parseAllocated(resourcesFileOpt, componentName);
        scala.collection.immutable.Map fileAllocResMap = ((IterableOnceOps)fileAllocated.map((Function1 & Serializable)a -> new Tuple2((Object)a.id().resourceName(), (Object)a.toResourceInformation()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map<String, ExecutorResourceRequest> execReq = resourceProfile.getCustomExecutorResources();
        scala.collection.immutable.Map filteredExecreq = (scala.collection.immutable.Map)execReq.filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$getOrDiscoverAllResourcesForResourceProfile$2(fileAllocResMap, x0$1)));
        scala.collection.immutable.Map rpAllocations = (scala.collection.immutable.Map)filteredExecreq.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                ExecutorResourceRequest execRequest = (ExecutorResourceRequest)tuple2._2();
                ResourceID resourceId = new ResourceID(componentName, rName);
                Optional<String> scriptOpt = MODULE$.emptyStringToOptional(execRequest.discoveryScript());
                Optional<String> vendorOpt = MODULE$.emptyStringToOptional(execRequest.vendor());
                ResourceRequest resourceReq = new ResourceRequest(resourceId, execRequest.amount(), scriptOpt, vendorOpt);
                String[] addrs = MODULE$.discoverResource(sparkConf, resourceReq).addresses();
                return new Tuple2((Object)rName, (Object)new ResourceInformation(rName, addrs));
            }
            throw new MatchError((Object)tuple2);
        });
        scala.collection.immutable.Map allAllocations = (scala.collection.immutable.Map)fileAllocResMap.$plus$plus((IterableOnce)rpAllocations);
        this.assertAllResourceAllocationsMatchResourceProfile((scala.collection.immutable.Map<String, ResourceInformation>)allAllocations, execReq);
        return allAllocations;
    }

    public void logResourceInfo(String componentName, scala.collection.immutable.Map<String, ResourceInformation> resources) {
        String resourceInfo = resources.isEmpty() ? "No custom resources configured for " + componentName + "." : "Custom resources for " + componentName + ":\n" + resources.mkString("\n");
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "==============================================================");
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> resourceInfo);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "==============================================================");
    }

    public ResourceInformation discoverResource(SparkConf sparkConf, ResourceRequest resourceRequest) {
        Object object = new Object();
        try {
            String discoveryScriptPlugin = "org.apache.spark.resource.ResourceDiscoveryScriptPlugin";
            scala.collection.immutable.Seq pluginClasses = (scala.collection.immutable.Seq)((SeqOps)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.RESOURCES_DISCOVERY_PLUGIN())).$colon$plus((Object)discoveryScriptPlugin);
            scala.collection.immutable.Seq<ResourceDiscoveryPlugin> resourcePlugins = Utils$.MODULE$.loadExtensions(ResourceDiscoveryPlugin.class, (scala.collection.immutable.Seq<String>)pluginClasses, sparkConf);
            resourcePlugins.foreach((Function1 & Serializable)plugin -> {
                ResourceUtils$.$anonfun$discoverResource$1(resourceRequest, sparkConf, object, plugin);
                return BoxedUnit.UNIT;
            });
            throw new SparkException("None of the discovery plugins returned ResourceInformation for " + resourceRequest.id().resourceName());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (ResourceInformation)ex.value();
        }
    }

    public boolean validateTaskCpusLargeEnough(SparkConf sparkConf, int execCores, int taskCpus) {
        if (execCores < taskCpus) {
            throw new SparkException("The number of cores per executor (=" + execCores + ") has to be >= the number of cpus per task = " + taskCpus + ".");
        }
        return true;
    }

    public void warnOnWastedResources(ResourceProfile rp, SparkConf sparkConf, Option<Object> execCores) {
        int n;
        boolean coresKnown = rp.isCoresLimitKnown();
        ObjectRef limitingResource = ObjectRef.create((Object)rp.limitingResource(sparkConf));
        IntRef maxTaskPerExec = IntRef.create((int)rp.maxTasksPerExecutor(sparkConf));
        int taskCpus = ResourceProfile$.MODULE$.getTaskCpusOrDefaultForProfile(rp, sparkConf);
        if (execCores.isDefined()) {
            n = BoxesRunTime.unboxToInt((Object)execCores.get());
        } else if (coresKnown) {
            n = BoxesRunTime.unboxToInt((Object)rp.getExecutorCores().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()))));
        } else {
            return;
        }
        int cores = n;
        if (!coresKnown) {
            int numTasksPerExecCores = cores / taskCpus;
            int numTasksPerExecCustomResource = rp.maxTasksPerExecutor(sparkConf);
            if (((String)limitingResource.elem).isEmpty() || StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)limitingResource.elem)) && numTasksPerExecCores < numTasksPerExecCustomResource) {
                limitingResource.elem = ResourceProfile$.MODULE$.CPUS();
                maxTaskPerExec.elem = numTasksPerExecCores;
            }
        }
        scala.collection.immutable.Map<String, TaskResourceRequest> taskReq = rp.getCustomTaskResources();
        scala.collection.immutable.Map<String, ExecutorResourceRequest> execReq = rp.getCustomExecutorResources();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)limitingResource.elem)) && !((String)limitingResource.elem).equals(ResourceProfile$.MODULE$.CPUS()) && taskCpus * maxTaskPerExec.elem < cores) {
            int resourceNumSlots = (int)Math.floor(cores / taskCpus);
            MessageWithContext message = this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The configuration of cores (exec = ", " "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_CORES$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)cores))})).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"task = ", ", runnable tasks = "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_TASK_CPUS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)taskCpus))}))).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ") will "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_RESOURCE_SLOTS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)resourceNumSlots))}))).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"result in wasted resources due to resource ", " "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RESOURCE$.MODULE$, (Object)((String)limitingResource.elem))}))).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limiting the number of runnable tasks per executor to: "}))).log((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Please adjust "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_TASKS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)maxTaskPerExec.elem))}))).$plus(this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"your configuration."}))).log((scala.collection.immutable.Seq)Nil$.MODULE$));
            if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Tests$.MODULE$.RESOURCES_WARNING_TESTING()))) {
                throw new SparkException(message.message());
            }
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> message));
        }
        taskReq.foreach((Function1 & Serializable)x0$1 -> {
            ResourceUtils$.$anonfun$warnOnWastedResources$3(execReq, rp, sparkConf, maxTaskPerExec, limitingResource, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> warnOnWastedResources$default$3() {
        return None$.MODULE$;
    }

    public final String GPU() {
        return GPU;
    }

    public final String FPGA() {
        return FPGA;
    }

    public final String RESOURCE_PREFIX() {
        return RESOURCE_PREFIX;
    }

    public static final /* synthetic */ boolean $anonfun$parseAllResourceRequests$2(ResourceRequest x$1) {
        return x$1.amount() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$addTaskResourceRequests$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double amount = tuple2._2$mcD$sp();
            return amount > 0.0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$parseResourceRequirements$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double amount = tuple2._2$mcD$sp();
            return amount > 0.0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$resourcesMeetRequirements$1(scala.collection.immutable.Map resourcesFree$1, ResourceRequirement req) {
        return BoxesRunTime.unboxToInt((Object)resourcesFree$1.getOrElse((Object)req.resourceName(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) >= req.amount();
    }

    public static final /* synthetic */ boolean $anonfun$parseAllocated$2(String componentName$3, ResourceAllocation x$3) {
        String string = x$3.id().componentName();
        String string2 = componentName$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$assertAllResourceAllocationsMatchResourceProfile$1(scala.collection.immutable.Map allocations$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rName = (String)tuple2._1();
            ExecutorResourceRequest req = (ExecutorResourceRequest)tuple2._2();
            Predef$.MODULE$.require(allocations$1.contains((Object)rName) && (long)((ResourceInformation)allocations$1.apply((Object)rName)).addresses().length >= req.amount(), (Function0 & Serializable)() -> "Resource: " + rName + ", with addresses: " + Predef$.MODULE$.wrapRefArray((Object[])((ResourceInformation)allocations$1.apply((Object)rName)).addresses()).mkString(",") + " is less than what the user requested: " + req.amount() + ")");
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getOrDiscoverAllResourcesForResourceProfile$2(scala.collection.immutable.Map fileAllocResMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rname = (String)tuple2._1();
            return fileAllocResMap$1.contains((Object)rname);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$discoverResource$1(ResourceRequest resourceRequest$1, SparkConf sparkConf$6, Object nonLocalReturnKey1$1, ResourceDiscoveryPlugin plugin) {
        Optional<ResourceInformation> riOption = plugin.discoverResource(resourceRequest$1, sparkConf$6);
        if (riOption.isPresent()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)riOption.get());
        }
    }

    public static final /* synthetic */ void $anonfun$warnOnWastedResources$3(scala.collection.immutable.Map execReq$1, ResourceProfile rp$1, SparkConf sparkConf$7, IntRef maxTaskPerExec$1, ObjectRef limitingResource$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rName = (String)tuple2._1();
            TaskResourceRequest treq = (TaskResourceRequest)tuple2._2();
            long execAmount = ((ExecutorResourceRequest)execReq$1.apply((Object)rName)).amount();
            int taskAmount = rp$1.getSchedulerTaskResourceAmount(rName);
            int numParts = rp$1.getNumSlotsPerAddress(rName, sparkConf$7);
            if ((long)maxTaskPerExec$1.elem < execAmount * (long)numParts / (long)taskAmount) {
                double origTaskAmount = treq.amount();
                String taskReqStr = origTaskAmount + "/" + numParts;
                int resourceNumSlots = (int)(execAmount * (long)numParts / (long)taskAmount);
                MessageWithContext message = MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The configuration of resource: "}))).log((scala.collection.immutable.Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RESOURCE_NAME$.MODULE$, (Object)treq.resourceName())}))).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(exec = ", ", "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXEC_AMOUNT$.MODULE$, (Object)BoxesRunTime.boxToLong((long)execAmount))}))).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"task = ", ", "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TASK_REQUIREMENTS$.MODULE$, (Object)taskReqStr)}))).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"runnable tasks = ", ") will "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_RESOURCE_SLOTS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)resourceNumSlots))}))).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"result in wasted resources due to resource ", " "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.RESOURCE$.MODULE$, (Object)((String)limitingResource$1.elem))}))).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"limiting the number of runnable tasks per executor to: "}))).log((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Please adjust your configuration."}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_TASKS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)maxTaskPerExec$1.elem))})));
                if (BoxesRunTime.unboxToBoolean((Object)sparkConf$7.get(Tests$.MODULE$.RESOURCES_WARNING_TESTING()))) {
                    throw new SparkException(message.message());
                }
                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> message));
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ResourceUtils$() {
    }
}

