/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.shared.common.error.StandardException;

public final class TemplateRow {
    private TemplateRow() {
    }

    private static DataValueDescriptor[] allocate_objects(Transaction transaction, int n, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        int n2 = formatableBitSet == null ? nArray.length : formatableBitSet.size();
        DataValueFactory dataValueFactory = transaction.getDataValueFactory();
        for (int i = 0; i < n2; ++i) {
            if (formatableBitSet != null && !formatableBitSet.get(i)) continue;
            dataValueDescriptorArray[i] = dataValueFactory.getNull(nArray[i], nArray2[i]);
        }
        return dataValueDescriptorArray;
    }

    public static DataValueDescriptor[] newU8Row(int n) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            dataValueDescriptorArray[i] = new SQLLongint(Long.MIN_VALUE);
        }
        return dataValueDescriptorArray;
    }

    public static DataValueDescriptor[] newRow(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        int n = dataValueDescriptorArray.length;
        while (n-- > 0) {
            dataValueDescriptorArray2[n] = dataValueDescriptorArray[n].getNewNull();
        }
        return dataValueDescriptorArray2;
    }

    public static DataValueDescriptor[] newRow(Transaction transaction, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2) throws StandardException {
        return TemplateRow.allocate_objects(transaction, nArray.length, formatableBitSet, nArray, nArray2);
    }

    public static DataValueDescriptor[] newBranchRow(Transaction transaction, int[] nArray, int[] nArray2, DataValueDescriptor dataValueDescriptor) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = TemplateRow.allocate_objects(transaction, nArray.length + 1, null, nArray, nArray2);
        dataValueDescriptorArray[nArray.length] = dataValueDescriptor;
        return dataValueDescriptorArray;
    }

    public static boolean checkColumnTypes(DataValueFactory dataValueFactory, int[] nArray, int[] nArray2, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl;
        block0: {
            bl = true;
            int n = dataValueDescriptorArray.length;
            if (nArray.length == dataValueDescriptorArray.length) break block0;
            bl = false;
        }
        return bl;
    }
}

