/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.SumAggregator;
import org.apache.derby.shared.common.error.StandardException;

public final class AvgAggregator
extends SumAggregator {
    private long count;
    private int scale;

    @Override
    protected void accumulate(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.count == 0L) {
            String string = dataValueDescriptor.getTypeName();
            if (string.equals("TINYINT") || string.equals("SMALLINT") || string.equals("INTEGER") || string.equals("BIGINT")) {
                this.scale = 0;
            } else if (string.equals("REAL") || string.equals("DOUBLE")) {
                this.scale = 31;
            } else {
                this.scale = ((SQLDecimal)dataValueDescriptor).getDecimalValueScale();
                if (this.scale < 4) {
                    this.scale = 4;
                }
            }
        }
        try {
            super.accumulate(dataValueDescriptor);
            ++this.count;
            return;
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("22003")) {
                throw standardException;
            }
            String string = this.value.getTypeName();
            NumberDataType numberDataType = string.equals("INTEGER") ? new SQLLongint() : (string.equals("TINYINT") || string.equals("SMALLINT") ? new SQLInteger() : (string.equals("REAL") ? new SQLDouble() : new SQLDecimal()));
            numberDataType.setValue(this.value);
            this.value = numberDataType;
            this.accumulate(dataValueDescriptor);
            return;
        }
    }

    @Override
    public void merge(ExecAggregator execAggregator) throws StandardException {
        AvgAggregator avgAggregator = (AvgAggregator)execAggregator;
        if (this.count == 0L) {
            this.count = avgAggregator.count;
            this.value = avgAggregator.value;
            this.scale = avgAggregator.scale;
            return;
        }
        if (avgAggregator.value != null) {
            this.count += avgAggregator.count - 1L;
            this.accumulate(avgAggregator.value);
        }
    }

    @Override
    public DataValueDescriptor getResult() throws StandardException {
        Object object;
        if (this.count == 0L) {
            return null;
        }
        NumberDataValue numberDataValue = (NumberDataValue)this.value;
        NumberDataValue numberDataValue2 = (NumberDataValue)this.value.getNewNull();
        if (this.count > Integer.MAX_VALUE && (((String)(object = numberDataValue.getTypeName())).equals("INTEGER") || ((String)object).equals("TINYINT") || ((String)object).equals("SMALLINT"))) {
            numberDataValue2.setValue(0);
            return numberDataValue2;
        }
        object = new SQLLongint(this.count);
        numberDataValue.divide(numberDataValue, (NumberDataValue)object, numberDataValue2, this.scale);
        return numberDataValue2;
    }

    @Override
    public ExecAggregator newAggregator() {
        return new AvgAggregator();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.count);
        objectOutput.writeInt(this.scale);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.count = objectInput.readLong();
        this.scale = objectInput.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 149;
    }
}

