/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.guava.hash;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sparkproject.guava.annotations.Beta;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.hash.ElementTypesAreNonnullByDefault;
import org.sparkproject.guava.hash.HashCode;
import org.sparkproject.guava.hash.HashFunction;
import org.sparkproject.guava.hash.Hasher;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super(Preconditions.checkNotNull(out));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

