/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.guava.graph;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sparkproject.guava.collect.BiMap;
import org.sparkproject.guava.collect.HashBiMap;
import org.sparkproject.guava.collect.ImmutableBiMap;
import org.sparkproject.guava.graph.AbstractUndirectedNetworkConnections;
import org.sparkproject.guava.graph.EdgesConnecting;
import org.sparkproject.guava.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class UndirectedNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    UndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections(HashBiMap.create(2));
    }

    static <N, E> UndirectedNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

