/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class DateTimeFormatterHelper$ {
    public static final DateTimeFormatterHelper$ MODULE$ = new DateTimeFormatterHelper$();
    private static DateTimeFormatter fractionFormatter;
    private static final java.util.Map<Tuple3<String, Locale, Object>, DateTimeFormatter> org$apache$spark$sql$catalyst$util$DateTimeFormatterHelper$$cache;
    private static final Regex extractor;
    private static final Set<Object> weekBasedLetters;
    private static final Set<Object> unsupportedLetters;
    private static final Set<Object> unsupportedLettersForParsing;
    private static final Set<String> unsupportedPatternLengths;
    private static volatile boolean bitmap$0;

    static {
        org$apache$spark$sql$catalyst$util$DateTimeFormatterHelper$$cache = Collections.synchronizedMap(new LinkedHashMap<Tuple3<String, Locale, Object>, DateTimeFormatter>(){

            public boolean removeEldestEntry(Map.Entry<Tuple3<String, Locale, Object>, DateTimeFormatter> eldest) {
                return this.size() > 128;
            }
        });
        extractor = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([^S]*)(S*)(.*)$"));
        weekBasedLetters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'Y', 'W', 'w', 'u', 'e', 'c'}));
        unsupportedLetters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'A', 'B', 'n', 'N', 'p'}));
        unsupportedLettersForParsing = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'E', 'F', 'q', 'Q'}));
        unsupportedPatternLengths = ((IterableOnceOps)((IterableOps)new .colon.colon((Object)"G", (List)new .colon.colon((Object)"M", (List)new .colon.colon((Object)"L", (List)new .colon.colon((Object)"E", (List)new .colon.colon((Object)"Q", (List)new .colon.colon((Object)"q", (List)Nil$.MODULE$)))))).map((Function1 & Serializable)x$2 -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(x$2), 5))).$plus$plus((IterableOnce)new .colon.colon((Object)"y", (List)Nil$.MODULE$).map((Function1 & Serializable)x$3 -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(x$3), 7)))).toSet();
    }

    public java.util.Map<Tuple3<String, Locale, Object>, DateTimeFormatter> org$apache$spark$sql$catalyst$util$DateTimeFormatterHelper$$cache() {
        return org$apache$spark$sql$catalyst$util$DateTimeFormatterHelper$$cache;
    }

    public final Regex extractor() {
        return extractor;
    }

    public DateTimeFormatterBuilder createBuilder() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive();
    }

    public DateTimeFormatter toFormatter(DateTimeFormatterBuilder builder, Locale locale) {
        return builder.toFormatter(locale).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
    }

    public DateTimeFormatterBuilder createBuilderWithVarLengthSecondFraction(String pattern) {
        DateTimeFormatterBuilder builder = this.createBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])pattern.split("'")))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if ("".equals(string) && idx != 0) {
                    return builder.appendLiteral("'");
                }
            }
            if (tuple2 != null) {
                String patternPart = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (idx % 2 == 0) {
                    String rest = patternPart;
                    while (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rest))) {
                        Option option;
                        String string = rest;
                        if (string != null && !(option = MODULE$.extractor().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
                            String prefix = (String)((LinearSeqOps)option.get()).apply(0);
                            String secondFraction = (String)((LinearSeqOps)option.get()).apply(1);
                            String suffix = (String)((LinearSeqOps)option.get()).apply(2);
                            builder.appendPattern(prefix);
                            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(secondFraction)) ? builder.appendFraction(ChronoField.NANO_OF_SECOND, 1, secondFraction.length(), false) : BoxedUnit.UNIT;
                            rest = suffix;
                            continue;
                        }
                        throw new SparkIllegalArgumentException("INVALID_DATETIME_PATTERN.SECONDS_FRACTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)pattern)})));
                    }
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String patternPart = (String)tuple2._1();
                return builder.appendLiteral(patternPart);
            }
            throw new MatchError((Object)tuple2);
        });
        return builder;
    }

    public DateTimeFormatter buildFormatter(String pattern, Locale locale, boolean varLenEnabled) {
        DateTimeFormatterBuilder builder = varLenEnabled ? this.createBuilderWithVarLengthSecondFraction(pattern) : this.createBuilder().appendPattern(pattern);
        return this.toFormatter(builder, locale);
    }

    private DateTimeFormatter fractionFormatter$lzycompute() {
        DateTimeFormatterHelper$ dateTimeFormatterHelper$ = this;
        synchronized (dateTimeFormatterHelper$) {
            if (!bitmap$0) {
                DateTimeFormatterBuilder builder = this.createBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true);
                fractionFormatter = this.toFormatter(builder, TimestampFormatter$.MODULE$.defaultLocale());
                bitmap$0 = true;
            }
        }
        return fractionFormatter;
    }

    public DateTimeFormatter fractionFormatter() {
        if (!bitmap$0) {
            return this.fractionFormatter$lzycompute();
        }
        return fractionFormatter;
    }

    public final Set<Object> weekBasedLetters() {
        return weekBasedLetters;
    }

    public final Set<Object> unsupportedLetters() {
        return unsupportedLetters;
    }

    public final Set<Object> unsupportedLettersForParsing() {
        return unsupportedLettersForParsing;
    }

    public final Set<String> unsupportedPatternLengths() {
        return unsupportedPatternLengths;
    }

    public String convertIncompatiblePattern(String pattern, boolean isParsing) {
        boolean eraDesignatorContained = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])pattern.split("'")))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$1(x0$1)));
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])(pattern + " ").split("'")))), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String patternPart = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (index % 2 == 0) {
                    StringOps$.MODULE$.withFilter$extension(Predef$.MODULE$.augmentString(patternPart), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$3(BoxesRunTime.unboxToChar((Object)c)))).foreach((Function1 & Serializable)c -> DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$4(BoxesRunTime.unboxToChar((Object)c)));
                    StringOps$.MODULE$.withFilter$extension(Predef$.MODULE$.augmentString(patternPart), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$5(isParsing, BoxesRunTime.unboxToChar((Object)c)))).foreach((Function1 & Serializable)c -> DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$6(pattern, BoxesRunTime.unboxToChar((Object)c)));
                    MODULE$.unsupportedPatternLengths().withFilter((Function1 & Serializable)style -> BoxesRunTime.boxToBoolean((boolean)patternPart.contains(style))).foreach((Function1 & Serializable)style -> {
                        throw new SparkIllegalArgumentException("INVALID_DATETIME_PATTERN.LENGTH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), style)})));
                    });
                    if (!eraDesignatorContained) {
                        return patternPart.replace("y", "u");
                    }
                    return patternPart;
                }
                return patternPart;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))).mkString("'")), " ");
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String patternPart = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            return index % 2 == 0 && patternPart.contains("G");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$3(char c) {
        return MODULE$.weekBasedLetters().contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    public static final /* synthetic */ Nothing$ $anonfun$convertIncompatiblePattern$4(char c) {
        throw new SparkIllegalArgumentException("INCONSISTENT_BEHAVIOR_CROSS_VERSION.DATETIME_WEEK_BASED_PATTERN", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Character.toString(c))})));
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$5(boolean isParsing$1, char c) {
        return MODULE$.unsupportedLetters().contains((Object)BoxesRunTime.boxToCharacter((char)c)) || isParsing$1 && MODULE$.unsupportedLettersForParsing().contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    public static final /* synthetic */ Nothing$ $anonfun$convertIncompatiblePattern$6(String pattern$4, char c) {
        throw new SparkIllegalArgumentException("INVALID_DATETIME_PATTERN.ILLEGAL_CHARACTER", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Character.toString(c)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)pattern$4)})));
    }

    private DateTimeFormatterHelper$() {
    }
}

