/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Extract;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r}f\u0001\u0002!B\t2CQ\u0001\u001c\u0001\u0005\u00025DQa\u001c\u0001\u0005BADqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\u0001\u0011!\t\t\u0003\u0001b\u0001\n\u0013y\b\u0002CA\u0012\u0001\u0001\u0006I!!\u0001\t\u0011\u0005\u0015\u0002A1A\u0005\n}D\u0001\"a\n\u0001A\u0003%\u0011\u0011\u0001\u0005\b\u0003S\u0001A\u0011IA\u0016\r\u0019\t\t\u0004\u0001\u0001\u00024!1AN\u0003C\u0001\u0003{Aq!!\u0011\u000b\t\u0003\n\u0019\u0005C\u0004\u0002Z)!\t%a\u0017\t\u000f\u0005%$\u0002\"\u0011\u0002l!9\u0011Q\u0011\u0006\u0005B\u0005\u001d\u0005bBAI\u0015\u0011\u0005\u00131\u0013\u0005\b\u00033SA\u0011IAN\u0011\u001d\t\tK\u0003C!\u0003GCq!!,\u0001\t\u0003\ny\u000bC\u0004\u0002B\u0002!\t%a1\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9\u0011q\u001f\u0001\u0005B\u0005e\bb\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\b\u0005[\u0001A\u0011\tB\u0018\u0011\u001d\u0011\u0019\u0004\u0001C!\u0005kAqAa\u0011\u0001\t\u0003\u0012)\u0005C\u0004\u0003T\u0001!\tE!\u0016\t\u000f\t}\u0003\u0001\"\u0011\u0003b!9!1\u000e\u0001\u0005B\t5\u0004b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u0007\u0003A\u0011\tBC\u0011\u001d\u0011I\t\u0001C!\u0005\u0017CqAa1\u0001\t\u0003\u0012)\rC\u0004\u0003P\u0002!\tE!5\t\u000f\t]\u0007\u0001\"\u0011\u0003Z\"9!q\u001e\u0001\u0005B\tE\bbBB\u0010\u0001\u0011\u00053\u0011\u0005\u0004\u0007\u0007S\u0001\u0001aa\u000b\t\u0013\rMbE!A!\u0002\u0013i\u0005B\u0003B\u0006M\t\u0005\t\u0015!\u0003\u0003\u000e!1AN\nC\u0001\u0007kAqa!\u0010'\t\u0003\u001ay\u0004C\u0004\u0004B\u0001!\tea\u0011\t\u000f\r\u001d\u0003\u0001\"\u0011\u0004J!911\n\u0001\u0005B\r%\u0003bBB'\u0001\u0011\u00053\u0011\n\u0005\t\u0007\u001f\u0002\u0011\u0011!C\u0001[\"I1\u0011\u000b\u0001\u0002\u0002\u0013\u000531\u000b\u0005\n\u0007+\u0002\u0011\u0011!C\u0001\u0007/B\u0011b!\u0017\u0001\u0003\u0003%\taa\u0017\t\u0013\r\u001d\u0004!!A\u0005B\r%\u0004\"CB:\u0001\u0005\u0005I\u0011AB;\u0011%\u0019I\bAA\u0001\n\u0003\u001aY\bC\u0005\u0004\u0000\u0001\t\t\u0011\"\u0011\u0004\u0002\"I11\u0011\u0001\u0002\u0002\u0013\u00053Q\u0011\u0005\n\u0007\u000f\u0003\u0011\u0011!C!\u0007\u0013;\u0011b!$B\u0003\u0003EIaa$\u0007\u0011\u0001\u000b\u0015\u0011!E\u0005\u0007#Ca\u0001\u001c\u001e\u0005\u0002\r%\u0006\"CBBu\u0005\u0005IQIBC\u0011!\u0019YKOA\u0001\n\u0003k\u0007\"CBWu\u0005\u0005I\u0011QBX\u0011%\u0019)LOA\u0001\n\u0013\u00199L\u0001\u0007NsN\u000bF\nR5bY\u0016\u001cGO\u0003\u0002C\u0007\u0006!!\u000e\u001a2d\u0015\t!U)A\u0002tc2T!AR$\u0002\u000bM\u0004\u0018M]6\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0002\u0001'\u0019\u0001Q*U,[AB\u0011ajT\u0007\u0002\u0003&\u0011\u0001+\u0011\u0002\f\u0015\u0012\u00147\rR5bY\u0016\u001cG\u000f\u0005\u0002S+6\t1K\u0003\u0002U\u0007\u0006A1-\u0019;bYf\u001cH/\u0003\u0002W'\ni1+\u0015'D_:4\u0007*\u001a7qKJ\u0004\"A\u0014-\n\u0005e\u000b%!\u0005(p\u0019\u0016<\u0017mY=K\t\n\u001bUI\u001d:peB\u00111LX\u0007\u00029*\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\n9\u0001K]8ek\u000e$\bCA1j\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002f\u0017\u00061AH]8pizJ\u0011!X\u0005\u0003Qr\u000bq\u0001]1dW\u0006<W-\u0003\u0002kW\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\u000eX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0004\"A\u0014\u0001\u0002\u0013\r\fg\u000eS1oI2,GCA9u!\tY&/\u0003\u0002t9\n9!i\\8mK\u0006t\u0007\"B;\u0003\u0001\u00041\u0018aA;sYB\u0011qo\u001f\b\u0003qf\u0004\"a\u0019/\n\u0005id\u0016A\u0002)sK\u0012,g-\u0003\u0002}{\n11\u000b\u001e:j]\u001eT!A\u001f/\u0002K\u0011L7\u000f^5oGR,fn];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001cXCAA\u0001!\u0019\t\u0019!!\u0004\u0002\u00125\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005j[6,H/\u00192mK*\u0019\u00111\u0002/\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0005\u0015!aA*fiB!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001\u00027b]\u001eT!!a\u0007\u0002\t)\fg/Y\u0005\u0004y\u0006U\u0011A\n3jgRLgn\u0019;V]N,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005Y2/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N\fAd];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\b%\u0001\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\u0018aE:vaB|'\u000f^3e\rVt7\r^5p]N\u0004\u0013aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGcA9\u0002.!1\u0011qF\u0005A\u0002Y\f\u0001BZ;oG:\u000bW.\u001a\u0002\u0010\u001bf\u001c\u0016\u000bT*R\u0019\n+\u0018\u000e\u001c3feN\u0019!\"!\u000e\u0011\t\u0005]\u0012\u0011H\u0007\u0002\u0001%\u0019\u00111H(\u0003\u001d)#%iQ*R\u0019\n+\u0018\u000e\u001c3feR\u0011\u0011q\b\t\u0004\u0003oQ\u0011\u0001\u0004<jg&$X\t\u001f;sC\u000e$Hc\u0001<\u0002F!9\u0011q\t\u0007A\u0002\u0005%\u0013aB3yiJ\f7\r\u001e\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005M3)A\u0005d_:tWm\u0019;pe&!\u0011qKA'\u0005\u001d)\u0005\u0010\u001e:bGR\f\u0001C^5tSR\u001c\u0016\u000b\u0014$v]\u000e$\u0018n\u001c8\u0015\u000bY\fi&a\u0018\t\r\u0005=R\u00021\u0001w\u0011\u001d\t\t'\u0004a\u0001\u0003G\na!\u001b8qkR\u001c\b\u0003B.\u0002fYL1!a\u001a]\u0005\u0015\t%O]1z\u000391\u0018n]5u'>\u0014Ho\u0014:eKJ$rA^A7\u0003c\nY\b\u0003\u0004\u0002p9\u0001\rA^\u0001\bg>\u0014HoS3z\u0011\u001d\t\u0019H\u0004a\u0001\u0003k\nQb]8si\u0012K'/Z2uS>t\u0007\u0003BA&\u0003oJA!!\u001f\u0002N\ti1k\u001c:u\t&\u0014Xm\u0019;j_:Dq!! \u000f\u0001\u0004\ty(\u0001\u0007ok2dwJ\u001d3fe&tw\r\u0005\u0003\u0002L\u0005\u0005\u0015\u0002BAB\u0003\u001b\u0012ABT;mY>\u0013H-\u001a:j]\u001e\fqB^5tSR\u001cF/\u0019:ug^KG\u000f\u001b\u000b\u0006m\u0006%\u0015Q\u0012\u0005\u0007\u0003\u0017{\u0001\u0019\u0001<\u0002\u00031Da!a$\u0010\u0001\u00041\u0018!\u0001:\u0002\u001bYL7/\u001b;F]\u0012\u001cx+\u001b;i)\u00151\u0018QSAL\u0011\u0019\tY\t\u0005a\u0001m\"1\u0011q\u0012\tA\u0002Y\fQB^5tSR\u001cuN\u001c;bS:\u001cH#\u0002<\u0002\u001e\u0006}\u0005BBAF#\u0001\u0007a\u000f\u0003\u0004\u0002\u0010F\u0001\rA^\u0001\u0017m&\u001c\u0018\u000e^!hOJ,w-\u0019;f\rVt7\r^5p]R9a/!*\u0002(\u0006-\u0006BBA\u0018%\u0001\u0007a\u000f\u0003\u0004\u0002*J\u0001\r!]\u0001\u000bSN$\u0015n\u001d;j]\u000e$\bbBA1%\u0001\u0007\u00111M\u0001\u0012G>l\u0007/\u001b7f\u000bb\u0004(/Z:tS>tG\u0003BAY\u0003o\u0003BaWAZm&\u0019\u0011Q\u0017/\u0003\r=\u0003H/[8o\u0011\u001d\tIl\u0005a\u0001\u0003w\u000bA!\u001a=qeB!\u00111JA_\u0013\u0011\ty,!\u0014\u0003\u0015\u0015C\bO]3tg&|g.A\bhKR\u001c\u0015\r^1msN$H+\u001f9f))\t)-a5\u0002^\u0006\u0005\u0018Q\u001d\t\u00067\u0006M\u0016q\u0019\t\u0005\u0003\u0013\fy-\u0004\u0002\u0002L*\u0019\u0011QZ\"\u0002\u000bQL\b/Z:\n\t\u0005E\u00171\u001a\u0002\t\t\u0006$\u0018\rV=qK\"9\u0011Q\u001b\u000bA\u0002\u0005]\u0017aB:rYRK\b/\u001a\t\u00047\u0006e\u0017bAAn9\n\u0019\u0011J\u001c;\t\r\u0005}G\u00031\u0001w\u0003!!\u0018\u0010]3OC6,\u0007bBAr)\u0001\u0007\u0011q[\u0001\u0005g&TX\rC\u0004\u0002hR\u0001\r!!;\u0002\u00055$\u0007\u0003BAe\u0003WLA!!<\u0002L\nyQ*\u001a;bI\u0006$\u0018MQ;jY\u0012,'/A\brk>$X-\u00133f]RLg-[3s)\r1\u00181\u001f\u0005\u0007\u0003k,\u0002\u0019\u0001<\u0002\u000f\r|GNT1nK\u0006i1o\u00195f[\u0006\u001cX\t_5tiN$r!]A~\u0005\u0013\u0011y\u0002C\u0004\u0002~Z\u0001\r!a@\u0002\t\r|gN\u001c\t\u0005\u0005\u0003\u0011)!\u0004\u0002\u0003\u0004)\u0019A)!\u0007\n\t\t\u001d!1\u0001\u0002\u000b\u0007>tg.Z2uS>t\u0007b\u0002B\u0006-\u0001\u0007!QB\u0001\b_B$\u0018n\u001c8t!\u0011\u0011yAa\u0007\u000e\u0005\tE!b\u0001\"\u0003\u0014)!!Q\u0003B\f\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0007\te1)A\u0005fq\u0016\u001cW\u000f^5p]&!!Q\u0004B\t\u0005-QEIQ\"PaRLwN\\:\t\r\t\u0005b\u00031\u0001w\u0003\u0019\u00198\r[3nC\u0006YA.[:u'\u000eDW-\\1t)\u0019\u00119C!\u000b\u0003,A)1,!\u001a\u0002d!9\u0011Q`\fA\u0002\u0005}\bb\u0002B\u0006/\u0001\u0007!QB\u0001\u0019SN\u001c\u0015m]2bI&tw\r\u0016:v]\u000e\fG/\u001a+bE2,GC\u0001B\u0019!\u0011Y\u00161W9\u00021\u001d,G/\u00169eCR,7i\u001c7v[:$\u0016\u0010]3Rk\u0016\u0014\u0018\u0010F\u0004w\u0005o\u0011YDa\u0010\t\r\te\u0012\u00041\u0001w\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0003\u0004\u0003>e\u0001\rA^\u0001\u000bG>dW/\u001c8OC6,\u0007B\u0002B!3\u0001\u0007a/A\u0006oK^$\u0015\r^1UsB,\u0017\u0001F4fiJ+g.Y7f\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0005w\u0005\u000f\u0012IEa\u0013\u0003P!1!\u0011\b\u000eA\u0002YDaA!\u0010\u001b\u0001\u00041\bB\u0002B'5\u0001\u0007a/A\u0004oK^t\u0015-\\3\t\u000f\tE#\u00041\u0001\u0002X\u0006qAMY'bU>\u0014h+\u001a:tS>t\u0017aH4fiV\u0003H-\u0019;f\u0007>dW/\u001c8Ok2d\u0017MY5mSRL\u0018+^3ssR9aOa\u0016\u0003Z\tm\u0003B\u0002B\u001d7\u0001\u0007a\u000f\u0003\u0004\u0003>m\u0001\rA\u001e\u0005\u0007\u0005;Z\u0002\u0019A9\u0002\u0015%\u001ch*\u001e7mC\ndW-\u0001\u000bhKR$\u0016M\u00197f\u0007>lW.\u001a8u#V,'/\u001f\u000b\u0006m\n\r$q\r\u0005\u0007\u0005Kb\u0002\u0019\u0001<\u0002\u000bQ\f'\r\\3\t\r\t%D\u00041\u0001w\u0003\u001d\u0019w.\\7f]R\f1bZ3u\u0015\u0012\u00135\tV=qKR!!q\u000eB<!\u0015Y\u00161\u0017B9!\rq%1O\u0005\u0004\u0005k\n%\u0001\u0003&eE\u000e$\u0016\u0010]3\t\u000f\teT\u00041\u0001\u0002H\u0006\u0011A\r^\u0001\u0016O\u0016$8k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\u00151(q\u0010BA\u0011\u0019\u0011\tC\ba\u0001m\"1!\u0011\u000e\u0010A\u0002Y\f\u0001D]3n_Z,7k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\r1(q\u0011\u0005\u0007\u0005Cy\u0002\u0019\u0001<\u0002\u0017\r\u0014X-\u0019;f\u0013:$W\r\u001f\u000b\fm\n5%\u0011\u0013BQ\u0005[\u0013y\f\u0003\u0004\u0003\u0010\u0002\u0002\rA^\u0001\nS:$W\r\u001f(b[\u0016DqAa%!\u0001\u0004\u0011)*\u0001\u0006uC\ndW-\u00133f]R\u0004BAa&\u0003\u001e6\u0011!\u0011\u0014\u0006\u0005\u00057\u000b\t&A\u0004dCR\fGn\\4\n\t\t}%\u0011\u0014\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002BRA\u0001\u0007!QU\u0001\bG>dW/\u001c8t!\u0015Y\u0016Q\rBT!\u0011\tYE!+\n\t\t-\u0016Q\n\u0002\u000f\u001d\u0006lW\r\u001a*fM\u0016\u0014XM\\2f\u0011\u001d\u0011y\u000b\ta\u0001\u0005c\u000b\u0011cY8mk6t7\u000f\u0015:pa\u0016\u0014H/[3t!!\u0011\u0019L!/\u0003(\nuVB\u0001B[\u0015\u0011\u00119,!\u0007\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005w\u0013)LA\u0002NCB\u0004bAa-\u0003:Z4\bb\u0002BaA\u0001\u0007!QX\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\u0018aC5oI\u0016DX\t_5tiN$\u0012\"\u001dBd\u0005\u0013\u0014YM!4\t\u000f\u0005u\u0018\u00051\u0001\u0002\u0000\"1!qR\u0011A\u0002YDqAa%\"\u0001\u0004\u0011)\nC\u0004\u0003\f\u0005\u0002\rA!\u0004\u0002\u0013\u0011\u0014x\u000e]%oI\u0016DH#\u0002<\u0003T\nU\u0007B\u0002BHE\u0001\u0007a\u000fC\u0004\u0003\u0014\n\u0002\rA!&\u0002\u00171L7\u000f^%oI\u0016DXm\u001d\u000b\t\u00057\u0014IOa;\u0003nB)1,!\u001a\u0003^B!!q\u001cBs\u001b\t\u0011\tO\u0003\u0003\u0003d\ne\u0015!B5oI\u0016D\u0018\u0002\u0002Bt\u0005C\u0014!\u0002V1cY\u0016Le\u000eZ3y\u0011\u001d\tip\ta\u0001\u0003\u007fDqAa%$\u0001\u0004\u0011)\nC\u0004\u0003\f\r\u0002\rA!\u0004\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0007\u0003t\u000e\u001d11BB\b\u0007/\u0019YB\u0005\u0004\u0003v\ne(q \u0004\u0007\u0005o\u0004\u0001Aa=\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007\u0005\u0014Y0C\u0002\u0003~.\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0011\t\r\u000511A\u0007\u0002\u000b&\u00191QA#\u0003\u001dM\u0003\u0018M]6UQJ|w/\u00192mK\"91\u0011\u0002\u0013A\u0002\te\u0018!A3\t\r\r5A\u00051\u0001w\u0003%\u0019wN\u001c3ji&|g\u000eC\u0004\u0004\u0012\u0011\u0002\raa\u0005\u0002#5,7o]1hKB\u000b'/Y7fi\u0016\u00148\u000fE\u0003x\u0007+1h/C\u0002\u0003<vDaa!\u0007%\u0001\u00041\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:Daa!\b%\u0001\u0004\t\u0018!C5t%VtG/[7f\u0003)!'o\u001c9TG\",W.\u0019\u000b\u0006m\u000e\r2Q\u0005\u0005\u0007\u0005C)\u0003\u0019\u0001<\t\r\r\u001dR\u00051\u0001r\u0003\u001d\u0019\u0017m]2bI\u0016\u0014A#T=T#2\u001b\u0016\u000bT)vKJL()^5mI\u0016\u00148c\u0001\u0014\u0004.A\u0019aja\f\n\u0007\rE\u0012IA\nKI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'/A\u0004eS\u0006dWm\u0019;\u0015\r\r]2\u0011HB\u001e!\r\t9D\n\u0005\u0007\u0007gI\u0003\u0019A'\t\u000f\t-\u0011\u00061\u0001\u0003\u000e\u0005)!-^5mIR\ta/\u0001\fhKRTEMY2T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s)\u0011\u0019ic!\u0012\t\u000f\t-1\u00061\u0001\u0003\u000e\u0005i1/\u001e9q_J$8\u000fT5nSR,\u0012!]\u0001\u000fgV\u0004\bo\u001c:ug>3gm]3u\u00031\u0019X\u000f\u001d9peR\u001c\b*\u001b8u\u0003\u0011\u0019w\u000e]=\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002X\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB/\u0007G\u00022aWB0\u0013\r\u0019\t\u0007\u0018\u0002\u0004\u0003:L\b\"CB3e\u0005\u0005\t\u0019AAl\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\u000e\t\u0007\u0007[\u001ayg!\u0018\u000e\u0005\u0005%\u0011\u0002BB9\u0003\u0013\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0011oa\u001e\t\u0013\r\u0015D'!AA\u0002\ru\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0005\u0004~!I1QM\u001b\u0002\u0002\u0003\u0007\u0011q[\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q[\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011C\u0001\u0007KF,\u0018\r\\:\u0015\u0007E\u001cY\tC\u0005\u0004fa\n\t\u00111\u0001\u0004^\u0005aQ*_*R\u0019\u0012K\u0017\r\\3diB\u0011aJO\n\u0006u\rM5q\u0014\t\u0006\u0007+\u001bYJ\\\u0007\u0003\u0007/S1a!']\u0003\u001d\u0011XO\u001c;j[\u0016LAa!(\u0004\u0018\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u0019\u0011\t\r\u00056qU\u0007\u0003\u0007GSAa!*\u0002\u001a\u0005\u0011\u0011n\\\u0005\u0004U\u000e\rFCABH\u0003\u0015\t\u0007\u000f\u001d7z\u0003\u001d)h.\u00199qYf$2!]BY\u0011!\u0019\u0019LPA\u0001\u0002\u0004q\u0017a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u0018\t\u0005\u0003'\u0019Y,\u0003\u0003\u0004>\u0006U!AB(cU\u0016\u001cG\u000f")
public class MySQLDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(MySQLDialect x$0) {
        return MySQLDialect$.MODULE$.unapply(x$0);
    }

    public static MySQLDialect apply() {
        return MySQLDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    public Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MySQLSQLBuilder mysqlSQLBuilder = new MySQLSQLBuilder(this);
        try {
            some = new Some((Object)mysqlSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (-3 == n2 && "BIT".equalsIgnoreCase(typeName) && size != 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (-7 == n2 && size > 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (12 == n2 && "TINYTEXT".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ((12 == n2 ? true : 1 == n2) && "JSON".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (-6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ByteType$.MODULE$);
            }
            return new Some((Object)ShortType$.MODULE$);
        }
        if (5 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ShortType$.MODULE$);
            }
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (4 == n2 && "MEDIUMINT UNSIGNED".equalsIgnoreCase(typeName)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (7 == n2 ? true : 6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)FloatType$.MODULE$);
            }
            return new Some((Object)DoubleType$.MODULE$);
        }
        if (93 == n2) {
            bl = true;
            n = n2;
            if ("DATETIME".equalsIgnoreCase(typeName)) {
                return new Some((Object)this.getTimestampType(md.build()));
            }
        }
        if (bl && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        String escapedColName = colName.replace("`", "``");
        return "`" + escapedColName + "`";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion >= 8) {
            return "ALTER TABLE " + tableName + " RENAME COLUMN " + this.quoteIdentifier(columnName) + " TO " + this.quoteIdentifier(newName);
        }
        throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return "ALTER TABLE " + table + " COMMENT = '" + comment + "'";
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("LONGTEXT", -1));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TINYINT", -6));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType) && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return Option$.MODULE$.apply((Object)new JdbcType("DATETIME", 93));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCommentNamespaceError(schema);
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError(schema);
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.quoteIdentifier(tableIdent.name()) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(" ");
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + this.quoteIdentifier(tableIdent.name()) + " WHERE key_name = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName) + " ON " + tableIdent.name();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + tableIdent.name();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1050: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
                case 1061: {
                    String string = condition;
                    String string3 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 1091: {
                    String string = condition;
                    String string4 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string4) : string4 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema);
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceError(schema);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MySQLSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    public MySQLDialect copy() {
        return new MySQLDialect();
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MySQLDialect && ((MySQLDialect)x$1).canEqual(this);
    }

    private final Option getCatalystTypeForBitArray$1(MetadataBuilder md$1) {
        md$1.putLong("binarylong", 1L);
        if (this.conf().legacyMySqlBitArrayMappingEnabled()) {
            return new Some((Object)LongType$.MODULE$);
        }
        return new Some((Object)BinaryType$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$1));
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(indexComment)) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public MySQLDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_ADD", "DATE_DIFF"})));
    }

    public class MySQLSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(Extract extract2) {
            String field;
            block12: {
                field = extract2.field();
                String string = field;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1852950412: {
                        if ("SECOND".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case -1351979174: {
                        if ("YEAR_OF_WEEK".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 2660340: {
                        if ("WEEK".equals(string)) {
                            return "WEEKOFYEAR(" + this.build(extract2.source()) + ")";
                        }
                        break block12;
                    }
                    case 2074232729: {
                        if ("DAY_OF_WEEK".equals(string)) {
                            return "(WEEKDAY(" + this.build(extract2.source()) + ") + 1)";
                        }
                        break block12;
                    }
                    case 2074292194: {
                        if ("DAY_OF_YEAR".equals(string)) {
                            return "DAYOFYEAR(" + this.build(extract2.source()) + ")";
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                return this.visitUnexpectedExpr((Expression)extract2);
            }
            return super.visitExtract(field, this.build(extract2.source()));
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -1728155146: {
                    if (!"DATE_DIFF".equals(string)) break;
                    return "DATEDIFF(" + inputs[0] + ", " + inputs[1] + ")";
                }
                case -1718317968: {
                    if (!"DATE_ADD".equals(string)) break;
                    return "DATE_ADD(" + inputs[0] + ", INTERVAL " + inputs[1] + " DAY)";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
            Tuple2 tuple2 = new Tuple2((Object)sortDirection, (Object)nullOrdering);
            if (tuple2 != null) {
                SortDirection sortDirection2 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering2 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection2) && NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
                    return sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection3 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering3 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection3) && NullOrdering.NULLS_LAST.equals(nullOrdering3)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 1 ELSE 0 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection4 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering4 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection4) && NullOrdering.NULLS_FIRST.equals(nullOrdering4)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 0 ELSE 1 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection5 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering5 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection5) && NullOrdering.NULLS_LAST.equals(nullOrdering5)) {
                    return sortKey + " " + sortDirection;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        public String visitStartsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        public String visitEndsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "' ESCAPE '\\\\'";
        }

        public String visitContains(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer().org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer() {
            return (MySQLDialect)this.$outer;
        }

        public MySQLSQLBuilder(MySQLDialect $outer) {
        }
    }

    public class MySQLSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ MySQLDialect $outer;

        @Override
        public String build() {
            String limitOrOffsetStmt = this.limit() > 0 ? (this.offset() > 0 ? "LIMIT " + this.offset() + ", " + this.limit() : this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()))) : (this.offset() > 0 ? "LIMIT " + this.offset() + ", 18446744073709551615" : "");
            return this.options.prepareQuery() + "SELECT " + this.hintClause() + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + limitOrOffsetStmt;
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public MySQLSQLQueryBuilder(MySQLDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

