/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.RocksDBKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreChangeDataReader$;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.RocksDBValueStateEncoder;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001B\t\u0013\u0001\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00036\u0011!a\u0004A!A!\u0002\u0013i\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001b\u0001\u0005\u0002)Dqa\u001d\u0001A\u0002\u0013EC\u000fC\u0004v\u0001\u0001\u0007I\u0011\u000b<\t\rq\u0004\u0001\u0015)\u0003O\u0011\u0015i\b\u0001\"\u0011\u007f\u000f%\t)CEA\u0001\u0012\u0003\t9C\u0002\u0005\u0012%\u0005\u0005\t\u0012AA\u0015\u0011\u0019Ig\u0002\"\u0001\u00022!I\u00111\u0007\b\u0012\u0002\u0013\u0005\u0011Q\u0007\u0002\"%>\u001c7n\u001d#C'R\fG/Z*u_J,7\t[1oO\u0016$\u0015\r^1SK\u0006$WM\u001d\u0006\u0003'Q\tQa\u001d;bi\u0016T!!\u0006\f\u0002\u0013M$(/Z1nS:<'BA\f\u0019\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA\u00111\u0005J\u0007\u0002%%\u0011QE\u0005\u0002\u001b'R\fG/Z*u_J,7\t[1oO\u0016$\u0015\r^1SK\u0006$WM]\u0001\u0003M6\u0004\"\u0001K\u0015\u000e\u0003QI!A\u000b\u000b\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\u0006i1\u000f^1uK2{7-\u0019;j_:\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u0005\u0019\u001c(BA\u0019\u001d\u0003\u0019A\u0017\rZ8pa&\u00111G\f\u0002\u0005!\u0006$\b.\u0001\u0007ti\u0006\u0014HOV3sg&|g\u000e\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0003M_:<\u0017AC3oIZ+'o]5p]\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001j\t!![8\n\u0005\t{$\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0003IYW-\u001f,bYV,WI\\2pI\u0016\u0014X*\u00199\u0011\t\u0015ce*W\u0007\u0002\r*\u0011q\tS\u0001\u000bG>t7-\u001e:sK:$(BA%K\u0003\u0011)H/\u001b7\u000b\u0003-\u000bAA[1wC&\u0011QJ\u0012\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA(W\u001d\t\u0001F\u000b\u0005\u0002Ro5\t!K\u0003\u0002TA\u00051AH]8pizJ!!V\u001c\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+^\u0002RA\u000e.]?\nL!aW\u001c\u0003\rQ+\b\u000f\\34!\t\u0019S,\u0003\u0002_%\t1\"k\\2lg\u0012\u00135*Z=Ti\u0006$X-\u00128d_\u0012,'\u000f\u0005\u0002$A&\u0011\u0011M\u0005\u0002\u0019%>\u001c7n\u001d#C-\u0006dW/Z*uCR,WI\\2pI\u0016\u0014\bC\u0001\u001cd\u0013\t!wGA\u0003TQ>\u0014H/\u0001\td_24\u0015-\\5ms:\u000bW.Z(qiB\u0019ag\u001a(\n\u0005!<$AB(qi&|g.\u0001\u0004=S:LGO\u0010\u000b\tW2lgn\u001c9reB\u00111\u0005\u0001\u0005\u0006M!\u0001\ra\n\u0005\u0006W!\u0001\r\u0001\f\u0005\u0006i!\u0001\r!\u000e\u0005\u0006w!\u0001\r!\u000e\u0005\u0006y!\u0001\r!\u0010\u0005\u0006\u0007\"\u0001\r\u0001\u0012\u0005\bK\"\u0001\n\u00111\u0001g\u0003=\u0019\u0007.\u00198hK2|wmU;gM&DX#\u0001(\u0002'\rD\u0017M\\4fY><7+\u001e4gSb|F%Z9\u0015\u0005]T\bC\u0001\u001cy\u0013\tIxG\u0001\u0003V]&$\bbB>\u000b\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0014\u0001E2iC:<W\r\\8h'V4g-\u001b=!\u0003\u001d9W\r\u001e(fqR$\u0012a \t\u000bm\u0005\u0005\u0011QAA\u000b\u0003+)\u0014bAA\u0002o\t1A+\u001e9mKR\u0002B!a\u0002\u0002\u000e9\u00191%!\u0003\n\u0007\u0005-!#\u0001\u0006SK\u000e|'\u000f\u001a+za\u0016LA!a\u0004\u0002\u0012\t)a+\u00197vK&\u0019\u00111C\u001c\u0003\u0017\u0015sW/\\3sCRLwN\u001c\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005}\u0001$\u0001\u0005dCR\fG._:u\u0013\u0011\t\u0019#!\u0007\u0003\u0013Us7/\u00194f%><\u0018!\t*pG.\u001cHIQ*uCR,7\u000b^8sK\u000eC\u0017M\\4f\t\u0006$\u0018MU3bI\u0016\u0014\bCA\u0012\u000f'\rq\u00111\u0006\t\u0004m\u00055\u0012bAA\u0018o\t1\u0011I\\=SK\u001a$\"!a\n\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\t9DK\u0002g\u0003sY#!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b:\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011JA \u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RocksDBStateStoreChangeDataReader
extends StateStoreChangeDataReader {
    private final ConcurrentHashMap<String, Tuple3<RocksDBKeyStateEncoder, RocksDBValueStateEncoder, Object>> keyValueEncoderMap;
    private final Option<String> colFamilyNameOpt;
    private String changelogSuffix;

    public static Option<String> $lessinit$greater$default$7() {
        return RocksDBStateStoreChangeDataReader$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String changelogSuffix() {
        return this.changelogSuffix;
    }

    @Override
    public void changelogSuffix_$eq(String x$1) {
        this.changelogSuffix = x$1;
    }

    public Tuple4<Enumeration.Value, UnsafeRow, UnsafeRow, Object> getNext() {
        Tuple3 currRecord = null;
        Tuple3<RocksDBKeyStateEncoder, RocksDBValueStateEncoder, Object> currEncoder = this.keyValueEncoderMap.get(this.colFamilyNameOpt.getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME()));
        if (this.colFamilyNameOpt.isDefined()) {
            while (currRecord == null) {
                Tuple3 result;
                StateStoreChangelogReader reader = this.currentChangelogReader();
                if (reader == null) {
                    return null;
                }
                Tuple3 nextRecord = (Tuple3)reader.next();
                byte[] colFamilyIdBytes = RocksDBStateStoreProvider$.MODULE$.getColumnFamilyIdAsBytes(BoxesRunTime.unboxToShort((Object)currEncoder._3()));
                int endIndex = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(colFamilyIdBytes));
                if (!Arrays.equals((byte[])nextRecord._2(), 0, endIndex, colFamilyIdBytes, 0, endIndex)) continue;
                byte[] extractedKey = RocksDBStateStoreProvider$.MODULE$.decodeStateRowWithPrefix((byte[])nextRecord._2());
                currRecord = result = new Tuple3(nextRecord._1(), (Object)extractedKey, nextRecord._3());
            }
        } else {
            StateStoreChangelogReader reader = this.currentChangelogReader();
            if (reader == null) {
                return null;
            }
            currRecord = (Tuple3)reader.next();
        }
        UnsafeRow keyRow = ((RocksDBKeyStateEncoder)currEncoder._1()).decodeKey((byte[])currRecord._2());
        if (currRecord._3() == null) {
            return new Tuple4(currRecord._1(), (Object)keyRow, null, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
        }
        UnsafeRow valueRow = ((RocksDBValueStateEncoder)currEncoder._2()).decodeValue((byte[])currRecord._3());
        return new Tuple4(currRecord._1(), (Object)keyRow, (Object)valueRow, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
    }

    public RocksDBStateStoreChangeDataReader(CheckpointFileManager fm, Path stateLocation, long startVersion, long endVersion, CompressionCodec compressionCodec, ConcurrentHashMap<String, Tuple3<RocksDBKeyStateEncoder, RocksDBValueStateEncoder, Object>> keyValueEncoderMap, Option<String> colFamilyNameOpt) {
        this.keyValueEncoderMap = keyValueEncoderMap;
        this.colFamilyNameOpt = colFamilyNameOpt;
        super(fm, stateLocation, startVersion, endVersion, compressionCodec, colFamilyNameOpt);
        this.changelogSuffix = "changelog";
    }
}

