/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CommitLog;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import org.apache.spark.sql.execution.streaming.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadata;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV1;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV2;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class OperatorStateMetadataUtils$
implements Logging {
    public static final OperatorStateMetadataUtils$ MODULE$ = new OperatorStateMetadataUtils$();
    private static final Formats formats;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return formats;
    }

    public Option<OperatorStateMetadata> readMetadata(FSDataInputStream inputStream, int expectedVersion) {
        Some some;
        BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        try {
            String versionStr = inputReader.readLine();
            int version = MetadataVersionUtil$.MODULE$.validateVersion(versionStr, 2);
            if (version != expectedVersion) {
                throw new IllegalArgumentException("Expected version " + expectedVersion + ", but found " + version);
            }
            some = new Some((Object)this.deserialize(version, inputReader));
        }
        finally {
            inputStream.close();
        }
        return some;
    }

    public void writeMetadata(CheckpointFileManager.CancellableFSDataOutputStream outputStream, OperatorStateMetadata operatorMetadata, Path metadataFilePath) {
        try {
            outputStream.write(("v" + operatorMetadata.version() + "\n").getBytes(StandardCharsets.UTF_8));
            this.serialize(outputStream, operatorMetadata);
            outputStream.close();
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to write state metadata file to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.META_FILE$.MODULE$, (Object)metadataFilePath)}))), e);
            outputStream.cancel();
            throw e;
        }
    }

    public OperatorStateMetadata deserialize(int version, BufferedReader in) {
        int n = version;
        switch (n) {
            case 1: {
                return (OperatorStateMetadata)Serialization$.MODULE$.read((Reader)in, this.formats(), ManifestFactory$.MODULE$.classType(OperatorStateMetadataV1.class));
            }
            case 2: {
                return (OperatorStateMetadata)Serialization$.MODULE$.read((Reader)in, this.formats(), ManifestFactory$.MODULE$.classType(OperatorStateMetadataV2.class));
            }
        }
        throw new IllegalArgumentException("Failed to deserialize operator metadata with version=" + version);
    }

    public void serialize(FSDataOutputStream out, OperatorStateMetadata operatorStateMetadata) {
        int n = operatorStateMetadata.version();
        switch (n) {
            case 1: {
                Serialization$.MODULE$.write((Object)((OperatorStateMetadataV1)operatorStateMetadata), (OutputStream)out, this.formats());
                return;
            }
            case 2: {
                Serialization$.MODULE$.write((Object)((OperatorStateMetadataV2)operatorStateMetadata), (OutputStream)out, this.formats());
                return;
            }
        }
        throw new IllegalArgumentException("Failed to serialize operator metadata with version=" + operatorStateMetadata.version());
    }

    public long getLastOffsetBatch(SparkSession session, String checkpointLocation) {
        OffsetSeqLog offsetLog = new OffsetSeqLog(session, new Path(checkpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_OFFSETS()).toString());
        return BoxesRunTime.unboxToLong((Object)offsetLog.getLatest().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0 & Serializable)() -> {
            throw StateDataSourceErrors$.MODULE$.offsetLogUnavailable(0L, checkpointLocation);
        }));
    }

    public Option<Object> getLastCommittedBatch(SparkSession session, String checkpointLocation) {
        CommitLog commitLog = new CommitLog(session, new Path(checkpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_COMMITS()).toString());
        return commitLog.getLatest().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2._1$mcJ$sp()));
    }

    private OperatorStateMetadataUtils$() {
    }
}

