/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.IterableFactory;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.MapFactory;
import coursierapi.shaded.scala.collection.MapOps;
import coursierapi.shaded.scala.collection.Set;
import coursierapi.shaded.scala.collection.StrictOptimizedIterableOps;
import coursierapi.shaded.scala.collection.StrictOptimizedMapOps;
import coursierapi.shaded.scala.collection.generic.DefaultSerializable;
import coursierapi.shaded.scala.collection.mutable.AbstractMap;
import coursierapi.shaded.scala.collection.mutable.Iterable;
import coursierapi.shaded.scala.collection.mutable.LinkedHashMap$;
import coursierapi.shaded.scala.collection.mutable.LinkedHashSet$;
import coursierapi.shaded.scala.collection.mutable.SeqMap;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.hashing.MurmurHash3$;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LinkedHashMap<K, V>
extends AbstractMap<K, V>
implements StrictOptimizedMapOps<K, V, LinkedHashMap, LinkedHashMap<K, V>>,
DefaultSerializable,
SeqMap<K, V> {
    private LinkedEntry<K, V> firstEntry = null;
    private LinkedEntry<K, V> lastEntry = null;
    public LinkedEntry<K, V>[] scala$collection$mutable$LinkedHashMap$$table = new LinkedEntry[this.tableSizeFor(16)];
    private int threshold = (int)((double)this.scala$collection$mutable$LinkedHashMap$$table.length * 0.75);
    private int contentSize = 0;

    @Override
    public IterableOps map(Function1 f) {
        return StrictOptimizedMapOps.map$(this, f);
    }

    @Override
    public IterableOps flatMap(Function1 f) {
        return StrictOptimizedMapOps.flatMap$(this, f);
    }

    @Override
    public IterableOps concat(IterableOnce suffix) {
        return StrictOptimizedMapOps.concat$(this, suffix);
    }

    @Override
    public IterableOps collect(PartialFunction pf) {
        return StrictOptimizedMapOps.collect$(this, pf);
    }

    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public MapFactory<LinkedHashMap> mapFactory() {
        return LinkedHashMap$.MODULE$;
    }

    public LinkedEntry<K, V> firstEntry() {
        return this.firstEntry;
    }

    public void firstEntry_$eq(LinkedEntry<K, V> x$1) {
        this.firstEntry = x$1;
    }

    public LinkedEntry<K, V> lastEntry() {
        return this.lastEntry;
    }

    public void lastEntry_$eq(LinkedEntry<K, V> x$1) {
        this.lastEntry = x$1;
    }

    @Override
    public Tuple2<K, V> last() {
        if (this.size() > 0) {
            return new Tuple2<K, V>(this.lastEntry().key(), this.lastEntry().value());
        }
        throw new NoSuchElementException("Cannot call .last on empty LinkedHashMap");
    }

    @Override
    public Option<Tuple2<K, V>> lastOption() {
        if (this.size() > 0) {
            return new Some<Tuple2<K, V>>(new Tuple2<K, V>(this.lastEntry().key(), this.lastEntry().value()));
        }
        return None$.MODULE$;
    }

    @Override
    public Tuple2<K, V> head() {
        if (this.size() > 0) {
            return new Tuple2<K, V>(this.firstEntry().key(), this.firstEntry().value());
        }
        throw new NoSuchElementException("Cannot call .head on empty LinkedHashMap");
    }

    @Override
    public Option<Tuple2<K, V>> headOption() {
        if (this.size() > 0) {
            return new Some<Tuple2<K, V>>(new Tuple2<K, V>(this.firstEntry().key(), this.firstEntry().value()));
        }
        return None$.MODULE$;
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Option<V> get(K key) {
        int findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1];
        LinkedEntry<K, V> linkedEntry2 = linkedEntry == null ? null : linkedEntry.findEntry(key, findEntry_hash);
        linkedEntry = null;
        LinkedEntry<K, V> e = linkedEntry2;
        if (e == null) {
            return None$.MODULE$;
        }
        return new Some<V>(e.value());
    }

    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / 0.75));
        if (target > this.scala$collection$mutable$LinkedHashMap$$table.length) {
            this.growTable(target);
            return;
        }
    }

    @Override
    public boolean contains(K key) {
        if (this.getClass() == LinkedHashMap.class) {
            int findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
            int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
            LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1];
            LinkedEntry<K, V> linkedEntry2 = linkedEntry == null ? null : linkedEntry.findEntry(key, findEntry_hash);
            linkedEntry = null;
            return linkedEntry2 != null;
        }
        return MapOps.contains$(this, key);
    }

    @Override
    public Option<V> put(K key, V value) {
        Some<V> some = this.put0(key, value, true);
        if (some == null) {
            return None$.MODULE$;
        }
        return some;
    }

    @Override
    public void update(K key, V value) {
        this.put0(key, value, false);
    }

    @Override
    public Option<V> remove(K key) {
        LinkedEntry<K, V> linkedEntry = this.removeEntry0(key);
        if (linkedEntry == null) {
            return None$.MODULE$;
        }
        return new Some<V>(linkedEntry.value());
    }

    @Override
    public <V1> V1 getOrElse(K key, Function0<V1> function0) {
        Class<?> clazz = this.getClass();
        Class<LinkedHashMap> clazz2 = LinkedHashMap.class;
        if (clazz == null || !clazz.equals(clazz2)) {
            Option option = this.get(key);
            if (option instanceof Some) {
                return (V1)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                return function0.apply();
            }
            throw new MatchError(option);
        }
        int findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1];
        LinkedEntry<K, V> linkedEntry2 = linkedEntry == null ? null : linkedEntry.findEntry(key, findEntry_hash);
        linkedEntry = null;
        LinkedEntry<K, V> nd = linkedEntry2;
        if (nd == null) {
            return function0.apply();
        }
        return (V1)nd.value();
    }

    @Override
    public V getOrElseUpdate(K key, Function0<V> defaultValue) {
        LinkedEntry<K, V> nd;
        Class<?> clazz = this.getClass();
        Class<LinkedHashMap> clazz2 = LinkedHashMap.class;
        if (clazz == null || !clazz.equals(clazz2)) {
            Option option = this.get(key);
            if (option instanceof Some) {
                return (V)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                V getOrElseUpdate_d = defaultValue.apply();
                this.update(key, getOrElseUpdate_d);
                return getOrElseUpdate_d;
            }
            throw new MatchError(option);
        }
        int scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int hash = scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        int idx = hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[idx];
        LinkedEntry<K, V> linkedEntry2 = nd = linkedEntry == null ? null : linkedEntry.findEntry(key, hash);
        if (nd != null) {
            return nd.value();
        }
        LinkedEntry<K, V>[] table0 = this.scala$collection$mutable$LinkedHashMap$$table;
        V v = defaultValue.apply();
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$LinkedHashMap$$table.length * 2);
        }
        int newIdx = table0 == this.scala$collection$mutable$LinkedHashMap$$table ? idx : hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        this.put0(key, v, false, hash, newIdx);
        return v;
    }

    private LinkedEntry<K, V> removeEntry0(K elem) {
        int scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(elem);
        return this.removeEntry0(elem, scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16);
    }

    private LinkedEntry<K, V> removeEntry0(K elem, int hash) {
        int idx = hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[idx];
        if (linkedEntry == null) {
            return null;
        }
        if (linkedEntry.hash() == hash && BoxesRunTime.equals(linkedEntry.key(), elem)) {
            this.scala$collection$mutable$LinkedHashMap$$table[idx] = linkedEntry.next();
            this.deleteEntry(linkedEntry);
            --this.contentSize;
            return linkedEntry;
        }
        LinkedEntry<K, V> prev = linkedEntry;
        for (LinkedEntry<K, V> next = linkedEntry.next(); next != null && next.hash() <= hash; next = next.next()) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                this.deleteEntry(next);
                --this.contentSize;
                return next;
            }
            prev = next;
        }
        return null;
    }

    public int unimproveHash(int improvedHash) {
        return improvedHash ^ improvedHash >>> 16;
    }

    public LinkedHashMap<K, V> addOne(Tuple2<K, V> kv) {
        this.put(kv._1(), kv._2());
        return this;
    }

    public LinkedHashMap<K, V> subtractOne(K key) {
        this.remove(key);
        return this;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator(this){

            public Tuple2<K, V> extract(LinkedEntry<K, V> nd) {
                return new Tuple2<K, V>(nd.key(), nd.value());
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new LinkedKeySet(this);
    }

    @Override
    public Iterator<K> keysIterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator(this){

            public K extract(LinkedEntry<K, V> nd) {
                return nd.key();
            }
        };
    }

    public Iterator<LinkedEntry<K, V>> entryIterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator(this){

            public LinkedEntry<K, V> extract(LinkedEntry<K, V> nd) {
                return nd;
            }
        };
    }

    @Override
    public Iterator<V> valuesIterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator(this){

            public V extract(LinkedEntry<K, V> nd) {
                return nd.value();
            }
        };
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        for (LinkedEntry<K, V> cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply(new Tuple2<K, V>(cur.key(), cur.value()));
        }
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        for (LinkedEntry<K, V> cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply(cur.key(), cur.value());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.scala$collection$mutable$LinkedHashMap$$table, null);
        this.contentSize = 0;
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private int tableSizeFor(int capacity) {
        int n = capacity - 1;
        int max$extension_that = 4;
        int n2 = Integer.highestOneBit(Math.max(n, max$extension_that)) * 2;
        int min$extension_that = 0x40000000;
        return Math.min(n2, min$extension_that);
    }

    private LinkedEntry<K, V> createNewEntry(K key, int hash, V value) {
        LinkedEntry<K, V> e = new LinkedEntry<K, V>(key, hash, value);
        if (this.firstEntry() == null) {
            this.firstEntry_$eq(e);
        } else {
            this.lastEntry().later_$eq(e);
            e.earlier_$eq(this.lastEntry());
        }
        this.lastEntry_$eq(e);
        return e;
    }

    private void deleteEntry(LinkedEntry<K, V> e) {
        if (e.earlier() == null) {
            this.firstEntry_$eq(e.later());
        } else {
            e.earlier().later_$eq(e.later());
        }
        if (e.later() == null) {
            this.lastEntry_$eq(e.earlier());
        } else {
            e.later().earlier_$eq(e.earlier());
        }
        e.earlier_$eq(null);
        e.later_$eq(null);
        e.next_$eq(null);
    }

    private Some<V> put0(K key, V value, boolean getOld) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$LinkedHashMap$$table.length * 2);
        }
        int scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int hash = scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        int idx = hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        return this.put0(key, value, getOld, hash, idx);
    }

    private Some<V> put0(K key, V value, boolean getOld, int hash, int idx) {
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[idx];
        if (linkedEntry == null) {
            this.scala$collection$mutable$LinkedHashMap$$table[idx] = this.createNewEntry(key, hash, value);
        } else {
            LinkedEntry<K, V> prev = null;
            for (LinkedEntry<K, V> n = linkedEntry; n != null && n.hash() <= hash; n = n.next()) {
                if (n.hash() == hash && BoxesRunTime.equals(key, n.key())) {
                    V old = n.value();
                    n.value_$eq(value);
                    if (getOld) {
                        return new Some<V>(old);
                    }
                    return null;
                }
                prev = n;
            }
            LinkedEntry<K, V> nnode = this.createNewEntry(key, hash, value);
            if (prev == null) {
                nnode.next_$eq(linkedEntry);
                this.scala$collection$mutable$LinkedHashMap$$table[idx] = nnode;
            } else {
                nnode.next_$eq(prev.next());
                prev.next_$eq(nnode);
            }
        }
        ++this.contentSize;
        return null;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException(new StringBuilder(36).append("new hash table size ").append(newlen).append(" exceeds maximum").toString());
        }
        this.threshold = (int)((double)newlen * 0.75);
        if (this.size() == 0) {
            this.scala$collection$mutable$LinkedHashMap$$table = new LinkedEntry[newlen];
            return;
        }
        this.scala$collection$mutable$LinkedHashMap$$table = Arrays.copyOf(this.scala$collection$mutable$LinkedHashMap$$table, newlen);
        LinkedEntry<Object, Object> preLow = new LinkedEntry<Object, Object>(null, 0, null);
        LinkedEntry<Object, Object> preHigh = new LinkedEntry<Object, Object>(null, 0, null);
        for (int oldlen = this.scala$collection$mutable$LinkedHashMap$$table.length; oldlen < newlen; oldlen *= 2) {
            for (int i = 0; i < oldlen; ++i) {
                LinkedEntry<K, V> old = this.scala$collection$mutable$LinkedHashMap$$table[i];
                if (old == null) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                LinkedEntry<Object, Object> lastLow = preLow;
                LinkedEntry<Object, Object> lastHigh = preHigh;
                LinkedEntry<K, V> n = old;
                while (n != null) {
                    LinkedEntry<K, V> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (old != preLow.next()) {
                    this.scala$collection$mutable$LinkedHashMap$$table[i] = preLow.next();
                }
                if (preHigh.next() == null) continue;
                this.scala$collection$mutable$LinkedHashMap$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return MurmurHash3$.MODULE$.emptyMapHash();
        }
        LinkedHashMapIterator tupleHashIterator = new LinkedHashMapIterator(this){
            private int hash;
            private final /* synthetic */ LinkedHashMap $outer;

            public int hash() {
                return this.hash;
            }

            public void hash_$eq(int x$1) {
                this.hash = x$1;
            }

            public int hashCode() {
                return this.hash();
            }

            public Object extract(LinkedEntry<K, V> nd) {
                this.hash_$eq(MurmurHash3$.MODULE$.tuple2Hash(this.$outer.unimproveHash(nd.hash()), Statics.anyHash(nd.value())));
                return this;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hash = 0;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash(tupleHashIterator, MurmurHash3$.MODULE$.mapSeed());
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashMap";
    }

    public static final class LinkedEntry<K, V> {
        private final K key;
        private final int hash;
        private V value;
        private LinkedEntry<K, V> earlier;
        private LinkedEntry<K, V> later;
        private LinkedEntry<K, V> next;

        public K key() {
            return this.key;
        }

        public int hash() {
            return this.hash;
        }

        public V value() {
            return this.value;
        }

        public void value_$eq(V x$1) {
            this.value = x$1;
        }

        public LinkedEntry<K, V> earlier() {
            return this.earlier;
        }

        public void earlier_$eq(LinkedEntry<K, V> x$1) {
            this.earlier = x$1;
        }

        public LinkedEntry<K, V> later() {
            return this.later;
        }

        public void later_$eq(LinkedEntry<K, V> x$1) {
            this.later = x$1;
        }

        public LinkedEntry<K, V> next() {
            return this.next;
        }

        public void next_$eq(LinkedEntry<K, V> x$1) {
            this.next = x$1;
        }

        public final LinkedEntry<K, V> findEntry(K k, int h) {
            while (h != this_.hash() || !BoxesRunTime.equals(k, this_.key())) {
                if (this_.next() == null || this_.hash() > h) {
                    return null;
                }
                LinkedEntry<K, V> this_ = this_.next();
            }
            return this_;
        }

        public LinkedEntry(K key, int hash, V value) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.earlier = null;
            this.later = null;
            this.next = null;
        }
    }

    private abstract class LinkedHashMapIterator<T>
    extends AbstractIterator<T> {
        private LinkedEntry<K, V> cur;

        public abstract T extract(LinkedEntry<K, V> var1);

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T r = this.extract(this.cur);
                this.cur = this.cur.later();
                return r;
            }
            return (T)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        public LinkedHashMapIterator() {
            if (LinkedHashMap.this == null) {
                throw null;
            }
            this.cur = LinkedHashMap.this.firstEntry();
        }
    }

    public class LinkedKeySet
    extends MapOps.KeySet {
        @Override
        public IterableFactory<Set> iterableFactory() {
            return LinkedHashSet$.MODULE$;
        }

        public LinkedKeySet(LinkedHashMap $outer) {
            super($outer);
        }
    }
}

