/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import java.io.Serializable;
import java.math.BigInteger;

public final class ZipEightByteInteger
implements Serializable {
    public static final ZipEightByteInteger ZERO = new ZipEightByteInteger(0L);
    private final BigInteger value;

    public static byte[] getBytes(BigInteger value) {
        byte[] result = new byte[8];
        long val = value.longValue();
        result[0] = (byte)(val & 0xFFL);
        result[1] = (byte)((val & 0xFF00L) >> 8);
        result[2] = (byte)((val & 0xFF0000L) >> 16);
        result[3] = (byte)((val & 0xFF000000L) >> 24);
        result[4] = (byte)((val & 0xFF00000000L) >> 32);
        result[5] = (byte)((val & 0xFF0000000000L) >> 40);
        result[6] = (byte)((val & 0xFF000000000000L) >> 48);
        result[7] = (byte)((val & 0x7F00000000000000L) >> 56);
        if (value.testBit(63)) {
            result[7] = (byte)(result[7] | 0xFFFFFF80);
        }
        return result;
    }

    public static byte[] getBytes(long value) {
        return ZipEightByteInteger.getBytes(BigInteger.valueOf(value));
    }

    public static long getLongValue(byte[] bytes) {
        return ZipEightByteInteger.getLongValue(bytes, 0);
    }

    public static long getLongValue(byte[] bytes, int offset) {
        return ZipEightByteInteger.getValue(bytes, offset).longValue();
    }

    public static BigInteger getValue(byte[] bytes, int offset) {
        long value = (long)bytes[offset + 7] << 56 & 0x7F00000000000000L;
        value += (long)bytes[offset + 6] << 48 & 0xFF000000000000L;
        value += (long)bytes[offset + 5] << 40 & 0xFF0000000000L;
        value += (long)bytes[offset + 4] << 32 & 0xFF00000000L;
        value += (long)bytes[offset + 3] << 24 & 0xFF000000L;
        value += (long)bytes[offset + 2] << 16 & 0xFF0000L;
        value += (long)bytes[offset + 1] << 8 & 0xFF00L;
        BigInteger val = BigInteger.valueOf(value += (long)bytes[offset] & 0xFFL);
        return (bytes[offset + 7] & 0xFFFFFF80) == -128 ? val.setBit(63) : val;
    }

    public ZipEightByteInteger(BigInteger value) {
        this.value = value;
    }

    public ZipEightByteInteger(byte[] bytes, int offset) {
        this.value = ZipEightByteInteger.getValue(bytes, offset);
    }

    public ZipEightByteInteger(long value) {
        this(BigInteger.valueOf(value));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZipEightByteInteger)) {
            return false;
        }
        return this.value.equals(((ZipEightByteInteger)o).getValue());
    }

    public byte[] getBytes() {
        return ZipEightByteInteger.getBytes(this.value);
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "ZipEightByteInteger value: " + this.value;
    }
}

