/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskMetrics;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.TaskStatus;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.util.Utils$;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\t5d!B\u0006\r\u00011A\u0002\"B\u0012\u0001\t\u0003)\u0003\"B\u0014\u0001\t\u0003A\u0003bBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a%\u0001\t\u0003\t)\nC\u0004\u0002d\u0002!\t!!:\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!\u0011\t\u0001\u0005\u0002\t\r\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0002\u000f'R\fw-Z:SKN|WO]2f\u0015\tia\"\u0001\u0002wc)\u0011q\u0002E\u0001\u0004CBL'BA\t\u0013\u0003\u0019\u0019H/\u0019;vg*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xmE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005a\u0011B\u0001\u0012\r\u0005=\u0011\u0015m]3BaB\u0014Vm]8ve\u000e,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0019\u0002\"\u0001\t\u0001\u0002\u0013M$\u0018mZ3MSN$HCB\u00159%~#G\u000fE\u0002+eUr!a\u000b\u0019\u000f\u00051zS\"A\u0017\u000b\u00059\"\u0013A\u0002\u001fs_>$h(C\u0001\u001d\u0013\t\t4$A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$aA*fc*\u0011\u0011g\u0007\t\u0003AYJ!a\u000e\u0007\u0003\u0013M#\u0018mZ3ECR\f\u0007\"B\u001d\u0003\u0001\u0004Q\u0014\u0001C:uCR,8/Z:\u0011\u0007m\u0002%)D\u0001=\u0015\tid(\u0001\u0003vi&d'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012A\u0001T5tiB\u0011\u0001eQ\u0005\u0003\t2\u00111b\u0015;bO\u0016\u001cF/\u0019;vg\"\"\u0001H\u0012)R!\t9e*D\u0001I\u0015\tI%*\u0001\u0002sg*\u00111\nT\u0001\u0003oNT\u0011!T\u0001\bU\u0006\\\u0017M\u001d;b\u0013\ty\u0005J\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\fQA^1mk\u0016\f\u0013!\u0005\u0005\u0006'\n\u0001\r\u0001V\u0001\bI\u0016$\u0018-\u001b7t!\tQR+\u0003\u0002W7\t9!i\\8mK\u0006t\u0007\u0006\u0002*G!b\u000b\u0013a\u0015\u0015\u0005%j\u0003V\f\u0005\u0002H7&\u0011A\f\u0013\u0002\r\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0002=\u0006)a-\u00197tK\")\u0001M\u0001a\u0001)\u0006iq/\u001b;i'VlW.\u0019:jKNDCa\u0018$QE\u0006\n\u0001\r\u000b\u0003`5Bk\u0006\"B3\u0003\u0001\u00041\u0017AD9vC:$\u0018\u000e\\3TiJLgn\u001a\t\u0003O.t!\u0001[5\u0011\u00051Z\u0012B\u00016\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)\\\u0002\u0006\u00023G!>\f\u0013\u0001]\u0001\ncV\fg\u000e^5mKNDC\u0001\u001a.Qe\u0006\n1/A\u000b1]Ab\u0003G\f\u001a6YArS\u0007\f\u0019/oUb\u0013G\f\u0019\t\u000bU\u0014\u0001\u0019\u0001<\u0002\u0015Q\f7o[*uCR,8\u000fE\u0002<\u0001^\u0004\"\u0001\t=\n\u0005ed!A\u0003+bg.\u001cF/\u0019;vg\"\"AO\u0012)|C\u0005)\bF\u0001\u0002~!\t9e0\u0003\u0002\u0000\u0011\n\u0019q)\u0012+\u0002\u0013M$\u0018mZ3ECR\fGcC\u0015\u0002\u0006\u0005e\u00111EA\u0014\u0003[Aq!a\u0002\u0004\u0001\u0004\tI!A\u0004ti\u0006<W-\u00133\u0011\u0007i\tY!C\u0002\u0002\u000em\u00111!\u00138uQ\u001d\t)!!\u0005Q\u0003/\u00012aRA\n\u0013\r\t)\u0002\u0013\u0002\n!\u0006$\b\u000eU1sC6\f#!a\u0002\t\u000bM\u001b\u0001\u0019\u0001+)\u000b\u0005ea\t\u0015-)\r\u0005e!\fUA\u0010C\t\t\t#\u0001\u0003ueV,\u0007\"B;\u0004\u0001\u00041\b&BA\u0012\rB[\b\"\u00021\u0004\u0001\u0004!\u0006&BA\u0014\rB\u0013\u0007&BA\u00145Bk\u0006\"B3\u0004\u0001\u00041\u0007&BA\u0017\rB{\u0007&BA\u00175B\u0013\bFA\u0002~Q\u0019\u0019\u0011q\u0007)\u0002>A\u0019q)!\u000f\n\u0007\u0005m\u0002J\u0001\u0003QCRD\u0017EAA \u00039Y8\u000f^1hK&#'\b\t/eWu\fab\u001c8f\u0003R$X-\u001c9u\t\u0006$\u0018\rF\u00076\u0003\u000b\nI%!\u0015\u0002X\u0005m\u0013\u0011\r\u0005\b\u0003\u000f!\u0001\u0019AA\u0005Q\u001d\t)%!\u0005Q\u0003/Aq!a\u0013\u0005\u0001\u0004\tI!\u0001\bti\u0006<W-\u0011;uK6\u0004H/\u00133)\u000f\u0005%\u0013\u0011\u0003)\u0002P\u0005\u0012\u00111\n\u0005\u0006'\u0012\u0001\r\u0001\u0016\u0015\u0006\u0003#2\u0005\u000b\u0017\u0015\u0007\u0003#R\u0006+a\b\t\u000bU$\u0001\u0019\u0001<)\u000b\u0005]c\tU>\t\u000b\u0001$\u0001\u0019\u0001+)\u000b\u0005mc\t\u00152)\u000b\u0005m#\fU/\t\u000b\u0015$\u0001\u0019\u00014)\u000b\u0005\u0005d\tU8)\u000b\u0005\u0005$\f\u0015:)\u0005\u0011i\bF\u0002\u0003\u00028A\u000bY'\t\u0002\u0002n\u0005!3p\u001d;bO\u0016LEM\u000f\u0011]I.jxf_:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u001e!9\u0012\\S0A\u0006uCN\\7+^7nCJLH\u0003CA:\u0003s\ni(!!\u0011\u0007\u0001\n)(C\u0002\u0002x1\u0011q\u0003V1tW6+GO]5d\t&\u001cHO]5ckRLwN\\:\t\u000f\u0005\u001dQ\u00011\u0001\u0002\n!:\u0011\u0011PA\t!\u0006]\u0001bBA&\u000b\u0001\u0007\u0011\u0011\u0002\u0015\b\u0003{\n\t\u0002UA(\u0011\u0015)W\u00011\u0001gQ\u0019\t\tI\u0017)\u0002\u0006\u0006\u0012\u0011qQ\u0001\u0018a9\u0002T\u0007\f\u0019/eUb\u0003GL\u001b-a9:T\u0007\f\u0019/sUBS!!!G!>D#!B?)\r\u0015\t9\u0004UAHC\t\t\t*\u0001\u0019|gR\fw-Z%eu\u0001bFmK?0wN$\u0018mZ3BiR,W\u000e\u001d;JIj\u0002C\fZ\u0016~_Q\f7o[*v[6\f'/_\u0001\ti\u0006\u001c8\u000eT5tiRq\u0011qSAP\u0003G\u000b9+!.\u0002D\u0006]\u0007\u0003\u0002\u00163\u00033\u00032\u0001IAN\u0013\r\ti\n\u0004\u0002\t)\u0006\u001c8\u000eR1uC\"9\u0011q\u0001\u0004A\u0002\u0005%\u0001fBAP\u0003#\u0001\u0016q\u0003\u0005\b\u0003\u00172\u0001\u0019AA\u0005Q\u001d\t\u0019+!\u0005Q\u0003\u001fBq!!+\u0007\u0001\u0004\tI!\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0007\u0003OS\u0006+!,\"\u0005\u0005=\u0016!\u0001\u0019)\r\u0005\u001df\tUAZC\t\tI\u000bC\u0004\u00028\u001a\u0001\r!!\u0003\u0002\r1,gn\u001a;iQ\u0019\t)L\u0017)\u0002<\u0006\u0012\u0011QX\u0001\u0003eABc!!.G!\u0006\u0005\u0017EAA\\\u0011\u001d\t)M\u0002a\u0001\u0003\u000f\faa]8si\nK\bc\u0001\u0011\u0002J&\u0019\u00111\u001a\u0007\u0003\u0017Q\u000b7o[*peRLgn\u001a\u0015\u0007\u0003\u0007T\u0006+a4\"\u0005\u0005E\u0017AA%EQ\u0019\t\u0019M\u0012)\u0002V\u0006\u0012\u0011Q\u0019\u0005\u0006s\u0019\u0001\rA\u001e\u0015\u0006\u0003/4\u0005+\u0015\u0015\u0003\ruDcABA\u001c!\u0006}\u0017EAAq\u00035Z8\u000f^1hK&#'\b\t/eWu|3p\u001d;bO\u0016\fE\u000f^3naRLEM\u000f\u0011]I.jx\u0006^1tW2K7\u000f^\u0001\ni\u0006\u001c8\u000eV1cY\u0016$\"\"a:\u0002z\u0006u(\u0011\u0001B\u0004!\u0019Y\u0014\u0011\u001e4\u0002n&\u0019\u00111\u001e\u001f\u0003\u000f!\u000b7\u000f['baB!\u0011q^A{\u001b\t\t\tPC\u0002\u0002tz\nA\u0001\\1oO&!\u0011q_Ay\u0005\u0019y%M[3di\"9\u0011qA\u0004A\u0002\u0005%\u0001fBA}\u0003#\u0001\u0016q\u0003\u0005\b\u0003\u0017:\u0001\u0019AA\u0005Q\u001d\ti0!\u0005Q\u0003\u001fBQaU\u0004A\u0002QCSA!\u0001G!bCcA!\u0001[!\u0006}\u0001b\u0002B\u0005\u000f\u0001\u0007!1B\u0001\bkJL\u0017J\u001c4p!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\t\u0011\u0006!1m\u001c:f\u0013\u0011\u0011)Ba\u0004\u0003\u000fU\u0013\u0018.\u00138g_\"\"!q\u0001B\r!\u0011\u0011iAa\u0007\n\t\tu!q\u0002\u0002\b\u0007>tG/\u001a=uQ\t9Q\u0010\u000b\u0004\b\u0003o\u0001&1E\u0011\u0003\u0005K\taf_:uC\u001e,\u0017\n\u001a\u001e!9\u0012\\SpL>ti\u0006<W-\u0011;uK6\u0004H/\u00133;Aq#7&`\u0018uCN\\G+\u00192mK\u0006aAm\u001c)bO&t\u0017\r^5p]Ra\u0011q\u0013B\u0016\u0005k\u00119D!\u000f\u0003>!9!Q\u0006\u0005A\u0002\t=\u0012aD9vKJL\b+\u0019:b[\u0016$XM]:\u0011\r\t5!\u0011\u00074g\u0013\u0011\u0011\u0019Da\u0004\u0003\u001d5+H\u000e^5wC2,X\rZ'ba\"9\u0011q\u0001\u0005A\u0002\u0005%\u0001bBA&\u0011\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0005wA\u0001\u0019\u0001+\u0002\u0011%\u001c8+Z1sG\"DqAa\u0010\t\u0001\u0004\tI!\u0001\u0007u_R\fGNU3d_J$7/\u0001\bgS2$XM\u001d+bg.d\u0015n\u001d;\u0015\r\u0005]%Q\tB%\u0011\u001d\u00119%\u0003a\u0001\u0003/\u000bA\u0002^1tW\u0012\u000bG/\u0019'jgRDaAa\u0013\n\u0001\u00041\u0017aC:fCJ\u001c\u0007NV1mk\u0016\f1\u0003]1sg\u0016\fV/\u00198uS2,7\u000b\u001e:j]\u001e$BA!\u0015\u0003^A)!Da\u0015\u0003X%\u0019!QK\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0007i\u0011I&C\u0002\u0003\\m\u0011a\u0001R8vE2,\u0007\"B3\u000b\u0001\u00041\u0007F\u0002\u0001\u0003bA\u00139\u0007E\u0002H\u0005GJ1A!\u001aI\u0005!\u0001&o\u001c3vG\u0016\u001cHF\u0001B5C\t\u0011Y'\u0001\tbaBd\u0017nY1uS>twF[:p]\u0002")
public class StagesResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$(this);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    public Seq<StageData> stageList(@QueryParam(value="status") List<StageStatus> statuses, @QueryParam(value="details") @DefaultValue(value="false") boolean details, @QueryParam(value="withSummaries") @DefaultValue(value="false") boolean withSummaries, @QueryParam(value="quantiles") @DefaultValue(value="0.0,0.25,0.5,0.75,1.0") String quantileString, @QueryParam(value="taskStatus") List<TaskStatus> taskStatus) {
        double[] quantiles = this.parseQuantileString(quantileString);
        return (Seq)this.withUI((Function1 & Serializable)ui -> (Seq)ui.store().stageList(statuses, details, withSummaries, quantiles, taskStatus).filter((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$stageList$2(details, taskStatus, stage))));
    }

    @GET
    @Path(value="{stageId: \\d+}")
    public Seq<StageData> stageData(@PathParam(value="stageId") int stageId, @QueryParam(value="details") @DefaultValue(value="true") boolean details, @QueryParam(value="taskStatus") List<TaskStatus> taskStatus, @QueryParam(value="withSummaries") @DefaultValue(value="false") boolean withSummaries, @QueryParam(value="quantiles") @DefaultValue(value="0.0,0.25,0.5,0.75,1.0") String quantileString) {
        return (Seq)this.withUI((Function1 & Serializable)ui -> {
            double[] quantiles = this.parseQuantileString(quantileString);
            Seq<StageData> ret = ui.store().stageData(stageId, details, taskStatus, withSummaries, quantiles);
            if (ret.nonEmpty()) {
                return ret;
            }
            throw new NotFoundException("unknown stage: " + stageId);
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}")
    public StageData oneAttemptData(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @QueryParam(value="details") @DefaultValue(value="true") boolean details, @QueryParam(value="taskStatus") List<TaskStatus> taskStatus, @QueryParam(value="withSummaries") @DefaultValue(value="false") boolean withSummaries, @QueryParam(value="quantiles") @DefaultValue(value="0.0,0.25,0.5,0.75,1.0") String quantileString) {
        return (StageData)this.withUI((Function1 & Serializable)ui -> {
            StageData stageData;
            try {
                double[] quantiles = this.parseQuantileString(quantileString);
                stageData = (StageData)ui.store().stageAttempt(stageId, stageAttemptId, details, taskStatus, withSummaries, quantiles)._1();
            }
            catch (NoSuchElementException noSuchElementException) {
                String string;
                Seq<StageData> all = ui.store().stageData(stageId, false, taskStatus, ui.store().stageData$default$4(), ui.store().stageData$default$5());
                if (all.nonEmpty()) {
                    Seq ids = (Seq)all.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.attemptId()));
                    string = "unknown attempt for stage " + stageId + ".  Found attempts: [" + ids.mkString(",") + "]";
                } else {
                    string = "unknown stage: " + stageId;
                }
                String msg = string;
                throw new NotFoundException(msg);
            }
            return stageData;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskSummary")
    public TaskMetricDistributions taskSummary(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0.05,0.25,0.5,0.75,0.95") @QueryParam(value="quantiles") String quantileString) {
        return (TaskMetricDistributions)this.withUI((Function1 & Serializable)ui -> {
            double[] quantiles = this.parseQuantileString(quantileString);
            return (TaskMetricDistributions)ui.store().taskSummary(stageId, stageAttemptId, quantiles).getOrElse((Function0 & Serializable)() -> {
                throw new NotFoundException("No tasks reported metrics for " + stageId + " / " + stageAttemptId + " yet.");
            });
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskList")
    public Seq<TaskData> taskList(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="length") int length, @DefaultValue(value="ID") @QueryParam(value="sortBy") TaskSorting sortBy, @QueryParam(value="status") List<TaskStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable)x$2 -> x$2.store().taskList(stageId, stageAttemptId, offset, length, sortBy, statuses));
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskTable")
    public HashMap<String, Object> taskTable(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @QueryParam(value="details") @DefaultValue(value="true") boolean details, @Context UriInfo uriInfo) {
        return (HashMap)this.withUI((Function1 & Serializable)ui -> {
            MultivaluedStringMap uriQueryParameters = UIUtils$.MODULE$.decodeURLParameter((MultivaluedMap<String, String>)uriInfo.getQueryParameters(true));
            String totalRecords = (String)uriQueryParameters.getFirst((Object)"numTasks");
            boolean isSearch = false;
            String searchValue = null;
            String filteredRecords = totalRecords;
            if (uriQueryParameters.getFirst((Object)"search[value]") != null && ((String)uriQueryParameters.getFirst((Object)"search[value]")).length() > 0) {
                isSearch = true;
                searchValue = (String)uriQueryParameters.getFirst((Object)"search[value]");
            }
            Seq<TaskData> _tasksToShow = this.doPagination((MultivaluedMap<String, String>)uriQueryParameters, stageId, stageAttemptId, isSearch, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(totalRecords)));
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (_tasksToShow.nonEmpty()) {
                if (isSearch) {
                    Seq<TaskData> filteredTaskList = this.filterTaskList(_tasksToShow, searchValue);
                    filteredRecords = Integer.toString(filteredTaskList.length());
                    if (filteredTaskList.length() > 0) {
                        int pageStartIndex = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)uriQueryParameters.getFirst((Object)"start")));
                        int pageLength = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)uriQueryParameters.getFirst((Object)"length")));
                        v0 = ret.put("aaData", filteredTaskList.slice(pageStartIndex, pageStartIndex + pageLength));
                    } else {
                        v0 = ret.put("aaData", filteredTaskList);
                    }
                } else {
                    v0 = ret.put("aaData", _tasksToShow);
                }
            } else {
                v0 = ret.put("aaData", _tasksToShow);
            }
            ret.put("recordsTotal", totalRecords);
            ret.put("recordsFiltered", filteredRecords);
            return ret;
        });
    }

    public Seq<TaskData> doPagination(MultivaluedMap<String, String> queryParameters, int stageId, int stageAttemptId, boolean isSearch, int totalRecords) {
        IntRef pageLength;
        IntRef pageStartIndex;
        String isAscendingStr;
        ObjectRef columnNameToSort;
        block1: {
            columnNameToSort = ObjectRef.create((Object)((String)queryParameters.getFirst((Object)"columnNameToSort")));
            if (((String)columnNameToSort.elem).equalsIgnoreCase("Logs")) {
                columnNameToSort.elem = "Index";
            }
            isAscendingStr = (String)queryParameters.getFirst((Object)"order[0][dir]");
            pageStartIndex = IntRef.create((int)0);
            pageLength = IntRef.create((int)totalRecords);
            if (isSearch) break block1;
            pageStartIndex.elem = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)queryParameters.getFirst((Object)"start")));
            pageLength.elem = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)queryParameters.getFirst((Object)"length")));
        }
        return (Seq)this.withUI((Function1 & Serializable)x$3 -> x$3.store().taskList(stageId, stageAttemptId, pageStartIndex$1.elem, pageLength$1.elem, ApiHelper$.MODULE$.indexName((String)columnNameToSort$1.elem), "asc".equalsIgnoreCase(isAscendingStr), x$3.store().taskList$default$7()));
    }

    public Seq<TaskData> filterTaskList(Seq<TaskData> taskDataList, String searchValue) {
        String defaultOptionString = "d";
        String searchValueLowerCase = searchValue.toLowerCase(Locale.ROOT);
        Function1 & Serializable containsValue = (Function1 & Serializable)taskDataParams -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$1(searchValueLowerCase, taskDataParams));
        Function1 & Serializable taskMetricsContainsValue = (Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$2(containsValue, task));
        Seq filteredTaskDataSequence = (Seq)taskDataList.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$3(containsValue, defaultOptionString, taskMetricsContainsValue, f)));
        return filteredTaskDataSequence;
    }

    public double[] parseQuantileString(String quantileString) {
        return (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])quantileString.split(",")), (Function1 & Serializable)s -> BoxesRunTime.boxToDouble((double)StagesResource.$anonfun$parseQuantileString$1(s)), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public static final /* synthetic */ boolean $anonfun$stageList$3(StageData stage$1, TaskStatus x0$1) {
        TaskStatus taskStatus = x0$1;
        if (((Object)((Object)TaskStatus.FAILED)).equals((Object)taskStatus)) {
            return stage$1.numFailedTasks() > 0;
        }
        if (((Object)((Object)TaskStatus.KILLED)).equals((Object)taskStatus)) {
            return stage$1.numKilledTasks() > 0;
        }
        if (((Object)((Object)TaskStatus.RUNNING)).equals((Object)taskStatus)) {
            return stage$1.numActiveTasks() > 0;
        }
        if (((Object)((Object)TaskStatus.SUCCESS)).equals((Object)taskStatus)) {
            return stage$1.numCompleteTasks() > 0;
        }
        if (((Object)((Object)TaskStatus.UNKNOWN)).equals((Object)taskStatus)) {
            return stage$1.numTasks() - stage$1.numFailedTasks() - stage$1.numKilledTasks() - stage$1.numActiveTasks() - stage$1.numCompleteTasks() > 0;
        }
        throw new MatchError((Object)taskStatus);
    }

    public static final /* synthetic */ boolean $anonfun$stageList$2(boolean details$1, List taskStatus$1, StageData stage) {
        if (details$1 && CollectionConverters$.MODULE$.ListHasAsScala(taskStatus$1).asScala().nonEmpty()) {
            return CollectionConverters$.MODULE$.ListHasAsScala(taskStatus$1).asScala().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$stageList$3(stage, x0$1)));
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$1(String searchValueLowerCase$1, Object taskDataParams) {
        return taskDataParams.toString().toLowerCase(Locale.ROOT).contains(searchValueLowerCase$1);
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$2(Function1 containsValue$1, TaskData task) {
        Option<TaskMetrics> option = task.taskMetrics();
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).executorDeserializeTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).executorRunTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).jvmGcTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).resultSerializationTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).memoryBytesSpilled()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).diskBytesSpilled()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).peakExecutionMemory()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).inputMetrics().bytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).inputMetrics().recordsRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).outputMetrics().bytesWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).outputMetrics().recordsWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().fetchWaitTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().remoteBytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().localBytesRead() + ((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().remoteBytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().recordsRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().bytesWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().recordsWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().writeTime() / 1000000L)));
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$3(Function1 containsValue$1, String defaultOptionString$1, Function1 taskMetricsContainsValue$1, TaskData f) {
        return BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)f.taskId()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToInteger((int)f.index()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToInteger((int)f.attempt()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDate(f.launchTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply(f.resultFetchStart().getOrElse((Function0 & Serializable)() -> defaultOptionString$1))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.executorId())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.host())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.status())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.taskLocality())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)f.speculative()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply(f.errorMessage().getOrElse((Function0 & Serializable)() -> defaultOptionString$1))) || BoxesRunTime.unboxToBoolean((Object)taskMetricsContainsValue$1.apply((Object)f)) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(f.schedulerDelay()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(f.gettingResultTime())));
    }

    public static final /* synthetic */ double $anonfun$parseQuantileString$1(String s) {
        double d;
        try {
            d = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s));
        }
        catch (NumberFormatException nfe) {
            throw new BadParameterException("quantiles", "double", s);
        }
        return d;
    }

    public StagesResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

