/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.spark.network.shuffle.checksum.ShuffleChecksumHelper;
import org.apache.spark.network.util.LimitedInputStream;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.ShuffleChecksumBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ShuffleChecksumUtils$ {
    public static final ShuffleChecksumUtils$ MODULE$ = new ShuffleChecksumUtils$();

    public String getChecksumFileName(BlockId blockId, String algorithm) {
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleDataBlockId) {
            ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId2;
            int shuffleId = shuffleDataBlockId.shuffleId();
            long mapId = shuffleDataBlockId.mapId();
            return ShuffleChecksumHelper.getChecksumFileName((String)new ShuffleChecksumBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()).name(), (String)algorithm);
        }
        return null;
    }

    public boolean compareChecksums(int numPartition, String algorithm, File checksum, File data, File index) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef checksumIn = ObjectRef.create(null);
            long[] expectChecksums = (long[])Array$.MODULE$.ofDim(numPartition, (ClassTag)ClassTag$.MODULE$.Long());
            try {
                checksumIn.elem = new DataInputStream(new FileInputStream(checksum));
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartition).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    expectChecksums$1[i] = ((DataInputStream)checksumIn$1.elem).readLong();
                });
            }
            finally {
                if ((DataInputStream)checksumIn.elem != null) {
                    ((DataInputStream)checksumIn.elem).close();
                }
            }
            ObjectRef dataIn = ObjectRef.create(null);
            ObjectRef indexIn = ObjectRef.create(null);
            ObjectRef checkedIn = ObjectRef.create(null);
            try {
                dataIn.elem = new FileInputStream(data);
                indexIn.elem = new DataInputStream(new FileInputStream(index));
                LongRef prevOffset = LongRef.create((long)((DataInputStream)indexIn.elem).readLong());
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartition).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    long curOffset = ((DataInputStream)indexIn$1.elem).readLong();
                    int limit = (int)(curOffset - prevOffset$1.elem);
                    byte[] bytes = new byte[limit];
                    Checksum checksumCal = ShuffleChecksumHelper.getChecksumByAlgorithm((String)algorithm);
                    checkedIn$1.elem = new CheckedInputStream((InputStream)new LimitedInputStream((InputStream)((FileInputStream)dataIn$1.elem), curOffset - prevOffset$1.elem), checksumCal);
                    ((CheckedInputStream)checkedIn$1.elem).read(bytes, 0, limit);
                    prevOffset$1.elem = curOffset;
                    if (((CheckedInputStream)checkedIn$1.elem).getChecksum().getValue() != expectChecksums[i]) {
                        throw new NonLocalReturnControl.mcZ.sp(object, false);
                    }
                });
            }
            finally {
                if ((FileInputStream)dataIn.elem != null) {
                    ((FileInputStream)dataIn.elem).close();
                }
                if ((DataInputStream)indexIn.elem != null) {
                    ((DataInputStream)indexIn.elem).close();
                }
                if ((CheckedInputStream)checkedIn.elem != null) {
                    ((CheckedInputStream)checkedIn.elem).close();
                }
            }
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private ShuffleChecksumUtils$() {
    }
}

