/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.io.LongWritable;

@Description(name="factorial", value="_FUNC_(int) - Returns n factorial. Valid n is [0..20].", extended="Returns null if n is out of [0..20] range.\nExample:\n > SELECT _FUNC_(5);\n 120")
public class GenericUDFFactorial
extends GenericUDF {
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[1];
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[1];
    private final LongWritable output = new LongWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 1);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.obtainIntConverter(arguments, 0, this.inputTypes, this.converters);
        WritableLongObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Integer val = this.getIntValue(arguments, 0, this.converters);
        if (val == null || val < 0 || val > 20) {
            return null;
        }
        long factorial = FACTORIALS[val];
        this.output.set(factorial);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "factorial";
    }
}

