/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.CompressionUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.AddToClassPathAction;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.HiveTotalOrderPartitioner;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.PartitionKeySampler;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecReducer;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.mr.Throttle;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.log.NullAppender;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.LoggerFactory;

public class ExecDriver
extends Task<MapredWork>
implements Serializable,
HadoopJobExecHook {
    private static final long serialVersionUID = 1L;
    private static final String JOBCONF_FILENAME = "jobconf.xml";
    protected transient JobConf job;
    public static MemoryMXBean memoryMXBean;
    protected HadoopJobExecHelper jobExecHelper;
    protected static final transient org.slf4j.Logger LOG;
    private RunningJob rj;

    public ExecDriver() {
        this.console = new SessionState.LogHelper(LOG);
        this.job = new JobConf(ExecDriver.class);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    private void initializeFiles(String prop, String files) {
        if (files != null && files.length() > 0) {
            this.job.set(prop, files);
        }
    }

    protected static String getResource(HiveConf conf, SessionState.ResourceType resType) {
        switch (resType) {
            case JAR: {
                String addedJars = Utilities.getResourceFiles((Configuration)conf, SessionState.ResourceType.JAR);
                String auxJars = conf.getAuxJars();
                String reloadableAuxJars = SessionState.get() == null ? null : SessionState.get().getReloadableAuxJars();
                return HiveStringUtils.joinIgnoringEmpty((String[])new String[]{addedJars, auxJars, reloadableAuxJars}, (char)',');
            }
            case FILE: {
                return Utilities.getResourceFiles((Configuration)conf, SessionState.ResourceType.FILE);
            }
            case ARCHIVE: {
                return Utilities.getResourceFiles((Configuration)conf, SessionState.ResourceType.ARCHIVE);
            }
        }
        return null;
    }

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext driverContext, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, driverContext, opContext);
        this.job = new JobConf((Configuration)this.conf, ExecDriver.class);
        this.initializeFiles("tmpjars", ExecDriver.getResource(this.conf, SessionState.ResourceType.JAR));
        this.initializeFiles("tmpfiles", ExecDriver.getResource(this.conf, SessionState.ResourceType.FILE));
        this.initializeFiles("tmparchives", ExecDriver.getResource(this.conf, SessionState.ResourceType.ARCHIVE));
        this.conf.stripHiddenConfigurations((Configuration)this.job);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    public ExecDriver(MapredWork plan, JobConf job, boolean isSilent) throws HiveException {
        this.setWork(plan);
        this.job = job;
        this.console = new SessionState.LogHelper(LOG, isSilent);
        this.jobExecHelper = new HadoopJobExecHelper(job, this.console, this, this);
    }

    @Override
    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        Counters.Counter cntr = ctrs.findCounter(HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVECOUNTERGROUP), "FATAL_ERROR");
        return cntr != null && cntr.getValue() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DriverContext driverContext) {
        String mesg;
        Path emptyScratchDir;
        IOPrepareCache ioPrepareCache = IOPrepareCache.get();
        ioPrepareCache.clear();
        boolean success = true;
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        JobClient jc = null;
        if (driverContext.isShutdown()) {
            LOG.warn("Task was cancelled");
            return 5;
        }
        MapWork mWork = ((MapredWork)this.work).getMapWork();
        ReduceWork rWork = ((MapredWork)this.work).getReduceWork();
        try {
            if (ctx == null) {
                ctx = new Context((Configuration)this.job);
                ctxCreated = true;
            }
            emptyScratchDir = ctx.getMRTmpPath();
            FileSystem fs = emptyScratchDir.getFileSystem((Configuration)this.job);
            fs.mkdirs(emptyScratchDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.console.printError("Error launching map-reduce job", "\n" + StringUtils.stringifyException((Throwable)e));
            return 5;
        }
        HiveFileFormatUtils.prepareJobOutput(this.job);
        this.job.setOutputFormat(HiveOutputFormatImpl.class);
        this.job.setMapperClass(ExecMapper.class);
        this.job.setMapOutputKeyClass(HiveKey.class);
        this.job.setMapOutputValueClass(BytesWritable.class);
        try {
            String partitioner = HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEPARTITIONER);
            this.job.setPartitionerClass(JavaUtils.loadClass((String)partitioner));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ExecDriver.propagateSplitSettings(this.job, mWork);
        this.job.setNumReduceTasks(rWork != null ? rWork.getNumReduceTasks() : 0);
        this.job.setReducerClass(ExecReducer.class);
        this.setInputAttributes((Configuration)this.job);
        boolean useSpeculativeExecReducers = HiveConf.getBoolVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESPECULATIVEEXECREDUCERS);
        this.job.setBoolean("mapreduce.reduce.speculative", useSpeculativeExecReducers);
        String inpFormat = HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEINPUTFORMAT);
        if (mWork.isUseBucketizedHiveInputFormat()) {
            inpFormat = BucketizedHiveInputFormat.class.getName();
        }
        LOG.info("Using " + inpFormat);
        try {
            this.job.setInputFormat(JavaUtils.loadClass((String)inpFormat));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.job.setOutputKeyClass(Text.class);
        this.job.setOutputValueClass(Text.class);
        int returnVal = 0;
        boolean noName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.job.get("mapreduce.job.name"));
        if (noName) {
            this.job.set("mapreduce.job.name", "JOB" + Utilities.randGen.nextInt());
        }
        try {
            StatsFactory factory;
            MapredLocalWork localwork = mWork.getMapRedLocalWork();
            if (localwork != null && localwork.hasStagedAlias() && !ShimLoader.getHadoopShims().isLocalMode((Configuration)this.job)) {
                Path localPath = localwork.getTmpPath();
                Path hdfsPath = mWork.getTmpHDFSPath();
                FileSystem hdfs = hdfsPath.getFileSystem((Configuration)this.job);
                FileSystem localFS = localPath.getFileSystem((Configuration)this.job);
                FileStatus[] hashtableFiles = localFS.listStatus(localPath);
                int fileNumber = hashtableFiles.length;
                String[] fileNames = new String[fileNumber];
                for (int i = 0; i < fileNumber; ++i) {
                    fileNames[i] = hashtableFiles[i].getPath().getName();
                }
                String stageId = this.getId();
                String archiveFileName = Utilities.generateTarFileName(stageId);
                localwork.setStageID(stageId);
                CompressionUtils.tar((String)localPath.toUri().getPath(), (String[])fileNames, (String)archiveFileName);
                Path archivePath = Utilities.generateTarPath(localPath, stageId);
                LOG.info("Archive " + hashtableFiles.length + " hash table files to " + archivePath);
                Path hdfsFilePath = Utilities.generateTarPath(hdfsPath, stageId);
                short replication = (short)this.job.getInt("mapred.submit.replication", 10);
                hdfs.copyFromLocalFile(archivePath, hdfsFilePath);
                hdfs.setReplication(hdfsFilePath, replication);
                LOG.info("Upload 1 archive file  from" + archivePath + " to: " + hdfsFilePath);
                DistributedCache.createSymlink((Configuration)this.job);
                DistributedCache.addCacheArchive((URI)hdfsFilePath.toUri(), (Configuration)this.job);
                LOG.info("Add 1 archive file to distributed cache. Archive file: " + hdfsFilePath.toUri());
            }
            ((MapredWork)this.work).configureJobConf(this.job);
            List<Path> inputPaths = Utilities.getInputPaths(this.job, mWork, emptyScratchDir, ctx, false);
            Utilities.setInputPaths(this.job, inputPaths);
            Utilities.setMapRedWork((Configuration)this.job, (MapredWork)this.work, ctx.getMRTmpPath());
            if (mWork.getSamplingType() > 0 && rWork != null && this.job.getNumReduceTasks() > 1) {
                try {
                    this.handleSampling(ctx, mWork, this.job);
                    this.job.setPartitionerClass(HiveTotalOrderPartitioner.class);
                }
                catch (IllegalStateException e) {
                    this.console.printInfo("Not enough sampling data.. Rolling back to single reducer task");
                    rWork.setNumReduceTasks(1);
                    this.job.setNumReduceTasks(1);
                }
                catch (Exception e) {
                    LOG.error("Sampling error", (Throwable)e);
                    this.console.printError(e.toString(), "\n" + StringUtils.stringifyException((Throwable)e));
                    rWork.setNumReduceTasks(1);
                    this.job.setNumReduceTasks(1);
                }
            }
            jc = new JobClient(this.job);
            Throttle.checkJobTracker(this.job, LOG);
            if ((mWork.isGatheringStats() || rWork != null && rWork.isGatheringStats()) && (factory = StatsFactory.newFactory((Configuration)this.job)) != null) {
                StatsPublisher statsPublisher = factory.getStatsPublisher();
                List<String> statsTmpDir = Utilities.getStatsTmpDirs(mWork, (Configuration)this.job);
                if (rWork != null) {
                    statsTmpDir.addAll(Utilities.getStatsTmpDirs(rWork, (Configuration)this.job));
                }
                StatsCollectionContext sc = new StatsCollectionContext((Configuration)this.job);
                sc.setStatsTmpDirs(statsTmpDir);
                if (!statsPublisher.init(sc) && HiveConf.getBoolVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
                    throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
                }
            }
            Utilities.createTmpDirs((Configuration)this.job, mWork);
            Utilities.createTmpDirs((Configuration)this.job, rWork);
            SessionState ss = SessionState.get();
            if (HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && ss != null) {
                TezSessionState session = ss.getTezSession();
                TezSessionPoolManager.getInstance();
                TezSessionPoolManager.closeIfNotDefault(session, true);
            }
            HiveConfUtil.updateJobCredentialProviders((Configuration)this.job);
            if (driverContext.isShutdown()) {
                LOG.warn("Task was cancelled");
                int n = 5;
                return n;
            }
            this.rj = jc.submitJob(this.job);
            if (driverContext.isShutdown()) {
                LOG.warn("Task was cancelled");
                if (this.rj != null) {
                    this.rj.killJob();
                    this.rj = null;
                }
                int n = 5;
                return n;
            }
            this.jobID = this.rj.getJobID();
            this.updateStatusInQueryDisplay();
            returnVal = this.jobExecHelper.progress(this.rj, jc, ctx);
            success = returnVal == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setException(e);
            mesg = " with exception '" + Utilities.getNameMessage(e) + "'";
            mesg = this.rj != null ? "Ended Job = " + this.rj.getJobID() + mesg : "Job Submission failed" + mesg;
            this.console.printError(mesg, "\n" + StringUtils.stringifyException((Throwable)e));
            success = false;
            returnVal = 1;
        }
        finally {
            Utilities.clearWork((Configuration)this.job);
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (this.rj != null) {
                    if (returnVal != 0) {
                        this.rj.killJob();
                    }
                    this.jobID = this.rj.getID().toString();
                }
                if (jc != null) {
                    jc.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Failed while cleaning up ", (Throwable)e);
            }
            finally {
                HadoopJobExecHelper.runningJobs.remove(this.rj);
            }
        }
        try {
            if (this.rj == null) return returnVal;
            if (mWork.getAliasToWork() != null) {
                for (Operator<? extends OperatorDesc> op : mWork.getAliasToWork().values()) {
                    op.jobClose((Configuration)this.job, success);
                }
            }
            if (rWork == null) return returnVal;
            rWork.getReducer().jobClose((Configuration)this.job, success);
            return returnVal;
        }
        catch (Exception e) {
            if (!success) return returnVal;
            this.setException(e);
            success = false;
            returnVal = 3;
            mesg = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
            this.console.printError(mesg, "\n" + StringUtils.stringifyException((Throwable)e));
        }
        return returnVal;
    }

    public static void propagateSplitSettings(JobConf job, MapWork work) {
        if (work.getNumMapTasks() != null) {
            job.setNumMapTasks(work.getNumMapTasks().intValue());
        }
        if (work.getMaxSplitSize() != null) {
            HiveConf.setLongVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)work.getMaxSplitSize());
        }
        if (work.getMinSplitSize() != null) {
            HiveConf.setLongVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)work.getMinSplitSize());
        }
        if (work.getMinSplitSizePerNode() != null) {
            HiveConf.setLongVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZEPERNODE, (long)work.getMinSplitSizePerNode());
        }
        if (work.getMinSplitSizePerRack() != null) {
            HiveConf.setLongVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZEPERRACK, (long)work.getMinSplitSizePerRack());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSampling(Context context, MapWork mWork, JobConf job) throws Exception {
        assert (mWork.getAliasToWork().keySet().size() == 1);
        String alias = mWork.getAliases().get(0);
        Operator<? extends OperatorDesc> topOp = mWork.getAliasToWork().get(alias);
        PartitionDesc partDesc = mWork.getAliasToPartnInfo().get(alias);
        ArrayList<PartitionDesc> parts = mWork.getPartitionDescs();
        ArrayList<Path> inputPaths = mWork.getPaths();
        Path tmpPath = context.getExternalTmpPath((Path)inputPaths.get(0));
        Path partitionFile = new Path(tmpPath, ".partitions");
        ShimLoader.getHadoopShims().setTotalOrderPartitionFile(job, partitionFile);
        PartitionKeySampler sampler = new PartitionKeySampler();
        if (mWork.getSamplingType() == 1) {
            this.console.printInfo("Use sampling data created in previous MR");
            for (Path path : inputPaths) {
                FileSystem fs = path.getFileSystem((Configuration)job);
                for (FileStatus status : fs.globStatus(new Path(path, ".sampling*"))) {
                    sampler.addSampleFile(status.getPath(), job);
                }
            }
        } else if (mWork.getSamplingType() == 2) {
            FetchWork fetchWork;
            this.console.printInfo("Creating sampling data..");
            assert (topOp instanceof TableScanOperator);
            TableScanOperator ts = (TableScanOperator)topOp;
            if (!partDesc.isPartitioned()) {
                assert (inputPaths.size() == 1);
                fetchWork = new FetchWork((Path)inputPaths.get(0), partDesc.getTableDesc());
            } else {
                fetchWork = new FetchWork(inputPaths, parts, partDesc.getTableDesc());
            }
            fetchWork.setSource(ts);
            FetchOperator fetcher = PartitionKeySampler.createSampler(fetchWork, job, ts);
            try {
                ts.initialize((Configuration)job, new ObjectInspector[]{fetcher.getOutputObjectInspector()});
                OperatorUtils.setChildrenCollector(ts.getChildOperators(), sampler);
                while (fetcher.pushRow()) {
                }
            }
            finally {
                fetcher.clearFetchContext();
            }
        } else {
            throw new IllegalArgumentException("Invalid sampling type " + mWork.getSamplingType());
        }
        sampler.writePartitionKeys(partitionFile, job);
    }

    protected void setInputAttributes(Configuration conf) {
        MapWork mWork = ((MapredWork)this.work).getMapWork();
        if (mWork.getInputformat() != null) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEINPUTFORMAT, (String)mWork.getInputformat());
        }
        if (mWork.getIndexIntermediateFile() != null) {
            conf.set(HiveConf.ConfVars.HIVE_INDEX_COMPACT_FILE.varname, mWork.getIndexIntermediateFile());
            conf.set(HiveConf.ConfVars.HIVE_INDEX_BLOCKFILTER_FILE.varname, mWork.getIndexIntermediateFile());
        }
        conf.setBoolean("hive.input.format.sorted", mWork.isInputFormatSorted());
        if (HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CURRENT_DATABASE, (String)null) == null) {
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CURRENT_DATABASE, (String)ExecDriver.getCurrentDB());
        }
    }

    public static String getCurrentDB() {
        String currentDB = null;
        if (SessionState.get() != null) {
            currentDB = SessionState.get().getCurrentDatabase();
        }
        return currentDB == null ? "default" : currentDB;
    }

    public boolean mapStarted() {
        return this.jobExecHelper.mapStarted();
    }

    public boolean reduceStarted() {
        return this.jobExecHelper.reduceStarted();
    }

    public boolean mapDone() {
        return this.jobExecHelper.mapDone();
    }

    public boolean reduceDone() {
        return this.jobExecHelper.reduceDone();
    }

    private static void printUsage() {
        System.err.println("ExecDriver -plan <plan-file> [-jobconffile <job conf file>][-files <file1>[,<file2>] ...]");
        System.exit(1);
    }

    private static void setupChildLog4j(Configuration conf) {
        try {
            LogUtils.initHiveExecLog4j();
        }
        catch (LogUtils.LogInitializationException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) throws IOException, HiveException {
        int ret;
        Serializable plan;
        String hadoopAuthToken;
        String planFileName = null;
        String jobConfFileName = null;
        boolean noLog = false;
        String files = null;
        String libjars = null;
        boolean localtask = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-plan")) {
                    planFileName = args[++i];
                    continue;
                }
                if (args[i].equals("-jobconffile")) {
                    jobConfFileName = args[++i];
                    continue;
                }
                if (args[i].equals("-nolog")) {
                    noLog = true;
                    continue;
                }
                if (args[i].equals("-files")) {
                    files = args[++i];
                    continue;
                }
                if (args[i].equals("-libjars")) {
                    libjars = args[++i];
                    continue;
                }
                if (!args[i].equals("-localtask")) continue;
                localtask = true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Missing argument to option");
            ExecDriver.printUsage();
        }
        JobConf conf = localtask ? new JobConf(MapredLocalTask.class) : new JobConf(ExecDriver.class);
        if (jobConfFileName != null) {
            conf.addResource(new Path(jobConfFileName));
        }
        if (files != null) {
            conf.set("tmpfiles", files);
        }
        if (libjars != null) {
            conf.set("tmpjars", libjars);
        }
        if (UserGroupInformation.isSecurityEnabled() && (hadoopAuthToken = System.getenv("HADOOP_TOKEN_FILE_LOCATION")) != null) {
            conf.set("mapreduce.job.credentials.binary", hadoopAuthToken);
        }
        boolean isSilent = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESESSIONSILENT);
        String queryId = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID, (String)"").trim();
        if (queryId.isEmpty()) {
            queryId = "unknown-" + System.currentTimeMillis();
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID, (String)queryId);
        }
        System.setProperty(HiveConf.ConfVars.HIVEQUERYID.toString(), queryId);
        if (noLog) {
            org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
            NullAppender appender = NullAppender.createNullAppender();
            appender.addToLogger(logger.getName(), Level.ERROR);
            appender.start();
        } else {
            ExecDriver.setupChildLog4j((Configuration)conf);
        }
        org.slf4j.Logger LOG = LoggerFactory.getLogger((String)ExecDriver.class.getName());
        SessionState.LogHelper console = new SessionState.LogHelper(LOG, isSilent);
        if (planFileName == null) {
            console.printError("Must specify Plan File Name");
            ExecDriver.printUsage();
        }
        for (Appender appender : ((Logger)LogManager.getRootLogger()).getAppenders().values()) {
            if (appender instanceof FileAppender) {
                console.printInfo("Execution log at: " + ((FileAppender)appender).getFileName());
                continue;
            }
            if (!(appender instanceof RollingFileAppender)) continue;
            console.printInfo("Execution log at: " + ((RollingFileAppender)appender).getFileName());
        }
        Path p = new Path(planFileName);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream pathData = fs.open(p);
        try {
            ClassLoader loader = conf.getClassLoader();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)libjars)) {
                AddToClassPathAction addAction = new AddToClassPathAction(loader, Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)libjars, (String)",")));
                loader = AccessController.doPrivileged(addAction);
            }
            conf.setClassLoader(loader);
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
        if (localtask) {
            memoryMXBean = ManagementFactory.getMemoryMXBean();
            plan = SerializationUtilities.deserializePlan((InputStream)pathData, MapredLocalWork.class);
            MapredLocalTask ed = new MapredLocalTask((MapredLocalWork)plan, conf, isSilent);
            ret = ed.executeInProcess(new DriverContext());
        } else {
            plan = SerializationUtilities.deserializePlan((InputStream)pathData, MapredWork.class);
            ExecDriver ed = new ExecDriver((MapredWork)plan, conf, isSilent);
            ret = ed.execute(new DriverContext());
        }
        if (ret != 0) {
            System.exit(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateCmdLine(HiveConf hconf, Context ctx) throws IOException {
        HiveConf tempConf = new HiveConf();
        Path hConfFilePath = new Path(ctx.getLocalTmpPath(), JOBCONF_FILENAME);
        FSDataOutputStream out = null;
        Properties deltaP = hconf.getChangedProperties();
        boolean hadoopLocalMode = ShimLoader.getHadoopShims().isLocalMode((Configuration)hconf);
        String hadoopSysDir = "mapred.system.dir";
        String hadoopWorkDir = "mapred.local.dir";
        for (Object one : deltaP.keySet()) {
            String oneProp = (String)one;
            if (hadoopLocalMode && (oneProp.equals(hadoopSysDir) || oneProp.equals(hadoopWorkDir))) continue;
            tempConf.set(oneProp, hconf.get(oneProp));
        }
        if (hadoopLocalMode) {
            tempConf.set(hadoopSysDir, hconf.get(hadoopSysDir) + "/" + Utilities.randGen.nextInt());
            tempConf.set(hadoopWorkDir, hconf.get(hadoopWorkDir) + "/" + Utilities.randGen.nextInt());
        }
        try {
            out = FileSystem.getLocal((Configuration)hconf).create(hConfFilePath);
            tempConf.writeXml((OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return " -jobconffile " + hConfFilePath.toString();
    }

    @Override
    public Collection<MapWork> getMapWork() {
        return Collections.singleton(((MapredWork)this.getWork()).getMapWork());
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public Collection<Operator<? extends OperatorDesc>> getTopOperators() {
        return ((MapredWork)this.getWork()).getMapWork().getAliasToWork().values();
    }

    @Override
    public boolean hasReduce() {
        MapredWork w = (MapredWork)this.getWork();
        return w.getReduceWork() != null;
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public String getName() {
        return "MAPRED";
    }

    @Override
    public void logPlanProgress(SessionState ss) throws IOException {
        ss.getHiveHistory().logPlanProgress(this.queryPlan);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.rj != null) {
            try {
                this.rj.killJob();
            }
            catch (Exception e) {
                LOG.warn("failed to kill job " + this.rj.getID(), (Throwable)e);
            }
            this.rj = null;
        }
    }

    @Override
    public String getExternalHandle() {
        return this.jobID;
    }

    static {
        LOG = LoggerFactory.getLogger(ExecDriver.class);
    }
}

