/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;

public class Stat {
    private final Map<String, LongWritable> statsMap = new HashMap<String, LongWritable>();
    private final Map<String, Integer> bookkeepingInfo = new HashMap<String, Integer>();

    public void addToStat(String statType, long amount) {
        LongWritable currentValue = this.statsMap.get(statType);
        if (currentValue == null) {
            this.statsMap.put(statType, new LongWritable(amount));
        } else {
            currentValue.set(currentValue.get() + amount);
        }
    }

    public long getStat(String statType) {
        LongWritable currValue = this.statsMap.get(statType);
        if (currValue == null) {
            return 0L;
        }
        return currValue.get();
    }

    public Collection<String> getStoredStats() {
        return this.statsMap.keySet();
    }

    public void clear() {
        this.statsMap.clear();
    }

    public void setBookkeepingInfo(String statType, int info) {
        this.bookkeepingInfo.put(statType, info);
    }

    public int getBookkeepingInfo(String statType) {
        Integer info = this.bookkeepingInfo.get(statType);
        if (info == null) {
            return -1;
        }
        return info;
    }
}

