/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.SketchesArgumentException;

public class BitPacking {
    public static void packBits(long value, int bits, byte[] buffer, int bufOffset, int bitOffset) {
        if (bitOffset > 0) {
            int chunkBits = 8 - bitOffset;
            int mask = (1 << chunkBits) - 1;
            if (bits < chunkBits) {
                int n = bufOffset;
                buffer[n] = (byte)((long)buffer[n] | value << chunkBits - bits & (long)mask);
                return;
            }
            int n = bufOffset++;
            buffer[n] = (byte)((long)buffer[n] | value >>> bits - chunkBits & (long)mask);
            bits -= chunkBits;
        }
        while (bits >= 8) {
            buffer[bufOffset++] = (byte)(value >>> bits - 8);
            bits -= 8;
        }
        if (bits > 0) {
            buffer[bufOffset] = (byte)(value << 8 - bits);
        }
    }

    public static void unpackBits(long[] value, int index, int bits, byte[] buffer, int bufOffset, int bitOffset) {
        int availBits = 8 - bitOffset;
        int chunkBits = availBits <= bits ? availBits : bits;
        int mask = (1 << chunkBits) - 1;
        value[index] = buffer[bufOffset] >>> availBits - chunkBits & mask;
        bufOffset += availBits == chunkBits ? 1 : 0;
        bits -= chunkBits;
        while (bits >= 8) {
            int n = index;
            value[n] = value[n] << 8;
            int n2 = index;
            value[n2] = value[n2] | Byte.toUnsignedLong(buffer[bufOffset++]);
            bits -= 8;
        }
        if (bits > 0) {
            int n = index;
            value[n] = value[n] << bits;
            int n3 = index;
            value[n3] = value[n3] | Byte.toUnsignedLong(buffer[bufOffset]) >>> 8 - bits;
        }
    }

    static void packBitsBlock8(long[] values, int i, byte[] buf, int off, int bits) {
        switch (bits) {
            case 1: {
                BitPacking.packBits1(values, i, buf, off);
                break;
            }
            case 2: {
                BitPacking.packBits2(values, i, buf, off);
                break;
            }
            case 3: {
                BitPacking.packBits3(values, i, buf, off);
                break;
            }
            case 4: {
                BitPacking.packBits4(values, i, buf, off);
                break;
            }
            case 5: {
                BitPacking.packBits5(values, i, buf, off);
                break;
            }
            case 6: {
                BitPacking.packBits6(values, i, buf, off);
                break;
            }
            case 7: {
                BitPacking.packBits7(values, i, buf, off);
                break;
            }
            case 8: {
                BitPacking.packBits8(values, i, buf, off);
                break;
            }
            case 9: {
                BitPacking.packBits9(values, i, buf, off);
                break;
            }
            case 10: {
                BitPacking.packBits10(values, i, buf, off);
                break;
            }
            case 11: {
                BitPacking.packBits11(values, i, buf, off);
                break;
            }
            case 12: {
                BitPacking.packBits12(values, i, buf, off);
                break;
            }
            case 13: {
                BitPacking.packBits13(values, i, buf, off);
                break;
            }
            case 14: {
                BitPacking.packBits14(values, i, buf, off);
                break;
            }
            case 15: {
                BitPacking.packBits15(values, i, buf, off);
                break;
            }
            case 16: {
                BitPacking.packBits16(values, i, buf, off);
                break;
            }
            case 17: {
                BitPacking.packBits17(values, i, buf, off);
                break;
            }
            case 18: {
                BitPacking.packBits18(values, i, buf, off);
                break;
            }
            case 19: {
                BitPacking.packBits19(values, i, buf, off);
                break;
            }
            case 20: {
                BitPacking.packBits20(values, i, buf, off);
                break;
            }
            case 21: {
                BitPacking.packBits21(values, i, buf, off);
                break;
            }
            case 22: {
                BitPacking.packBits22(values, i, buf, off);
                break;
            }
            case 23: {
                BitPacking.packBits23(values, i, buf, off);
                break;
            }
            case 24: {
                BitPacking.packBits24(values, i, buf, off);
                break;
            }
            case 25: {
                BitPacking.packBits25(values, i, buf, off);
                break;
            }
            case 26: {
                BitPacking.packBits26(values, i, buf, off);
                break;
            }
            case 27: {
                BitPacking.packBits27(values, i, buf, off);
                break;
            }
            case 28: {
                BitPacking.packBits28(values, i, buf, off);
                break;
            }
            case 29: {
                BitPacking.packBits29(values, i, buf, off);
                break;
            }
            case 30: {
                BitPacking.packBits30(values, i, buf, off);
                break;
            }
            case 31: {
                BitPacking.packBits31(values, i, buf, off);
                break;
            }
            case 32: {
                BitPacking.packBits32(values, i, buf, off);
                break;
            }
            case 33: {
                BitPacking.packBits33(values, i, buf, off);
                break;
            }
            case 34: {
                BitPacking.packBits34(values, i, buf, off);
                break;
            }
            case 35: {
                BitPacking.packBits35(values, i, buf, off);
                break;
            }
            case 36: {
                BitPacking.packBits36(values, i, buf, off);
                break;
            }
            case 37: {
                BitPacking.packBits37(values, i, buf, off);
                break;
            }
            case 38: {
                BitPacking.packBits38(values, i, buf, off);
                break;
            }
            case 39: {
                BitPacking.packBits39(values, i, buf, off);
                break;
            }
            case 40: {
                BitPacking.packBits40(values, i, buf, off);
                break;
            }
            case 41: {
                BitPacking.packBits41(values, i, buf, off);
                break;
            }
            case 42: {
                BitPacking.packBits42(values, i, buf, off);
                break;
            }
            case 43: {
                BitPacking.packBits43(values, i, buf, off);
                break;
            }
            case 44: {
                BitPacking.packBits44(values, i, buf, off);
                break;
            }
            case 45: {
                BitPacking.packBits45(values, i, buf, off);
                break;
            }
            case 46: {
                BitPacking.packBits46(values, i, buf, off);
                break;
            }
            case 47: {
                BitPacking.packBits47(values, i, buf, off);
                break;
            }
            case 48: {
                BitPacking.packBits48(values, i, buf, off);
                break;
            }
            case 49: {
                BitPacking.packBits49(values, i, buf, off);
                break;
            }
            case 50: {
                BitPacking.packBits50(values, i, buf, off);
                break;
            }
            case 51: {
                BitPacking.packBits51(values, i, buf, off);
                break;
            }
            case 52: {
                BitPacking.packBits52(values, i, buf, off);
                break;
            }
            case 53: {
                BitPacking.packBits53(values, i, buf, off);
                break;
            }
            case 54: {
                BitPacking.packBits54(values, i, buf, off);
                break;
            }
            case 55: {
                BitPacking.packBits55(values, i, buf, off);
                break;
            }
            case 56: {
                BitPacking.packBits56(values, i, buf, off);
                break;
            }
            case 57: {
                BitPacking.packBits57(values, i, buf, off);
                break;
            }
            case 58: {
                BitPacking.packBits58(values, i, buf, off);
                break;
            }
            case 59: {
                BitPacking.packBits59(values, i, buf, off);
                break;
            }
            case 60: {
                BitPacking.packBits60(values, i, buf, off);
                break;
            }
            case 61: {
                BitPacking.packBits61(values, i, buf, off);
                break;
            }
            case 62: {
                BitPacking.packBits62(values, i, buf, off);
                break;
            }
            case 63: {
                BitPacking.packBits63(values, i, buf, off);
                break;
            }
            default: {
                throw new SketchesArgumentException("wrong number of bits " + bits);
            }
        }
    }

    static void unpackBitsBlock8(long[] values, int i, byte[] buf, int off, int bits) {
        switch (bits) {
            case 1: {
                BitPacking.unpackBits1(values, i, buf, off);
                break;
            }
            case 2: {
                BitPacking.unpackBits2(values, i, buf, off);
                break;
            }
            case 3: {
                BitPacking.unpackBits3(values, i, buf, off);
                break;
            }
            case 4: {
                BitPacking.unpackBits4(values, i, buf, off);
                break;
            }
            case 5: {
                BitPacking.unpackBits5(values, i, buf, off);
                break;
            }
            case 6: {
                BitPacking.unpackBits6(values, i, buf, off);
                break;
            }
            case 7: {
                BitPacking.unpackBits7(values, i, buf, off);
                break;
            }
            case 8: {
                BitPacking.unpackBits8(values, i, buf, off);
                break;
            }
            case 9: {
                BitPacking.unpackBits9(values, i, buf, off);
                break;
            }
            case 10: {
                BitPacking.unpackBits10(values, i, buf, off);
                break;
            }
            case 11: {
                BitPacking.unpackBits11(values, i, buf, off);
                break;
            }
            case 12: {
                BitPacking.unpackBits12(values, i, buf, off);
                break;
            }
            case 13: {
                BitPacking.unpackBits13(values, i, buf, off);
                break;
            }
            case 14: {
                BitPacking.unpackBits14(values, i, buf, off);
                break;
            }
            case 15: {
                BitPacking.unpackBits15(values, i, buf, off);
                break;
            }
            case 16: {
                BitPacking.unpackBits16(values, i, buf, off);
                break;
            }
            case 17: {
                BitPacking.unpackBits17(values, i, buf, off);
                break;
            }
            case 18: {
                BitPacking.unpackBits18(values, i, buf, off);
                break;
            }
            case 19: {
                BitPacking.unpackBits19(values, i, buf, off);
                break;
            }
            case 20: {
                BitPacking.unpackBits20(values, i, buf, off);
                break;
            }
            case 21: {
                BitPacking.unpackBits21(values, i, buf, off);
                break;
            }
            case 22: {
                BitPacking.unpackBits22(values, i, buf, off);
                break;
            }
            case 23: {
                BitPacking.unpackBits23(values, i, buf, off);
                break;
            }
            case 24: {
                BitPacking.unpackBits24(values, i, buf, off);
                break;
            }
            case 25: {
                BitPacking.unpackBits25(values, i, buf, off);
                break;
            }
            case 26: {
                BitPacking.unpackBits26(values, i, buf, off);
                break;
            }
            case 27: {
                BitPacking.unpackBits27(values, i, buf, off);
                break;
            }
            case 28: {
                BitPacking.unpackBits28(values, i, buf, off);
                break;
            }
            case 29: {
                BitPacking.unpackBits29(values, i, buf, off);
                break;
            }
            case 30: {
                BitPacking.unpackBits30(values, i, buf, off);
                break;
            }
            case 31: {
                BitPacking.unpackBits31(values, i, buf, off);
                break;
            }
            case 32: {
                BitPacking.unpackBits32(values, i, buf, off);
                break;
            }
            case 33: {
                BitPacking.unpackBits33(values, i, buf, off);
                break;
            }
            case 34: {
                BitPacking.unpackBits34(values, i, buf, off);
                break;
            }
            case 35: {
                BitPacking.unpackBits35(values, i, buf, off);
                break;
            }
            case 36: {
                BitPacking.unpackBits36(values, i, buf, off);
                break;
            }
            case 37: {
                BitPacking.unpackBits37(values, i, buf, off);
                break;
            }
            case 38: {
                BitPacking.unpackBits38(values, i, buf, off);
                break;
            }
            case 39: {
                BitPacking.unpackBits39(values, i, buf, off);
                break;
            }
            case 40: {
                BitPacking.unpackBits40(values, i, buf, off);
                break;
            }
            case 41: {
                BitPacking.unpackBits41(values, i, buf, off);
                break;
            }
            case 42: {
                BitPacking.unpackBits42(values, i, buf, off);
                break;
            }
            case 43: {
                BitPacking.unpackBits43(values, i, buf, off);
                break;
            }
            case 44: {
                BitPacking.unpackBits44(values, i, buf, off);
                break;
            }
            case 45: {
                BitPacking.unpackBits45(values, i, buf, off);
                break;
            }
            case 46: {
                BitPacking.unpackBits46(values, i, buf, off);
                break;
            }
            case 47: {
                BitPacking.unpackBits47(values, i, buf, off);
                break;
            }
            case 48: {
                BitPacking.unpackBits48(values, i, buf, off);
                break;
            }
            case 49: {
                BitPacking.unpackBits49(values, i, buf, off);
                break;
            }
            case 50: {
                BitPacking.unpackBits50(values, i, buf, off);
                break;
            }
            case 51: {
                BitPacking.unpackBits51(values, i, buf, off);
                break;
            }
            case 52: {
                BitPacking.unpackBits52(values, i, buf, off);
                break;
            }
            case 53: {
                BitPacking.unpackBits53(values, i, buf, off);
                break;
            }
            case 54: {
                BitPacking.unpackBits54(values, i, buf, off);
                break;
            }
            case 55: {
                BitPacking.unpackBits55(values, i, buf, off);
                break;
            }
            case 56: {
                BitPacking.unpackBits56(values, i, buf, off);
                break;
            }
            case 57: {
                BitPacking.unpackBits57(values, i, buf, off);
                break;
            }
            case 58: {
                BitPacking.unpackBits58(values, i, buf, off);
                break;
            }
            case 59: {
                BitPacking.unpackBits59(values, i, buf, off);
                break;
            }
            case 60: {
                BitPacking.unpackBits60(values, i, buf, off);
                break;
            }
            case 61: {
                BitPacking.unpackBits61(values, i, buf, off);
                break;
            }
            case 62: {
                BitPacking.unpackBits62(values, i, buf, off);
                break;
            }
            case 63: {
                BitPacking.unpackBits63(values, i, buf, off);
                break;
            }
            default: {
                throw new SketchesArgumentException("wrong number of bits " + bits);
            }
        }
    }

    static void packBits1(long[] values, int i, byte[] buf, int off) {
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off;
        buf[n] = (byte)((long)buf[n] | values[i + 1] << 6);
        int n2 = off;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] << 5);
        int n3 = off;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] << 4);
        int n4 = off;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] << 3);
        int n5 = off;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] << 2);
        int n6 = off;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] << 1);
        int n7 = off;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7]);
    }

    static void packBits2(long[] values, int i, byte[] buf, int off) {
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off;
        buf[n] = (byte)((long)buf[n] | values[i + 1] << 4);
        int n2 = off;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3]);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] << 4);
        int n5 = off;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] << 2);
        int n6 = off;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7]);
    }

    static void packBits3(long[] values, int i, byte[] buf, int off) {
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off;
        buf[n] = (byte)((long)buf[n] | values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] << 4);
        int n4 = off;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] << 1);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] << 3);
        int n7 = off;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7]);
    }

    static void packBits4(long[] values, int i, byte[] buf, int off) {
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1]);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3]);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5]);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7]);
    }

    static void packBits5(long[] values, int i, byte[] buf, int off) {
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7]);
    }

    static void packBits6(long[] values, int i, byte[] buf, int off) {
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3]);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7]);
    }

    static void packBits7(long[] values, int i, byte[] buf, int off) {
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7]);
    }

    static void packBits8(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)values[i + 0];
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)values[i + 2];
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)values[i + 4];
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)values[i + 6];
        buf[off] = (byte)values[i + 7];
    }

    static void packBits9(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 1);
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 3);
        buf[off] = (byte)(values[i + 2] << 5);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 5);
        buf[off] = (byte)(values[i + 4] << 3);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 7);
        buf[off] = (byte)(values[i + 6] << 1);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits10(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 2);
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 6);
        buf[off] = (byte)(values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 2);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 6);
        buf[off] = (byte)(values[i + 6] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits11(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 3);
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 9);
        buf[off++] = (byte)(values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 7);
        buf[off] = (byte)(values[i + 4] << 1);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 5);
        buf[off] = (byte)(values[i + 6] << 3);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits12(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 4);
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 4);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 4);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 4);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits13(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 5);
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 7);
        buf[off] = (byte)(values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] >>> 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 9);
        buf[off++] = (byte)(values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 11);
        buf[off++] = (byte)(values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits14(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 6);
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 10);
        buf[off++] = (byte)(values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 6);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 10);
        buf[off++] = (byte)(values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits15(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 7);
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 13);
        buf[off++] = (byte)(values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 11);
        buf[off++] = (byte)(values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 9);
        buf[off++] = (byte)(values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits16(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 8);
        buf[off++] = (byte)values[i + 0];
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 8);
        buf[off++] = (byte)values[i + 2];
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 8);
        buf[off++] = (byte)values[i + 4];
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 8);
        buf[off++] = (byte)values[i + 6];
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits17(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 9);
        buf[off++] = (byte)(values[i + 0] >>> 1);
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 11);
        buf[off++] = (byte)(values[i + 2] >>> 3);
        buf[off] = (byte)(values[i + 2] << 5);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 13);
        buf[off++] = (byte)(values[i + 4] >>> 5);
        buf[off] = (byte)(values[i + 4] << 3);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 15);
        buf[off++] = (byte)(values[i + 6] >>> 7);
        buf[off] = (byte)(values[i + 6] << 1);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits18(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 10);
        buf[off++] = (byte)(values[i + 0] >>> 2);
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 14);
        buf[off++] = (byte)(values[i + 2] >>> 6);
        buf[off] = (byte)(values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 10);
        buf[off++] = (byte)(values[i + 4] >>> 2);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 14);
        buf[off++] = (byte)(values[i + 6] >>> 6);
        buf[off] = (byte)(values[i + 6] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits19(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 11);
        buf[off++] = (byte)(values[i + 0] >>> 3);
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 17);
        buf[off++] = (byte)(values[i + 2] >>> 9);
        buf[off++] = (byte)(values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 15);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 4] >>> 7);
        buf[off] = (byte)(values[i + 4] << 1);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 6] >>> 13);
        buf[off++] = (byte)(values[i + 6] >>> 5);
        buf[off] = (byte)(values[i + 6] << 3);
        int n8 = off++;
        buf[n8] = (byte)((long)buf[n8] | values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits20(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 12);
        buf[off++] = (byte)(values[i + 0] >>> 4);
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 12);
        buf[off++] = (byte)(values[i + 2] >>> 4);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 12);
        buf[off++] = (byte)(values[i + 4] >>> 4);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 12);
        buf[off++] = (byte)(values[i + 6] >>> 4);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits21(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 13);
        buf[off++] = (byte)(values[i + 0] >>> 5);
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 15);
        buf[off++] = (byte)(values[i + 2] >>> 7);
        buf[off] = (byte)(values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 17);
        buf[off++] = (byte)(values[i + 4] >>> 9);
        buf[off++] = (byte)(values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 19);
        buf[off++] = (byte)(values[i + 6] >>> 11);
        buf[off++] = (byte)(values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits22(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 14);
        buf[off++] = (byte)(values[i + 0] >>> 6);
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 18);
        buf[off++] = (byte)(values[i + 2] >>> 10);
        buf[off++] = (byte)(values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 14);
        buf[off++] = (byte)(values[i + 4] >>> 6);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 18);
        buf[off++] = (byte)(values[i + 6] >>> 10);
        buf[off++] = (byte)(values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits23(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 15);
        buf[off++] = (byte)(values[i + 0] >>> 7);
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 21);
        buf[off++] = (byte)(values[i + 2] >>> 13);
        buf[off++] = (byte)(values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 19);
        buf[off++] = (byte)(values[i + 4] >>> 11);
        buf[off++] = (byte)(values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 17);
        buf[off++] = (byte)(values[i + 6] >>> 9);
        buf[off++] = (byte)(values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits24(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 16);
        buf[off++] = (byte)(values[i + 0] >>> 8);
        buf[off++] = (byte)values[i + 0];
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 16);
        buf[off++] = (byte)(values[i + 2] >>> 8);
        buf[off++] = (byte)values[i + 2];
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 16);
        buf[off++] = (byte)(values[i + 4] >>> 8);
        buf[off++] = (byte)values[i + 4];
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 16);
        buf[off++] = (byte)(values[i + 6] >>> 8);
        buf[off++] = (byte)values[i + 6];
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits25(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 17);
        buf[off++] = (byte)(values[i + 0] >>> 9);
        buf[off++] = (byte)(values[i + 0] >>> 1);
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 19);
        buf[off++] = (byte)(values[i + 2] >>> 11);
        buf[off++] = (byte)(values[i + 2] >>> 3);
        buf[off] = (byte)(values[i + 2] << 5);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 21);
        buf[off++] = (byte)(values[i + 4] >>> 13);
        buf[off++] = (byte)(values[i + 4] >>> 5);
        buf[off] = (byte)(values[i + 4] << 3);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 23);
        buf[off++] = (byte)(values[i + 6] >>> 15);
        buf[off++] = (byte)(values[i + 6] >>> 7);
        buf[off] = (byte)(values[i + 6] << 1);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits26(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 18);
        buf[off++] = (byte)(values[i + 0] >>> 10);
        buf[off++] = (byte)(values[i + 0] >>> 2);
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 22);
        buf[off++] = (byte)(values[i + 2] >>> 14);
        buf[off++] = (byte)(values[i + 2] >>> 6);
        buf[off] = (byte)(values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 18);
        buf[off++] = (byte)(values[i + 4] >>> 10);
        buf[off++] = (byte)(values[i + 4] >>> 2);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 22);
        buf[off++] = (byte)(values[i + 6] >>> 14);
        buf[off++] = (byte)(values[i + 6] >>> 6);
        buf[off] = (byte)(values[i + 6] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits27(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 19);
        buf[off++] = (byte)(values[i + 0] >>> 11);
        buf[off++] = (byte)(values[i + 0] >>> 3);
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 25);
        buf[off++] = (byte)(values[i + 2] >>> 17);
        buf[off++] = (byte)(values[i + 2] >>> 9);
        buf[off++] = (byte)(values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 23);
        buf[off++] = (byte)(values[i + 4] >>> 15);
        buf[off++] = (byte)(values[i + 4] >>> 7);
        buf[off] = (byte)(values[i + 4] << 1);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 21);
        buf[off++] = (byte)(values[i + 6] >>> 13);
        buf[off++] = (byte)(values[i + 6] >>> 5);
        buf[off] = (byte)(values[i + 6] << 3);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits28(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 20);
        buf[off++] = (byte)(values[i + 0] >>> 12);
        buf[off++] = (byte)(values[i + 0] >>> 4);
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 20);
        buf[off++] = (byte)(values[i + 2] >>> 12);
        buf[off++] = (byte)(values[i + 2] >>> 4);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 20);
        buf[off++] = (byte)(values[i + 4] >>> 12);
        buf[off++] = (byte)(values[i + 4] >>> 4);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 20);
        buf[off++] = (byte)(values[i + 6] >>> 12);
        buf[off++] = (byte)(values[i + 6] >>> 4);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits29(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 21);
        buf[off++] = (byte)(values[i + 0] >>> 13);
        buf[off++] = (byte)(values[i + 0] >>> 5);
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 23);
        buf[off++] = (byte)(values[i + 2] >>> 15);
        buf[off++] = (byte)(values[i + 2] >>> 7);
        buf[off] = (byte)(values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 25);
        buf[off++] = (byte)(values[i + 4] >>> 17);
        buf[off++] = (byte)(values[i + 4] >>> 9);
        buf[off++] = (byte)(values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 27);
        buf[off++] = (byte)(values[i + 6] >>> 19);
        buf[off++] = (byte)(values[i + 6] >>> 11);
        buf[off++] = (byte)(values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits30(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 22);
        buf[off++] = (byte)(values[i + 0] >>> 14);
        buf[off++] = (byte)(values[i + 0] >>> 6);
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 26);
        buf[off++] = (byte)(values[i + 2] >>> 18);
        buf[off++] = (byte)(values[i + 2] >>> 10);
        buf[off++] = (byte)(values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 22);
        buf[off++] = (byte)(values[i + 4] >>> 14);
        buf[off++] = (byte)(values[i + 4] >>> 6);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 26);
        buf[off++] = (byte)(values[i + 6] >>> 18);
        buf[off++] = (byte)(values[i + 6] >>> 10);
        buf[off++] = (byte)(values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits31(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 23);
        buf[off++] = (byte)(values[i + 0] >>> 15);
        buf[off++] = (byte)(values[i + 0] >>> 7);
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 29);
        buf[off++] = (byte)(values[i + 2] >>> 21);
        buf[off++] = (byte)(values[i + 2] >>> 13);
        buf[off++] = (byte)(values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 27);
        buf[off++] = (byte)(values[i + 4] >>> 19);
        buf[off++] = (byte)(values[i + 4] >>> 11);
        buf[off++] = (byte)(values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 25);
        buf[off++] = (byte)(values[i + 6] >>> 17);
        buf[off++] = (byte)(values[i + 6] >>> 9);
        buf[off++] = (byte)(values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits32(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 24);
        buf[off++] = (byte)(values[i + 0] >>> 16);
        buf[off++] = (byte)(values[i + 0] >>> 8);
        buf[off++] = (byte)values[i + 0];
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 24);
        buf[off++] = (byte)(values[i + 2] >>> 16);
        buf[off++] = (byte)(values[i + 2] >>> 8);
        buf[off++] = (byte)values[i + 2];
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 24);
        buf[off++] = (byte)(values[i + 4] >>> 16);
        buf[off++] = (byte)(values[i + 4] >>> 8);
        buf[off++] = (byte)values[i + 4];
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 24);
        buf[off++] = (byte)(values[i + 6] >>> 16);
        buf[off++] = (byte)(values[i + 6] >>> 8);
        buf[off++] = (byte)values[i + 6];
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits33(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 25);
        buf[off++] = (byte)(values[i + 0] >>> 17);
        buf[off++] = (byte)(values[i + 0] >>> 9);
        buf[off++] = (byte)(values[i + 0] >>> 1);
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 27);
        buf[off++] = (byte)(values[i + 2] >>> 19);
        buf[off++] = (byte)(values[i + 2] >>> 11);
        buf[off++] = (byte)(values[i + 2] >>> 3);
        buf[off] = (byte)(values[i + 2] << 5);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 29);
        buf[off++] = (byte)(values[i + 4] >>> 21);
        buf[off++] = (byte)(values[i + 4] >>> 13);
        buf[off++] = (byte)(values[i + 4] >>> 5);
        buf[off] = (byte)(values[i + 4] << 3);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 31);
        buf[off++] = (byte)(values[i + 6] >>> 23);
        buf[off++] = (byte)(values[i + 6] >>> 15);
        buf[off++] = (byte)(values[i + 6] >>> 7);
        buf[off] = (byte)(values[i + 6] << 1);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits34(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 26);
        buf[off++] = (byte)(values[i + 0] >>> 18);
        buf[off++] = (byte)(values[i + 0] >>> 10);
        buf[off++] = (byte)(values[i + 0] >>> 2);
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 30);
        buf[off++] = (byte)(values[i + 2] >>> 22);
        buf[off++] = (byte)(values[i + 2] >>> 14);
        buf[off++] = (byte)(values[i + 2] >>> 6);
        buf[off] = (byte)(values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 26);
        buf[off++] = (byte)(values[i + 4] >>> 18);
        buf[off++] = (byte)(values[i + 4] >>> 10);
        buf[off++] = (byte)(values[i + 4] >>> 2);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 30);
        buf[off++] = (byte)(values[i + 6] >>> 22);
        buf[off++] = (byte)(values[i + 6] >>> 14);
        buf[off++] = (byte)(values[i + 6] >>> 6);
        buf[off] = (byte)(values[i + 6] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits35(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 27);
        buf[off++] = (byte)(values[i + 0] >>> 19);
        buf[off++] = (byte)(values[i + 0] >>> 11);
        buf[off++] = (byte)(values[i + 0] >>> 3);
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 33);
        buf[off++] = (byte)(values[i + 2] >>> 25);
        buf[off++] = (byte)(values[i + 2] >>> 17);
        buf[off++] = (byte)(values[i + 2] >>> 9);
        buf[off++] = (byte)(values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 31);
        buf[off++] = (byte)(values[i + 4] >>> 23);
        buf[off++] = (byte)(values[i + 4] >>> 15);
        buf[off++] = (byte)(values[i + 4] >>> 7);
        buf[off] = (byte)(values[i + 4] << 1);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 29);
        buf[off++] = (byte)(values[i + 6] >>> 21);
        buf[off++] = (byte)(values[i + 6] >>> 13);
        buf[off++] = (byte)(values[i + 6] >>> 5);
        buf[off] = (byte)(values[i + 6] << 3);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits36(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 28);
        buf[off++] = (byte)(values[i + 0] >>> 20);
        buf[off++] = (byte)(values[i + 0] >>> 12);
        buf[off++] = (byte)(values[i + 0] >>> 4);
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 32);
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 28);
        buf[off++] = (byte)(values[i + 2] >>> 20);
        buf[off++] = (byte)(values[i + 2] >>> 12);
        buf[off++] = (byte)(values[i + 2] >>> 4);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 28);
        buf[off++] = (byte)(values[i + 4] >>> 20);
        buf[off++] = (byte)(values[i + 4] >>> 12);
        buf[off++] = (byte)(values[i + 4] >>> 4);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5] >>> 32);
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 28);
        buf[off++] = (byte)(values[i + 6] >>> 20);
        buf[off++] = (byte)(values[i + 6] >>> 12);
        buf[off++] = (byte)(values[i + 6] >>> 4);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits37(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 29);
        buf[off++] = (byte)(values[i + 0] >>> 21);
        buf[off++] = (byte)(values[i + 0] >>> 13);
        buf[off++] = (byte)(values[i + 0] >>> 5);
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 34);
        buf[off++] = (byte)(values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 31);
        buf[off++] = (byte)(values[i + 2] >>> 23);
        buf[off++] = (byte)(values[i + 2] >>> 15);
        buf[off++] = (byte)(values[i + 2] >>> 7);
        buf[off] = (byte)(values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 33);
        buf[off++] = (byte)(values[i + 4] >>> 25);
        buf[off++] = (byte)(values[i + 4] >>> 17);
        buf[off++] = (byte)(values[i + 4] >>> 9);
        buf[off++] = (byte)(values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 35);
        buf[off++] = (byte)(values[i + 6] >>> 27);
        buf[off++] = (byte)(values[i + 6] >>> 19);
        buf[off++] = (byte)(values[i + 6] >>> 11);
        buf[off++] = (byte)(values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits38(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 30);
        buf[off++] = (byte)(values[i + 0] >>> 22);
        buf[off++] = (byte)(values[i + 0] >>> 14);
        buf[off++] = (byte)(values[i + 0] >>> 6);
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 36);
        buf[off++] = (byte)(values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 34);
        buf[off++] = (byte)(values[i + 2] >>> 26);
        buf[off++] = (byte)(values[i + 2] >>> 18);
        buf[off++] = (byte)(values[i + 2] >>> 10);
        buf[off++] = (byte)(values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 30);
        buf[off++] = (byte)(values[i + 4] >>> 22);
        buf[off++] = (byte)(values[i + 4] >>> 14);
        buf[off++] = (byte)(values[i + 4] >>> 6);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 36);
        buf[off++] = (byte)(values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 34);
        buf[off++] = (byte)(values[i + 6] >>> 26);
        buf[off++] = (byte)(values[i + 6] >>> 18);
        buf[off++] = (byte)(values[i + 6] >>> 10);
        buf[off++] = (byte)(values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits39(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 31);
        buf[off++] = (byte)(values[i + 0] >>> 23);
        buf[off++] = (byte)(values[i + 0] >>> 15);
        buf[off++] = (byte)(values[i + 0] >>> 7);
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 38);
        buf[off++] = (byte)(values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 37);
        buf[off++] = (byte)(values[i + 2] >>> 29);
        buf[off++] = (byte)(values[i + 2] >>> 21);
        buf[off++] = (byte)(values[i + 2] >>> 13);
        buf[off++] = (byte)(values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 35);
        buf[off++] = (byte)(values[i + 4] >>> 27);
        buf[off++] = (byte)(values[i + 4] >>> 19);
        buf[off++] = (byte)(values[i + 4] >>> 11);
        buf[off++] = (byte)(values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 33);
        buf[off++] = (byte)(values[i + 6] >>> 25);
        buf[off++] = (byte)(values[i + 6] >>> 17);
        buf[off++] = (byte)(values[i + 6] >>> 9);
        buf[off++] = (byte)(values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits40(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 32);
        buf[off++] = (byte)(values[i + 0] >>> 24);
        buf[off++] = (byte)(values[i + 0] >>> 16);
        buf[off++] = (byte)(values[i + 0] >>> 8);
        buf[off++] = (byte)values[i + 0];
        buf[off++] = (byte)(values[i + 1] >>> 32);
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 32);
        buf[off++] = (byte)(values[i + 2] >>> 24);
        buf[off++] = (byte)(values[i + 2] >>> 16);
        buf[off++] = (byte)(values[i + 2] >>> 8);
        buf[off++] = (byte)values[i + 2];
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 32);
        buf[off++] = (byte)(values[i + 4] >>> 24);
        buf[off++] = (byte)(values[i + 4] >>> 16);
        buf[off++] = (byte)(values[i + 4] >>> 8);
        buf[off++] = (byte)values[i + 4];
        buf[off++] = (byte)(values[i + 5] >>> 32);
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 32);
        buf[off++] = (byte)(values[i + 6] >>> 24);
        buf[off++] = (byte)(values[i + 6] >>> 16);
        buf[off++] = (byte)(values[i + 6] >>> 8);
        buf[off++] = (byte)values[i + 6];
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits41(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 33);
        buf[off++] = (byte)(values[i + 0] >>> 25);
        buf[off++] = (byte)(values[i + 0] >>> 17);
        buf[off++] = (byte)(values[i + 0] >>> 9);
        buf[off++] = (byte)(values[i + 0] >>> 1);
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 34);
        buf[off++] = (byte)(values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 35);
        buf[off++] = (byte)(values[i + 2] >>> 27);
        buf[off++] = (byte)(values[i + 2] >>> 19);
        buf[off++] = (byte)(values[i + 2] >>> 11);
        buf[off++] = (byte)(values[i + 2] >>> 3);
        buf[off] = (byte)(values[i + 2] << 5);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 37);
        buf[off++] = (byte)(values[i + 4] >>> 29);
        buf[off++] = (byte)(values[i + 4] >>> 21);
        buf[off++] = (byte)(values[i + 4] >>> 13);
        buf[off++] = (byte)(values[i + 4] >>> 5);
        buf[off] = (byte)(values[i + 4] << 3);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 38);
        buf[off++] = (byte)(values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 39);
        buf[off++] = (byte)(values[i + 6] >>> 31);
        buf[off++] = (byte)(values[i + 6] >>> 23);
        buf[off++] = (byte)(values[i + 6] >>> 15);
        buf[off++] = (byte)(values[i + 6] >>> 7);
        buf[off] = (byte)(values[i + 6] << 1);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits42(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 34);
        buf[off++] = (byte)(values[i + 0] >>> 26);
        buf[off++] = (byte)(values[i + 0] >>> 18);
        buf[off++] = (byte)(values[i + 0] >>> 10);
        buf[off++] = (byte)(values[i + 0] >>> 2);
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 36);
        buf[off++] = (byte)(values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 38);
        buf[off++] = (byte)(values[i + 2] >>> 30);
        buf[off++] = (byte)(values[i + 2] >>> 22);
        buf[off++] = (byte)(values[i + 2] >>> 14);
        buf[off++] = (byte)(values[i + 2] >>> 6);
        buf[off] = (byte)(values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 34);
        buf[off++] = (byte)(values[i + 4] >>> 26);
        buf[off++] = (byte)(values[i + 4] >>> 18);
        buf[off++] = (byte)(values[i + 4] >>> 10);
        buf[off++] = (byte)(values[i + 4] >>> 2);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 36);
        buf[off++] = (byte)(values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 38);
        buf[off++] = (byte)(values[i + 6] >>> 30);
        buf[off++] = (byte)(values[i + 6] >>> 22);
        buf[off++] = (byte)(values[i + 6] >>> 14);
        buf[off++] = (byte)(values[i + 6] >>> 6);
        buf[off] = (byte)(values[i + 6] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits43(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 35);
        buf[off++] = (byte)(values[i + 0] >>> 27);
        buf[off++] = (byte)(values[i + 0] >>> 19);
        buf[off++] = (byte)(values[i + 0] >>> 11);
        buf[off++] = (byte)(values[i + 0] >>> 3);
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 38);
        buf[off++] = (byte)(values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 41);
        buf[off++] = (byte)(values[i + 2] >>> 33);
        buf[off++] = (byte)(values[i + 2] >>> 25);
        buf[off++] = (byte)(values[i + 2] >>> 17);
        buf[off++] = (byte)(values[i + 2] >>> 9);
        buf[off++] = (byte)(values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 39);
        buf[off++] = (byte)(values[i + 4] >>> 31);
        buf[off++] = (byte)(values[i + 4] >>> 23);
        buf[off++] = (byte)(values[i + 4] >>> 15);
        buf[off++] = (byte)(values[i + 4] >>> 7);
        buf[off] = (byte)(values[i + 4] << 1);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 42);
        buf[off++] = (byte)(values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 37);
        buf[off++] = (byte)(values[i + 6] >>> 29);
        buf[off++] = (byte)(values[i + 6] >>> 21);
        buf[off++] = (byte)(values[i + 6] >>> 13);
        buf[off++] = (byte)(values[i + 6] >>> 5);
        buf[off] = (byte)(values[i + 6] << 3);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits44(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 36);
        buf[off++] = (byte)(values[i + 0] >>> 28);
        buf[off++] = (byte)(values[i + 0] >>> 20);
        buf[off++] = (byte)(values[i + 0] >>> 12);
        buf[off++] = (byte)(values[i + 0] >>> 4);
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 40);
        buf[off++] = (byte)(values[i + 1] >>> 32);
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 36);
        buf[off++] = (byte)(values[i + 2] >>> 28);
        buf[off++] = (byte)(values[i + 2] >>> 20);
        buf[off++] = (byte)(values[i + 2] >>> 12);
        buf[off++] = (byte)(values[i + 2] >>> 4);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 36);
        buf[off++] = (byte)(values[i + 4] >>> 28);
        buf[off++] = (byte)(values[i + 4] >>> 20);
        buf[off++] = (byte)(values[i + 4] >>> 12);
        buf[off++] = (byte)(values[i + 4] >>> 4);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5] >>> 40);
        buf[off++] = (byte)(values[i + 5] >>> 32);
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 36);
        buf[off++] = (byte)(values[i + 6] >>> 28);
        buf[off++] = (byte)(values[i + 6] >>> 20);
        buf[off++] = (byte)(values[i + 6] >>> 12);
        buf[off++] = (byte)(values[i + 6] >>> 4);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits45(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 37);
        buf[off++] = (byte)(values[i + 0] >>> 29);
        buf[off++] = (byte)(values[i + 0] >>> 21);
        buf[off++] = (byte)(values[i + 0] >>> 13);
        buf[off++] = (byte)(values[i + 0] >>> 5);
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 42);
        buf[off++] = (byte)(values[i + 1] >>> 34);
        buf[off++] = (byte)(values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 39);
        buf[off++] = (byte)(values[i + 2] >>> 31);
        buf[off++] = (byte)(values[i + 2] >>> 23);
        buf[off++] = (byte)(values[i + 2] >>> 15);
        buf[off++] = (byte)(values[i + 2] >>> 7);
        buf[off] = (byte)(values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 41);
        buf[off++] = (byte)(values[i + 4] >>> 33);
        buf[off++] = (byte)(values[i + 4] >>> 25);
        buf[off++] = (byte)(values[i + 4] >>> 17);
        buf[off++] = (byte)(values[i + 4] >>> 9);
        buf[off++] = (byte)(values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 38);
        buf[off++] = (byte)(values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 43);
        buf[off++] = (byte)(values[i + 6] >>> 35);
        buf[off++] = (byte)(values[i + 6] >>> 27);
        buf[off++] = (byte)(values[i + 6] >>> 19);
        buf[off++] = (byte)(values[i + 6] >>> 11);
        buf[off++] = (byte)(values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits46(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 38);
        buf[off++] = (byte)(values[i + 0] >>> 30);
        buf[off++] = (byte)(values[i + 0] >>> 22);
        buf[off++] = (byte)(values[i + 0] >>> 14);
        buf[off++] = (byte)(values[i + 0] >>> 6);
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 44);
        buf[off++] = (byte)(values[i + 1] >>> 36);
        buf[off++] = (byte)(values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 42);
        buf[off++] = (byte)(values[i + 2] >>> 34);
        buf[off++] = (byte)(values[i + 2] >>> 26);
        buf[off++] = (byte)(values[i + 2] >>> 18);
        buf[off++] = (byte)(values[i + 2] >>> 10);
        buf[off++] = (byte)(values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 38);
        buf[off++] = (byte)(values[i + 4] >>> 30);
        buf[off++] = (byte)(values[i + 4] >>> 22);
        buf[off++] = (byte)(values[i + 4] >>> 14);
        buf[off++] = (byte)(values[i + 4] >>> 6);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 44);
        buf[off++] = (byte)(values[i + 5] >>> 36);
        buf[off++] = (byte)(values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 42);
        buf[off++] = (byte)(values[i + 6] >>> 34);
        buf[off++] = (byte)(values[i + 6] >>> 26);
        buf[off++] = (byte)(values[i + 6] >>> 18);
        buf[off++] = (byte)(values[i + 6] >>> 10);
        buf[off++] = (byte)(values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits47(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 39);
        buf[off++] = (byte)(values[i + 0] >>> 31);
        buf[off++] = (byte)(values[i + 0] >>> 23);
        buf[off++] = (byte)(values[i + 0] >>> 15);
        buf[off++] = (byte)(values[i + 0] >>> 7);
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 46);
        buf[off++] = (byte)(values[i + 1] >>> 38);
        buf[off++] = (byte)(values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 45);
        buf[off++] = (byte)(values[i + 2] >>> 37);
        buf[off++] = (byte)(values[i + 2] >>> 29);
        buf[off++] = (byte)(values[i + 2] >>> 21);
        buf[off++] = (byte)(values[i + 2] >>> 13);
        buf[off++] = (byte)(values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 43);
        buf[off++] = (byte)(values[i + 4] >>> 35);
        buf[off++] = (byte)(values[i + 4] >>> 27);
        buf[off++] = (byte)(values[i + 4] >>> 19);
        buf[off++] = (byte)(values[i + 4] >>> 11);
        buf[off++] = (byte)(values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 42);
        buf[off++] = (byte)(values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 41);
        buf[off++] = (byte)(values[i + 6] >>> 33);
        buf[off++] = (byte)(values[i + 6] >>> 25);
        buf[off++] = (byte)(values[i + 6] >>> 17);
        buf[off++] = (byte)(values[i + 6] >>> 9);
        buf[off++] = (byte)(values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits48(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 40);
        buf[off++] = (byte)(values[i + 0] >>> 32);
        buf[off++] = (byte)(values[i + 0] >>> 24);
        buf[off++] = (byte)(values[i + 0] >>> 16);
        buf[off++] = (byte)(values[i + 0] >>> 8);
        buf[off++] = (byte)values[i + 0];
        buf[off++] = (byte)(values[i + 1] >>> 40);
        buf[off++] = (byte)(values[i + 1] >>> 32);
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 40);
        buf[off++] = (byte)(values[i + 2] >>> 32);
        buf[off++] = (byte)(values[i + 2] >>> 24);
        buf[off++] = (byte)(values[i + 2] >>> 16);
        buf[off++] = (byte)(values[i + 2] >>> 8);
        buf[off++] = (byte)values[i + 2];
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 40);
        buf[off++] = (byte)(values[i + 4] >>> 32);
        buf[off++] = (byte)(values[i + 4] >>> 24);
        buf[off++] = (byte)(values[i + 4] >>> 16);
        buf[off++] = (byte)(values[i + 4] >>> 8);
        buf[off++] = (byte)values[i + 4];
        buf[off++] = (byte)(values[i + 5] >>> 40);
        buf[off++] = (byte)(values[i + 5] >>> 32);
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 40);
        buf[off++] = (byte)(values[i + 6] >>> 32);
        buf[off++] = (byte)(values[i + 6] >>> 24);
        buf[off++] = (byte)(values[i + 6] >>> 16);
        buf[off++] = (byte)(values[i + 6] >>> 8);
        buf[off++] = (byte)values[i + 6];
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits49(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 41);
        buf[off++] = (byte)(values[i + 0] >>> 33);
        buf[off++] = (byte)(values[i + 0] >>> 25);
        buf[off++] = (byte)(values[i + 0] >>> 17);
        buf[off++] = (byte)(values[i + 0] >>> 9);
        buf[off++] = (byte)(values[i + 0] >>> 1);
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 42);
        buf[off++] = (byte)(values[i + 1] >>> 34);
        buf[off++] = (byte)(values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 43);
        buf[off++] = (byte)(values[i + 2] >>> 35);
        buf[off++] = (byte)(values[i + 2] >>> 27);
        buf[off++] = (byte)(values[i + 2] >>> 19);
        buf[off++] = (byte)(values[i + 2] >>> 11);
        buf[off++] = (byte)(values[i + 2] >>> 3);
        buf[off] = (byte)(values[i + 2] << 5);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 45);
        buf[off++] = (byte)(values[i + 4] >>> 37);
        buf[off++] = (byte)(values[i + 4] >>> 29);
        buf[off++] = (byte)(values[i + 4] >>> 21);
        buf[off++] = (byte)(values[i + 4] >>> 13);
        buf[off++] = (byte)(values[i + 4] >>> 5);
        buf[off] = (byte)(values[i + 4] << 3);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 46);
        buf[off++] = (byte)(values[i + 5] >>> 38);
        buf[off++] = (byte)(values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 47);
        buf[off++] = (byte)(values[i + 6] >>> 39);
        buf[off++] = (byte)(values[i + 6] >>> 31);
        buf[off++] = (byte)(values[i + 6] >>> 23);
        buf[off++] = (byte)(values[i + 6] >>> 15);
        buf[off++] = (byte)(values[i + 6] >>> 7);
        buf[off] = (byte)(values[i + 6] << 1);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits50(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 42);
        buf[off++] = (byte)(values[i + 0] >>> 34);
        buf[off++] = (byte)(values[i + 0] >>> 26);
        buf[off++] = (byte)(values[i + 0] >>> 18);
        buf[off++] = (byte)(values[i + 0] >>> 10);
        buf[off++] = (byte)(values[i + 0] >>> 2);
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 44);
        buf[off++] = (byte)(values[i + 1] >>> 36);
        buf[off++] = (byte)(values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 46);
        buf[off++] = (byte)(values[i + 2] >>> 38);
        buf[off++] = (byte)(values[i + 2] >>> 30);
        buf[off++] = (byte)(values[i + 2] >>> 22);
        buf[off++] = (byte)(values[i + 2] >>> 14);
        buf[off++] = (byte)(values[i + 2] >>> 6);
        buf[off] = (byte)(values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 48);
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 42);
        buf[off++] = (byte)(values[i + 4] >>> 34);
        buf[off++] = (byte)(values[i + 4] >>> 26);
        buf[off++] = (byte)(values[i + 4] >>> 18);
        buf[off++] = (byte)(values[i + 4] >>> 10);
        buf[off++] = (byte)(values[i + 4] >>> 2);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 44);
        buf[off++] = (byte)(values[i + 5] >>> 36);
        buf[off++] = (byte)(values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 46);
        buf[off++] = (byte)(values[i + 6] >>> 38);
        buf[off++] = (byte)(values[i + 6] >>> 30);
        buf[off++] = (byte)(values[i + 6] >>> 22);
        buf[off++] = (byte)(values[i + 6] >>> 14);
        buf[off++] = (byte)(values[i + 6] >>> 6);
        buf[off] = (byte)(values[i + 6] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits51(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 43);
        buf[off++] = (byte)(values[i + 0] >>> 35);
        buf[off++] = (byte)(values[i + 0] >>> 27);
        buf[off++] = (byte)(values[i + 0] >>> 19);
        buf[off++] = (byte)(values[i + 0] >>> 11);
        buf[off++] = (byte)(values[i + 0] >>> 3);
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 46);
        buf[off++] = (byte)(values[i + 1] >>> 38);
        buf[off++] = (byte)(values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 49);
        buf[off++] = (byte)(values[i + 2] >>> 41);
        buf[off++] = (byte)(values[i + 2] >>> 33);
        buf[off++] = (byte)(values[i + 2] >>> 25);
        buf[off++] = (byte)(values[i + 2] >>> 17);
        buf[off++] = (byte)(values[i + 2] >>> 9);
        buf[off++] = (byte)(values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 47);
        buf[off++] = (byte)(values[i + 4] >>> 39);
        buf[off++] = (byte)(values[i + 4] >>> 31);
        buf[off++] = (byte)(values[i + 4] >>> 23);
        buf[off++] = (byte)(values[i + 4] >>> 15);
        buf[off++] = (byte)(values[i + 4] >>> 7);
        buf[off] = (byte)(values[i + 4] << 1);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 50);
        buf[off++] = (byte)(values[i + 5] >>> 42);
        buf[off++] = (byte)(values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 45);
        buf[off++] = (byte)(values[i + 6] >>> 37);
        buf[off++] = (byte)(values[i + 6] >>> 29);
        buf[off++] = (byte)(values[i + 6] >>> 21);
        buf[off++] = (byte)(values[i + 6] >>> 13);
        buf[off++] = (byte)(values[i + 6] >>> 5);
        buf[off] = (byte)(values[i + 6] << 3);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits52(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 44);
        buf[off++] = (byte)(values[i + 0] >>> 36);
        buf[off++] = (byte)(values[i + 0] >>> 28);
        buf[off++] = (byte)(values[i + 0] >>> 20);
        buf[off++] = (byte)(values[i + 0] >>> 12);
        buf[off++] = (byte)(values[i + 0] >>> 4);
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 48);
        buf[off++] = (byte)(values[i + 1] >>> 40);
        buf[off++] = (byte)(values[i + 1] >>> 32);
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 44);
        buf[off++] = (byte)(values[i + 2] >>> 36);
        buf[off++] = (byte)(values[i + 2] >>> 28);
        buf[off++] = (byte)(values[i + 2] >>> 20);
        buf[off++] = (byte)(values[i + 2] >>> 12);
        buf[off++] = (byte)(values[i + 2] >>> 4);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3] >>> 48);
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 44);
        buf[off++] = (byte)(values[i + 4] >>> 36);
        buf[off++] = (byte)(values[i + 4] >>> 28);
        buf[off++] = (byte)(values[i + 4] >>> 20);
        buf[off++] = (byte)(values[i + 4] >>> 12);
        buf[off++] = (byte)(values[i + 4] >>> 4);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5] >>> 48);
        buf[off++] = (byte)(values[i + 5] >>> 40);
        buf[off++] = (byte)(values[i + 5] >>> 32);
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 44);
        buf[off++] = (byte)(values[i + 6] >>> 36);
        buf[off++] = (byte)(values[i + 6] >>> 28);
        buf[off++] = (byte)(values[i + 6] >>> 20);
        buf[off++] = (byte)(values[i + 6] >>> 12);
        buf[off++] = (byte)(values[i + 6] >>> 4);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits53(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 45);
        buf[off++] = (byte)(values[i + 0] >>> 37);
        buf[off++] = (byte)(values[i + 0] >>> 29);
        buf[off++] = (byte)(values[i + 0] >>> 21);
        buf[off++] = (byte)(values[i + 0] >>> 13);
        buf[off++] = (byte)(values[i + 0] >>> 5);
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 50);
        buf[off++] = (byte)(values[i + 1] >>> 42);
        buf[off++] = (byte)(values[i + 1] >>> 34);
        buf[off++] = (byte)(values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 47);
        buf[off++] = (byte)(values[i + 2] >>> 39);
        buf[off++] = (byte)(values[i + 2] >>> 31);
        buf[off++] = (byte)(values[i + 2] >>> 23);
        buf[off++] = (byte)(values[i + 2] >>> 15);
        buf[off++] = (byte)(values[i + 2] >>> 7);
        buf[off] = (byte)(values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 52);
        buf[off++] = (byte)(values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 49);
        buf[off++] = (byte)(values[i + 4] >>> 41);
        buf[off++] = (byte)(values[i + 4] >>> 33);
        buf[off++] = (byte)(values[i + 4] >>> 25);
        buf[off++] = (byte)(values[i + 4] >>> 17);
        buf[off++] = (byte)(values[i + 4] >>> 9);
        buf[off++] = (byte)(values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 46);
        buf[off++] = (byte)(values[i + 5] >>> 38);
        buf[off++] = (byte)(values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 51);
        buf[off++] = (byte)(values[i + 6] >>> 43);
        buf[off++] = (byte)(values[i + 6] >>> 35);
        buf[off++] = (byte)(values[i + 6] >>> 27);
        buf[off++] = (byte)(values[i + 6] >>> 19);
        buf[off++] = (byte)(values[i + 6] >>> 11);
        buf[off++] = (byte)(values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits54(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 46);
        buf[off++] = (byte)(values[i + 0] >>> 38);
        buf[off++] = (byte)(values[i + 0] >>> 30);
        buf[off++] = (byte)(values[i + 0] >>> 22);
        buf[off++] = (byte)(values[i + 0] >>> 14);
        buf[off++] = (byte)(values[i + 0] >>> 6);
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 52);
        buf[off++] = (byte)(values[i + 1] >>> 44);
        buf[off++] = (byte)(values[i + 1] >>> 36);
        buf[off++] = (byte)(values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 50);
        buf[off++] = (byte)(values[i + 2] >>> 42);
        buf[off++] = (byte)(values[i + 2] >>> 34);
        buf[off++] = (byte)(values[i + 2] >>> 26);
        buf[off++] = (byte)(values[i + 2] >>> 18);
        buf[off++] = (byte)(values[i + 2] >>> 10);
        buf[off++] = (byte)(values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 48);
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 46);
        buf[off++] = (byte)(values[i + 4] >>> 38);
        buf[off++] = (byte)(values[i + 4] >>> 30);
        buf[off++] = (byte)(values[i + 4] >>> 22);
        buf[off++] = (byte)(values[i + 4] >>> 14);
        buf[off++] = (byte)(values[i + 4] >>> 6);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 52);
        buf[off++] = (byte)(values[i + 5] >>> 44);
        buf[off++] = (byte)(values[i + 5] >>> 36);
        buf[off++] = (byte)(values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 50);
        buf[off++] = (byte)(values[i + 6] >>> 42);
        buf[off++] = (byte)(values[i + 6] >>> 34);
        buf[off++] = (byte)(values[i + 6] >>> 26);
        buf[off++] = (byte)(values[i + 6] >>> 18);
        buf[off++] = (byte)(values[i + 6] >>> 10);
        buf[off++] = (byte)(values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits55(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 47);
        buf[off++] = (byte)(values[i + 0] >>> 39);
        buf[off++] = (byte)(values[i + 0] >>> 31);
        buf[off++] = (byte)(values[i + 0] >>> 23);
        buf[off++] = (byte)(values[i + 0] >>> 15);
        buf[off++] = (byte)(values[i + 0] >>> 7);
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 54);
        buf[off++] = (byte)(values[i + 1] >>> 46);
        buf[off++] = (byte)(values[i + 1] >>> 38);
        buf[off++] = (byte)(values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 53);
        buf[off++] = (byte)(values[i + 2] >>> 45);
        buf[off++] = (byte)(values[i + 2] >>> 37);
        buf[off++] = (byte)(values[i + 2] >>> 29);
        buf[off++] = (byte)(values[i + 2] >>> 21);
        buf[off++] = (byte)(values[i + 2] >>> 13);
        buf[off++] = (byte)(values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 52);
        buf[off++] = (byte)(values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 51);
        buf[off++] = (byte)(values[i + 4] >>> 43);
        buf[off++] = (byte)(values[i + 4] >>> 35);
        buf[off++] = (byte)(values[i + 4] >>> 27);
        buf[off++] = (byte)(values[i + 4] >>> 19);
        buf[off++] = (byte)(values[i + 4] >>> 11);
        buf[off++] = (byte)(values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 50);
        buf[off++] = (byte)(values[i + 5] >>> 42);
        buf[off++] = (byte)(values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 49);
        buf[off++] = (byte)(values[i + 6] >>> 41);
        buf[off++] = (byte)(values[i + 6] >>> 33);
        buf[off++] = (byte)(values[i + 6] >>> 25);
        buf[off++] = (byte)(values[i + 6] >>> 17);
        buf[off++] = (byte)(values[i + 6] >>> 9);
        buf[off++] = (byte)(values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits56(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 48);
        buf[off++] = (byte)(values[i + 0] >>> 40);
        buf[off++] = (byte)(values[i + 0] >>> 32);
        buf[off++] = (byte)(values[i + 0] >>> 24);
        buf[off++] = (byte)(values[i + 0] >>> 16);
        buf[off++] = (byte)(values[i + 0] >>> 8);
        buf[off++] = (byte)values[i + 0];
        buf[off++] = (byte)(values[i + 1] >>> 48);
        buf[off++] = (byte)(values[i + 1] >>> 40);
        buf[off++] = (byte)(values[i + 1] >>> 32);
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 48);
        buf[off++] = (byte)(values[i + 2] >>> 40);
        buf[off++] = (byte)(values[i + 2] >>> 32);
        buf[off++] = (byte)(values[i + 2] >>> 24);
        buf[off++] = (byte)(values[i + 2] >>> 16);
        buf[off++] = (byte)(values[i + 2] >>> 8);
        buf[off++] = (byte)values[i + 2];
        buf[off++] = (byte)(values[i + 3] >>> 48);
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 48);
        buf[off++] = (byte)(values[i + 4] >>> 40);
        buf[off++] = (byte)(values[i + 4] >>> 32);
        buf[off++] = (byte)(values[i + 4] >>> 24);
        buf[off++] = (byte)(values[i + 4] >>> 16);
        buf[off++] = (byte)(values[i + 4] >>> 8);
        buf[off++] = (byte)values[i + 4];
        buf[off++] = (byte)(values[i + 5] >>> 48);
        buf[off++] = (byte)(values[i + 5] >>> 40);
        buf[off++] = (byte)(values[i + 5] >>> 32);
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 48);
        buf[off++] = (byte)(values[i + 6] >>> 40);
        buf[off++] = (byte)(values[i + 6] >>> 32);
        buf[off++] = (byte)(values[i + 6] >>> 24);
        buf[off++] = (byte)(values[i + 6] >>> 16);
        buf[off++] = (byte)(values[i + 6] >>> 8);
        buf[off++] = (byte)values[i + 6];
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits57(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 49);
        buf[off++] = (byte)(values[i + 0] >>> 41);
        buf[off++] = (byte)(values[i + 0] >>> 33);
        buf[off++] = (byte)(values[i + 0] >>> 25);
        buf[off++] = (byte)(values[i + 0] >>> 17);
        buf[off++] = (byte)(values[i + 0] >>> 9);
        buf[off++] = (byte)(values[i + 0] >>> 1);
        buf[off] = (byte)(values[i + 0] << 7);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 50);
        buf[off++] = (byte)(values[i + 1] >>> 42);
        buf[off++] = (byte)(values[i + 1] >>> 34);
        buf[off++] = (byte)(values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 51);
        buf[off++] = (byte)(values[i + 2] >>> 43);
        buf[off++] = (byte)(values[i + 2] >>> 35);
        buf[off++] = (byte)(values[i + 2] >>> 27);
        buf[off++] = (byte)(values[i + 2] >>> 19);
        buf[off++] = (byte)(values[i + 2] >>> 11);
        buf[off++] = (byte)(values[i + 2] >>> 3);
        buf[off] = (byte)(values[i + 2] << 5);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 52);
        buf[off++] = (byte)(values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 53);
        buf[off++] = (byte)(values[i + 4] >>> 45);
        buf[off++] = (byte)(values[i + 4] >>> 37);
        buf[off++] = (byte)(values[i + 4] >>> 29);
        buf[off++] = (byte)(values[i + 4] >>> 21);
        buf[off++] = (byte)(values[i + 4] >>> 13);
        buf[off++] = (byte)(values[i + 4] >>> 5);
        buf[off] = (byte)(values[i + 4] << 3);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 54);
        buf[off++] = (byte)(values[i + 5] >>> 46);
        buf[off++] = (byte)(values[i + 5] >>> 38);
        buf[off++] = (byte)(values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 55);
        buf[off++] = (byte)(values[i + 6] >>> 47);
        buf[off++] = (byte)(values[i + 6] >>> 39);
        buf[off++] = (byte)(values[i + 6] >>> 31);
        buf[off++] = (byte)(values[i + 6] >>> 23);
        buf[off++] = (byte)(values[i + 6] >>> 15);
        buf[off++] = (byte)(values[i + 6] >>> 7);
        buf[off] = (byte)(values[i + 6] << 1);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 56);
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits58(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 50);
        buf[off++] = (byte)(values[i + 0] >>> 42);
        buf[off++] = (byte)(values[i + 0] >>> 34);
        buf[off++] = (byte)(values[i + 0] >>> 26);
        buf[off++] = (byte)(values[i + 0] >>> 18);
        buf[off++] = (byte)(values[i + 0] >>> 10);
        buf[off++] = (byte)(values[i + 0] >>> 2);
        buf[off] = (byte)(values[i + 0] << 6);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 52);
        buf[off++] = (byte)(values[i + 1] >>> 44);
        buf[off++] = (byte)(values[i + 1] >>> 36);
        buf[off++] = (byte)(values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 54);
        buf[off++] = (byte)(values[i + 2] >>> 46);
        buf[off++] = (byte)(values[i + 2] >>> 38);
        buf[off++] = (byte)(values[i + 2] >>> 30);
        buf[off++] = (byte)(values[i + 2] >>> 22);
        buf[off++] = (byte)(values[i + 2] >>> 14);
        buf[off++] = (byte)(values[i + 2] >>> 6);
        buf[off] = (byte)(values[i + 2] << 2);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 56);
        buf[off++] = (byte)(values[i + 3] >>> 48);
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 50);
        buf[off++] = (byte)(values[i + 4] >>> 42);
        buf[off++] = (byte)(values[i + 4] >>> 34);
        buf[off++] = (byte)(values[i + 4] >>> 26);
        buf[off++] = (byte)(values[i + 4] >>> 18);
        buf[off++] = (byte)(values[i + 4] >>> 10);
        buf[off++] = (byte)(values[i + 4] >>> 2);
        buf[off] = (byte)(values[i + 4] << 6);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 52);
        buf[off++] = (byte)(values[i + 5] >>> 44);
        buf[off++] = (byte)(values[i + 5] >>> 36);
        buf[off++] = (byte)(values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 54);
        buf[off++] = (byte)(values[i + 6] >>> 46);
        buf[off++] = (byte)(values[i + 6] >>> 38);
        buf[off++] = (byte)(values[i + 6] >>> 30);
        buf[off++] = (byte)(values[i + 6] >>> 22);
        buf[off++] = (byte)(values[i + 6] >>> 14);
        buf[off++] = (byte)(values[i + 6] >>> 6);
        buf[off] = (byte)(values[i + 6] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 56);
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits59(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 51);
        buf[off++] = (byte)(values[i + 0] >>> 43);
        buf[off++] = (byte)(values[i + 0] >>> 35);
        buf[off++] = (byte)(values[i + 0] >>> 27);
        buf[off++] = (byte)(values[i + 0] >>> 19);
        buf[off++] = (byte)(values[i + 0] >>> 11);
        buf[off++] = (byte)(values[i + 0] >>> 3);
        buf[off] = (byte)(values[i + 0] << 5);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 54);
        buf[off++] = (byte)(values[i + 1] >>> 46);
        buf[off++] = (byte)(values[i + 1] >>> 38);
        buf[off++] = (byte)(values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 57);
        buf[off++] = (byte)(values[i + 2] >>> 49);
        buf[off++] = (byte)(values[i + 2] >>> 41);
        buf[off++] = (byte)(values[i + 2] >>> 33);
        buf[off++] = (byte)(values[i + 2] >>> 25);
        buf[off++] = (byte)(values[i + 2] >>> 17);
        buf[off++] = (byte)(values[i + 2] >>> 9);
        buf[off++] = (byte)(values[i + 2] >>> 1);
        buf[off] = (byte)(values[i + 2] << 7);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 52);
        buf[off++] = (byte)(values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 55);
        buf[off++] = (byte)(values[i + 4] >>> 47);
        buf[off++] = (byte)(values[i + 4] >>> 39);
        buf[off++] = (byte)(values[i + 4] >>> 31);
        buf[off++] = (byte)(values[i + 4] >>> 23);
        buf[off++] = (byte)(values[i + 4] >>> 15);
        buf[off++] = (byte)(values[i + 4] >>> 7);
        buf[off] = (byte)(values[i + 4] << 1);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 58);
        buf[off++] = (byte)(values[i + 5] >>> 50);
        buf[off++] = (byte)(values[i + 5] >>> 42);
        buf[off++] = (byte)(values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 53);
        buf[off++] = (byte)(values[i + 6] >>> 45);
        buf[off++] = (byte)(values[i + 6] >>> 37);
        buf[off++] = (byte)(values[i + 6] >>> 29);
        buf[off++] = (byte)(values[i + 6] >>> 21);
        buf[off++] = (byte)(values[i + 6] >>> 13);
        buf[off++] = (byte)(values[i + 6] >>> 5);
        buf[off] = (byte)(values[i + 6] << 3);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 56);
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits60(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 52);
        buf[off++] = (byte)(values[i + 0] >>> 44);
        buf[off++] = (byte)(values[i + 0] >>> 36);
        buf[off++] = (byte)(values[i + 0] >>> 28);
        buf[off++] = (byte)(values[i + 0] >>> 20);
        buf[off++] = (byte)(values[i + 0] >>> 12);
        buf[off++] = (byte)(values[i + 0] >>> 4);
        buf[off] = (byte)(values[i + 0] << 4);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 56);
        buf[off++] = (byte)(values[i + 1] >>> 48);
        buf[off++] = (byte)(values[i + 1] >>> 40);
        buf[off++] = (byte)(values[i + 1] >>> 32);
        buf[off++] = (byte)(values[i + 1] >>> 24);
        buf[off++] = (byte)(values[i + 1] >>> 16);
        buf[off++] = (byte)(values[i + 1] >>> 8);
        buf[off++] = (byte)values[i + 1];
        buf[off++] = (byte)(values[i + 2] >>> 52);
        buf[off++] = (byte)(values[i + 2] >>> 44);
        buf[off++] = (byte)(values[i + 2] >>> 36);
        buf[off++] = (byte)(values[i + 2] >>> 28);
        buf[off++] = (byte)(values[i + 2] >>> 20);
        buf[off++] = (byte)(values[i + 2] >>> 12);
        buf[off++] = (byte)(values[i + 2] >>> 4);
        buf[off] = (byte)(values[i + 2] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 3] >>> 56);
        buf[off++] = (byte)(values[i + 3] >>> 48);
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 52);
        buf[off++] = (byte)(values[i + 4] >>> 44);
        buf[off++] = (byte)(values[i + 4] >>> 36);
        buf[off++] = (byte)(values[i + 4] >>> 28);
        buf[off++] = (byte)(values[i + 4] >>> 20);
        buf[off++] = (byte)(values[i + 4] >>> 12);
        buf[off++] = (byte)(values[i + 4] >>> 4);
        buf[off] = (byte)(values[i + 4] << 4);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 5] >>> 56);
        buf[off++] = (byte)(values[i + 5] >>> 48);
        buf[off++] = (byte)(values[i + 5] >>> 40);
        buf[off++] = (byte)(values[i + 5] >>> 32);
        buf[off++] = (byte)(values[i + 5] >>> 24);
        buf[off++] = (byte)(values[i + 5] >>> 16);
        buf[off++] = (byte)(values[i + 5] >>> 8);
        buf[off++] = (byte)values[i + 5];
        buf[off++] = (byte)(values[i + 6] >>> 52);
        buf[off++] = (byte)(values[i + 6] >>> 44);
        buf[off++] = (byte)(values[i + 6] >>> 36);
        buf[off++] = (byte)(values[i + 6] >>> 28);
        buf[off++] = (byte)(values[i + 6] >>> 20);
        buf[off++] = (byte)(values[i + 6] >>> 12);
        buf[off++] = (byte)(values[i + 6] >>> 4);
        buf[off] = (byte)(values[i + 6] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 7] >>> 56);
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits61(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 53);
        buf[off++] = (byte)(values[i + 0] >>> 45);
        buf[off++] = (byte)(values[i + 0] >>> 37);
        buf[off++] = (byte)(values[i + 0] >>> 29);
        buf[off++] = (byte)(values[i + 0] >>> 21);
        buf[off++] = (byte)(values[i + 0] >>> 13);
        buf[off++] = (byte)(values[i + 0] >>> 5);
        buf[off] = (byte)(values[i + 0] << 3);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 58);
        buf[off++] = (byte)(values[i + 1] >>> 50);
        buf[off++] = (byte)(values[i + 1] >>> 42);
        buf[off++] = (byte)(values[i + 1] >>> 34);
        buf[off++] = (byte)(values[i + 1] >>> 26);
        buf[off++] = (byte)(values[i + 1] >>> 18);
        buf[off++] = (byte)(values[i + 1] >>> 10);
        buf[off++] = (byte)(values[i + 1] >>> 2);
        buf[off] = (byte)(values[i + 1] << 6);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 55);
        buf[off++] = (byte)(values[i + 2] >>> 47);
        buf[off++] = (byte)(values[i + 2] >>> 39);
        buf[off++] = (byte)(values[i + 2] >>> 31);
        buf[off++] = (byte)(values[i + 2] >>> 23);
        buf[off++] = (byte)(values[i + 2] >>> 15);
        buf[off++] = (byte)(values[i + 2] >>> 7);
        buf[off] = (byte)(values[i + 2] << 1);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 60);
        buf[off++] = (byte)(values[i + 3] >>> 52);
        buf[off++] = (byte)(values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 57);
        buf[off++] = (byte)(values[i + 4] >>> 49);
        buf[off++] = (byte)(values[i + 4] >>> 41);
        buf[off++] = (byte)(values[i + 4] >>> 33);
        buf[off++] = (byte)(values[i + 4] >>> 25);
        buf[off++] = (byte)(values[i + 4] >>> 17);
        buf[off++] = (byte)(values[i + 4] >>> 9);
        buf[off++] = (byte)(values[i + 4] >>> 1);
        buf[off] = (byte)(values[i + 4] << 7);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 54);
        buf[off++] = (byte)(values[i + 5] >>> 46);
        buf[off++] = (byte)(values[i + 5] >>> 38);
        buf[off++] = (byte)(values[i + 5] >>> 30);
        buf[off++] = (byte)(values[i + 5] >>> 22);
        buf[off++] = (byte)(values[i + 5] >>> 14);
        buf[off++] = (byte)(values[i + 5] >>> 6);
        buf[off] = (byte)(values[i + 5] << 2);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 59);
        buf[off++] = (byte)(values[i + 6] >>> 51);
        buf[off++] = (byte)(values[i + 6] >>> 43);
        buf[off++] = (byte)(values[i + 6] >>> 35);
        buf[off++] = (byte)(values[i + 6] >>> 27);
        buf[off++] = (byte)(values[i + 6] >>> 19);
        buf[off++] = (byte)(values[i + 6] >>> 11);
        buf[off++] = (byte)(values[i + 6] >>> 3);
        buf[off] = (byte)(values[i + 6] << 5);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 56);
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits62(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 54);
        buf[off++] = (byte)(values[i + 0] >>> 46);
        buf[off++] = (byte)(values[i + 0] >>> 38);
        buf[off++] = (byte)(values[i + 0] >>> 30);
        buf[off++] = (byte)(values[i + 0] >>> 22);
        buf[off++] = (byte)(values[i + 0] >>> 14);
        buf[off++] = (byte)(values[i + 0] >>> 6);
        buf[off] = (byte)(values[i + 0] << 2);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 60);
        buf[off++] = (byte)(values[i + 1] >>> 52);
        buf[off++] = (byte)(values[i + 1] >>> 44);
        buf[off++] = (byte)(values[i + 1] >>> 36);
        buf[off++] = (byte)(values[i + 1] >>> 28);
        buf[off++] = (byte)(values[i + 1] >>> 20);
        buf[off++] = (byte)(values[i + 1] >>> 12);
        buf[off++] = (byte)(values[i + 1] >>> 4);
        buf[off] = (byte)(values[i + 1] << 4);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 58);
        buf[off++] = (byte)(values[i + 2] >>> 50);
        buf[off++] = (byte)(values[i + 2] >>> 42);
        buf[off++] = (byte)(values[i + 2] >>> 34);
        buf[off++] = (byte)(values[i + 2] >>> 26);
        buf[off++] = (byte)(values[i + 2] >>> 18);
        buf[off++] = (byte)(values[i + 2] >>> 10);
        buf[off++] = (byte)(values[i + 2] >>> 2);
        buf[off] = (byte)(values[i + 2] << 6);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 56);
        buf[off++] = (byte)(values[i + 3] >>> 48);
        buf[off++] = (byte)(values[i + 3] >>> 40);
        buf[off++] = (byte)(values[i + 3] >>> 32);
        buf[off++] = (byte)(values[i + 3] >>> 24);
        buf[off++] = (byte)(values[i + 3] >>> 16);
        buf[off++] = (byte)(values[i + 3] >>> 8);
        buf[off++] = (byte)values[i + 3];
        buf[off++] = (byte)(values[i + 4] >>> 54);
        buf[off++] = (byte)(values[i + 4] >>> 46);
        buf[off++] = (byte)(values[i + 4] >>> 38);
        buf[off++] = (byte)(values[i + 4] >>> 30);
        buf[off++] = (byte)(values[i + 4] >>> 22);
        buf[off++] = (byte)(values[i + 4] >>> 14);
        buf[off++] = (byte)(values[i + 4] >>> 6);
        buf[off] = (byte)(values[i + 4] << 2);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 5] >>> 60);
        buf[off++] = (byte)(values[i + 5] >>> 52);
        buf[off++] = (byte)(values[i + 5] >>> 44);
        buf[off++] = (byte)(values[i + 5] >>> 36);
        buf[off++] = (byte)(values[i + 5] >>> 28);
        buf[off++] = (byte)(values[i + 5] >>> 20);
        buf[off++] = (byte)(values[i + 5] >>> 12);
        buf[off++] = (byte)(values[i + 5] >>> 4);
        buf[off] = (byte)(values[i + 5] << 4);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 6] >>> 58);
        buf[off++] = (byte)(values[i + 6] >>> 50);
        buf[off++] = (byte)(values[i + 6] >>> 42);
        buf[off++] = (byte)(values[i + 6] >>> 34);
        buf[off++] = (byte)(values[i + 6] >>> 26);
        buf[off++] = (byte)(values[i + 6] >>> 18);
        buf[off++] = (byte)(values[i + 6] >>> 10);
        buf[off++] = (byte)(values[i + 6] >>> 2);
        buf[off] = (byte)(values[i + 6] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 7] >>> 56);
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void packBits63(long[] values, int i, byte[] buf, int off) {
        buf[off++] = (byte)(values[i + 0] >>> 55);
        buf[off++] = (byte)(values[i + 0] >>> 47);
        buf[off++] = (byte)(values[i + 0] >>> 39);
        buf[off++] = (byte)(values[i + 0] >>> 31);
        buf[off++] = (byte)(values[i + 0] >>> 23);
        buf[off++] = (byte)(values[i + 0] >>> 15);
        buf[off++] = (byte)(values[i + 0] >>> 7);
        buf[off] = (byte)(values[i + 0] << 1);
        int n = off++;
        buf[n] = (byte)((long)buf[n] | values[i + 1] >>> 62);
        buf[off++] = (byte)(values[i + 1] >>> 54);
        buf[off++] = (byte)(values[i + 1] >>> 46);
        buf[off++] = (byte)(values[i + 1] >>> 38);
        buf[off++] = (byte)(values[i + 1] >>> 30);
        buf[off++] = (byte)(values[i + 1] >>> 22);
        buf[off++] = (byte)(values[i + 1] >>> 14);
        buf[off++] = (byte)(values[i + 1] >>> 6);
        buf[off] = (byte)(values[i + 1] << 2);
        int n2 = off++;
        buf[n2] = (byte)((long)buf[n2] | values[i + 2] >>> 61);
        buf[off++] = (byte)(values[i + 2] >>> 53);
        buf[off++] = (byte)(values[i + 2] >>> 45);
        buf[off++] = (byte)(values[i + 2] >>> 37);
        buf[off++] = (byte)(values[i + 2] >>> 29);
        buf[off++] = (byte)(values[i + 2] >>> 21);
        buf[off++] = (byte)(values[i + 2] >>> 13);
        buf[off++] = (byte)(values[i + 2] >>> 5);
        buf[off] = (byte)(values[i + 2] << 3);
        int n3 = off++;
        buf[n3] = (byte)((long)buf[n3] | values[i + 3] >>> 60);
        buf[off++] = (byte)(values[i + 3] >>> 52);
        buf[off++] = (byte)(values[i + 3] >>> 44);
        buf[off++] = (byte)(values[i + 3] >>> 36);
        buf[off++] = (byte)(values[i + 3] >>> 28);
        buf[off++] = (byte)(values[i + 3] >>> 20);
        buf[off++] = (byte)(values[i + 3] >>> 12);
        buf[off++] = (byte)(values[i + 3] >>> 4);
        buf[off] = (byte)(values[i + 3] << 4);
        int n4 = off++;
        buf[n4] = (byte)((long)buf[n4] | values[i + 4] >>> 59);
        buf[off++] = (byte)(values[i + 4] >>> 51);
        buf[off++] = (byte)(values[i + 4] >>> 43);
        buf[off++] = (byte)(values[i + 4] >>> 35);
        buf[off++] = (byte)(values[i + 4] >>> 27);
        buf[off++] = (byte)(values[i + 4] >>> 19);
        buf[off++] = (byte)(values[i + 4] >>> 11);
        buf[off++] = (byte)(values[i + 4] >>> 3);
        buf[off] = (byte)(values[i + 4] << 5);
        int n5 = off++;
        buf[n5] = (byte)((long)buf[n5] | values[i + 5] >>> 58);
        buf[off++] = (byte)(values[i + 5] >>> 50);
        buf[off++] = (byte)(values[i + 5] >>> 42);
        buf[off++] = (byte)(values[i + 5] >>> 34);
        buf[off++] = (byte)(values[i + 5] >>> 26);
        buf[off++] = (byte)(values[i + 5] >>> 18);
        buf[off++] = (byte)(values[i + 5] >>> 10);
        buf[off++] = (byte)(values[i + 5] >>> 2);
        buf[off] = (byte)(values[i + 5] << 6);
        int n6 = off++;
        buf[n6] = (byte)((long)buf[n6] | values[i + 6] >>> 57);
        buf[off++] = (byte)(values[i + 6] >>> 49);
        buf[off++] = (byte)(values[i + 6] >>> 41);
        buf[off++] = (byte)(values[i + 6] >>> 33);
        buf[off++] = (byte)(values[i + 6] >>> 25);
        buf[off++] = (byte)(values[i + 6] >>> 17);
        buf[off++] = (byte)(values[i + 6] >>> 9);
        buf[off++] = (byte)(values[i + 6] >>> 1);
        buf[off] = (byte)(values[i + 6] << 7);
        int n7 = off++;
        buf[n7] = (byte)((long)buf[n7] | values[i + 7] >>> 56);
        buf[off++] = (byte)(values[i + 7] >>> 48);
        buf[off++] = (byte)(values[i + 7] >>> 40);
        buf[off++] = (byte)(values[i + 7] >>> 32);
        buf[off++] = (byte)(values[i + 7] >>> 24);
        buf[off++] = (byte)(values[i + 7] >>> 16);
        buf[off++] = (byte)(values[i + 7] >>> 8);
        buf[off] = (byte)values[i + 7];
    }

    static void unpackBits1(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off]) >>> 7 & 1L;
        values[i + 1] = Byte.toUnsignedLong(buf[off]) >>> 6 & 1L;
        values[i + 2] = Byte.toUnsignedLong(buf[off]) >>> 5 & 1L;
        values[i + 3] = Byte.toUnsignedLong(buf[off]) >>> 4 & 1L;
        values[i + 4] = Byte.toUnsignedLong(buf[off]) >>> 3 & 1L;
        values[i + 5] = Byte.toUnsignedLong(buf[off]) >>> 2 & 1L;
        values[i + 6] = Byte.toUnsignedLong(buf[off]) >>> 1 & 1L;
        values[i + 7] = Byte.toUnsignedLong(buf[off]) & 1L;
    }

    static void unpackBits2(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off]) >>> 6 & 3L;
        values[i + 1] = Byte.toUnsignedLong(buf[off]) >>> 4 & 3L;
        values[i + 2] = Byte.toUnsignedLong(buf[off]) >>> 2 & 3L;
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) & 3L;
        values[i + 4] = Byte.toUnsignedLong(buf[off]) >>> 6 & 3L;
        values[i + 5] = Byte.toUnsignedLong(buf[off]) >>> 4 & 3L;
        values[i + 6] = Byte.toUnsignedLong(buf[off]) >>> 2 & 3L;
        values[i + 7] = Byte.toUnsignedLong(buf[off]) & 3L;
    }

    static void unpackBits3(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = Byte.toUnsignedLong(buf[off]) >>> 2 & 7L;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 1;
        int n = i + 2;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = Byte.toUnsignedLong(buf[off]) >>> 4 & 7L;
        values[i + 4] = Byte.toUnsignedLong(buf[off]) >>> 1 & 7L;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 2;
        int n2 = i + 5;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = Byte.toUnsignedLong(buf[off]) >>> 3 & 7L;
        values[i + 7] = Byte.toUnsignedLong(buf[off]) & 7L;
    }

    static void unpackBits4(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = Byte.toUnsignedLong(buf[off++]) & 0xFL;
        values[i + 2] = Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) & 0xFL;
        values[i + 4] = Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = Byte.toUnsignedLong(buf[off++]) & 0xFL;
        values[i + 6] = Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = Byte.toUnsignedLong(buf[off]) & 0xFL;
    }

    static void unpackBits5(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 2;
        int n = i + 1;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = Byte.toUnsignedLong(buf[off]) >>> 1 & 0x1FL;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 4;
        int n2 = i + 3;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 1;
        int n3 = i + 4;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = Byte.toUnsignedLong(buf[off]) >>> 2 & 0x1FL;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 3;
        int n4 = i + 6;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = Byte.toUnsignedLong(buf[off]) & 0x1FL;
    }

    static void unpackBits6(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 4;
        int n = i + 1;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 2;
        int n2 = i + 2;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) & 0x3FL;
        values[i + 4] = Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 4;
        int n3 = i + 5;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 2;
        int n4 = i + 6;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = Byte.toUnsignedLong(buf[off]) & 0x3FL;
    }

    static void unpackBits7(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 6;
        int n = i + 1;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 5;
        int n2 = i + 2;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 4;
        int n3 = i + 3;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 3;
        int n4 = i + 4;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 2;
        int n5 = i + 5;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 1;
        int n6 = i + 6;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = Byte.toUnsignedLong(buf[off]) & 0x7FL;
    }

    static void unpackBits8(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]);
        values[i + 1] = Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]);
        values[i + 3] = Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]);
        values[i + 5] = Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]);
        values[i + 7] = Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits9(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 1;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 2;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 3;
        int n3 = i + 2;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 4;
        int n4 = i + 3;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 5;
        int n5 = i + 4;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 6;
        int n6 = i + 5;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 7;
        int n7 = i + 6;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 8;
        int n8 = i + 7;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits10(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 2;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 4;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 6;
        int n3 = i + 2;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 8;
        int n4 = i + 3;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 2;
        int n5 = i + 4;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 4;
        int n6 = i + 5;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 6;
        int n7 = i + 6;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 8;
        int n8 = i + 7;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits11(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 3;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 6;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 9;
        int n3 = i + 2;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n4 = i + 2;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 4;
        int n5 = i + 3;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 7;
        int n6 = i + 4;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 10;
        int n7 = i + 5;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n8 = i + 5;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 5;
        int n9 = i + 6;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 8;
        int n10 = i + 7;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits12(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 4;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 8;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 4;
        int n3 = i + 2;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 8;
        int n4 = i + 3;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 4;
        int n5 = i + 4;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 8;
        int n6 = i + 5;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 4;
        int n7 = i + 6;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 8;
        int n8 = i + 7;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits13(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 5;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 10;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 7;
        int n4 = i + 2;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 12;
        int n5 = i + 3;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n6 = i + 3;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 9;
        int n7 = i + 4;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n8 = i + 4;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 6;
        int n9 = i + 5;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 11;
        int n10 = i + 6;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n11 = i + 6;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 8;
        int n12 = i + 7;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits14(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 6;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 12;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 10;
        int n4 = i + 2;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n5 = i + 2;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 8;
        int n6 = i + 3;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 6;
        int n7 = i + 4;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 12;
        int n8 = i + 5;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n9 = i + 5;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 10;
        int n10 = i + 6;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n11 = i + 6;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 8;
        int n12 = i + 7;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits15(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 7;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 14;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 13;
        int n4 = i + 2;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n5 = i + 2;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 12;
        int n6 = i + 3;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n7 = i + 3;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 11;
        int n8 = i + 4;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n9 = i + 4;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 10;
        int n10 = i + 5;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n11 = i + 5;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 9;
        int n12 = i + 6;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n13 = i + 6;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 8;
        int n14 = i + 7;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits16(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]);
        values[i + 1] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n2 = i + 1;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n3 = i + 2;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]);
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n4 = i + 3;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n5 = i + 4;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]);
        values[i + 5] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n6 = i + 5;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n7 = i + 6;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]);
        values[i + 7] = Byte.toUnsignedLong(buf[off++]) << 8;
        int n8 = i + 7;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits17(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 9;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 10;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 11;
        int n5 = i + 2;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 12;
        int n7 = i + 3;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n8 = i + 3;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 13;
        int n9 = i + 4;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n10 = i + 4;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 14;
        int n11 = i + 5;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n12 = i + 5;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 15;
        int n13 = i + 6;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n14 = i + 6;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 16;
        int n15 = i + 7;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n16 = i + 7;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits18(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 10;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 12;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 14;
        int n5 = i + 2;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 16;
        int n7 = i + 3;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n8 = i + 3;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 10;
        int n9 = i + 4;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n10 = i + 4;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 12;
        int n11 = i + 5;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n12 = i + 5;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 14;
        int n13 = i + 6;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n14 = i + 6;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 16;
        int n15 = i + 7;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n16 = i + 7;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits19(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 11;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 14;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 17;
        int n5 = i + 2;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 12;
        int n8 = i + 3;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n9 = i + 3;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 15;
        int n10 = i + 4;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n11 = i + 4;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 18;
        int n12 = i + 5;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n13 = i + 5;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n14 = i + 5;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 13;
        int n15 = i + 6;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n16 = i + 6;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 16;
        int n17 = i + 7;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n18 = i + 7;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits20(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 12;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 16;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 12;
        int n5 = i + 2;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 16;
        int n7 = i + 3;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n8 = i + 3;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 12;
        int n9 = i + 4;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n10 = i + 4;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 16;
        int n11 = i + 5;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 5;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 12;
        int n13 = i + 6;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n14 = i + 6;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 16;
        int n15 = i + 7;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n16 = i + 7;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits21(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 13;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 18;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 15;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 20;
        int n8 = i + 3;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n9 = i + 3;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n10 = i + 3;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 17;
        int n11 = i + 4;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n12 = i + 4;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n13 = i + 4;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 14;
        int n14 = i + 5;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n15 = i + 5;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 19;
        int n16 = i + 6;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n17 = i + 6;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n18 = i + 6;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 16;
        int n19 = i + 7;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n20 = i + 7;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits22(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 14;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 20;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 18;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 16;
        int n9 = i + 3;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n10 = i + 3;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 14;
        int n11 = i + 4;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n12 = i + 4;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 20;
        int n13 = i + 5;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n14 = i + 5;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n15 = i + 5;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 18;
        int n16 = i + 6;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n17 = i + 6;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n18 = i + 6;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 16;
        int n19 = i + 7;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n20 = i + 7;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits23(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 15;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 22;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 21;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 20;
        int n9 = i + 3;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n10 = i + 3;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n11 = i + 3;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 19;
        int n12 = i + 4;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n13 = i + 4;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n14 = i + 4;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 18;
        int n15 = i + 5;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n16 = i + 5;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n17 = i + 5;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 17;
        int n18 = i + 6;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n19 = i + 6;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n20 = i + 6;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 16;
        int n21 = i + 7;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n22 = i + 7;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits24(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]);
        values[i + 1] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n3 = i + 1;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n5 = i + 2;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n6 = i + 2;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]);
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n7 = i + 3;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n8 = i + 3;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n9 = i + 4;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n10 = i + 4;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]);
        values[i + 5] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n11 = i + 5;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 5;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n13 = i + 6;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n14 = i + 6;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]);
        values[i + 7] = Byte.toUnsignedLong(buf[off++]) << 16;
        int n15 = i + 7;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n16 = i + 7;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits25(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 17;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 18;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 19;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 20;
        int n10 = i + 3;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n11 = i + 3;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 21;
        int n13 = i + 4;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n14 = i + 4;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n15 = i + 4;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 22;
        int n16 = i + 5;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n17 = i + 5;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n18 = i + 5;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 23;
        int n19 = i + 6;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n20 = i + 6;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n21 = i + 6;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 24;
        int n22 = i + 7;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 7;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 7;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits26(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 18;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 20;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 22;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 24;
        int n10 = i + 3;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n11 = i + 3;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 18;
        int n13 = i + 4;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n14 = i + 4;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n15 = i + 4;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 20;
        int n16 = i + 5;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n17 = i + 5;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n18 = i + 5;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 22;
        int n19 = i + 6;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n20 = i + 6;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n21 = i + 6;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 24;
        int n22 = i + 7;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 7;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 7;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits27(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 19;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 22;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 25;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 20;
        int n11 = i + 3;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 23;
        int n14 = i + 4;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n15 = i + 4;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n16 = i + 4;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 26;
        int n17 = i + 5;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n18 = i + 5;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n19 = i + 5;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n20 = i + 5;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 21;
        int n21 = i + 6;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n22 = i + 6;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n23 = i + 6;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 24;
        int n24 = i + 7;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n25 = i + 7;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n26 = i + 7;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits28(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 20;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 24;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 20;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 24;
        int n10 = i + 3;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n11 = i + 3;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 20;
        int n13 = i + 4;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n14 = i + 4;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n15 = i + 4;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 24;
        int n16 = i + 5;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n17 = i + 5;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n18 = i + 5;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 20;
        int n19 = i + 6;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n20 = i + 6;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n21 = i + 6;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 24;
        int n22 = i + 7;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 7;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 7;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits29(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 21;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 26;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 23;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 28;
        int n11 = i + 3;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 25;
        int n15 = i + 4;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n16 = i + 4;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n17 = i + 4;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n18 = i + 4;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 22;
        int n19 = i + 5;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n20 = i + 5;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n21 = i + 5;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 27;
        int n22 = i + 6;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n23 = i + 6;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n24 = i + 6;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n25 = i + 6;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 24;
        int n26 = i + 7;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n27 = i + 7;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n28 = i + 7;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits30(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 22;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 28;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 26;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 24;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 22;
        int n15 = i + 4;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n16 = i + 4;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n17 = i + 4;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 28;
        int n18 = i + 5;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n19 = i + 5;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n20 = i + 5;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n21 = i + 5;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 26;
        int n22 = i + 6;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n23 = i + 6;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n24 = i + 6;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n25 = i + 6;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 24;
        int n26 = i + 7;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n27 = i + 7;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n28 = i + 7;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits31(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 23;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 30;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 29;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 28;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 27;
        int n16 = i + 4;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n17 = i + 4;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n18 = i + 4;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 26;
        int n20 = i + 5;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n21 = i + 5;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n22 = i + 5;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n23 = i + 5;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 25;
        int n24 = i + 6;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n25 = i + 6;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n26 = i + 6;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n27 = i + 6;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 24;
        int n28 = i + 7;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n29 = i + 7;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n30 = i + 7;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits32(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]);
        values[i + 1] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n4 = i + 1;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n7 = i + 2;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n8 = i + 2;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]);
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n10 = i + 3;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n11 = i + 3;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 3;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n13 = i + 4;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n14 = i + 4;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n15 = i + 4;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]);
        values[i + 5] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n16 = i + 5;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n17 = i + 5;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n18 = i + 5;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n19 = i + 6;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n20 = i + 6;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n21 = i + 6;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]);
        values[i + 7] = Byte.toUnsignedLong(buf[off++]) << 24;
        int n22 = i + 7;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 7;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 7;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits33(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 25;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 26;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 27;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 28;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 29;
        int n17 = i + 4;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n18 = i + 4;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 30;
        int n21 = i + 5;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n22 = i + 5;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n23 = i + 5;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n24 = i + 5;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 31;
        int n25 = i + 6;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n26 = i + 6;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n27 = i + 6;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n28 = i + 6;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 32;
        int n29 = i + 7;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n30 = i + 7;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n31 = i + 7;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n32 = i + 7;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits34(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 26;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 28;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 30;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 32;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 26;
        int n17 = i + 4;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n18 = i + 4;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 28;
        int n21 = i + 5;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n22 = i + 5;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n23 = i + 5;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n24 = i + 5;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 30;
        int n25 = i + 6;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n26 = i + 6;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n27 = i + 6;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n28 = i + 6;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 32;
        int n29 = i + 7;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n30 = i + 7;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n31 = i + 7;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n32 = i + 7;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]);
    }

    static void unpackBits35(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 27;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 30;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 2L) << 33;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 28;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 31;
        int n18 = i + 4;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 34;
        int n22 = i + 5;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n23 = i + 5;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n24 = i + 5;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n25 = i + 5;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 29;
        int n27 = i + 6;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n28 = i + 6;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n29 = i + 6;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n30 = i + 6;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 32;
        int n31 = i + 7;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n32 = i + 7;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n33 = i + 7;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n34 = i + 7;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits36(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 28;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 32;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 28;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 32;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 28;
        int n17 = i + 4;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n18 = i + 4;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 32;
        int n21 = i + 5;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n22 = i + 5;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 5;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 5;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 28;
        int n25 = i + 6;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n26 = i + 6;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n27 = i + 6;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n28 = i + 6;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 32;
        int n29 = i + 7;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n30 = i + 7;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n31 = i + 7;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n32 = i + 7;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits37(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 29;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 34;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 31;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 36;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 33;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 30;
        int n24 = i + 5;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n25 = i + 5;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 35;
        int n28 = i + 6;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n29 = i + 6;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n30 = i + 6;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n31 = i + 6;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n32 = i + 6;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 32;
        int n33 = i + 7;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n34 = i + 7;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n35 = i + 7;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n36 = i + 7;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits38(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 30;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 36;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 34;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 32;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 30;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 36;
        int n23 = i + 5;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n24 = i + 5;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n25 = i + 5;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 34;
        int n28 = i + 6;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n29 = i + 6;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n30 = i + 6;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n31 = i + 6;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n32 = i + 6;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 32;
        int n33 = i + 7;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n34 = i + 7;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n35 = i + 7;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n36 = i + 7;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits39(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 31;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 38;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 37;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 36;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 35;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 34;
        int n25 = i + 5;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n28 = i + 5;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 33;
        int n30 = i + 6;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n31 = i + 6;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n32 = i + 6;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n33 = i + 6;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 32;
        int n35 = i + 7;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n36 = i + 7;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n37 = i + 7;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n38 = i + 7;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits40(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]);
        values[i + 1] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n5 = i + 1;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n9 = i + 2;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n10 = i + 2;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n13 = i + 3;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n14 = i + 3;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n15 = i + 3;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n17 = i + 4;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n18 = i + 4;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n19 = i + 4;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n20 = i + 4;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]);
        values[i + 5] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n21 = i + 5;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n22 = i + 5;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 5;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 5;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n25 = i + 6;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n26 = i + 6;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n27 = i + 6;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n28 = i + 6;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]);
        values[i + 7] = Byte.toUnsignedLong(buf[off++]) << 32;
        int n29 = i + 7;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n30 = i + 7;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n31 = i + 7;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n32 = i + 7;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits41(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 33;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 34;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 35;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 36;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 37;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 38;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n28 = i + 5;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 39;
        int n31 = i + 6;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n32 = i + 6;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n33 = i + 6;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n35 = i + 6;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 40;
        int n36 = i + 7;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n37 = i + 7;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n38 = i + 7;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n39 = i + 7;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n40 = i + 7;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits42(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 34;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 36;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 38;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 40;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 34;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 36;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n28 = i + 5;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 38;
        int n31 = i + 6;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n32 = i + 6;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n33 = i + 6;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n35 = i + 6;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 40;
        int n36 = i + 7;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n37 = i + 7;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n38 = i + 7;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n39 = i + 7;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n40 = i + 7;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits43(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 35;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 38;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 41;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 36;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 39;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 42;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n28 = i + 5;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 37;
        int n33 = i + 6;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n35 = i + 6;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n36 = i + 6;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 40;
        int n38 = i + 7;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n39 = i + 7;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n40 = i + 7;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n41 = i + 7;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n42 = i + 7;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits44(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 36;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 40;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 36;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 40;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 36;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 40;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n28 = i + 5;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 36;
        int n31 = i + 6;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n32 = i + 6;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n33 = i + 6;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n35 = i + 6;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 40;
        int n36 = i + 7;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n37 = i + 7;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n38 = i + 7;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n39 = i + 7;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n40 = i + 7;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits45(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 37;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 42;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 39;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 44;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 41;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 38;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 43;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n35 = i + 6;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n36 = i + 6;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n38 = i + 6;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 40;
        int n40 = i + 7;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n41 = i + 7;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n42 = i + 7;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n43 = i + 7;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n44 = i + 7;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits46(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 38;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 44;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 42;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 40;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 38;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 44;
        int n28 = i + 5;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 42;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n35 = i + 6;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n36 = i + 6;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n38 = i + 6;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 40;
        int n40 = i + 7;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n41 = i + 7;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n42 = i + 7;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n43 = i + 7;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n44 = i + 7;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits47(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 39;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 46;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 45;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 44;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 43;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 42;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 41;
        int n36 = i + 6;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n38 = i + 6;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 40;
        int n42 = i + 7;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n43 = i + 7;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n44 = i + 7;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n45 = i + 7;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n46 = i + 7;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits48(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]);
        values[i + 1] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n6 = i + 1;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n11 = i + 2;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n12 = i + 2;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]);
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n16 = i + 3;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n17 = i + 3;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n18 = i + 3;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n21 = i + 4;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n22 = i + 4;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n23 = i + 4;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n24 = i + 4;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]);
        values[i + 5] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n26 = i + 5;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n27 = i + 5;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n28 = i + 5;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n29 = i + 5;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n30 = i + 5;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n31 = i + 6;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n32 = i + 6;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n33 = i + 6;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n34 = i + 6;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n35 = i + 6;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]);
        values[i + 7] = Byte.toUnsignedLong(buf[off++]) << 40;
        int n36 = i + 7;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n37 = i + 7;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n38 = i + 7;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n39 = i + 7;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n40 = i + 7;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits49(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 41;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 42;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 43;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 44;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 45;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 46;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 47;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n38 = i + 6;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 48;
        int n43 = i + 7;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n44 = i + 7;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n45 = i + 7;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n46 = i + 7;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n47 = i + 7;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n48 = i + 7;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits50(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 42;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 44;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 46;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 48;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 42;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 44;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 46;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n38 = i + 6;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 48;
        int n43 = i + 7;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n44 = i + 7;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n45 = i + 7;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n46 = i + 7;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n47 = i + 7;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n48 = i + 7;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits51(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 43;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 46;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 49;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 41;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 44;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 47;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 50;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 45;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n43 = i + 6;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n44 = i + 6;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 48;
        int n45 = i + 7;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n46 = i + 7;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n47 = i + 7;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n48 = i + 7;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n49 = i + 7;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n50 = i + 7;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits52(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 44;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 48;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 44;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 48;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 44;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 48;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 44;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n38 = i + 6;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 48;
        int n43 = i + 7;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n44 = i + 7;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n45 = i + 7;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n46 = i + 7;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n47 = i + 7;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n48 = i + 7;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits53(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 45;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 50;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 47;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 52;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 49;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 41;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 46;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 51;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 43;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n43 = i + 6;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n44 = i + 6;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n45 = i + 6;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 48;
        int n47 = i + 7;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n48 = i + 7;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n49 = i + 7;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n50 = i + 7;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n51 = i + 7;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n52 = i + 7;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits54(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 46;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 52;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 50;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 48;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 46;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 52;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 50;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n43 = i + 6;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n44 = i + 6;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n45 = i + 6;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 48;
        int n47 = i + 7;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n48 = i + 7;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n49 = i + 7;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n50 = i + 7;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n51 = i + 7;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n52 = i + 7;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]);
    }

    static void unpackBits55(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 47;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 54;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 53;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 45;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 52;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 51;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 43;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 50;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 49;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 41;
        int n43 = i + 6;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n44 = i + 6;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n45 = i + 6;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n47 = i + 6;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 48;
        int n49 = i + 7;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n50 = i + 7;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n51 = i + 7;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n52 = i + 7;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n53 = i + 7;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n54 = i + 7;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits56(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]);
        values[i + 1] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n7 = i + 1;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n13 = i + 2;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n14 = i + 2;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]);
        values[i + 3] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n19 = i + 3;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n20 = i + 3;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n21 = i + 3;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n25 = i + 4;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n26 = i + 4;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n27 = i + 4;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n28 = i + 4;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]);
        values[i + 5] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n31 = i + 5;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n32 = i + 5;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n33 = i + 5;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n34 = i + 5;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n35 = i + 5;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n37 = i + 6;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n38 = i + 6;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n39 = i + 6;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n40 = i + 6;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n41 = i + 6;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n42 = i + 6;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]);
        values[i + 7] = Byte.toUnsignedLong(buf[off++]) << 48;
        int n43 = i + 7;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n44 = i + 7;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n45 = i + 7;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n46 = i + 7;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n47 = i + 7;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n48 = i + 7;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits57(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 49;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 41;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n7 = i + 0;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 50;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n14 = i + 1;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 51;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 43;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n21 = i + 2;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 52;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n28 = i + 3;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 53;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 45;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n35 = i + 4;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 54;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n42 = i + 5;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 55;
        int n43 = i + 6;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 47;
        int n44 = i + 6;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n45 = i + 6;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n47 = i + 6;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n49 = i + 6;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 56;
        int n50 = i + 7;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n51 = i + 7;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n52 = i + 7;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n53 = i + 7;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n54 = i + 7;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n55 = i + 7;
        values[n55] = values[n55] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n56 = i + 7;
        values[n56] = values[n56] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits58(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 50;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n7 = i + 0;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 52;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n14 = i + 1;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 54;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n21 = i + 2;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 56;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n28 = i + 3;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 50;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n35 = i + 4;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 52;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n42 = i + 5;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 54;
        int n43 = i + 6;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n44 = i + 6;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n45 = i + 6;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n47 = i + 6;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n49 = i + 6;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 56;
        int n50 = i + 7;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n51 = i + 7;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n52 = i + 7;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n53 = i + 7;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n54 = i + 7;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n55 = i + 7;
        values[n55] = values[n55] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n56 = i + 7;
        values[n56] = values[n56] | Byte.toUnsignedLong(buf[off++]);
    }

    static void unpackBits59(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 51;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 43;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n7 = i + 0;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 54;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n14 = i + 1;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 57;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 49;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 41;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n21 = i + 2;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n22 = i + 2;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 52;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n28 = i + 3;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n29 = i + 3;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 55;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 47;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n35 = i + 4;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n36 = i + 4;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 58;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 50;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n42 = i + 5;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n43 = i + 5;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n44 = i + 5;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 53;
        int n45 = i + 6;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 45;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n47 = i + 6;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n49 = i + 6;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n50 = i + 6;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n51 = i + 6;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 56;
        int n52 = i + 7;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n53 = i + 7;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n54 = i + 7;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n55 = i + 7;
        values[n55] = values[n55] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n56 = i + 7;
        values[n56] = values[n56] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n57 = i + 7;
        values[n57] = values[n57] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n58 = i + 7;
        values[n58] = values[n58] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits60(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 52;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n7 = i + 0;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 56;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n14 = i + 1;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]);
        values[i + 2] = Byte.toUnsignedLong(buf[off++]) << 52;
        int n15 = i + 2;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n21 = i + 2;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 56;
        int n22 = i + 3;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n28 = i + 3;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 52;
        int n29 = i + 4;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n30 = i + 4;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n35 = i + 4;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 56;
        int n36 = i + 5;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n37 = i + 5;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n42 = i + 5;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]);
        values[i + 6] = Byte.toUnsignedLong(buf[off++]) << 52;
        int n43 = i + 6;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n44 = i + 6;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n45 = i + 6;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n47 = i + 6;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n49 = i + 6;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 56;
        int n50 = i + 7;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n51 = i + 7;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n52 = i + 7;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n53 = i + 7;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n54 = i + 7;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n55 = i + 7;
        values[n55] = values[n55] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n56 = i + 7;
        values[n56] = values[n56] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits61(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 53;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 45;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n7 = i + 0;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 58;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 50;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n14 = i + 1;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n15 = i + 1;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 55;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 47;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n21 = i + 2;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n22 = i + 2;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 60;
        int n23 = i + 3;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off++]) << 52;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n28 = i + 3;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n29 = i + 3;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n30 = i + 3;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 57;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 49;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 41;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n35 = i + 4;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n36 = i + 4;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n37 = i + 4;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n38 = i + 4;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 54;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n42 = i + 5;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n43 = i + 5;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n44 = i + 5;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n45 = i + 5;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 59;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 51;
        int n47 = i + 6;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 43;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n49 = i + 6;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n50 = i + 6;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n51 = i + 6;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n52 = i + 6;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n53 = i + 6;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 56;
        int n54 = i + 7;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n55 = i + 7;
        values[n55] = values[n55] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n56 = i + 7;
        values[n56] = values[n56] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n57 = i + 7;
        values[n57] = values[n57] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n58 = i + 7;
        values[n58] = values[n58] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n59 = i + 7;
        values[n59] = values[n59] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n60 = i + 7;
        values[n60] = values[n60] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits62(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 54;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n7 = i + 0;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 60;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 52;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n14 = i + 1;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n15 = i + 1;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 58;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 50;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n21 = i + 2;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n22 = i + 2;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n23 = i + 2;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 56;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n28 = i + 3;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n29 = i + 3;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n30 = i + 3;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]);
        values[i + 4] = Byte.toUnsignedLong(buf[off++]) << 54;
        int n31 = i + 4;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n35 = i + 4;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n36 = i + 4;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n37 = i + 4;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 60;
        int n38 = i + 5;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 52;
        int n39 = i + 5;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n42 = i + 5;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n43 = i + 5;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n44 = i + 5;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n45 = i + 5;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 58;
        int n46 = i + 6;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 50;
        int n47 = i + 6;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n49 = i + 6;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n50 = i + 6;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n51 = i + 6;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n52 = i + 6;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n53 = i + 6;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 56;
        int n54 = i + 7;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n55 = i + 7;
        values[n55] = values[n55] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n56 = i + 7;
        values[n56] = values[n56] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n57 = i + 7;
        values[n57] = values[n57] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n58 = i + 7;
        values[n58] = values[n58] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n59 = i + 7;
        values[n59] = values[n59] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n60 = i + 7;
        values[n60] = values[n60] | Byte.toUnsignedLong(buf[off]);
    }

    static void unpackBits63(long[] values, int i, byte[] buf, int off) {
        values[i + 0] = Byte.toUnsignedLong(buf[off++]) << 55;
        int n = i + 0;
        values[n] = values[n] | Byte.toUnsignedLong(buf[off++]) << 47;
        int n2 = i + 0;
        values[n2] = values[n2] | Byte.toUnsignedLong(buf[off++]) << 39;
        int n3 = i + 0;
        values[n3] = values[n3] | Byte.toUnsignedLong(buf[off++]) << 31;
        int n4 = i + 0;
        values[n4] = values[n4] | Byte.toUnsignedLong(buf[off++]) << 23;
        int n5 = i + 0;
        values[n5] = values[n5] | Byte.toUnsignedLong(buf[off++]) << 15;
        int n6 = i + 0;
        values[n6] = values[n6] | Byte.toUnsignedLong(buf[off++]) << 7;
        int n7 = i + 0;
        values[n7] = values[n7] | Byte.toUnsignedLong(buf[off]) >>> 1;
        values[i + 1] = (Byte.toUnsignedLong(buf[off++]) & 1L) << 62;
        int n8 = i + 1;
        values[n8] = values[n8] | Byte.toUnsignedLong(buf[off++]) << 54;
        int n9 = i + 1;
        values[n9] = values[n9] | Byte.toUnsignedLong(buf[off++]) << 46;
        int n10 = i + 1;
        values[n10] = values[n10] | Byte.toUnsignedLong(buf[off++]) << 38;
        int n11 = i + 1;
        values[n11] = values[n11] | Byte.toUnsignedLong(buf[off++]) << 30;
        int n12 = i + 1;
        values[n12] = values[n12] | Byte.toUnsignedLong(buf[off++]) << 22;
        int n13 = i + 1;
        values[n13] = values[n13] | Byte.toUnsignedLong(buf[off++]) << 14;
        int n14 = i + 1;
        values[n14] = values[n14] | Byte.toUnsignedLong(buf[off++]) << 6;
        int n15 = i + 1;
        values[n15] = values[n15] | Byte.toUnsignedLong(buf[off]) >>> 2;
        values[i + 2] = (Byte.toUnsignedLong(buf[off++]) & 3L) << 61;
        int n16 = i + 2;
        values[n16] = values[n16] | Byte.toUnsignedLong(buf[off++]) << 53;
        int n17 = i + 2;
        values[n17] = values[n17] | Byte.toUnsignedLong(buf[off++]) << 45;
        int n18 = i + 2;
        values[n18] = values[n18] | Byte.toUnsignedLong(buf[off++]) << 37;
        int n19 = i + 2;
        values[n19] = values[n19] | Byte.toUnsignedLong(buf[off++]) << 29;
        int n20 = i + 2;
        values[n20] = values[n20] | Byte.toUnsignedLong(buf[off++]) << 21;
        int n21 = i + 2;
        values[n21] = values[n21] | Byte.toUnsignedLong(buf[off++]) << 13;
        int n22 = i + 2;
        values[n22] = values[n22] | Byte.toUnsignedLong(buf[off++]) << 5;
        int n23 = i + 2;
        values[n23] = values[n23] | Byte.toUnsignedLong(buf[off]) >>> 3;
        values[i + 3] = (Byte.toUnsignedLong(buf[off++]) & 7L) << 60;
        int n24 = i + 3;
        values[n24] = values[n24] | Byte.toUnsignedLong(buf[off++]) << 52;
        int n25 = i + 3;
        values[n25] = values[n25] | Byte.toUnsignedLong(buf[off++]) << 44;
        int n26 = i + 3;
        values[n26] = values[n26] | Byte.toUnsignedLong(buf[off++]) << 36;
        int n27 = i + 3;
        values[n27] = values[n27] | Byte.toUnsignedLong(buf[off++]) << 28;
        int n28 = i + 3;
        values[n28] = values[n28] | Byte.toUnsignedLong(buf[off++]) << 20;
        int n29 = i + 3;
        values[n29] = values[n29] | Byte.toUnsignedLong(buf[off++]) << 12;
        int n30 = i + 3;
        values[n30] = values[n30] | Byte.toUnsignedLong(buf[off++]) << 4;
        int n31 = i + 3;
        values[n31] = values[n31] | Byte.toUnsignedLong(buf[off]) >>> 4;
        values[i + 4] = (Byte.toUnsignedLong(buf[off++]) & 0xFL) << 59;
        int n32 = i + 4;
        values[n32] = values[n32] | Byte.toUnsignedLong(buf[off++]) << 51;
        int n33 = i + 4;
        values[n33] = values[n33] | Byte.toUnsignedLong(buf[off++]) << 43;
        int n34 = i + 4;
        values[n34] = values[n34] | Byte.toUnsignedLong(buf[off++]) << 35;
        int n35 = i + 4;
        values[n35] = values[n35] | Byte.toUnsignedLong(buf[off++]) << 27;
        int n36 = i + 4;
        values[n36] = values[n36] | Byte.toUnsignedLong(buf[off++]) << 19;
        int n37 = i + 4;
        values[n37] = values[n37] | Byte.toUnsignedLong(buf[off++]) << 11;
        int n38 = i + 4;
        values[n38] = values[n38] | Byte.toUnsignedLong(buf[off++]) << 3;
        int n39 = i + 4;
        values[n39] = values[n39] | Byte.toUnsignedLong(buf[off]) >>> 5;
        values[i + 5] = (Byte.toUnsignedLong(buf[off++]) & 0x1FL) << 58;
        int n40 = i + 5;
        values[n40] = values[n40] | Byte.toUnsignedLong(buf[off++]) << 50;
        int n41 = i + 5;
        values[n41] = values[n41] | Byte.toUnsignedLong(buf[off++]) << 42;
        int n42 = i + 5;
        values[n42] = values[n42] | Byte.toUnsignedLong(buf[off++]) << 34;
        int n43 = i + 5;
        values[n43] = values[n43] | Byte.toUnsignedLong(buf[off++]) << 26;
        int n44 = i + 5;
        values[n44] = values[n44] | Byte.toUnsignedLong(buf[off++]) << 18;
        int n45 = i + 5;
        values[n45] = values[n45] | Byte.toUnsignedLong(buf[off++]) << 10;
        int n46 = i + 5;
        values[n46] = values[n46] | Byte.toUnsignedLong(buf[off++]) << 2;
        int n47 = i + 5;
        values[n47] = values[n47] | Byte.toUnsignedLong(buf[off]) >>> 6;
        values[i + 6] = (Byte.toUnsignedLong(buf[off++]) & 0x3FL) << 57;
        int n48 = i + 6;
        values[n48] = values[n48] | Byte.toUnsignedLong(buf[off++]) << 49;
        int n49 = i + 6;
        values[n49] = values[n49] | Byte.toUnsignedLong(buf[off++]) << 41;
        int n50 = i + 6;
        values[n50] = values[n50] | Byte.toUnsignedLong(buf[off++]) << 33;
        int n51 = i + 6;
        values[n51] = values[n51] | Byte.toUnsignedLong(buf[off++]) << 25;
        int n52 = i + 6;
        values[n52] = values[n52] | Byte.toUnsignedLong(buf[off++]) << 17;
        int n53 = i + 6;
        values[n53] = values[n53] | Byte.toUnsignedLong(buf[off++]) << 9;
        int n54 = i + 6;
        values[n54] = values[n54] | Byte.toUnsignedLong(buf[off++]) << 1;
        int n55 = i + 6;
        values[n55] = values[n55] | Byte.toUnsignedLong(buf[off]) >>> 7;
        values[i + 7] = (Byte.toUnsignedLong(buf[off++]) & 0x7FL) << 56;
        int n56 = i + 7;
        values[n56] = values[n56] | Byte.toUnsignedLong(buf[off++]) << 48;
        int n57 = i + 7;
        values[n57] = values[n57] | Byte.toUnsignedLong(buf[off++]) << 40;
        int n58 = i + 7;
        values[n58] = values[n58] | Byte.toUnsignedLong(buf[off++]) << 32;
        int n59 = i + 7;
        values[n59] = values[n59] | Byte.toUnsignedLong(buf[off++]) << 24;
        int n60 = i + 7;
        values[n60] = values[n60] | Byte.toUnsignedLong(buf[off++]) << 16;
        int n61 = i + 7;
        values[n61] = values[n61] | Byte.toUnsignedLong(buf[off++]) << 8;
        int n62 = i + 7;
        values[n62] = values[n62] | Byte.toUnsignedLong(buf[off]);
    }
}

