/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class BlocksRemoved
extends BlockTransferMessage {
    public final int numRemovedBlocks;

    public BlocksRemoved(int numRemovedBlocks) {
        this.numRemovedBlocks = numRemovedBlocks;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.BLOCKS_REMOVED;
    }

    public int hashCode() {
        return Objects.hashCode(this.numRemovedBlocks);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("numRemovedBlocks", this.numRemovedBlocks).toString();
    }

    public boolean equals(Object other) {
        if (other instanceof BlocksRemoved) {
            BlocksRemoved o = (BlocksRemoved)other;
            return this.numRemovedBlocks == o.numRemovedBlocks;
        }
        return false;
    }

    public int encodedLength() {
        return 4;
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.numRemovedBlocks);
    }

    public static BlocksRemoved decode(ByteBuf buf) {
        int numRemovedBlocks = buf.readInt();
        return new BlocksRemoved(numRemovedBlocks);
    }
}

