/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$ClientType$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSchedulerImpl$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStoreImpl;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStoreImpl$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.StatefulSetPodsAllocator;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005e4Q\u0001C\u0005\u0001\u001fUAQA\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1BQ!\u0010\u0001\u0005\nyBQ!\u0012\u0001\u0005B\u0019CQ\u0001\u0015\u0001\u0005BECa\u0001\u0017\u0001\u0005\u0002%I\u0006\"B9\u0001\t\u0003\u0012(\u0001G&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;fe6\u000bg.Y4fe*\u0011!bC\u0001\u0004Wb\u001a(B\u0001\u0007\u000e\u0003\u001d\u0019G.^:uKJT!AD\b\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\t\u0012\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00112#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0005\u0019qN]4\u0014\t\u00011B\u0004\t\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uqR\"A\u0007\n\u0005}i!AF#yi\u0016\u0014h.\u00197DYV\u001cH/\u001a:NC:\fw-\u001a:\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rz\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0015\u0012#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0011\u0006\u0005\u0002+\u00015\t\u0011\"A\u0005dC:\u001c%/Z1uKR\u0011Q\u0006\r\t\u0003/9J!a\f\r\u0003\u000f\t{w\u000e\\3b]\")\u0011G\u0001a\u0001e\u0005IQ.Y:uKJ,&\u000b\u0014\t\u0003gir!\u0001\u000e\u001d\u0011\u0005UBR\"\u0001\u001c\u000b\u0005]:\u0013A\u0002\u001fs_>$h(\u0003\u0002:1\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tI\u0004$A\u0004jg2{7-\u00197\u0015\u00055z\u0004\"\u0002!\u0004\u0001\u0004\t\u0015\u0001B2p]\u001a\u0004\"AQ\"\u000e\u0003=I!\u0001R\b\u0003\u0013M\u0003\u0018M]6D_:4\u0017aE2sK\u0006$X\rV1tWN\u001b\u0007.\u001a3vY\u0016\u0014HcA$K\u001fB\u0011Q\u0004S\u0005\u0003\u00136\u0011Q\u0002V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\b\"B&\u0005\u0001\u0004a\u0015AA:d!\t\u0011U*\u0003\u0002O\u001f\ta1\u000b]1sW\u000e{g\u000e^3yi\")\u0011\u0007\u0002a\u0001e\u000512M]3bi\u0016\u001c6\r[3ek2,'OQ1dW\u0016tG\r\u0006\u0003S+Z;\u0006CA\u000fT\u0013\t!VB\u0001\tTG\",G-\u001e7fe\n\u000b7m[3oI\")1*\u0002a\u0001\u0019\")\u0011'\u0002a\u0001e!)a\"\u0002a\u0001\u000f\u0006IR.Y6f\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s)\u0011QVL\u00187\u0011\u0005)Z\u0016B\u0001/\n\u0005U\t%m\u001d;sC\u000e$\bk\u001c3t\u00032dwnY1u_JDQa\u0013\u0004A\u00021CQa\u0018\u0004A\u0002\u0001\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005\u0005TW\"\u00012\u000b\u0005\r$\u0017AB2mS\u0016tGO\u0003\u0002fM\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005\u001dD\u0017a\u00024bEJL7\r\u000f\u0006\u0002S\u0006\u0011\u0011n\\\u0005\u0003W\n\u0014\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\t\u000b54\u0001\u0019\u00018\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011!f\\\u0005\u0003a&\u0011!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\f!\"\u001b8ji&\fG.\u001b>f)\r\u0019ho\u001e\t\u0003/QL!!\u001e\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d\u001d\u0001\ra\u0012\u0005\u0006q\u001e\u0001\rAU\u0001\bE\u0006\u001c7.\u001a8e\u0001")
public class KubernetesClusterManager
implements ExternalClusterManager,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("k8s");
    }

    private boolean isLocal(SparkConf conf) {
        return ((String)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_MASTER_URL())).startsWith("local");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        Option option;
        int n;
        Option option2;
        String string = (String)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_MASTER_URL());
        if ("local".equals(string) ? true : string != null && !(option2 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            n = 1;
        } else if (string != null && !(option = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String maxFailures = (String)((LinearSeqOps)option.get()).apply(1);
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(maxFailures));
        } else {
            n = BoxesRunTime.unboxToInt((Object)sc.conf().get(package$.MODULE$.TASK_MAX_FAILURES()));
        }
        int maxTaskFailures = n;
        return new TaskSchedulerImpl(sc, maxTaskFailures, this.isLocal(sc.conf()), TaskSchedulerImpl$.MODULE$.$lessinit$greater$default$4());
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        ScheduledExecutorService subscribersExecutor;
        Tuple3 tuple3;
        if (this.isLocal(sc.conf())) {
            Option option;
            int n;
            Option option2;
            String string = (String)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_MASTER_URL());
            if (string != null && !(option2 = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
                String threads;
                String string2 = threads = (String)((LinearSeqOps)option2.get()).apply(0);
                String string3 = "*";
                n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? KubernetesClusterManager.localCpuCount$1() : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads));
            } else if (string != null && !(option = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                String threads;
                String string4 = threads = (String)((LinearSeqOps)option.get()).apply(0);
                String string5 = "*";
                n = !(string4 != null ? !string4.equals(string5) : string5 != null) ? KubernetesClusterManager.localCpuCount$1() : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(threads));
            } else {
                n = 1;
            }
            int threadCount = n;
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Running Spark with ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MASTER_URL$.MODULE$, sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_MASTER_URL()))}))));
            TaskSchedulerImpl schedulerImpl = (TaskSchedulerImpl)scheduler;
            Option conf = sc.conf().getOption("spark.app.id").map((Function1 & Serializable)x$1 -> sc.conf().set("spark.test.appId", x$1));
            LocalSchedulerBackend backend = new LocalSchedulerBackend((SparkConf)conf.getOrElse((Function0 & Serializable)() -> sc.conf()), schedulerImpl, threadCount);
            schedulerImpl.initialize((SchedulerBackend)backend);
            return backend;
        }
        boolean wasSparkSubmittedInClusterMode = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK()));
        if (wasSparkSubmittedInClusterMode) {
            Predef$.MODULE$.require(((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).isDefined(), (Function0 & Serializable)() -> "If the application is deployed using spark-submit in cluster mode, the driver pod name must be provided.");
            Option serviceAccountCaCrt = new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt")).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.exists()));
            v3 = new Tuple3((Object)Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_MASTER_URL()), (Object)serviceAccountCaCrt);
        } else {
            v3 = tuple3 = new Tuple3((Object)Config$.MODULE$.KUBERNETES_AUTH_CLIENT_MODE_PREFIX(), (Object)KubernetesUtils$.MODULE$.parseMasterUrl(masterURL), (Object)None$.MODULE$);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String authConfPrefix = (String)tuple3._1();
        String apiServerUri = (String)tuple3._2();
        Option defaultServiceAccountCaCrt = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)authConfPrefix, (Object)apiServerUri, (Object)defaultServiceAccountCaCrt);
        String authConfPrefix2 = (String)tuple32._1();
        String apiServerUri2 = (String)tuple32._2();
        Option defaultServiceAccountCaCrt2 = (Option)tuple32._3();
        Object object = !sc.conf().contains(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX()) ? sc.conf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)KubernetesConf$.MODULE$.getResourceNamePrefix(sc.conf().get("spark.app.name"))) : BoxedUnit.UNIT;
        KubernetesClient kubernetesClient = SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(apiServerUri2, (Option<String>)new Some(sc.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE())), authConfPrefix2, (Enumeration.Value)SparkKubernetesClientFactory$ClientType$.MODULE$.Driver(), sc.conf(), (Option<File>)defaultServiceAccountCaCrt2);
        Object object2 = ((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).isDefined() ? KubernetesUtils$.MODULE$.loadPodFromTemplate(kubernetesClient, (String)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).get(), (Option<String>)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())), sc.conf()) : BoxedUnit.UNIT;
        ScheduledExecutorService schedulerExecutorService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-executor-maintenance");
        ExecutorPodsSnapshot$.MODULE$.setShouldCheckAllContainers(BoxesRunTime.unboxToBoolean((Object)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_CHECK_ALL_CONTAINERS())));
        String sparkContainerName = (String)((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_CONTAINER_NAME())).getOrElse((Function0 & Serializable)() -> Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME());
        ExecutorPodsSnapshot$.MODULE$.setSparkContainerName(sparkContainerName);
        ScheduledExecutorService x$12 = subscribersExecutor = ThreadUtils$.MODULE$.newDaemonThreadPoolScheduledExecutor("kubernetes-executor-snapshots-subscribers", 2);
        SparkConf x$22 = sc.conf();
        Clock x$3 = ExecutorPodsSnapshotsStoreImpl$.MODULE$.$lessinit$greater$default$2();
        ExecutorPodsSnapshotsStoreImpl snapshotsStore = new ExecutorPodsSnapshotsStoreImpl(x$12, x$3, x$22);
        ExecutorPodsLifecycleManager executorPodsLifecycleEventHandler = new ExecutorPodsLifecycleManager(sc.conf(), kubernetesClient, snapshotsStore, ExecutorPodsLifecycleManager$.MODULE$.$lessinit$greater$default$4());
        AbstractPodsAllocator executorPodsAllocator = this.makeExecutorPodsAllocator(sc, kubernetesClient, snapshotsStore);
        ExecutorPodsWatchSnapshotSource podsWatchEventSource = new ExecutorPodsWatchSnapshotSource(snapshotsStore, kubernetesClient, sc.conf());
        ScheduledExecutorService eventsPollingExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-executor-pod-polling-sync");
        ExecutorPodsPollingSnapshotSource podsPollingEventSource = new ExecutorPodsPollingSnapshotSource(sc.conf(), kubernetesClient, snapshotsStore, eventsPollingExecutor);
        return new KubernetesClusterSchedulerBackend((TaskSchedulerImpl)scheduler, sc, kubernetesClient, schedulerExecutorService, snapshotsStore, executorPodsAllocator, executorPodsLifecycleEventHandler, podsWatchEventSource, podsPollingEventSource);
    }

    public AbstractPodsAllocator makeExecutorPodsAllocator(SparkContext sc, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore) {
        String string;
        block4: {
            String string2 = (String)sc.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR());
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1331586071: {
                    if (!"direct".equals(string2)) break;
                    string = ExecutorPodsAllocator.class.getName();
                    break block4;
                }
                case 1736521110: {
                    if (!"statefulset".equals(string2)) break;
                    string = StatefulSetPodsAllocator.class.getName();
                    break block4;
                }
            }
            string = string2;
        }
        String executorPodsAllocatorName = string;
        Class cls = Utils$.MODULE$.classForName(executorPodsAllocatorName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Constructor cstr = cls.getConstructor(SparkConf.class, SecurityManager.class, KubernetesExecutorBuilder.class, KubernetesClient.class, ExecutorPodsSnapshotsStore.class, Clock.class);
        return (AbstractPodsAllocator)cstr.newInstance(sc.conf(), sc.env().securityManager(), new KubernetesExecutorBuilder(), kubernetesClient, snapshotsStore, new SystemClock());
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }

    private static final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    public KubernetesClusterManager() {
        Logging.$init$((Logging)this);
    }
}

