/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.connector.expressions.BucketTransform;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.NamedTransform$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IndeterminateStringType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringHelper$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SchemaUtils;
import org.apache.spark.sql.util.SchemaUtils$ColumnPath$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.SparkSchemaUtils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$ = new SchemaUtils$();

    public Seq<SchemaUtils.ColumnPath> findColumnPaths(DataType dt, Function1<DataType, Object> f) {
        DataType dataType = dt;
        if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)dt))) {
            return new .colon.colon((Object)new SchemaUtils.ColumnPath(SchemaUtils$ColumnPath$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            return (Seq)this.findColumnPaths(elementType, f).map((Function1 & Serializable)p -> p.prepended("element"));
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return (Seq)((IterableOps)this.findColumnPaths(keyType, f).map((Function1 & Serializable)p -> p.prepended("key"))).$plus$plus((IterableOnce)this.findColumnPaths(valueType, f).map((Function1 & Serializable)p -> p.prepended("value")));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x0$1 -> {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    return (Seq)MODULE$.findColumnPaths(dataType, f).map((Function1 & Serializable)p -> p.prepended(name));
                }
                throw new MatchError((Object)structField);
            }, ClassTag$.MODULE$.apply(SchemaUtils.ColumnPath.class))));
        }
        return Nil$.MODULE$;
    }

    public void checkSchemaColumnNameDuplication(DataType schema, boolean caseSensitiveAnalysis) {
        block2: {
            DataType dataType;
            while (true) {
                if ((dataType = schema) instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType;
                    schema = elementType = arrayType.elementType();
                    continue;
                }
                if (!(dataType instanceof MapType)) break;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                this.checkSchemaColumnNameDuplication(keyType, caseSensitiveAnalysis);
                schema = valueType;
            }
            if (!(dataType instanceof StructType)) break block2;
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            this.checkColumnNameDuplication((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$1 -> x$1.name(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq(), caseSensitiveAnalysis);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication(field.dataType(), caseSensitiveAnalysis);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void checkSchemaColumnNameDuplication(StructType schema, Function2<String, String, Object> resolver) {
        this.checkSchemaColumnNameDuplication((DataType)schema, this.isCaseSensitiveAnalysis(resolver));
    }

    public boolean checkSchemaColumnNameDuplication$default$2() {
        return false;
    }

    private boolean isCaseSensitiveAnalysis(Function2<String, String, Object> resolver) {
        Function2<String, String, Object> function2 = resolver;
        Function2<String, String, Object> function22 = package$.MODULE$.caseSensitiveResolution();
        if (!(function2 != null ? !function2.equals(function22) : function22 != null)) {
            return true;
        }
        Function2<String, String, Object> function23 = resolver;
        Function2<String, String, Object> function24 = package$.MODULE$.caseInsensitiveResolution();
        if (!(function23 != null ? !function23.equals(function24) : function24 != null)) {
            return false;
        }
        throw QueryExecutionErrors$.MODULE$.unreachableError(": A resolver to check if two identifiers are equal must be `caseSensitiveResolution` or `caseInsensitiveResolution` in o.a.s.sql.catalyst.");
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, Function2<String, String, Object> resolver) {
        this.checkColumnNameDuplication(columnNames, this.isCaseSensitiveAnalysis(resolver));
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, boolean caseSensitiveAnalysis) {
        Seq names;
        Seq seq = names = caseSensitiveAnalysis ? columnNames : (Seq)columnNames.map((Function1 & Serializable)x$2 -> x$2.toLowerCase());
        if (((SeqOps)names.distinct()).length() != names.length()) {
            String columnName = (String)((IterableOnceOps)names.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).toSeq().sortBy((Function1 & Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$)).collectFirst((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            return (B1)x;
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    return tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                }
            }).get();
            throw QueryCompilationErrors$.MODULE$.columnAlreadyExistsError(columnName);
        }
    }

    public Seq<String> explodeNestedFieldNames(StructType schema) {
        return (Seq)this.explode$1(schema).map((Function1 & Serializable)x$6 -> new UnresolvedAttribute((Seq<String>)x$6).name());
    }

    public void checkTransformDuplication(Seq<Transform> transforms, String checkType, boolean isCaseSensitive) {
        Seq normalizedTransforms;
        Seq extractedTransforms = (Seq)transforms.map((Function1 & Serializable)x0$1 -> {
            Some<Tuple2<String, Seq<Expression>>> some;
            Transform transform2 = x0$1;
            if (transform2 instanceof BucketTransform) {
                BucketTransform bucketTransform = (BucketTransform)transform2;
                Seq colNames = (Seq)bucketTransform.columns().map((Function1 & Serializable)c -> new UnresolvedAttribute((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)c.fieldNames()).toImmutableArraySeq()).name());
                MODULE$.checkColumnNameDuplication((Seq<String>)colNames, isCaseSensitive);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bucketTransform.name()), (Object)colNames);
            }
            if (transform2 != null && !(some = NamedTransform$.MODULE$.unapply(transform2)).isEmpty()) {
                String transformName = (String)((Tuple2)some.get())._1();
                Seq refs = (Seq)((Tuple2)some.get())._2();
                Seq fieldNameParts = (Seq)refs.collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof FieldReference) {
                            FieldReference fieldReference = (FieldReference)A1;
                            Seq<String> parts = fieldReference.parts();
                            return (B1)new UnresolvedAttribute(parts).name();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Expression x1) {
                        Expression expression = x1;
                        return expression instanceof FieldReference;
                    }
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transformName), (Object)fieldNameParts);
            }
            throw new MatchError((Object)transform2);
        });
        Seq seq = normalizedTransforms = isCaseSensitive ? extractedTransforms : (Seq)extractedTransforms.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t._1()), ((IterableOps)t._2()).map((Function1 & Serializable)x$7 -> x$7.toLowerCase(Locale.ROOT))));
        if (((SeqOps)normalizedTransforms.distinct()).length() != normalizedTransforms.length()) {
            Iterable duplicateColumns = (Iterable)normalizedTransforms.groupBy((Function1 & Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x)).collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 != null) {
                        Tuple2 x = (Tuple2)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            return (B1)String.valueOf(((IterableOnceOps)x._2()).mkString("."));
                        }
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>> x2) {
                    Seq ys;
                    Tuple2<Tuple2<String, Seq<String>>, Seq<Tuple2<String, Seq<String>>>> tuple2 = x2;
                    return tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                }
            });
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3058", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkType"), (Object)checkType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicateColumns"), (Object)duplicateColumns.mkString(", "))})));
        }
    }

    public Seq<Object> findColumnPosition(Seq<String> column, StructType schema, Function2<String, String, Object> resolver) {
        Seq seq;
        try {
            seq = SchemaUtils$.find$1(column, schema, (Seq)Nil$.MODULE$, resolver);
        }
        catch (IndexOutOfBoundsException i) {
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3060", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"i"), (Object)i.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.treeString())})));
        }
        catch (AnalysisException e) {
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3061", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)e.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.treeString())})));
        }
        return seq;
    }

    public Seq<String> getColumnName(Seq<Object> position, StructType schema) {
        StructField topLevel = schema.apply(BoxesRunTime.unboxToInt((Object)position.head()));
        Tuple2 field = (Tuple2)((IterableOnceOps)position.tail()).foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)topLevel.name(), (List)Nil$.MODULE$)), (Object)topLevel), (Function2 & Serializable)(x0$1, x1$1) -> SchemaUtils$.$anonfun$getColumnName$1(schema, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)));
        return (Seq)field._1();
    }

    public Seq<NamedExpression> restoreOriginalOutputNames(Seq<NamedExpression> projectList, Seq<String> originalNames) {
        return (Seq)((IterableOps)projectList.zip(originalNames)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                NamedExpression attr = (NamedExpression)tuple2._1();
                String name = (String)tuple2._2();
                if (attr instanceof Attribute) {
                    Attribute attribute = (Attribute)attr;
                    return attribute.withName(name);
                }
            }
            if (tuple2 != null) {
                NamedExpression alias = (NamedExpression)tuple2._1();
                String name = (String)tuple2._2();
                if (alias instanceof Alias) {
                    Alias alias2 = (Alias)alias;
                    return alias2.withName(name);
                }
            }
            if (tuple2 != null) {
                NamedExpression other = (NamedExpression)tuple2._1();
                return other;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String escapeMetaCharacters(String str) {
        return SparkSchemaUtils$.MODULE$.escapeMetaCharacters(str);
    }

    public boolean hasNonUTF8BinaryCollation(DataType dt) {
        return dt.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$hasNonUTF8BinaryCollation$1(x0$1)));
    }

    public boolean hasIndeterminateCollation(DataType dt) {
        return dt.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$hasIndeterminateCollation$1(x0$1)));
    }

    public void checkIndeterminateCollationInSchema(StructType schema) {
        Seq<SchemaUtils.ColumnPath> indeterminatePaths = this.findColumnPaths((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$checkIndeterminateCollationInSchema$1(x0$1)));
        if (indeterminatePaths.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.indeterminateCollationInSchemaError(indeterminatePaths);
        }
    }

    public void checkNoCollationsInMapKeys(DataType schema) {
        while (true) {
            DataType dataType;
            if ((dataType = schema) instanceof MapType) {
                MapType mapType = (MapType)dataType;
                if (this.hasNonUTF8BinaryCollation(mapType.keyType())) {
                    throw QueryCompilationErrors$.MODULE$.collatedStringsInMapKeysNotSupportedError();
                }
                schema = mapType.valueType();
                continue;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)field -> {
                    SchemaUtils$.MODULE$.checkNoCollationsInMapKeys(field.dataType());
                    return BoxedUnit.UNIT;
                });
                break;
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            schema = arrayType.elementType();
        }
    }

    public DataType replaceCollatedStringWithString(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            return new ArrayType(this.replaceCollatedStringWithString(et), nullable);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean nullable = mapType.valueContainsNull();
            return new MapType(this.replaceCollatedStringWithString(kt), this.replaceCollatedStringWithString(vt), nullable);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                DataType x$1 = MODULE$.replaceCollatedStringWithString(field.dataType());
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, ClassTag$.MODULE$.apply(StructField.class)));
        }
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return StringHelper$.MODULE$.removeCollation(stringType);
        }
        return dt;
    }

    private final Seq recurseIntoComplexTypes$1(DataType complexType) {
        DataType dataType;
        while (true) {
            if ((dataType = complexType) instanceof StructType) {
                StructType structType = (StructType)dataType;
                return this.explode$1(structType);
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            complexType = arrayType.elementType();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return (Seq)((IterableOps)this.recurseIntoComplexTypes$1(mapType.keyType()).map((Function1 & Serializable)x$4 -> (Seq)new .colon.colon((Object)"key", (List)Nil$.MODULE$).$plus$plus((IterableOnce)x$4))).$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1(mapType.valueType()).map((Function1 & Serializable)x$5 -> (Seq)new .colon.colon((Object)"value", (List)Nil$.MODULE$).$plus$plus((IterableOnce)x$5)));
        }
        return Nil$.MODULE$;
    }

    private final Seq explode$1(StructType schema) {
        return (Seq)schema.flatMap((Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType s = structField.dataType();
                if (s instanceof StructType) {
                    StructType structType = (StructType)s;
                    return (IterableOnce)new .colon.colon((Object)new .colon.colon((Object)name, (List)Nil$.MODULE$), (List)Nil$.MODULE$).$plus$plus((IterableOnce)this.explode$1(structType).map((Function1 & Serializable)nested -> (Seq)new .colon.colon((Object)name, (List)Nil$.MODULE$).$plus$plus((IterableOnce)nested)));
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType a = structField.dataType();
                if (a instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)a;
                    return (IterableOnce)new .colon.colon((Object)new .colon.colon((Object)name, (List)Nil$.MODULE$), (List)Nil$.MODULE$).$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1((DataType)arrayType).map((Function1 & Serializable)nested -> (Seq)new .colon.colon((Object)name, (List)Nil$.MODULE$).$plus$plus((IterableOnce)nested)));
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType m = structField.dataType();
                if (m instanceof MapType) {
                    MapType mapType = (MapType)m;
                    return (IterableOnce)new .colon.colon((Object)new .colon.colon((Object)name, (List)Nil$.MODULE$), (List)Nil$.MODULE$).$plus$plus((IterableOnce)this.recurseIntoComplexTypes$1((DataType)mapType).map((Function1 & Serializable)nested -> (Seq)new .colon.colon((Object)name, (List)Nil$.MODULE$).$plus$plus((IterableOnce)nested)));
                }
            }
            .colon.colon colon2 = new .colon.colon((Object)structField.name(), (List)Nil$.MODULE$);
            return Nil$.MODULE$.$colon$colon((Object)colon2);
        });
    }

    private static final /* synthetic */ String columnPath$lzycompute$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        String string;
        LazyRef lazyRef = columnPath$lzy$1;
        synchronized (lazyRef) {
            string = columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : (String)columnPath$lzy$1.initialize((Object)new UnresolvedAttribute((Seq<String>)((Seq)stack$1.$colon$plus((Object)thisCol$1))).name());
        }
        return string;
    }

    private static final String columnPath$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        if (columnPath$lzy$1.initialized()) {
            return (String)columnPath$lzy$1.value();
        }
        return SchemaUtils$.columnPath$lzycompute$1(columnPath$lzy$1, stack$1, thisCol$1);
    }

    public static final /* synthetic */ boolean $anonfun$findColumnPosition$1(Function2 resolver$1, String thisCol$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)thisCol$1));
    }

    private static final Seq find$1(Seq column, StructType schema, Seq stack, Function2 resolver$1) {
        ArrayType arrayType;
        DataType s;
        Nil$ nil$;
        LazyRef columnPath$lzy = new LazyRef();
        if (column.isEmpty()) {
            return Nil$.MODULE$;
        }
        String thisCol = (String)column.head();
        int pos = schema.indexWhere((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findColumnPosition$1(resolver$1, thisCol, f)));
        if (pos == -1) {
            throw new IndexOutOfBoundsException(SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol));
        }
        DataType dataType = schema.apply(pos).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            nil$ = SchemaUtils$.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol), resolver$1);
        } else if (dataType instanceof ArrayType && (s = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType) {
            StructType structType = (StructType)s;
            nil$ = SchemaUtils$.find$1((Seq)column.tail(), structType, (Seq)stack.$colon$plus((Object)thisCol), resolver$1);
        } else {
            if (column.length() > 1) {
                throw new AnalysisException("_LEGACY_ERROR_TEMP_3062", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnPath"), (Object)SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"o"), (Object)dataType.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attr"), (Object)new UnresolvedAttribute((Seq<String>)column).name())})));
            }
            nil$ = Nil$.MODULE$;
        }
        Nil$ children2 = nil$;
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{pos})).$plus$plus((IterableOnce)children2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getColumnName$1(StructType schema$1, Tuple2 x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 != null) {
            ArrayType arrayType;
            DataType s;
            Tuple2 nameAndField = (Tuple2)tuple2._1();
            int pos = tuple2._2$mcI$sp();
            DataType dataType = ((StructField)nameAndField._2()).dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField nowField = structType.apply(pos);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((SeqOps)nameAndField._1()).$colon$plus((Object)nowField.name())), (Object)nowField);
            }
            if (dataType instanceof ArrayType && (s = (arrayType = (ArrayType)dataType).elementType()) instanceof StructType) {
                StructType structType = (StructType)s;
                StructField nowField = structType.apply(pos);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((SeqOps)nameAndField._1()).$colon$plus((Object)nowField.name())), (Object)nowField);
            }
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3059", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pos"), (Object)Integer.toString(pos)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema$1.treeString())})));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$hasNonUTF8BinaryCollation$1(DataType x0$1) {
        DataType dataType = x0$1;
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return !stringType.isUTF8BinaryCollation();
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$hasIndeterminateCollation$1(DataType x0$1) {
        DataType dataType = x0$1;
        return IndeterminateStringType$.MODULE$.equals(dataType);
    }

    public static final /* synthetic */ boolean $anonfun$checkIndeterminateCollationInSchema$1(DataType x0$1) {
        DataType dataType = x0$1;
        return IndeterminateStringType$.MODULE$.equals(dataType);
    }

    private SchemaUtils$() {
    }
}

