/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.CurrentUserContext$;
import org.apache.spark.sql.catalyst.analysis.AsOfTimestamp;
import org.apache.spark.sql.catalyst.analysis.AsOfVersion;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.catalog.ClusterBySpec;
import org.apache.spark.sql.catalyst.catalog.ClusterBySpec$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.catalyst.util.GeneratedColumn$;
import org.apache.spark.sql.catalyst.util.IdentityColumn$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.IdentityColumnSpec;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class CatalogV2Util$ {
    public static final CatalogV2Util$ MODULE$ = new CatalogV2Util$();
    private static final Seq<String> TABLE_RESERVED_PROPERTIES = new .colon.colon((Object)"comment", (List)new .colon.colon((Object)"collation", (List)new .colon.colon((Object)"location", (List)new .colon.colon((Object)"provider", (List)new .colon.colon((Object)"owner", (List)new .colon.colon((Object)"external", (List)new .colon.colon((Object)"is_managed_location", (List)Nil$.MODULE$)))))));
    private static final Seq<String> NAMESPACE_RESERVED_PROPERTIES = new .colon.colon((Object)"comment", (List)new .colon.colon((Object)"location", (List)new .colon.colon((Object)"owner", (List)Nil$.MODULE$)));

    public Seq<String> TABLE_RESERVED_PROPERTIES() {
        return TABLE_RESERVED_PROPERTIES;
    }

    public Seq<String> NAMESPACE_RESERVED_PROPERTIES() {
        return NAMESPACE_RESERVED_PROPERTIES;
    }

    public scala.collection.immutable.Map<String, String> applyNamespaceChanges(scala.collection.immutable.Map<String, String> properties, Seq<NamespaceChange> changes) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.applyNamespaceChanges(CollectionConverters$.MODULE$.MapHasAsJava(properties).asJava(), changes)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, String> applyNamespaceChanges(Map<String, String> properties, Seq<NamespaceChange> changes) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        changes.foreach((Function1 & Serializable)x0$1 -> {
            NamespaceChange namespaceChange = x0$1;
            if (namespaceChange instanceof NamespaceChange.SetProperty) {
                NamespaceChange.SetProperty setProperty = (NamespaceChange.SetProperty)namespaceChange;
                return newProperties.put(setProperty.property(), setProperty.value());
            }
            if (namespaceChange instanceof NamespaceChange.RemoveProperty) {
                NamespaceChange.RemoveProperty removeProperty = (NamespaceChange.RemoveProperty)namespaceChange;
                return newProperties.remove(removeProperty.property());
            }
            return BoxedUnit.UNIT;
        });
        return Collections.unmodifiableMap(newProperties);
    }

    public scala.collection.immutable.Map<String, String> applyPropertiesChanges(scala.collection.immutable.Map<String, String> properties, Seq<TableChange> changes) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.applyPropertiesChanges(CollectionConverters$.MODULE$.MapHasAsJava(properties).asJava(), changes)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, String> applyPropertiesChanges(Map<String, String> properties, Seq<TableChange> changes) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        changes.foreach((Function1 & Serializable)x0$1 -> {
            TableChange tableChange = x0$1;
            if (tableChange instanceof TableChange.SetProperty) {
                TableChange.SetProperty setProperty = (TableChange.SetProperty)tableChange;
                return newProperties.put(setProperty.property(), setProperty.value());
            }
            if (tableChange instanceof TableChange.RemoveProperty) {
                TableChange.RemoveProperty removeProperty = (TableChange.RemoveProperty)tableChange;
                return newProperties.remove(removeProperty.property());
            }
            return BoxedUnit.UNIT;
        });
        return Collections.unmodifiableMap(newProperties);
    }

    public scala.collection.immutable.Map<String, String> applyClusterByChanges(scala.collection.immutable.Map<String, String> properties, StructType schema, Seq<TableChange> changes) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this.applyClusterByChanges(CollectionConverters$.MODULE$.MapHasAsJava(properties).asJava(), schema, changes)).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, String> applyClusterByChanges(Map<String, String> properties, StructType schema, Seq<TableChange> changes) {
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        changes.foreach((Function1 & Serializable)x0$1 -> {
            TableChange tableChange = x0$1;
            if (tableChange instanceof TableChange.ClusterBy) {
                TableChange.ClusterBy clusterBy = (TableChange.ClusterBy)tableChange;
                Tuple2<String, String> clusterByProp = ClusterBySpec$.MODULE$.toProperty(schema, new ClusterBySpec((Seq<NamedReference>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])clusterBy.clusteringColumns()))), ResolveDefaultColumns$.MODULE$.conf().resolver());
                return newProperties.put((String)clusterByProp._1(), (String)clusterByProp._2());
            }
            return BoxedUnit.UNIT;
        });
        return Collections.unmodifiableMap(newProperties);
    }

    public Transform[] applyClusterByChanges(Transform[] partitioning, StructType schema, Seq<TableChange> changes) {
        ObjectRef newPartitioning = ObjectRef.create((Object)partitioning);
        Option clusterByOpt = changes.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TableChange.ClusterBy) {
                    TableChange.ClusterBy clusterBy = (TableChange.ClusterBy)A1;
                    return (B1)clusterBy;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(TableChange x1) {
                TableChange tableChange = x1;
                return tableChange instanceof TableChange.ClusterBy;
            }
        });
        clusterByOpt.foreach((Function1 & Serializable)clusterBy -> {
            newPartitioning.elem = (Transform[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitioning), (Function1 & Serializable)x0$1 -> {
                Transform transform2 = x0$1;
                if (transform2 instanceof ClusterByTransform) {
                    return ClusterBySpec$.MODULE$.extractClusterByTransform(schema$2, new ClusterBySpec((Seq<NamedReference>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])clusterBy.clusteringColumns()))), ResolveDefaultColumns$.MODULE$.conf().resolver());
                }
                return transform2;
            }, ClassTag$.MODULE$.apply(Transform.class));
            return BoxedUnit.UNIT;
        });
        return (Transform[])newPartitioning.elem;
    }

    public StructType applySchemaChanges(StructType schema2, Seq<TableChange> changes, Option<String> tableProvider, String statementType) {
        return (StructType)changes.foldLeft((Object)schema2, (Function2 & Serializable)(schema, change) -> {
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn) {
                Object object;
                TableChange.AddColumn addColumn = (TableChange.AddColumn)tableChange;
                String[] stringArray = addColumn.fieldNames();
                if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                    String name = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    StructField field2 = new StructField(name, addColumn.dataType(), addColumn.isNullable(), StructField$.MODULE$.apply$default$4());
                    StructField fieldWithDefault = MODULE$.encodeDefaultValue(addColumn.defaultValue(), field2);
                    StructField fieldWithComment = (StructField)Option$.MODULE$.apply((Object)addColumn.comment()).map((Function1 & Serializable)comment -> fieldWithDefault.withComment(comment)).getOrElse((Function0 & Serializable)() -> fieldWithDefault);
                    return MODULE$.addField((StructType)schema, fieldWithComment, addColumn.position(), tableProvider, statementType, true);
                }
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps((Object[])stringArray))).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)parent -> {
                    DataType dataType = parent.dataType();
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        StructField field = new StructField((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])stringArray)), addColumn.dataType(), addColumn.isNullable(), StructField$.MODULE$.apply$default$4());
                        StructField fieldWithDefault = MODULE$.encodeDefaultValue(addColumn.defaultValue(), field);
                        StructField fieldWithComment = (StructField)Option$.MODULE$.apply((Object)addColumn.comment()).map((Function1 & Serializable)comment -> fieldWithDefault.withComment(comment)).getOrElse((Function0 & Serializable)() -> fieldWithDefault);
                        StructType x$1 = MODULE$.addField(structType, fieldWithComment, addColumn.position(), tableProvider, statementType, true);
                        String x$2 = parent.copy$default$1();
                        boolean x$3 = parent.copy$default$3();
                        Metadata x$4 = parent.copy$default$4();
                        return new Some((Object)parent.copy(x$2, (DataType)x$1, x$3, x$4));
                    }
                    throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3229", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps((Object[])stringArray)))))})));
                }, MODULE$.replace$default$4());
            }
            if (tableChange instanceof TableChange.RenameColumn) {
                TableChange.RenameColumn renameColumn = (TableChange.RenameColumn)tableChange;
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)renameColumn.fieldNames()).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)field -> new Some((Object)new StructField(renameColumn.newName(), field.dataType(), field.nullable(), field.metadata())), MODULE$.replace$default$4());
            }
            if (tableChange instanceof TableChange.UpdateColumnType) {
                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)updateColumnType.fieldNames()).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)field -> {
                    DataType x$5 = updateColumnType.newDataType();
                    String x$6 = field.copy$default$1();
                    boolean x$7 = field.copy$default$3();
                    Metadata x$8 = field.copy$default$4();
                    return new Some((Object)field.copy(x$6, x$5, x$7, x$8));
                }, MODULE$.replace$default$4());
            }
            if (tableChange instanceof TableChange.UpdateColumnNullability) {
                TableChange.UpdateColumnNullability updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange;
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)updateColumnNullability.fieldNames()).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)field -> {
                    boolean x$9 = updateColumnNullability.nullable();
                    String x$10 = field.copy$default$1();
                    DataType x$11 = field.copy$default$2();
                    Metadata x$12 = field.copy$default$4();
                    return new Some((Object)field.copy(x$10, x$11, x$9, x$12));
                }, MODULE$.replace$default$4());
            }
            if (tableChange instanceof TableChange.UpdateColumnComment) {
                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)updateColumnComment.fieldNames()).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)field -> new Some((Object)field.withComment(updateColumnComment.newComment())), MODULE$.replace$default$4());
            }
            if (tableChange instanceof TableChange.UpdateColumnPosition) {
                Object object;
                TableChange.UpdateColumnPosition updateColumnPosition = (TableChange.UpdateColumnPosition)tableChange;
                String[] stringArray = updateColumnPosition.fieldNames();
                if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                    String name = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    return CatalogV2Util$.updateFieldPos$1(schema, name, updateColumnPosition, tableProvider, statementType);
                }
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps((Object[])stringArray))).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)parent -> {
                    DataType dataType = parent.dataType();
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        StructType x$13 = CatalogV2Util$.updateFieldPos$1(structType, (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])stringArray)), updateColumnPosition, tableProvider, statementType);
                        String x$14 = parent.copy$default$1();
                        boolean x$15 = parent.copy$default$3();
                        Metadata x$16 = parent.copy$default$4();
                        return new Some((Object)parent.copy(x$14, (DataType)x$13, x$15, x$16));
                    }
                    throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3229", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.init$extension(Predef$.MODULE$.refArrayOps((Object[])stringArray)))))})));
                }, MODULE$.replace$default$4());
            }
            if (tableChange instanceof TableChange.UpdateColumnDefaultValue) {
                TableChange.UpdateColumnDefaultValue updateColumnDefaultValue = (TableChange.UpdateColumnDefaultValue)tableChange;
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)updateColumnDefaultValue.fieldNames()).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)field -> {
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(updateColumnDefaultValue.newDefaultValue()))) {
                        return new Some((Object)field.withCurrentDefaultValue(updateColumnDefaultValue.newDefaultValue()));
                    }
                    return new Some((Object)field.clearCurrentDefaultValue());
                }, MODULE$.replace$default$4());
            }
            if (tableChange instanceof TableChange.DeleteColumn) {
                TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)tableChange;
                return MODULE$.replace((StructType)schema, (Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)deleteColumn.fieldNames()).toImmutableArraySeq(), (Function1<StructField, Option<StructField>>)(Function1 & Serializable)x$3 -> None$.MODULE$, Predef$.MODULE$.Boolean2boolean(deleteColumn.ifExists()));
            }
            return schema;
        });
    }

    private StructType addField(StructType schema, StructField field, TableChange.ColumnPosition position, Option<String> tableProvider, String statementType, boolean addNewColumnToExistingTable) {
        StructType structType;
        if (position == null) {
            structType = schema.add(field);
        } else if (position instanceof TableChange.First) {
            StructField structField = field;
            StructType structType2 = new StructType((StructField[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Object)structField, ClassTag$.MODULE$.apply(StructField.class)));
            structType = structType2;
        } else {
            int x$2;
            Function1 & Serializable x$1;
            String afterCol = ((TableChange.After)position).column();
            Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])schema.fields());
            int fieldIndex = ArrayOps$.MODULE$.indexWhere$extension(qual$1, (Function1)(x$1 = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CatalogV2Util$.$anonfun$addField$1(afterCol, x$4))), x$2 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$1));
            if (fieldIndex == -1) {
                throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3228", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"afterCol"), (Object)afterCol)})));
            }
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), fieldIndex + 1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField[] before = (StructField[])tuple2._1();
            StructField[] after = (StructField[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)before, (Object)after);
            StructField[] before2 = (StructField[])tuple22._1();
            StructField[] after2 = (StructField[])tuple22._2();
            StructField structField = field;
            StructType structType3 = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])before2), ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])after2), (Object)structField, ClassTag$.MODULE$.apply(StructField.class)), ClassTag$.MODULE$.apply(StructField.class)));
            structType = structType3;
        }
        StructType newSchema = structType;
        ResolveDefaultColumns$.MODULE$.validateTableProviderForDefaultValue(newSchema, tableProvider, statementType, addNewColumnToExistingTable);
        return ResolveDefaultColumns$.MODULE$.constantFoldCurrentDefaultsToExistDefaults(newSchema, statementType);
    }

    /*
     * Unable to fully structure code
     */
    private StructType replace(StructType struct, Seq<String> fieldNames, Function1<StructField, Option<StructField>> update, boolean ifExists) {
        block8: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        posOpt = struct.getFieldIndex((String)fieldNames.head());
                                        if (posOpt.isEmpty()) {
                                            if (ifExists) {
                                                return struct;
                                            }
                                            throw new SparkIllegalArgumentException("FIELD_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)ResolveDefaultColumns$.MODULE$.toSQLId((String)fieldNames.head())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])struct.fields()), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$replace$1(org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/String;)(), ClassTag$.MODULE$.apply(String.class))).mkString(", "))})));
                                        }
                                        pos = BoxesRunTime.unboxToInt((Object)posOpt.get());
                                        field = struct.fields()[pos];
                                        var10_8 = new Tuple2(fieldNames.tail(), (Object)field.dataType());
                                        if (var10_8 == null || (var11_9 = (Seq)var10_8._1()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var12_10 = package$.MODULE$.Seq().unapplySeq((SeqOps)var11_9)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var12_10)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var12_10), 0) != 0) break block7;
                                        v0 = (Option)update.apply((Object)field);
                                        break block8;
                                    }
                                    if (var10_8 == null) break block9;
                                    names = (Seq)var10_8._1();
                                    struct = (DataType)var10_8._2();
                                    if (!(struct instanceof StructType)) break block9;
                                    var15_13 = (StructType)struct;
                                    updatedType = this.replace(var15_13, (Seq<String>)names, update, ifExists);
                                    v0 = new Some((Object)new StructField(field.name(), (DataType)updatedType, field.nullable(), field.metadata()));
                                    break block8;
                                }
                                if (var10_8 == null) break block10;
                                var17_15 = (Seq)var10_8._1();
                                map = (DataType)var10_8._2();
                                if (var17_15 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var19_17 = package$.MODULE$.Seq().unapplySeq((SeqOps)var17_15)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var19_17)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var19_17), 1) != 0 || !"key".equals(var20_18 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var19_17), 0)) || !(map instanceof MapType)) break block10;
                                var21_19 = (MapType)map;
                                keyType = var21_19.keyType();
                                updated = (StructField)((Option)update.apply((Object)new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()))).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$replace$2(), ()Lscala/runtime/Nothing$;)());
                                x$1 = var21_19.copy(updated.dataType(), var21_19.copy$default$2(), var21_19.copy$default$3());
                                x$2 = field.copy$default$1();
                                x$3 = field.copy$default$3();
                                x$4 = field.copy$default$4();
                                v1 = new Some((Object)field.copy(x$2, (DataType)x$1, x$3, x$4));
                                v0 = v1;
                                break block8;
                            }
                            if (var10_8 == null) break block11;
                            var28_26 = (Seq)var10_8._1();
                            map = (DataType)var10_8._2();
                            if (var28_26 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var30_28 = package$.MODULE$.Seq().unapplySeq((SeqOps)var28_26)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var30_28)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var30_28), 1) < 0) break block11;
                            var31_29 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var30_28), 0);
                            names = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var30_28), 1);
                            if (!"key".equals(var31_29) || !(map instanceof MapType) || !((keyStruct = (var33_31 = (MapType)map).keyType()) instanceof StructType)) break block11;
                            var35_33 = (StructType)keyStruct;
                            x$5 = var33_31.copy((DataType)this.replace(var35_33, (Seq<String>)names, update, ifExists), var33_31.copy$default$2(), var33_31.copy$default$3());
                            x$6 = field.copy$default$1();
                            x$7 = field.copy$default$3();
                            x$8 = field.copy$default$4();
                            v2 = new Some((Object)field.copy(x$6, (DataType)x$5, x$7, x$8));
                            v0 = v2;
                            break block8;
                        }
                        if (var10_8 == null) break block12;
                        var40_38 = (Seq)var10_8._1();
                        map = (DataType)var10_8._2();
                        if (var40_38 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var42_40 = package$.MODULE$.Seq().unapplySeq((SeqOps)var40_38)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_40)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_40), 1) != 0 || !"value".equals(var43_41 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var42_40), 0)) || !(map instanceof MapType)) break block12;
                        var44_42 = (MapType)map;
                        mapValueType = var44_42.valueType();
                        isNullable = var44_42.valueContainsNull();
                        updated = (StructField)((Option)update.apply((Object)new StructField("value", mapValueType, isNullable, StructField$.MODULE$.apply$default$4()))).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$replace$3(), ()Lscala/runtime/Nothing$;)());
                        x$9 = updated.dataType();
                        x$10 = updated.nullable();
                        x$11 = var44_42.copy$default$1();
                        x$12 = var44_42.copy(x$11, x$9, x$10);
                        x$13 = field.copy$default$1();
                        x$14 = field.copy$default$3();
                        x$15 = field.copy$default$4();
                        v3 = new Some((Object)field.copy(x$13, (DataType)x$12, x$14, x$15));
                        v0 = v3;
                        break block8;
                    }
                    if (var10_8 == null) break block13;
                    var55_53 = (Seq)var10_8._1();
                    map = (DataType)var10_8._2();
                    if (var55_53 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var57_55 = package$.MODULE$.Seq().unapplySeq((SeqOps)var55_53)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var57_55)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var57_55), 1) < 0) break block13;
                    var58_56 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var57_55), 0);
                    names = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var57_55), 1);
                    if (!"value".equals(var58_56) || !(map instanceof MapType) || !((valueStruct = (var60_58 = (MapType)map).valueType()) instanceof StructType)) break block13;
                    var62_60 = (StructType)valueStruct;
                    x$16 = this.replace(var62_60, (Seq<String>)names, update, ifExists);
                    x$17 = var60_58.copy$default$1();
                    x$18 = var60_58.copy$default$3();
                    x$19 = var60_58.copy(x$17, (DataType)x$16, x$18);
                    x$20 = field.copy$default$1();
                    x$21 = field.copy$default$3();
                    x$22 = field.copy$default$4();
                    v4 = new Some((Object)field.copy(x$20, (DataType)x$19, x$21, x$22));
                    v0 = v4;
                    break block8;
                }
                if (var10_8 == null) break block14;
                var70_68 = (Seq)var10_8._1();
                array = (DataType)var10_8._2();
                if (var70_68 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var72_70 = package$.MODULE$.Seq().unapplySeq((SeqOps)var70_68)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var72_70)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var72_70), 1) != 0 || !"element".equals(var73_71 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var72_70), 0)) || !(array instanceof ArrayType)) break block14;
                var74_72 = (ArrayType)array;
                elementType = var74_72.elementType();
                isNullable = var74_72.containsNull();
                updated = (StructField)((Option)update.apply((Object)new StructField("element", elementType, isNullable, StructField$.MODULE$.apply$default$4()))).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$replace$4(), ()Lscala/runtime/Nothing$;)());
                x$23 = var74_72.copy(updated.dataType(), updated.nullable());
                x$24 = field.copy$default$1();
                x$25 = field.copy$default$3();
                x$26 = field.copy$default$4();
                v5 = new Some((Object)field.copy(x$24, (DataType)x$23, x$25, x$26));
                v0 = v5;
                break block8;
            }
            if (var10_8 == null) ** GOTO lbl-1000
            var82_80 = (Seq)var10_8._1();
            array = (DataType)var10_8._2();
            if (var82_80 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(var84_82 = package$.MODULE$.Seq().unapplySeq((SeqOps)var82_80)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var84_82)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var84_82), 1) < 0) ** GOTO lbl-1000
            var85_83 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var84_82), 0);
            names = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(var84_82), 1);
            if ("element".equals(var85_83) && array instanceof ArrayType && (elementStruct = (var87_85 = (ArrayType)array).elementType()) instanceof StructType) {
                var89_87 = (StructType)elementStruct;
                x$27 = var87_85.copy((DataType)this.replace(var89_87, (Seq<String>)names, update, ifExists), var87_85.copy$default$2());
                x$28 = field.copy$default$1();
                x$29 = field.copy$default$3();
                x$30 = field.copy$default$4();
                v6 = new Some((Object)field.copy(x$28, (DataType)x$27, x$29, x$30));
                v0 = v6;
            } else if (var10_8 != null) {
                names = (Seq)var10_8._1();
                dataType = (DataType)var10_8._2();
                if (!ifExists) {
                    throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3223", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), names.head()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.simpleString())})));
                }
                v0 = None$.MODULE$;
            } else {
                throw new MatchError((Object)var10_8);
            }
        }
        replacement = v0;
        newFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])struct.fields()))), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$replace$5(int scala.Option scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Option;)((int)pos, (Option)replacement), ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(newFields);
    }

    private boolean replace$default$4() {
        return false;
    }

    public Option<Table> loadTable(CatalogPlugin catalog, Identifier ident, Option<TimeTravelSpec> timeTravelSpec, Option<String> writePrivilegesString) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)this.getTable(catalog, ident, timeTravelSpec, writePrivilegesString));
        }
        catch (NoSuchTableException noSuchTableException) {
            none$ = None$.MODULE$;
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<TimeTravelSpec> loadTable$default$3() {
        return None$.MODULE$;
    }

    public Option<String> loadTable$default$4() {
        return None$.MODULE$;
    }

    public Table getTable(CatalogPlugin catalog, Identifier ident, Option<TimeTravelSpec> timeTravelSpec, Option<String> writePrivilegesString) {
        if (timeTravelSpec.nonEmpty()) {
            Predef$.MODULE$.assert(writePrivilegesString.isEmpty(), (Function0 & Serializable)() -> "Should not write to a table with time travel");
            TimeTravelSpec timeTravelSpec2 = (TimeTravelSpec)timeTravelSpec.get();
            if (timeTravelSpec2 instanceof AsOfVersion) {
                AsOfVersion asOfVersion = (AsOfVersion)timeTravelSpec2;
                return CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident, asOfVersion.version());
            }
            if (timeTravelSpec2 instanceof AsOfTimestamp) {
                AsOfTimestamp asOfTimestamp = (AsOfTimestamp)timeTravelSpec2;
                return CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident, asOfTimestamp.timestamp());
            }
            throw new MatchError((Object)timeTravelSpec2);
        }
        if (writePrivilegesString.isDefined()) {
            java.util.Set writePrivileges = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)writePrivilegesString.get()).split(",")), (Function1 & Serializable)x$6 -> x$6.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x -> TableWritePrivilege.valueOf(x), ClassTag$.MODULE$.apply(TableWritePrivilege.class))).toSet()).asJava();
            return CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident, writePrivileges);
        }
        return CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident);
    }

    public Option<TimeTravelSpec> getTable$default$3() {
        return None$.MODULE$;
    }

    public Option<String> getTable$default$4() {
        return None$.MODULE$;
    }

    public Option<UnboundFunction> loadFunction(CatalogPlugin catalog, Identifier ident) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asFunctionCatalog().loadFunction(ident));
        }
        catch (NoSuchFunctionException noSuchFunctionException) {
            none$ = None$.MODULE$;
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<NamedRelation> loadRelation(CatalogPlugin catalog, Identifier ident) {
        return this.loadTable(catalog, ident, this.loadTable$default$3(), this.loadTable$default$4()).map((Function1 & Serializable)x$7 -> DataSourceV2Relation$.MODULE$.create((Table)x$7, (Option<CatalogPlugin>)new Some((Object)catalog), (Option<Identifier>)new Some((Object)ident)));
    }

    public boolean isSessionCatalog(CatalogPlugin catalog) {
        return catalog.name().equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME());
    }

    public scala.collection.immutable.Map<String, String> convertTableProperties(TableSpec t) {
        scala.collection.immutable.Map<String, String> props = this.convertTableProperties(t.properties(), t.options(), t.serde(), t.location(), t.comment(), t.collation(), t.provider(), t.external());
        return this.withDefaultOwnership(props);
    }

    private scala.collection.immutable.Map<String, String> convertTableProperties(scala.collection.immutable.Map<String, String> properties, scala.collection.immutable.Map<String, String> options, Option<SerdeInfo> serdeInfo, Option<String> location, Option<String> comment, Option<String> collation, Option<String> provider, boolean external) {
        return (scala.collection.immutable.Map)((MapOps)((MapOps)((MapOps)((MapOps)((MapOps)((MapOps)((MapOps)properties.$plus$plus(options)).$plus$plus((IterableOnce)options.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)("option." + key)), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }))).$plus$plus(this.convertToProperties(serdeInfo))).$plus$plus((IterableOnce)(external ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"external"), (Object)"true")) : None$.MODULE$))).$plus$plus((IterableOnce)provider.map((Function1 & Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), x$8)))).$plus$plus((IterableOnce)comment.map((Function1 & Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), x$9)))).$plus$plus((IterableOnce)collation.map((Function1 & Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collation"), x$10)))).$plus$plus((IterableOnce)location.map((Function1 & Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), x$11)));
    }

    private boolean convertTableProperties$default$8() {
        return false;
    }

    private scala.collection.immutable.Map<String, String> convertToProperties(Option<SerdeInfo> serdeInfo) {
        Option<SerdeInfo> option = serdeInfo;
        if (option instanceof Some) {
            Some some = (Some)option;
            SerdeInfo s = (SerdeInfo)some.value();
            return (scala.collection.immutable.Map)((MapOps)((MapOps)((MapOps)s.formatClasses().map((Function1 & Serializable)f -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.input-format"), (Object)f.input()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.output-format"), (Object)f.output())}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((IterableOnce)s.storedAs().map((Function1 & Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.stored-as"), x$12)))).$plus$plus((IterableOnce)s.serde().map((Function1 & Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.serde"), x$13)))).$plus$plus((IterableOnce)s.serdeProperties().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)("option." + key)), (Object)value);
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Map().empty();
        }
        throw new MatchError(option);
    }

    public scala.collection.immutable.Map<String, String> withDefaultOwnership(scala.collection.immutable.Map<String, String> properties) {
        return (scala.collection.immutable.Map)properties.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)CurrentUserContext$.MODULE$.getCurrentUser())})));
    }

    public TableCatalog getTableProviderCatalog(SupportsCatalogOptions provider, CatalogManager catalogManager, CaseInsensitiveStringMap options) {
        return CatalogV2Implicits$.MODULE$.CatalogHelper((CatalogPlugin)Option$.MODULE$.apply((Object)provider.extractCatalog(options)).map((Function1 & Serializable)name -> catalogManager.catalog((String)name)).getOrElse((Function0 & Serializable)() -> catalogManager.v2SessionCatalog())).asTableCatalog();
    }

    public StructType v2ColumnsToStructType(Column[] columns) {
        return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> MODULE$.v2ColumnToStructField((Column)col), ClassTag$.MODULE$.apply(StructField.class)));
    }

    private StructField v2ColumnToStructField(Column col) {
        Metadata metadata = (Metadata)Option$.MODULE$.apply((Object)col.metadataInJSON()).map((Function1 & Serializable)json -> Metadata$.MODULE$.fromJson(json)).getOrElse((Function0 & Serializable)() -> Metadata$.MODULE$.empty());
        ObjectRef f = ObjectRef.create((Object)new StructField(col.name(), col.dataType(), col.nullable(), metadata));
        Option$.MODULE$.apply((Object)col.comment()).foreach((Function1 & Serializable)comment -> {
            f.elem = ((StructField)f.elem).withComment(comment);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)col.defaultValue()).foreach((Function1 & Serializable)columnDefaultValue -> {
            f.elem = CatalogV2Util$.MODULE$.encodeDefaultValue(columnDefaultValue, (StructField)f.elem);
            return BoxedUnit.UNIT;
        });
        return (StructField)f.elem;
    }

    private StructField encodeDefaultValue(ColumnDefaultValue defaultValue, StructField f) {
        return (StructField)Option$.MODULE$.apply((Object)defaultValue).map((Function1 & Serializable)columnDefaultValue -> {
            String existingDefault = new Literal(columnDefaultValue.getValue().value(), columnDefaultValue.getValue().dataType()).sql();
            return f.withExistenceDefaultValue(existingDefault).withCurrentDefaultValue(columnDefaultValue.getSql());
        }).getOrElse((Function0 & Serializable)() -> f);
    }

    public Column[] structTypeToV2Columns(StructType schema) {
        return (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)f -> MODULE$.structFieldToV2Column((StructField)f), ClassTag$.MODULE$.apply(Column.class));
    }

    private Column structFieldToV2Column(StructField f) {
        boolean isDefaultColumn = f.getCurrentDefaultValue().isDefined() && f.getExistenceDefaultValue().isDefined();
        boolean isGeneratedColumn = GeneratedColumn$.MODULE$.isGeneratedColumn(f);
        boolean isIdentityColumn = IdentityColumn$.MODULE$.isIdentityColumn(f);
        if (isDefaultColumn) {
            this.checkDefaultColumnConflicts(f);
            Expression e = ResolveDefaultColumns$.MODULE$.analyze(f, "Column analysis", ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
            Predef$.MODULE$.assert(e.resolved() && e.foldable(), (Function0 & Serializable)() -> "The existence default value must be a simple SQL string that is resolved and foldable, but got: " + f.getExistenceDefaultValue().get());
            ColumnDefaultValue defaultValue = new ColumnDefaultValue((String)f.getCurrentDefaultValue().get(), new LiteralValue<Object>(e.eval(e.eval$default$1()), f.dataType()));
            Metadata cleanedMetadata = CatalogV2Util$.metadataWithKeysRemoved$1((Seq)new .colon.colon((Object)"comment", (List)new .colon.colon((Object)ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), (List)new .colon.colon((Object)ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), (List)Nil$.MODULE$))), f);
            return Column.create(f.name(), f.dataType(), f.nullable(), (String)f.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), defaultValue, CatalogV2Util$.metadataAsJson$1(cleanedMetadata));
        }
        if (isGeneratedColumn) {
            Metadata cleanedMetadata = CatalogV2Util$.metadataWithKeysRemoved$1((Seq)new .colon.colon((Object)"comment", (List)new .colon.colon((Object)GeneratedColumn$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY(), (List)Nil$.MODULE$)), f);
            return Column.create(f.name(), f.dataType(), f.nullable(), (String)f.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)GeneratedColumn$.MODULE$.getGenerationExpression(f).get(), CatalogV2Util$.metadataAsJson$1(cleanedMetadata));
        }
        if (isIdentityColumn) {
            Metadata cleanedMetadata = CatalogV2Util$.metadataWithKeysRemoved$1((Seq)new .colon.colon((Object)"comment", (List)new .colon.colon((Object)IdentityColumn$.MODULE$.IDENTITY_INFO_START(), (List)new .colon.colon((Object)IdentityColumn$.MODULE$.IDENTITY_INFO_STEP(), (List)new .colon.colon((Object)IdentityColumn$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT(), (List)Nil$.MODULE$)))), f);
            return Column.create(f.name(), f.dataType(), f.nullable(), (String)f.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (IdentityColumnSpec)IdentityColumn$.MODULE$.getIdentityInfo(f).get(), CatalogV2Util$.metadataAsJson$1(cleanedMetadata));
        }
        Metadata cleanedMetadata = CatalogV2Util$.metadataWithKeysRemoved$1((Seq)new .colon.colon((Object)"comment", (List)Nil$.MODULE$), f);
        return Column.create(f.name(), f.dataType(), f.nullable(), (String)f.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), CatalogV2Util$.metadataAsJson$1(cleanedMetadata));
    }

    private void checkDefaultColumnConflicts(StructField f) {
        if (GeneratedColumn$.MODULE$.isGeneratedColumn(f)) {
            throw new AnalysisException("GENERATED_COLUMN_WITH_DEFAULT_VALUE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)f.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), f.getCurrentDefaultValue().get()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"genExpr"), GeneratedColumn$.MODULE$.getGenerationExpression(f).get())})));
        }
        if (IdentityColumn$.MODULE$.isIdentityColumn(f)) {
            throw new AnalysisException("IDENTITY_COLUMN_WITH_DEFAULT_VALUE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)f.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), f.getCurrentDefaultValue().get()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identityColumnSpec"), (Object)((IdentityColumnSpec)IdentityColumn$.MODULE$.getIdentityInfo(f).get()).toString())})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$applySchemaChanges$11(String name$1, StructField x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$applySchemaChanges$13(StructField oldField$1, StructField x$2) {
        StructField structField = x$2;
        StructField structField2 = oldField$1;
        return structField == null ? structField2 != null : !structField.equals(structField2);
    }

    private static final StructType updateFieldPos$1(StructType struct, String name, TableChange.UpdateColumnPosition x7$1, Option tableProvider$1, String statementType$1) {
        StructField oldField = (StructField)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])struct.fields()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CatalogV2Util$.$anonfun$applySchemaChanges$11(name, x$1))).getOrElse((Function0 & Serializable)() -> {
            throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3230", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)})));
        });
        StructType withFieldRemoved = new StructType((StructField[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])struct.fields()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CatalogV2Util$.$anonfun$applySchemaChanges$13(oldField, x$2))));
        return MODULE$.addField(withFieldRemoved, oldField, x7$1.position(), (Option<String>)tableProvider$1, statementType$1, false);
    }

    public static final /* synthetic */ boolean $anonfun$addField$1(String afterCol$1, StructField x$4) {
        String string = x$4.name();
        String string2 = afterCol$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$replace$1(StructField f) {
        return ResolveDefaultColumns$.MODULE$.toSQLId(f.name());
    }

    public static final /* synthetic */ Nothing$ $anonfun$replace$2() {
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3226");
    }

    public static final /* synthetic */ Nothing$ $anonfun$replace$3() {
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3225");
    }

    public static final /* synthetic */ Nothing$ $anonfun$replace$4() {
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3224");
    }

    public static final /* synthetic */ Option $anonfun$replace$5(int pos$1, Option replacement$1, Tuple2 x0$1) {
        int index;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && pos$1 == (index = tuple2._2$mcI$sp())) {
            return replacement$1;
        }
        if (tuple2 != null) {
            StructField other = (StructField)tuple2._1();
            return new Some((Object)other);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String metadataAsJson$1(Metadata metadata) {
        Metadata metadata2 = metadata;
        Metadata metadata3 = Metadata$.MODULE$.empty();
        if (!(metadata2 != null ? !metadata2.equals(metadata3) : metadata3 != null)) {
            return null;
        }
        return metadata.json();
    }

    private static final Metadata metadataWithKeysRemoved$1(Seq keys, StructField f$3) {
        return ((MetadataBuilder)keys.foldLeft((Object)new MetadataBuilder().withMetadata(f$3.metadata()), (Function2 & Serializable)(builder, key) -> builder.remove(key))).build();
    }

    private CatalogV2Util$() {
    }
}

