/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.catalyst.expressions.codegen.BaseProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.package$ExpressionCanonicalizer$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GenerateSafeProjection$
extends CodeGenerator<Seq<Expression>, package.Projection> {
    public static final GenerateSafeProjection$ MODULE$ = new GenerateSafeProjection$();

    @Override
    public Seq<Expression> canonicalize(Seq<Expression> in) {
        return (Seq)in.map((Function1 & Serializable)plan2 -> package$ExpressionCanonicalizer$.MODULE$.execute(plan2));
    }

    @Override
    public Seq<Expression> bind(Seq<Expression> in, Seq<Attribute> inputSchema) {
        return BindReferences$.MODULE$.bindReferences(in, package$.MODULE$.AttributeSeq(inputSchema));
    }

    private ExprCode createCodeForStruct(CodegenContext ctx, String input, StructType schema) {
        String tmpInput = ctx.freshName("tmpInput");
        String output = ctx.freshName("safeRow");
        String values = ctx.freshName("values");
        String rowClass = GenericInternalRow.class.getName();
        Seq fieldWriters = (Seq)((IterableOps)((IterableOps)schema.map((Function1 & Serializable)x$1 -> x$1.dataType())).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DataType dt = (DataType)tuple2._1();
                int i = tuple2._2$mcI$sp();
                ExprCode converter = MODULE$.convertToSafe(ctx, JavaCode$.MODULE$.expression(CodeGenerator$.MODULE$.getValue(tmpInput, dt, Integer.toString(i)), dt), dt);
                return "\n        if (!" + tmpInput + ".isNullAt(" + i + ")) {\n          " + converter.code() + "\n          " + values + "[" + i + "] = " + converter.value() + ";\n        }\n      ";
            }
            throw new MatchError((Object)tuple2);
        });
        String allFields = ctx.splitExpressions((Seq<String>)fieldWriters, "writeFields", (Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"InternalRow"), (Object)tmpInput), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Object[]"), (Object)values), (List)Nil$.MODULE$)), ctx.splitExpressions$default$4(), ctx.splitExpressions$default$5(), ctx.splitExpressions$default$6());
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |final InternalRow ", " = ", ";\n         |final Object[] ", " = new Object[", "];\n         |", "\n         |final InternalRow ", " = new ", "(", ");\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tmpInput, input, values, BoxesRunTime.boxToInteger((int)schema.length()), allFields, output, rowClass, values})).stripMargin();
        return new ExprCode(code, FalseLiteral$.MODULE$, JavaCode$.MODULE$.variable(output, InternalRow.class));
    }

    private ExprCode createCodeForArray(CodegenContext ctx, String input, DataType elementType) {
        String tmpInput = ctx.freshName("tmpInput");
        String output = ctx.freshName("safeArray");
        String values = ctx.freshName("values");
        String numElements = ctx.freshName("numElements");
        String index = ctx.freshName("index");
        String arrayClass = GenericArrayData.class.getName();
        ExprCode elementConverter = this.convertToSafe(ctx, JavaCode$.MODULE$.expression(CodeGenerator$.MODULE$.getValue(tmpInput, elementType, index), elementType), elementType);
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ArrayData ", " = ", ";\n      final int ", " = ", ".numElements();\n      final Object[] ", " = new Object[", "];\n      for (int ", " = 0; ", " < ", "; ", "++) {\n        if (!", ".isNullAt(", ")) {\n          ", "\n          ", "[", "] = ", ";\n        }\n      }\n      final ArrayData ", " = new ", "(", ");\n    "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tmpInput, input, numElements, tmpInput, values, numElements, index, index, numElements, index, tmpInput, index, elementConverter.code(), values, index, elementConverter.value(), output, arrayClass, values}));
        return new ExprCode(code, FalseLiteral$.MODULE$, JavaCode$.MODULE$.variable(output, ArrayData.class));
    }

    private ExprCode createCodeForMap(CodegenContext ctx, String input, DataType keyType, DataType valueType) {
        String tmpInput = ctx.freshName("tmpInput");
        String output = ctx.freshName("safeMap");
        String mapClass = ArrayBasedMapData.class.getName();
        ExprCode keyConverter = this.createCodeForArray(ctx, tmpInput + ".keyArray()", keyType);
        ExprCode valueConverter = this.createCodeForArray(ctx, tmpInput + ".valueArray()", valueType);
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final MapData ", " = ", ";\n      ", "\n      ", "\n      final MapData ", " = new ", "(", ", ", ");\n    "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tmpInput, input, keyConverter.code(), valueConverter.code(), output, mapClass, keyConverter.value(), valueConverter.value()}));
        return new ExprCode(code, FalseLiteral$.MODULE$, JavaCode$.MODULE$.variable(output, MapData.class));
    }

    private ExprCode convertToSafe(CodegenContext ctx, ExprValue input, DataType dataType) {
        while (true) {
            DataType dataType2;
            if ((dataType2 = dataType) instanceof StructType) {
                StructType structType = (StructType)dataType2;
                return this.createCodeForStruct(ctx, ExprValue$.MODULE$.exprValueToString(input), structType);
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType elementType = arrayType.elementType();
                return this.createCodeForArray(ctx, ExprValue$.MODULE$.exprValueToString(input), elementType);
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                return this.createCodeForMap(ctx, ExprValue$.MODULE$.exprValueToString(input), keyType, valueType);
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        return ExprCode$.MODULE$.apply(FalseLiteral$.MODULE$, input);
    }

    @Override
    public package.Projection create(Seq<Expression> expressions) {
        CodegenContext ctx = this.newCodeGenContext();
        Seq expressionCodes = (Seq)((IterableOps)expressions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Expression expression;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && NoOp$.MODULE$.equals(expression = (Expression)tuple2._1())) {
                return "";
            }
            if (tuple2 != null) {
                Expression e = (Expression)tuple2._1();
                int i = tuple2._2$mcI$sp();
                ExprCode evaluationCode = e.genCode(ctx);
                ExprCode converter = MODULE$.convertToSafe(ctx, evaluationCode.value(), e.dataType());
                return evaluationCode.code().toString() + "\n            if (" + evaluationCode.isNull() + ") {\n              mutableRow.setNullAt(" + i + ");\n            } else {\n              " + converter.code() + "\n              " + CodeGenerator$.MODULE$.setColumn("mutableRow", e.dataType(), i, ExprValue$.MODULE$.exprValueToString(converter.value())) + ";\n            }\n          ";
            }
            throw new MatchError((Object)tuple2);
        });
        String allExpressions = ctx.splitExpressionsWithCurrentInputs((Seq<String>)expressionCodes, ctx.splitExpressionsWithCurrentInputs$default$2(), ctx.splitExpressionsWithCurrentInputs$default$3(), ctx.splitExpressionsWithCurrentInputs$default$4(), ctx.splitExpressionsWithCurrentInputs$default$5(), ctx.splitExpressionsWithCurrentInputs$default$6());
        String codeBody = "\n      public java.lang.Object generate(Object[] references) {\n        return new SpecificSafeProjection(references);\n      }\n\n      class SpecificSafeProjection extends " + BaseProjection.class.getName() + " {\n\n        private Object[] references;\n        private InternalRow mutableRow;\n        " + ctx.declareMutableStates() + "\n\n        public SpecificSafeProjection(Object[] references) {\n          this.references = references;\n          mutableRow = (InternalRow) references[references.length - 1];\n          " + ctx.initMutableStates() + "\n        }\n\n        public void initialize(int partitionIndex) {\n          " + ctx.initPartition() + "\n        }\n\n        public java.lang.Object apply(java.lang.Object _i) {\n          InternalRow " + ctx.INPUT_ROW() + " = (InternalRow) _i;\n          " + allExpressions + "\n          return mutableRow;\n        }\n\n        " + ctx.declareAddedFunctions() + "\n      }\n    ";
        CodeAndComment code = CodeFormatter$.MODULE$.stripOverlappingComments(new CodeAndComment(codeBody, ctx.getPlaceHolderToComments()));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "code for " + expressions.mkString(",") + ":\n" + CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2()));
        Tuple2<GeneratedClass, ByteCodeStats> tuple2 = CodeGenerator$.MODULE$.compile(code);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratedClass clazz = (GeneratedClass)tuple2._1();
        GeneratedClass clazz2 = clazz;
        SpecificInternalRow resultRow = new SpecificInternalRow((Seq<DataType>)((Seq)expressions.map((Function1 & Serializable)x$2 -> x$2.dataType())));
        return (package.Projection)clazz2.generate((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.genericArrayOps(ctx.references().toArray(ClassTag$.MODULE$.Any())), (Object)resultRow, ClassTag$.MODULE$.Any()));
    }

    private GenerateSafeProjection$() {
    }
}

