/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tma\u0001B\u0013'\u0001NB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u0003q\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011B(\t\u000b]\u0003A\u0011\u0001-\t\u000bu\u0003A\u0011\t0\t\u0011\t\u0004\u0001R1A\u0005\u0006\rDQa\u001a\u0001\u0005B!DQa\u001c\u0001\u0005BADQa\u001e\u0001\u0005B9CQ\u0001\u001f\u0001\u0005B9CQ!\u001f\u0001\u0005B9CQA\u001f\u0001\u0005BmDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005u\u0002\u0001\"\u0015\u0002@!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"a\u001c\u0001#\u0003%\t!!\u0017\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005e\u0003\"CA:\u0001\u0005\u0005I\u0011IA;\u0011!\t)\tAA\u0001\n\u0003\u0019\u0007\"CAD\u0001\u0005\u0005I\u0011AAE\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002 \u0002\t\t\u0011\"\u0001\u0002\"\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013q\u0015\u0005\n\u0003W\u0003\u0011\u0011!C!\u0003[;\u0011\"!5'\u0003\u0003E\t!a5\u0007\u0011\u00152\u0013\u0011!E\u0001\u0003+DaaV\u0010\u0005\u0002\u00055\b\"CAx?\u0005\u0005IQIAy\u0011%\t\u0019pHA\u0001\n\u0003\u000b)\u0010C\u0005\u0002~~\t\t\u0011\"!\u0002\u0000\"I!\u0011C\u0010\u0002\u0002\u0013%!1\u0003\u0002\u000f'V\u00147\u000f\u001e:j]\u001eLe\u000eZ3y\u0015\t9\u0003&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0015+\u0003!\u0019\u0017\r^1msN$(BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO\u000e\u00011#\u0002\u00015qm\n\u0005CA\u001b7\u001b\u00051\u0013BA\u001c'\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003keJ!A\u000f\u0014\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002C\u0015:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rJ\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0005%k\u0014a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!S\u001f\u0002\u000fM$(/\u0012=qeV\tq\n\u0005\u00026!&\u0011\u0011K\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C:ue\u0016C\bO\u001d\u0011\u0002\u0013\u0011,G.[7FqB\u0014\u0018A\u00033fY&lW\t\u001f9sA\u0005I1m\\;oi\u0016C\bO]\u0001\u000bG>,h\u000e^#yaJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003Z5nc\u0006CA\u001b\u0001\u0011\u0015iu\u00011\u0001P\u0011\u0015\u0019v\u00011\u0001P\u0011\u0015)v\u00011\u0001P\u00039qW\u000f\u001c7J]R|G.\u001a:b]R,\u0012a\u0018\t\u0003y\u0001L!!Y\u001f\u0003\u000f\t{w\u000e\\3b]\u0006Y1m\u001c7mCRLwN\\%e+\u0005!\u0007C\u0001\u001ff\u0013\t1WHA\u0002J]R\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002SB\u0011!.\\\u0007\u0002W*\u0011ANK\u0001\u0006if\u0004Xm]\u0005\u0003].\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A9\u0011\u0007\t\u0013H/\u0003\u0002t\u0019\n\u00191+Z9\u0011\u0005),\u0018B\u0001<l\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u000baJ,G\u000f^=OC6,W#\u0001?\u0011\u0007u\f\u0019A\u0004\u0002\u007f\u007fB\u0011A)P\u0005\u0004\u0003\u0003i\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0005\u001d!AB*ue&twMC\u0002\u0002\u0002u\nAB\\;mYN\u000bg-Z#wC2$\u0002\"!\u0004\u0002\u0014\u0005]\u00111\u0004\t\u0004y\u0005=\u0011bAA\t{\t\u0019\u0011I\\=\t\u000f\u0005U\u0001\u00031\u0001\u0002\u000e\u0005\u00191\u000f\u001e:\t\u000f\u0005e\u0001\u00031\u0001\u0002\u000e\u0005)A-\u001a7j[\"9\u0011Q\u0004\tA\u0002\u00055\u0011!B2pk:$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019#a\f\u0002:A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u0019\nqaY8eK\u001e,g.\u0003\u0003\u0002.\u0005\u001d\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005E\u0012\u00031\u0001\u00024\u0005\u00191\r\u001e=\u0011\t\u0005\u0015\u0012QG\u0005\u0005\u0003o\t9C\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005m\u0012\u00031\u0001\u0002$\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$r!WA!\u0003\u000b\nI\u0005\u0003\u0004\u0002DI\u0001\raT\u0001\t]\u0016<h)\u001b:ti\"1\u0011q\t\nA\u0002=\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u0005-#\u00031\u0001P\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$r!WA)\u0003'\n)\u0006C\u0004N'A\u0005\t\u0019A(\t\u000fM\u001b\u0002\u0013!a\u0001\u001f\"9Qk\u0005I\u0001\u0002\u0004y\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037R3aTA/W\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA5{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00141\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006LA!!\u0002\u0002|\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0007\u0003\u0017C\u0001\"!$\u001a\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0005CBAK\u00037\u000bi!\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0006]%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aXAR\u0011%\tiiGA\u0001\u0002\u0004\ti!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA<\u0003SC\u0001\"!$\u001d\u0003\u0003\u0005\r\u0001Z\u0001\u0007KF,\u0018\r\\:\u0015\u0007}\u000by\u000bC\u0005\u0002\u000ev\t\t\u00111\u0001\u0002\u000e!\u001a\u0002!a-\u0002:\u0006m\u0016qXAa\u0003\u000b\f9-a3\u0002NB\u0019Q'!.\n\u0007\u0005]fEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005u\u0016a!#\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\"W\r\\5nY\u0001\u001aw.\u001e8uS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aXOY:ue&tw\r\t4s_6\u0004\u0003m\u001d;sA\u0002\u0012WMZ8sK\u0002\u00027m\\;oi\u0002\u0004snY2veJ,gnY3tA=4\u0007\u0005\u001e5fA\u0011,G.[7ji\u0016\u0014\b\u0005\u00193fY&l\u0007M\f\u0006!A\u0001\u0002\u0003\u0005I%gA\u0001\u001cw.\u001e8uA\u0002J7\u000f\t9pg&$\u0018N^3-A\u00154XM]=uQ&tw\r\t;pAQDW\r\t7fMR\u0004sN\u001a\u0011uQ\u0016\u0004c-\u001b8bY\u0002\"W\r\\5nSR,'\u000f\t\u0015d_VtG/\u001b8hA\u0019\u0014x.\u001c\u0011uQ\u0016T\u0001\u0005\t\u0011!A\u0001bWM\u001a;*A%\u001c\bE]3ukJtW\r\u001a\u0018!\u0013\u001a\u0004\u0003mY8v]R\u0004\u0007%[:!]\u0016<\u0017\r^5wK2\u0002SM^3ssRD\u0017N\\4!i>\u0004C\u000f[3!e&<\u0007\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011gS:\fG\u000e\t3fY&l\u0017\u000e^3s\u0015\u0001\u0002\u0003\u0005\t\u0011!Q\r|WO\u001c;j]\u001e\u0004cM]8nAQDW\r\t:jO\"$\u0018\u0006I5tAI,G/\u001e:oK\u0012t\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u00043/\u001e2tiJLgnZ0j]\u0012,\u0007\u0010\t9fe\u001a|'/\\:!C\u0002\u001a\u0017m]3.g\u0016t7/\u001b;jm\u0016\u0004S.\u0019;dQ*\u0001\u0003\u0005\t\u0011!A]DWM\u001c\u0011tK\u0006\u00148\r[5oO\u00022wN\u001d\u0011aI\u0016d\u0017.\u001c1/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0017\u0001\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O]<xOL1qC\u000eDWML8sO\u001eb\u0003e\n\u0018(Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011xo^t\u0013\r]1dQ\u0016T\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0013\fQ!\r\u00186]A\nQa\u001a:pkB\f#!a4\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u001dM+(m\u001d;sS:<\u0017J\u001c3fqB\u0011QgH\n\u0006?\u0005]\u00171\u001d\t\t\u00033\fynT(P36\u0011\u00111\u001c\u0006\u0004\u0003;l\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003C\fYNA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0005\u0003S\fy(\u0001\u0002j_&\u00191*a:\u0015\u0005\u0005M\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0014!B1qa2LHcB-\u0002x\u0006e\u00181 \u0005\u0006\u001b\n\u0002\ra\u0014\u0005\u0006'\n\u0002\ra\u0014\u0005\u0006+\n\u0002\raT\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tA!\u0004\u0011\u000bq\u0012\u0019Aa\u0002\n\u0007\t\u0015QH\u0001\u0004PaRLwN\u001c\t\u0007y\t%qjT(\n\u0007\t-QH\u0001\u0004UkBdWm\r\u0005\t\u0005\u001f\u0019\u0013\u0011!a\u00013\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tU\u0001\u0003BA=\u0005/IAA!\u0007\u0002|\t1qJ\u00196fGR\u0004")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex x$0) {
        return SubstringIndex$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private int collationId$lzycompute() {
        SubstringIndex substringIndex = this;
        synchronized (substringIndex) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.first().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public DataType dataType() {
        return this.strExpr().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.strExpr();
    }

    @Override
    public Expression second() {
        return this.delimExpr();
    }

    @Override
    public Expression third() {
        return this.countExpr();
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return CollationSupport.SubstringIndex.exec((UTF8String)((UTF8String)str), (UTF8String)((UTF8String)delim), (int)BoxesRunTime.unboxToInt((Object)count), (int)this.collationId());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, delim, count) -> CollationSupport.SubstringIndex.genCode((String)str, (String)delim, (String)count, (int)this.collationId()));
    }

    @Override
    public SubstringIndex withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.strExpr();
            }
            case 1: {
                return this.delimExpr();
            }
            case 2: {
                return this.countExpr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "strExpr";
            }
            case 1: {
                return "delimExpr";
            }
            case 2: {
                return "countExpr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

