/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SecondsToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(seconds) - Creates timestamp from the number of seconds (can be fractional) since UTC epoch.", examples="\n    Examples:\n      > SELECT _FUNC_(1230219000);\n       2008-12-25 07:30:00\n      > SELECT _FUNC_(1230219000.123);\n       2008-12-25 07:30:00.123\n  ", group="datetime_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\u000f\u001f\u0001.B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\")1\n\u0001C\u0001\u0019\")q\n\u0001C!!\")A\u000b\u0001C!+\")q\f\u0001C!A\")A\r\u0001C!!\"AQ\r\u0001EC\u0002\u0013%a\rC\u0003r\u0001\u0011\u0005#\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005u\u0001\u0001\"\u0015\u0002 !I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003W\u0001\u0011\u0013!C\u0001\u0003[A\u0011\"a\u0011\u0001\u0003\u0003%\t%!\u0012\t\u0013\u0005U\u0003!!A\u0005\u0002\u0005]\u0003\"CA0\u0001\u0005\u0005I\u0011AA1\u0011%\t9\u0007AA\u0001\n\u0003\nI\u0007C\u0005\u0002x\u0001\t\t\u0011\"\u0001\u0002z!I\u0011Q\u0010\u0001\u0002\u0002\u0013\u0005\u0013q\u0010\u0005\n\u0003\u0007\u0003\u0011\u0011!C!\u0003\u000b;\u0011\"!+\u001f\u0003\u0003E\t!a+\u0007\u0011uq\u0012\u0011!E\u0001\u0003[CaaS\f\u0005\u0002\u0005\u0015\u0007\"CAd/\u0005\u0005IQIAe\u0011%\tYmFA\u0001\n\u0003\u000bi\rC\u0005\u0002R^\t\t\u0011\"!\u0002T\"I\u0011q\\\f\u0002\u0002\u0013%\u0011\u0011\u001d\u0002\u0013'\u0016\u001cwN\u001c3t)>$\u0016.\\3ti\u0006l\u0007O\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0015\u0001A\u0006M\u001a:!\tic&D\u0001\u001f\u0013\tycDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0013'\u0003\u00023=\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011!H\u0011\b\u0003w\u0001s!\u0001P \u000e\u0003uR!A\u0010\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014BA!6\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0011#\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0005+\u0014!B2iS2$W#A$\u0011\u00055B\u0015BA%\u001f\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\tie\n\u0005\u0002.\u0001!)Qi\u0001a\u0001\u000f\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#A)\u0011\u0005Q\u0012\u0016BA*6\u0005\u001d\u0011un\u001c7fC:\f!\"\u001b8qkR$\u0016\u0010]3t+\u00051\u0006c\u0001\u001eX3&\u0011\u0001\f\u0012\u0002\u0004'\u0016\f\bC\u0001.^\u001b\u0005Y&B\u0001/#\u0003\u0015!\u0018\u0010]3t\u0013\tq6L\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001b!\tQ&-\u0003\u0002d7\nAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u0003!)g/\u00197Gk:\u001cW#A4\u0011\tQB'N[\u0005\u0003SV\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005QZ\u0017B\u000176\u0005\r\te.\u001f\u0015\u0003\u00119\u0004\"\u0001N8\n\u0005A,$!\u0003;sC:\u001c\u0018.\u001a8u\u00031qW\u000f\u001c7TC\u001a,WI^1m)\tQ7\u000fC\u0003u\u0013\u0001\u0007!.A\u0003j]B,H/A\u0005e_\u001e+gnQ8eKR!q/`A\u0003!\tA80D\u0001z\u0015\tQh$A\u0004d_\u0012,w-\u001a8\n\u0005qL(\u0001C#yaJ\u001cu\u000eZ3\t\u000byT\u0001\u0019A@\u0002\u0007\r$\b\u0010E\u0002y\u0003\u0003I1!a\u0001z\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0002\u000b\u0001\u00049\u0018AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00189!\u0011\u0011CA\n!\taT'C\u0002\u0002\u0016U\na\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000bk\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2!TA\u0011\u0011\u0019\t\u0019\u0003\u0004a\u0001\u000f\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHcA'\u0002*!9Q)\u0004I\u0001\u0002\u00049\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003_Q3aRA\u0019W\t\t\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001fk\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0013q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001\u00027b]\u001eT!!!\u0015\u0002\t)\fg/Y\u0005\u0005\u00033\tY%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002ZA\u0019A'a\u0017\n\u0007\u0005uSGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002k\u0003GB\u0011\"!\u001a\u0012\u0003\u0003\u0005\r!!\u0017\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u0007E\u0003\u0002n\u0005M$.\u0004\u0002\u0002p)\u0019\u0011\u0011O\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002v\u0005=$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!UA>\u0011!\t)gEA\u0001\u0002\u0004Q\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0012\u0002\u0002\"I\u0011Q\r\u000b\u0002\u0002\u0003\u0007\u0011\u0011L\u0001\u0007KF,\u0018\r\\:\u0015\u0007E\u000b9\t\u0003\u0005\u0002fU\t\t\u00111\u0001kQM\u0001\u00111RAI\u0003'\u000b9*!'\u0002\u001e\u0006}\u00151UAS!\ri\u0013QR\u0005\u0004\u0003\u001fs\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003+\u000b1m\u0018$V\u001d\u000e{\u0006f]3d_:$7/\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\"\u0018.\\3ti\u0006l\u0007\u000f\t4s_6\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u00043/Z2p]\u0012\u001c\b\u0005K2b]\u0002\u0012W\r\t4sC\u000e$\u0018n\u001c8bY&\u00023/\u001b8dK\u0002*Fk\u0011\u0011fa>\u001c\u0007NL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111T\u0001\u0002,)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013GM\u001a1eEJ\u0004\u0007\r\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004\u0007\r\u001d.cIj#'\u000e\u00111oi\u001a\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n$g\r\u00193ce\u0002\u0004\u0007\r\u00182eMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1aaj\u0013GM\u00173k\u0001\u0002tGO\u001a1uA\u0002d&\r\u001a4\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAQ\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a*\u0002\u000bMr\u0013G\f\u0019\u0002%M+7m\u001c8egR{G+[7fgR\fW\u000e\u001d\t\u0003[]\u0019RaFAX\u0003w\u0003b!!-\u00028\u001ekUBAAZ\u0015\r\t),N\u0001\beVtG/[7f\u0013\u0011\tI,a-\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002>\u0006\rWBAA`\u0015\u0011\t\t-a\u0014\u0002\u0005%|\u0017bA\"\u0002@R\u0011\u00111V\u0001\ti>\u001cFO]5oOR\u0011\u0011qI\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001b\u0006=\u0007\"B#\u001b\u0001\u00049\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003+\fY\u000e\u0005\u00035\u0003/<\u0015bAAmk\t1q\n\u001d;j_:D\u0001\"!8\u001c\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAr!\u0011\tI%!:\n\t\u0005\u001d\u00181\n\u0002\u0007\u001f\nTWm\u0019;")
public class SecondsToTimestamp
extends UnaryExpression
implements ExpectsInputTypes,
Serializable {
    private transient Function1<Object, Object> evalFunc;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(SecondsToTimestamp x$0) {
        return SecondsToTimestamp$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<SecondsToTimestamp, A> g) {
        return SecondsToTimestamp$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, SecondsToTimestamp> compose(Function1<A$, Expression> g) {
        return SecondsToTimestamp$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)NumericType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        DataType dataType = this.child().dataType();
        if (dataType instanceof FloatType ? true : dataType instanceof DoubleType) {
            return true;
        }
        return this.child().nullable();
    }

    private Function1<Object, Object> evalFunc$lzycompute() {
        SecondsToTimestamp secondsToTimestamp = this;
        synchronized (secondsToTimestamp) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable intersect;
                DataType dataType = this.child().dataType();
                if (dataType instanceof IntegralType) {
                    intersect = (Function1 & Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$1(input));
                } else if (dataType instanceof DecimalType) {
                    intersect = (Function1 & Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$2(input));
                } else if (dataType instanceof FloatType) {
                    intersect = (Function1 & Serializable)input -> {
                        float f = BoxesRunTime.unboxToFloat((Object)input);
                        if (Float.isNaN(f) || Float.isInfinite(f)) {
                            return null;
                        }
                        return BoxesRunTime.boxToLong((long)((long)((double)f * (double)1000000L)));
                    };
                } else if (dataType instanceof DoubleType) {
                    intersect = (Function1 & Serializable)input -> {
                        double d = BoxesRunTime.unboxToDouble((Object)input);
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            return null;
                        }
                        return BoxesRunTime.boxToLong((long)((long)(d * (double)1000000L)));
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.evalFunc = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.evalFunc;
    }

    private Function1<Object, Object> evalFunc() {
        if (!this.bitmap$trans$0) {
            return this.evalFunc$lzycompute();
        }
        return this.evalFunc;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.evalFunc().apply(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof IntegralType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "java.lang.Math.multiplyExact(" + c + ", " + 1000000L + "L)");
        }
        if (dataType instanceof DecimalType) {
            String operand = "new java.math.BigDecimal(" + 1000000L + ")";
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + ".toJavaBigDecimal().multiply(" + operand + ").longValueExact()");
        }
        String castToDouble = dataType instanceof FloatType ? "(double)" : "";
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            String typeStr = CodeGenerator$.MODULE$.boxedType(dataType);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (" + typeStr + ".isNaN(" + c + ") || " + typeStr + ".isInfinite(" + c + ")) {\n           |  " + ev.isNull() + " = true;\n           |} else {\n           |  " + ev.value() + " = (long)(" + castToDouble + c + " * " + 1000000L + ");\n           |}\n           |"));
        });
    }

    @Override
    public String prettyName() {
        return "timestamp_seconds";
    }

    @Override
    public SecondsToTimestamp withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public SecondsToTimestamp copy(Expression child) {
        return new SecondsToTimestamp(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "SecondsToTimestamp";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SecondsToTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SecondsToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        SecondsToTimestamp secondsToTimestamp = (SecondsToTimestamp)x$1;
        Expression expression = this.child();
        Expression expression2 = secondsToTimestamp.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!secondsToTimestamp.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$evalFunc$1(Object input) {
        return Math.multiplyExact(((Number)input).longValue(), 1000000L);
    }

    public static final /* synthetic */ long $anonfun$evalFunc$2(Object input) {
        BigDecimal operand = new BigDecimal(1000000L);
        return ((Decimal)input).toJavaBigDecimal().multiply(operand).longValueExact();
    }

    public SecondsToTimestamp(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

