/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t]c\u0001\u0002\u0017.\u0001jB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0012)A\u00053\"AQ\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005_\u0001\tE\t\u0015!\u0003Z\u0011!y\u0006A!f\u0001\n\u0003A\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B-\t\u0011\u0005\u0004!Q3A\u0005\u0002\tD\u0001B\u001c\u0001\u0003\u0012\u0003\u0006Ia\u0019\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006m\u0002!\te\u001e\u0005\u0006_\u0002!\ta\u001f\u0005\u0006_\u0002!\tA \u0005\u0007\u0003\u000b\u0001A\u0011\t-\t\r\u0005\u001d\u0001\u0001\"\u0011Y\u0011\u0019\tI\u0001\u0001C!1\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0015\u0002j!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003\u000bC\u0011\"a'\u0001#\u0003%\t!!\"\t\u0013\u0005u\u0005!%A\u0005\u0002\u0005\u0015\u0005\"CAP\u0001E\u0005I\u0011AAQ\u0011%\t)\u000bAA\u0001\n\u0003\n9\u000bC\u0005\u00028\u0002\t\t\u0011\"\u0001\u0002:\"I\u0011\u0011\u0019\u0001\u0002\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003\u0013\u0004\u0011\u0011!C!\u0003\u0017D\u0011\"!7\u0001\u0003\u0003%\t!a7\t\u0013\u0005}\u0007!!A\u0005B\u0005\u0005\b\"CAs\u0001\u0005\u0005I\u0011IAt\u000f%\u0011Y!LA\u0001\u0012\u0003\u0011iA\u0002\u0005-[\u0005\u0005\t\u0012\u0001B\b\u0011\u0019yG\u0005\"\u0001\u0003(!I!\u0011\u0006\u0013\u0002\u0002\u0013\u0015#1\u0006\u0005\n\u0005[!\u0013\u0011!CA\u0005_A\u0011B!\u000f%#\u0003%\t!!)\t\u0013\tmB%!A\u0005\u0002\nu\u0002\"\u0003B&IE\u0005I\u0011AAQ\u0011%\u0011i\u0005JA\u0001\n\u0013\u0011yEA\u0007N_:$\bn\u001d\"fi^,WM\u001c\u0006\u0003]=\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001'M\u0001\tG\u0006$\u0018\r\\=ti*\u0011!gM\u0001\u0004gFd'B\u0001\u001b6\u0003\u0015\u0019\b/\u0019:l\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\u0004\u0001M1\u0001aO C\u000b.\u0003\"\u0001P\u001f\u000e\u00035J!AP\u0017\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002=\u0001&\u0011\u0011)\f\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"\u0001P\"\n\u0005\u0011k#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\u000fA\u0013x\u000eZ;diB\u0011A\n\u0016\b\u0003\u001bJs!AT)\u000e\u0003=S!\u0001U\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015BA*H\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005M;\u0015!\u00023bi\u0016\fT#A-\u0011\u0005qR\u0016BA..\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007I\u0006$X-\r\u0011\u0002\u000b\u0011\fG/\u001a\u001a\u0002\r\u0011\fG/\u001a\u001a!\u0003!\u0011x.\u001e8e\u001f\u001a4\u0017!\u0003:pk:$wJ\u001a4!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002GB\u0019a\t\u001a4\n\u0005\u0015<%AB(qi&|g\u000e\u0005\u0002hW:\u0011\u0001.\u001b\t\u0003\u001d\u001eK!A[$\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U\u001e\u000b1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"R!\u001d:tiV\u0004\"\u0001\u0010\u0001\t\u000b]K\u0001\u0019A-\t\u000buK\u0001\u0019A-\t\u000b}K\u0001\u0019A-\t\u000f\u0005L\u0001\u0013!a\u0001G\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#\u0001=\u0011\u0005\u0019K\u0018B\u0001>H\u0005\u001d\u0011un\u001c7fC:$2!\u001d?~\u0011\u001596\u00021\u0001Z\u0011\u0015i6\u00021\u0001Z)\u0019\tx0!\u0001\u0002\u0004!)q\u000b\u0004a\u00013\")Q\f\u0004a\u00013\")q\f\u0004a\u00013\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f!\"\u001b8qkR$\u0016\u0010]3t+\t\ty\u0001E\u0003M\u0003#\t)\"C\u0002\u0002\u0014Y\u00131aU3r!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000ec\u0005)A/\u001f9fg&!\u0011qDA\r\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t)\u0003\u0005\u0003\u0002\u0018\u0005\u001d\u0012\u0002BA\u0015\u00033\u0011\u0001\u0002R1uCRK\b/Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004\u007f\u0005=\u0002\"B1\u0013\u0001\u00041\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u001b\u0003w\ty$a\u0011\u0011\u0007\u0019\u000b9$C\u0002\u0002:\u001d\u00131!\u00118z\u0011\u001d\tid\u0005a\u0001\u0003k\t!\u0001^\u0019\t\u000f\u0005\u00053\u00031\u0001\u00026\u0005\u0011AO\r\u0005\u0007?N\u0001\r!!\u000e\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA%\u0003+\ny\u0006\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\ty%L\u0001\bG>$WmZ3o\u0013\u0011\t\u0019&!\u0014\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0016\u0015\u0001\u0004\tI&A\u0002dib\u0004B!a\u0013\u0002\\%!\u0011QLA'\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0019\u0015\u0001\u0004\tI%\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\u0019\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000fE\fY'a\u001c\u0002t!1\u0011Q\u000e\fA\u0002e\u000b\u0001B\\3x\r&\u00148\u000f\u001e\u0005\u0007\u0003c2\u0002\u0019A-\u0002\u00139,woU3d_:$\u0007BBA;-\u0001\u0007\u0011,\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u0013E\fY(! \u0002\u0000\u0005\u0005\u0005bB,\u0018!\u0003\u0005\r!\u0017\u0005\b;^\u0001\n\u00111\u0001Z\u0011\u001dyv\u0003%AA\u0002eCq!Y\f\u0011\u0002\u0003\u00071-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d%fA-\u0002\n.\u0012\u00111\u0012\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016\u001e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI*a$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAARU\r\u0019\u0017\u0011R\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0006\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\u0005Y\u0006twM\u0003\u0002\u00024\u0006!!.\u0019<b\u0013\ra\u0017QV\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003w\u00032ARA_\u0013\r\tyl\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003k\t)\rC\u0005\u0002Hz\t\t\u00111\u0001\u0002<\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!4\u0011\r\u0005=\u0017Q[A\u001b\u001b\t\t\tNC\u0002\u0002T\u001e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9.!5\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004q\u0006u\u0007\"CAdA\u0005\u0005\t\u0019AA\u001b\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005%\u00161\u001d\u0005\n\u0003\u000f\f\u0013\u0011!a\u0001\u0003w\u000ba!Z9vC2\u001cHc\u0001=\u0002j\"I\u0011q\u0019\u0012\u0002\u0002\u0003\u0007\u0011Q\u0007\u0015\u0014\u0001\u00055\u00181_A{\u0003s\fY0a@\u0003\u0002\t\u0015!q\u0001\t\u0004y\u0005=\u0018bAAy[\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA|\u0003\r\r!\u0002\t\u0011!A}3UKT\"`QQLW.Z:uC6\u0004\u0018\u0007\f\u0011uS6,7\u000f^1naJZF\u0006\t:pk:$wJ\u001a4^S\u0001j\u0003%\u00134!ARLW.Z:uC6\u0004\u0018\u0007\u0019\u0011jg\u0002b\u0017\r^3sAQD\u0017M\u001c\u0011ai&lWm\u001d;b[B\u0014\u0004\r\f\u0011uQ\u0016t\u0007\u0005\u001e5fAI,7/\u001e7u\u0015\u0001\u0002\u0003\u0005\t\u0011!SN\u0004\u0003o\\:ji&4XM\f\u0011JM\u0002\u0002G/[7fgR\fW\u000e]\u0019aA\u0005tG\r\t1uS6,7\u000f^1naJ\u0002\u0007%\u0019:fA=t\u0007\u0005\u001e5fAM\fW.\u001a\u0011eCf\u0004sN\u001a\u0011n_:$\b\u000e\f\u0011pe\u0002\u0012w\u000e\u001e5\u000bA\u0001\u0002\u0003\u0005\t\u0011be\u0016\u0004C\u000f[3!Y\u0006\u001cH\u000f\t3bs\u0002zg\rI7p]RDG\u0006\t;j[\u0016\u0004sN\u001a\u0011eCf\u0004s/\u001b7mA\t,\u0007%[4o_J,GM\f\u0011Pi\",'o^5tK2\u0002C\u000f[3!I&4g-\u001a:f]\u000e,\u0007%[:\u000bA\u0001\u0002\u0003\u0005\t\u0011dC2\u001cW\u000f\\1uK\u0012\u0004#-Y:fI\u0002zg\u000eI\u001a2A\u0011\f\u0017p\u001d\u0011qKJ\u0004Sn\u001c8uQ2\u0002\u0013M\u001c3!e>,h\u000eZ3eAQ|\u0007\u0005\u000f\u0011eS\u001eLGo\u001d\u0011v]2,7o\u001d\u0011s_VtGm\u00144g{\u0019\fGn]3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0018!!\u001f\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0014(O\u001c.aIj#\u0007\u000f\u00112ai\u001a\u0004G\u000f\u00191O1\u0002s%M\u001d:m5\n\u0004'L\u001a1O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0018:ie*\u0014HN\u001c8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013'O\u001d8[A\u0012TF\r\u001d!cAR4\u0007\r\u001e1a\u001db\u0003eJ\u0019:sYj\u0013\u0007M\u00174a\u001db\u0003EZ1mg\u0016L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a/sQJT'\u000f\u001c8oQ\n\u0014hM\u001b5qUR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u0007\ta\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003\n\u0005)\u0011GL\u001b/a\u0005iQj\u001c8uQN\u0014U\r^<fK:\u0004\"\u0001\u0010\u0013\u0014\u000b\u0011\u0012\tB!\b\u0011\u0013\tM!\u0011D-Z3\u000e\fXB\u0001B\u000b\u0015\r\u00119bR\u0001\beVtG/[7f\u0013\u0011\u0011YB!\u0006\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\u0011\u0011\u0019#!-\u0002\u0005%|\u0017bA+\u0003\"Q\u0011!QB\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011V\u0001\u0006CB\u0004H.\u001f\u000b\nc\nE\"1\u0007B\u001b\u0005oAQaV\u0014A\u0002eCQ!X\u0014A\u0002eCQaX\u0014A\u0002eCq!Y\u0014\u0011\u0002\u0003\u00071-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BAa\u0010\u0003HA!a\t\u001aB!!\u001d1%1I-Z3\u000eL1A!\u0012H\u0005\u0019!V\u000f\u001d7fi!A!\u0011J\u0015\u0002\u0002\u0003\u0007\u0011/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B)!\u0011\tYKa\u0015\n\t\tU\u0013Q\u0016\u0002\u0007\u001f\nTWm\u0019;")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween x$0) {
        return MonthsBetween$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression first() {
        return this.date1();
    }

    @Override
    public Expression second() {
        return this.date2();
    }

    @Override
    public Expression third() {
        return this.roundOff();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.zoneId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(d1, d2, roundOff) -> dtu + ".monthsBetween(" + d1 + ", " + d2 + ", " + roundOff + ", " + zid + ")");
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    @Override
    public MonthsBetween withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.date1();
            }
            case 1: {
                return this.date2();
            }
            case 2: {
                return this.roundOff();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "date1";
            }
            case 1: {
                return "date2";
            }
            case 2: {
                return "roundOff";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

