/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegralType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$DecimalAsIfIntegral$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n      > SELECT INTERVAL '1-1' YEAR TO MONTH _FUNC_ INTERVAL '-1' MONTH;\n       -13\n  ", since="3.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}b\u0001B\u0015+\u0001^B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002C2\u0001\u0005#\u0005\u000b\u0011B.\t\u000b\u0011\u0004A\u0011A3\t\u000b\u0011\u0004A\u0011\u00016\t\u000b5\u0004A\u0011\t8\t\u000bI\u0004A\u0011I:\t\u000bi\u0004A\u0011I>\t\r}\u0004A\u0011IA\u0001\u0011\u001d\t\u0019\u0002\u0001C!\u0003\u0003Aq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005u\u0002\u0001\"\u0011\u0002\u0002!Q\u0011q\b\u0001\t\u0006\u0004%I!!\u0011\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u0011q\u000b\u0001\u0005R\u0005e\u0003\"CA2\u0001\u0005\u0005I\u0011AA3\u0011%\ti\u0007AI\u0001\n\u0003\ty\u0007C\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002p!I\u0011q\u0011\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003\u001b\u0003\u0011\u0011!C!\u0003\u001fC\u0011\"a(\u0001\u0003\u0003%\t!!)\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAV\u0001\u0005\u0005I\u0011IAW\u0011%\tY\fAA\u0001\n\u0003\ti\fC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\"I\u0011q\u0019\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001a\u0005\u000e\u0003\u001b\u0004\u0001\u0013aA\u0001\u0002\u0013%10a4\b\u0013\u0005E(&!A\t\u0002\u0005Mh\u0001C\u0015+\u0003\u0003E\t!!>\t\r\u0011\fC\u0011\u0001B\u0007\u0011%\u0011y!IA\u0001\n\u000b\u0012\t\u0002C\u0005\u0003\u0014\u0005\n\t\u0011\"!\u0003\u0016!I!QD\u0011\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0005?\t\u0013\u0011!CA\u0005CA\u0011Ba\r\"#\u0003%\t!!#\t\u0013\tU\u0012%!A\u0005\n\t]\"AD%oi\u0016<'/\u00197ESZLG-\u001a\u0006\u0003W1\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QFL\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0006M\u0001\u0004gFd'BA\u00193\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000f\u001f@\u000bB\u0011\u0011HO\u0007\u0002U%\u00111H\u000b\u0002\u0011\u0005&t\u0017M]=Be&$\b.\\3uS\u000e\u0004\"!O\u001f\n\u0005yR#A\u0003#jm6{G\rT5lKB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n9\u0001K]8ek\u000e$\bC\u0001$O\u001d\t9EJ\u0004\u0002I\u00176\t\u0011J\u0003\u0002Km\u00051AH]8pizJ\u0011AQ\u0005\u0003\u001b\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0002P!\na1+\u001a:jC2L'0\u00192mK*\u0011Q*Q\u0001\u0005Y\u00164G/F\u0001T!\tID+\u0003\u0002VU\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003!)g/\u00197N_\u0012,W#A.\u0011\u0005q{fBA\u001d^\u0013\tq&&\u0001\u0005Fm\u0006dWj\u001c3f\u0013\t\u0001\u0017MA\u0003WC2,X-\u0003\u0002c\u0003\nYQI\\;nKJ\fG/[8o\u0003%)g/\u00197N_\u0012,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005M\u001eD\u0017\u000e\u0005\u0002:\u0001!)\u0011k\u0002a\u0001'\")qk\u0002a\u0001'\"9\u0011l\u0002I\u0001\u0002\u0004YFc\u00014lY\")\u0011\u000b\u0003a\u0001'\")q\u000b\u0003a\u0001'\u0006\u00192\r[3dW\u0012Kg/\u001b3f\u001fZ,'O\u001a7poV\tq\u000e\u0005\u0002Aa&\u0011\u0011/\u0011\u0002\b\u0005>|G.Z1o\u0003%Ig\u000e];u)f\u0004X-F\u0001u!\t)\b0D\u0001w\u0015\t9h&A\u0003usB,7/\u0003\u0002zm\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\tA\u0010\u0005\u0002v{&\u0011aP\u001e\u0002\t\t\u0006$\u0018\rV=qK\u000611/_7c_2,\"!a\u0001\u0011\t\u0005\u0015\u0011Q\u0002\b\u0005\u0003\u000f\tI\u0001\u0005\u0002I\u0003&\u0019\u00111B!\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0005\u0003\rM#(/\u001b8h\u0015\r\tY!Q\u0001\u000eI\u0016\u001c\u0017.\\1m\u001b\u0016$\bn\u001c3\u00021\u0011,7-[7bYR{G)\u0019;b)f\u0004XmQ8eK\u001e+g\u000e\u0006\u0003\u0002\u0004\u0005e\u0001bBA\u000e\u001d\u0001\u0007\u00111A\u0001\u000eI\u0016\u001c\u0017.\\1m%\u0016\u001cX\u000f\u001c;\u0002#I,7/\u001e7u\t\u0016\u001c\u0017.\\1m)f\u0004X\r\u0006\u0006\u0002\"\u0005\u001d\u0012\u0011GA\u001b\u0003s\u00012!^A\u0012\u0013\r\t)C\u001e\u0002\f\t\u0016\u001c\u0017.\\1m)f\u0004X\rC\u0004\u0002*=\u0001\r!a\u000b\u0002\u0005A\f\u0004c\u0001!\u0002.%\u0019\u0011qF!\u0003\u0007%sG\u000fC\u0004\u00024=\u0001\r!a\u000b\u0002\u0005M\f\u0004bBA\u001c\u001f\u0001\u0007\u00111F\u0001\u0003aJBq!a\u000f\u0010\u0001\u0004\tY#\u0001\u0002te\u0005Y1/\u001d7Pa\u0016\u0014\u0018\r^8s\u0003\r!\u0017N^\u000b\u0003\u0003\u0007\u0002\u0012\u0002QA#\u0003\u0013\nI%!\u0013\n\u0007\u0005\u001d\u0013IA\u0005Gk:\u001cG/[8oeA\u0019\u0001)a\u0013\n\u0007\u00055\u0013IA\u0002B]f\fQ\"\u001a<bY>\u0003XM]1uS>tGCBA%\u0003'\n)\u0006\u0003\u0004R%\u0001\u0007\u0011\u0011\n\u0005\u0007/J\u0001\r!!\u0013\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00024\u0002\\\u0005}\u0003BBA/'\u0001\u00071+A\u0004oK^dUM\u001a;\t\r\u0005\u00054\u00031\u0001T\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$rAZA4\u0003S\nY\u0007C\u0004R)A\u0005\t\u0019A*\t\u000f]#\u0002\u0013!a\u0001'\"9\u0011\f\u0006I\u0001\u0002\u0004Y\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003cR3aUA:W\t\t)\b\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\u0013Ut7\r[3dW\u0016$'bAA@\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0015\u0011\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYIK\u0002\\\u0003g\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000bA\u0001\\1oO*\u0011\u00111T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0005U\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0016\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0013\u0002(\"I\u0011\u0011\u0016\u000e\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0006CBAY\u0003o\u000bI%\u0004\u0002\u00024*\u0019\u0011QW!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0006M&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a\\A`\u0011%\tI\u000bHA\u0001\u0002\u0004\tI%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAI\u0003\u000bD\u0011\"!+\u001e\u0003\u0003\u0005\r!a\u000b\u0002\r\u0015\fX/\u00197t)\ry\u00171\u001a\u0005\n\u0003Ss\u0012\u0011!a\u0001\u0003\u0013\nab];qKJ$C-\u0019;b)f\u0004X-\u0003\u0002{u!\u001a\u0002!a5\u0002Z\u0006m\u0017q\\Aq\u0003K\f9/a;\u0002nB\u0019\u0011(!6\n\u0007\u0005]'FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005u\u0017!!\u0003fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011ESZLG-\u001a\u0011aKb\u0004(/\r1!Ef\u0004\u0003-\u001a=qeJ\u0002g\u0006I%uAI,G/\u001e:og\u0002rU\u000b\u0014'!S\u001a\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018M\u001c3!SN\u0004c*\u0016'MA=\u0014\b\u0005Y3yaJ\u0014\u0004\rI5tAAr\u0003\u0005\u00165fAI,7/\u001e7uA%\u001c\beY1ti\u0016$\u0007\u0005^8!Y>twML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111]\u0001\u0002\u0012)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033\u0007I0G+:\u001bu\f\t\u001a<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u0013(U\u000bJ3\u0016\t\u0014\u0011(c5\nt\u0005I-F\u0003J\u0003Ck\u0014\u0011N\u001f:#\u0006\nI0G+:\u001bu\fI%O)\u0016\u0013f+\u0011'!O5\nt\u0005I'P\u001dRC5H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00172g)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002j\u0006)1G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011q^\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\u0018AD%oi\u0016<'/\u00197ESZLG-\u001a\t\u0003s\u0005\u001aR!IA|\u0005\u0007\u0001\u0002\"!?\u0002\u0000N\u001b6LZ\u0007\u0003\u0003wT1!!@B\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0001\u0002|\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQAA!\u0003\u0002\u001a\u0006\u0011\u0011n\\\u0005\u0004\u001f\n\u001dACAAz\u0003!!xn\u0015;sS:<GCAAI\u0003\u0015\t\u0007\u000f\u001d7z)\u001d1'q\u0003B\r\u00057AQ!\u0015\u0013A\u0002MCQa\u0016\u0013A\u0002MCq!\u0017\u0013\u0011\u0002\u0003\u00071,A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BAa\t\u00030A)\u0001I!\n\u0003*%\u0019!qE!\u0003\r=\u0003H/[8o!\u0019\u0001%1F*T7&\u0019!QF!\u0003\rQ+\b\u000f\\34\u0011!\u0011\tDJA\u0001\u0002\u00041\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u000f\u0011\t\u0005M%1H\u0005\u0005\u0005{\t)J\u0001\u0004PE*,7\r\u001e")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private final Enumeration.Value evalMode;
    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    private volatile byte bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$3() {
        return IntegralDivide$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Enumeration.Value>> unapply(IntegralDivide x$0) {
        return IntegralDivide$.MODULE$.unapply(x$0);
    }

    public static Enumeration.Value apply$default$3() {
        return IntegralDivide$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Enumeration.Value>, IntegralDivide> tupled() {
        return IntegralDivide$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Enumeration.Value, IntegralDivide>>> curried() {
        return IntegralDivide$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ DataType org$apache$spark$sql$catalyst$expressions$DivModLike$$super$dataType() {
        return super.dataType();
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero = DivModLike.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    private /* synthetic */ DataType super$dataType() {
        return super.dataType();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    @Override
    public boolean checkDivideOverflow() {
        DataType dataType = this.left().dataType();
        return LongType$.MODULE$.equals(dataType) && this.failOnError();
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, DecimalType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return decimalResult + ".toLong()";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int intDig = p1 - s1 + s2;
        return DecimalType$.MODULE$.bounded(intDig == 0 ? 1 : intDig, 0);
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DecimalType decimalType;
                Option option;
                Decimal$DecimalAsIfIntegral$ decimal$DecimalAsIfIntegral$;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    decimal$DecimalAsIfIntegral$ = PhysicalIntegralType$.MODULE$.integral(integralType);
                } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    decimal$DecimalAsIfIntegral$ = PhysicalDecimalType$.MODULE$.apply(p, s).asIntegral();
                } else if (dataType instanceof YearMonthIntervalType) {
                    decimal$DecimalAsIfIntegral$ = PhysicalIntegerType$.MODULE$.integral();
                } else if (dataType instanceof DayTimeIntervalType) {
                    decimal$DecimalAsIfIntegral$ = PhysicalLongType$.MODULE$.integral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Decimal$DecimalAsIfIntegral$ integral = decimal$DecimalAsIfIntegral$;
                this.div = (Function2 & Serializable)(x, y) -> {
                    Object res;
                    DecimalType decimalType;
                    Option option;
                    DataType dataType = this.super$dataType();
                    if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                        int precision = ((Tuple2)option.get())._1$mcI$sp();
                        int scale = ((Tuple2)option.get())._2$mcI$sp();
                        v0 = this.checkDecimalOverflow((Decimal)integral.quot(x, y), precision, scale);
                    } else {
                        v0 = res = integral.quot(x, y);
                    }
                    if (res == null) {
                        return null;
                    }
                    return BoxesRunTime.boxToLong((long)integral.toLong(res));
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.div$lzycompute();
        }
        return this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    @Override
    public IntegralDivide withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public IntegralDivide copy(Expression left, Expression right, Enumeration.Value evalMode) {
        return new IntegralDivide(left, right, evalMode);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Enumeration.Value copy$default$3() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalMode();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "evalMode";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = integralDivide.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right, Enumeration.Value evalMode) {
        this.left = left;
        this.right = right;
        this.evalMode = evalMode;
        DivModLike.$init$(this);
    }

    public IntegralDivide(Expression left, Expression right) {
        this(left, right, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

