/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateAdd$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(start_date, num_days) - Returns the date that is `num_days` after `start_date`.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-07-30', 1);\n       2016-07-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015Q\u0006\u0001\"\u0011J\u0011\u0015Y\u0006\u0001\"\u0011J\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\b\u0001\t#\ny\u0002C\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,!I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u0013\u0002\u0011\u0013!C\u0001\u0003gA\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\ty\u0007AA\u0001\n\u0003\n\t\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\"I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001b;\u0011\"!-\"\u0003\u0003E\t!a-\u0007\u0011\u0001\n\u0013\u0011!E\u0001\u0003kCa\u0001\u0015\u000e\u0005\u0002\u00055\u0007\"CAh5\u0005\u0005IQIAi\u0011%\t\u0019NGA\u0001\n\u0003\u000b)\u000eC\u0005\u0002\\j\t\t\u0011\"!\u0002^\"I\u0011q\u001e\u000e\u0002\u0002\u0013%\u0011\u0011\u001f\u0002\b\t\u0006$X-\u00113e\u0015\t\u00113%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0013&\u0003!\u0019\u0017\r^1msN$(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011#\u0002\u00010gYb\u0004C\u0001\u00192\u001b\u0005\t\u0013B\u0001\u001a\"\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$a\u0002)s_\u0012,8\r\u001e\t\u0003{\u0015s!AP\"\u000f\u0005}\u0012U\"\u0001!\u000b\u0005\u0005k\u0013A\u0002\u001fs_>$h(C\u0001:\u0013\t!\u0005(A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019;%\u0001D*fe&\fG.\u001b>bE2,'B\u0001#9\u0003%\u0019H/\u0019:u\t\u0006$X-F\u0001K!\t\u00014*\u0003\u0002MC\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0015M$\u0018M\u001d;ECR,\u0007%\u0001\u0003eCf\u001c\u0018!\u00023bsN\u0004\u0013A\u0002\u001fj]&$h\bF\u0002S'R\u0003\"\u0001\r\u0001\t\u000b!+\u0001\u0019\u0001&\t\u000b9+\u0001\u0019\u0001&\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\tq\u000b\u0005\u000281&\u0011\u0011\f\u000f\u0002\b\u0005>|G.Z1o\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001_!\rit,Y\u0005\u0003A\u001e\u00131aU3r!\t\u0011W-D\u0001d\u0015\t!W%A\u0003usB,7/\u0003\u0002gG\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0011\u000e\u0005\u0002cU&\u00111n\u0019\u0002\t\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019a.]:\u0011\u0005]z\u0017B\u000199\u0005\r\te.\u001f\u0005\u0006e.\u0001\rA\\\u0001\u0006gR\f'\u000f\u001e\u0005\u0006i.\u0001\rA\\\u0001\u0002I\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005ov\f)\u0001\u0005\u0002yw6\t\u0011P\u0003\u0002{C\u000591m\u001c3fO\u0016t\u0017B\u0001?z\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002@\r\u0001\u0004y\u0018aA2uqB\u0019\u00010!\u0001\n\u0007\u0005\r\u0011P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u001dA\u00021\u0001x\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0004\u0011\t\u0005=\u0011q\u0003\b\u0005\u0003#\t\u0019\u0002\u0005\u0002@q%\u0019\u0011Q\u0003\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)\u0002O\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$RAUA\u0011\u0003KAa!a\t\u000f\u0001\u0004Q\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003Oq\u0001\u0019\u0001&\u0002\u00119,wOU5hQR\fAaY8qsR)!+!\f\u00020!9\u0001j\u0004I\u0001\u0002\u0004Q\u0005b\u0002(\u0010!\u0003\u0005\rAS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)DK\u0002K\u0003oY#!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007B\u0014AC1o]>$\u0018\r^5p]&!\u0011qIA\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006LA!!\u0007\u0002T\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\r\t\u0004o\u0005\r\u0014bAA3q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a.a\u001b\t\u0013\u00055D#!AA\u0002\u0005\u0005\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002tA)\u0011QOA>]6\u0011\u0011q\u000f\u0006\u0004\u0003sB\u0014AC2pY2,7\r^5p]&!\u0011QPA<\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007]\u000b\u0019\t\u0003\u0005\u0002nY\t\t\u00111\u0001o\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u0013\u0011\u0012\u0005\n\u0003[:\u0012\u0011!a\u0001\u0003C\na!Z9vC2\u001cHcA,\u0002\u0010\"A\u0011Q\u000e\r\u0002\u0002\u0003\u0007a\u000eK\n\u0001\u0003'\u000bI*a'\u0002 \u0006\u0005\u0016QUAT\u0003W\u000bi\u000bE\u00021\u0003+K1!a&\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!(\u0002-~3UKT\"`QM$\u0018M\u001d;`I\u0006$X\r\f\u0011ok6|F-Y=tS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\"\u0017\r^3!i\"\fG\u000fI5tA\u0001tW/\\0eCf\u001c\b\rI1gi\u0016\u0014\b\u0005Y:uCJ$x\fZ1uK\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0016a\u0013\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00171o5\u001a\u0004g\n\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\u0002t'L\u001a2\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAU\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a,\u0002\u000bErSG\f\u0019\u0002\u000f\u0011\u000bG/Z!eIB\u0011\u0001GG\n\u00065\u0005]\u00161\u0019\t\b\u0003s\u000byL\u0013&S\u001b\t\tYLC\u0002\u0002>b\nqA];oi&lW-\u0003\u0003\u0002B\u0006m&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011QYAf\u001b\t\t9M\u0003\u0003\u0002J\u0006]\u0013AA5p\u0013\r1\u0015q\u0019\u000b\u0003\u0003g\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\nQ!\u00199qYf$RAUAl\u00033DQ\u0001S\u000fA\u0002)CQAT\u000fA\u0002)\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002`\u0006-\b#B\u001c\u0002b\u0006\u0015\u0018bAArq\t1q\n\u001d;j_:\u0004RaNAt\u0015*K1!!;9\u0005\u0019!V\u000f\u001d7fe!A\u0011Q\u001e\u0010\u0002\u0002\u0003\u0007!+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a=\u0011\t\u0005E\u0013Q_\u0005\u0005\u0003o\f\u0019F\u0001\u0004PE*,7\r\u001e")
public class DateAdd
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression startDate;
    private final Expression days;

    public static Option<Tuple2<Expression, Expression>> unapply(DateAdd x$0) {
        return DateAdd$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, DateAdd> tupled() {
        return DateAdd$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, DateAdd>> curried() {
        return DateAdd$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression days() {
        return this.days;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.days();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$})), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object start, Object d) {
        return BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)start) + ((Number)d).intValue()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(sd, d) -> ev.value() + " = " + sd + " + " + d + ";");
    }

    @Override
    public String prettyName() {
        return "date_add";
    }

    @Override
    public DateAdd withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public DateAdd copy(Expression startDate, Expression days) {
        return new DateAdd(startDate, days);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.days();
    }

    @Override
    public String productPrefix() {
        return "DateAdd";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.startDate();
            }
            case 1: {
                return this.days();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateAdd;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "startDate";
            }
            case 1: {
                return "days";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateAdd)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateAdd dateAdd = (DateAdd)x$1;
        Expression expression = this.startDate();
        Expression expression2 = dateAdd.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.days();
        Expression expression4 = dateAdd.days();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!dateAdd.canEqual(this)) return false;
        return true;
    }

    public DateAdd(Expression startDate, Expression days) {
        this.startDate = startDate;
        this.days = days;
        ExpectsInputTypes.$init$(this);
    }
}

