/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.QueryPlanningTracker$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.resolver.AnalyzerBridgeState;
import org.apache.spark.sql.catalyst.analysis.resolver.AnalyzerBridgeState$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.HybridAnalyzer$;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolverGuard;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolverRunner;
import org.apache.spark.sql.catalyst.plans.NormalizePlan$;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u0010!\u0001=B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A\u0011\u0005\u0001B\u0001B\u0003%A\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!\u0011\u0007A!A!\u0002\u0013\u0019\u0007\"\u00024\u0001\t\u00039\u0007b\u00028\u0001\u0001\u0004%Ia\u001c\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011\u0019Q\b\u0001)Q\u0005a\"91\u0010\u0001a\u0001\n\u0013y\u0007b\u0002?\u0001\u0001\u0004%I! \u0005\u0007\u007f\u0002\u0001\u000b\u0015\u00029\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u0006\u0001\u0001\u0006I!!\u0002\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!1\u0011q\u0004\u0001\u0005\u0002=Da!!\t\u0001\t\u0003y\u0007bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003o\u0001A\u0011BA\u001d\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA3\u0001\u0011%\u0011qM\u0004\n\u0003\u001b\u0003\u0013\u0011!E\u0001\u0003\u001f3\u0001b\b\u0011\u0002\u0002#\u0005\u0011\u0011\u0013\u0005\u0007Mn!\t!a%\t\u0013\u0005U5$%A\u0005\u0002\u0005]\u0005\"CAW7E\u0005I\u0011AAX\u00059A\u0015P\u0019:jI\u0006s\u0017\r\\={KJT!!\t\u0012\u0002\u0011I,7o\u001c7wKJT!a\t\u0013\u0002\u0011\u0005t\u0017\r\\=tSNT!!\n\u0014\u0002\u0011\r\fG/\u00197zgRT!a\n\u0015\u0002\u0007M\fHN\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00197!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fMB\u0011q\u0007O\u0007\u0002I%\u0011\u0011\b\n\u0002\u000e'Fc5i\u001c8g\u0011\u0016d\u0007/\u001a:\u0002\u001d1,w-Y2z\u0003:\fG.\u001f>feB\u0011A(P\u0007\u0002E%\u0011aH\t\u0002\t\u0003:\fG.\u001f>fe\u0006i!/Z:pYZ,'oR;be\u0012\u0004\"!\u0011\"\u000e\u0003\u0001J!a\u0011\u0011\u0003\u001bI+7o\u001c7wKJ<U/\u0019:e!\t\tU)\u0003\u0002GA\tA!+Z:pYZ,'/\u0001\rfqR,g\u000eZ3e%\u0016\u001cx\u000e\\;uS>t7\t[3dWN\u00042!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N]\u00051AH]8pizJ\u0011aM\u0005\u0003!J\nq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A\u0013\u0004\u0003B\u0019V/~K!A\u0016\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u001dawnZ5dC2T!\u0001\u0018\u0013\u0002\u000bAd\u0017M\\:\n\u0005yK&a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"!\r1\n\u0005\u0005\u0014$\u0001B+oSR\f\u0001e\u00195fG.\u001cV\u000f\u001d9peR,GmU5oO2,\u0007+Y:t\r\u0016\fG/\u001e:fgB\u0011\u0011\u0007Z\u0005\u0003KJ\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0007Q&T7\u000e\\7\u0011\u0005\u0005\u0003\u0001\"\u0002\u001e\u0007\u0001\u0004Y\u0004\"B \u0007\u0001\u0004\u0001\u0005\"B\u0011\u0007\u0001\u0004!\u0005bB$\u0007!\u0003\u0005\r\u0001\u0013\u0005\bE\u001a\u0001\n\u00111\u0001d\u0003q\u0019\u0018N\\4mKB\u000b7o\u001d*fg>dW\u000f^5p]\u0012+(/\u0019;j_:,\u0012\u0001\u001d\t\u0004cE\u001c\u0018B\u0001:3\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u0007^\u0005\u0003kJ\u0012A\u0001T8oO\u0006\u00013/\u001b8hY\u0016\u0004\u0016m]:SKN|G.\u001e;j_:$UO]1uS>tw\fJ3r)\ty\u0006\u0010C\u0004z\u0011\u0005\u0005\t\u0019\u00019\u0002\u0007a$\u0013'A\u000ftS:<G.\u001a)bgN\u0014Vm]8mkRLwN\u001c#ve\u0006$\u0018n\u001c8!\u0003q1\u0017\u000e_3e!>Lg\u000e\u001e*fg>dW\u000f^5p]\u0012+(/\u0019;j_:\f\u0001EZ5yK\u0012\u0004v.\u001b8u%\u0016\u001cx\u000e\\;uS>tG)\u001e:bi&|gn\u0018\u0013fcR\u0011qL \u0005\bs.\t\t\u00111\u0001q\u0003u1\u0017\u000e_3e!>Lg\u000e\u001e*fg>dW\u000f^5p]\u0012+(/\u0019;j_:\u0004\u0013A\u0004:fg>dg/\u001a:Sk:tWM]\u000b\u0003\u0003\u000b\u00012!QA\u0004\u0013\r\tI\u0001\t\u0002\u000f%\u0016\u001cx\u000e\u001c<feJ+hN\\3s\u0003=\u0011Xm]8mm\u0016\u0014(+\u001e8oKJ\u0004\u0013!B1qa2LH#B,\u0002\u0012\u0005U\u0001BBA\n\u001f\u0001\u0007q+\u0001\u0003qY\u0006t\u0007bBA\f\u001f\u0001\u0007\u0011\u0011D\u0001\biJ\f7m[3s!\r9\u00141D\u0005\u0004\u0003;!#\u0001F)vKJL\b\u000b\\1o]&tw\r\u0016:bG.,'/A\u0010hKR\u001c\u0016N\\4mKB\u000b7o\u001d*fg>dW\u000f^5p]\u0012+(/\u0019;j_:\fqdZ3u\r&DX\r\u001a)pS:$(+Z:pYV$\u0018n\u001c8EkJ\fG/[8o\u0003y9\u0018\u000e\u001e5Ue\u0006\u001c7.\u001a3B]\u0006d\u0017P_3s\u0005JLGmZ3Ti\u0006$X\r\u0006\u0003\u0002(\u0005MBcA,\u0002*!A\u00111\u0006\n\u0005\u0002\u0004\ti#\u0001\u0003c_\u0012L\b\u0003B\u0019\u00020]K1!!\r3\u0005!a$-\u001f8b[\u0016t\u0004BBA\u001b%\u0001\u00071-A\u0004ek\u0006d'+\u001e8\u0002!I,7o\u001c7wK&sG)^1m%VtG#B,\u0002<\u0005u\u0002BBA\n'\u0001\u0007q\u000bC\u0004\u0002\u0018M\u0001\r!!\u0007\u0002'I,7o\u001c7wK&s7+\u001b8hY\u0016\u0004\u0016m]:\u0015\u0007]\u000b\u0019\u0005\u0003\u0004\u0002\u0014Q\u0001\raV\u0001\u0014e\u0016\u001cx\u000e\u001c<f\u0013:4\u0015\u000e_3e!>Lg\u000e\u001e\u000b\u0006/\u0006%\u00131\n\u0005\u0007\u0003')\u0002\u0019A,\t\u000f\u0005]Q\u00031\u0001\u0002\u001a\u0005!b/\u00197jI\u0006$X\rT8hS\u000e\fG\u000e\u00157b]N$RaXA)\u0003+Ba!a\u0015\u0017\u0001\u00049\u0016\u0001\u00054jq\u0016$\u0007k\\5oiJ+7/\u001e7u\u0011\u0019\t9F\u0006a\u0001/\u0006\u00012/\u001b8hY\u0016\u0004\u0016m]:SKN,H\u000e^\u0001\u000e]>\u0014X.\u00197ju\u0016\u0004F.\u00198\u0015\u0007]\u000bi\u0006\u0003\u0004\u0002\u0014]\u0001\raV\u0001\u0013G\",7m\u001b*fg>dg/\u001a:Hk\u0006\u0014H\rF\u0002d\u0003GBa!a\u0005\u0019\u0001\u00049\u0016A\u0004:fG>\u0014H\rR;sCRLwN\\\u000b\u0005\u0003S\n)\b\u0006\u0003\u0002l\u0005\u001d\u0005CB\u0019\u0002nM\f\t(C\u0002\u0002pI\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA:\u0003kb\u0001\u0001B\u0004\u0002xe\u0011\r!!\u001f\u0003\u0003Q\u000bB!a\u001f\u0002\u0002B\u0019\u0011'! \n\u0007\u0005}$GA\u0004O_RD\u0017N\\4\u0011\u0007E\n\u0019)C\u0002\u0002\u0006J\u00121!\u00118z\u0011!\tI)\u0007CA\u0002\u0005-\u0015!\u0002;ik:\\\u0007#B\u0019\u00020\u0005E\u0014A\u0004%zEJLG-\u00118bYfTXM\u001d\t\u0003\u0003n\u0019\"a\u0007\u0019\u0015\u0005\u0005=\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u001a*\u001a\u0001*a',\u0005\u0005u\u0005\u0003BAP\u0003Sk!!!)\u000b\t\u0005\r\u0016QU\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a*3\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\u000b\tKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAAYU\r\u0019\u00171\u0014")
public class HybridAnalyzer
implements SQLConfHelper {
    private final Analyzer legacyAnalyzer;
    private final ResolverGuard resolverGuard;
    private final boolean checkSupportedSinglePassFeatures;
    private Option<Object> singlePassResolutionDuration;
    private Option<Object> fixedPointResolutionDuration;
    private final ResolverRunner resolverRunner;

    public static boolean $lessinit$greater$default$5() {
        return HybridAnalyzer$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<Function1<LogicalPlan, BoxedUnit>> $lessinit$greater$default$4() {
        return HybridAnalyzer$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private Option<Object> singlePassResolutionDuration() {
        return this.singlePassResolutionDuration;
    }

    private void singlePassResolutionDuration_$eq(Option<Object> x$1) {
        this.singlePassResolutionDuration = x$1;
    }

    private Option<Object> fixedPointResolutionDuration() {
        return this.fixedPointResolutionDuration;
    }

    private void fixedPointResolutionDuration_$eq(Option<Object> x$1) {
        this.fixedPointResolutionDuration = x$1;
    }

    private ResolverRunner resolverRunner() {
        return this.resolverRunner;
    }

    public LogicalPlan apply(LogicalPlan plan2, QueryPlanningTracker tracker) {
        boolean dualRun = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_DUAL_RUN_LEGACY_AND_SINGLE_PASS_RESOLVER())) && this.checkResolverGuard(plan2);
        return this.withTrackedAnalyzerBridgeState(dualRun, (Function0<LogicalPlan>)(Function0 & Serializable)() -> {
            if (dualRun) {
                return this.resolveInDualRun(plan2, tracker);
            }
            if (BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_SINGLE_PASS_RESOLVER_ENABLED()))) {
                return this.resolveInSinglePass(plan2);
            }
            return this.resolveInFixedPoint(plan2, tracker);
        });
    }

    public Option<Object> getSinglePassResolutionDuration() {
        return this.singlePassResolutionDuration();
    }

    public Option<Object> getFixedPointResolutionDuration() {
        return this.fixedPointResolutionDuration();
    }

    private LogicalPlan withTrackedAnalyzerBridgeState(boolean dualRun, Function0<LogicalPlan> body) {
        LogicalPlan logicalPlan;
        boolean bridgeRelations = dualRun && BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_SINGLE_PASS_RESOLVER_RELATION_BRIDGING_ENABLED()));
        Option<AnalyzerBridgeState> prevSinglePassResolverBridgeState = AnalysisContext$.MODULE$.get().getSinglePassResolverBridgeState();
        AnalysisContext$.MODULE$.get().setSinglePassResolverBridgeState((Option<AnalyzerBridgeState>)(bridgeRelations ? new Some((Object)new AnalyzerBridgeState(AnalyzerBridgeState$.MODULE$.$lessinit$greater$default$1())) : None$.MODULE$));
        try {
            logicalPlan = (LogicalPlan)body.apply();
        }
        finally {
            AnalysisContext$.MODULE$.get().setSinglePassResolverBridgeState(prevSinglePassResolverBridgeState);
        }
        return logicalPlan;
    }

    private LogicalPlan resolveInDualRun(LogicalPlan plan2, QueryPlanningTracker tracker) {
        None$ none$;
        None$ none$2;
        None$ fixedPointException = None$.MODULE$;
        try {
            Tuple2 tuple2 = this.recordDuration((Function0 & Serializable)() -> new Some((Object)this.resolveInFixedPoint(plan2, tracker)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long resolutionDuration = tuple2._1$mcJ$sp();
            Some result = (Some)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)resolutionDuration), (Object)result);
            long resolutionDuration2 = tuple22._1$mcJ$sp();
            Some result2 = (Some)tuple22._2();
            this.fixedPointResolutionDuration_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)resolutionDuration2)));
            none$2 = result2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                fixedPointException = new Some((Object)throwable2);
                none$2 = None$.MODULE$;
            }
            throw throwable;
        }
        None$ fixedPointResult = none$2;
        None$ singlePassException = None$.MODULE$;
        try {
            Tuple2 tuple2 = this.recordDuration((Function0 & Serializable)() -> new Some((Object)this.resolveInSinglePass(plan2)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long resolutionDuration = tuple2._1$mcJ$sp();
            Some result = (Some)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)resolutionDuration), (Object)result);
            long resolutionDuration3 = tuple23._1$mcJ$sp();
            Some result3 = (Some)tuple23._2();
            this.singlePassResolutionDuration_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)resolutionDuration3)));
            none$ = result3;
        }
        catch (Throwable throwable) {
            Throwable throwable4;
            Throwable throwable5 = throwable;
            if (throwable5 != null && NonFatal$.MODULE$.apply(throwable4 = throwable5)) {
                singlePassException = new Some((Object)throwable4);
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        None$ singlePassResult = none$;
        None$ none$3 = fixedPointException;
        if (none$3 instanceof Some) {
            Some some = (Some)none$3;
            Throwable fixedPointEx = (Throwable)some.value();
            None$ none$4 = singlePassException;
            if (none$4 instanceof Some) {
                throw fixedPointEx;
            }
            if (None$.MODULE$.equals(none$4)) {
                throw QueryCompilationErrors$.MODULE$.fixedPointFailedSinglePassSucceeded((LogicalPlan)singlePassResult.get(), fixedPointEx);
            }
            throw new MatchError((Object)none$4);
        }
        if (None$.MODULE$.equals(none$3)) {
            boolean bl = false;
            Some some = null;
            None$ none$5 = singlePassException;
            if (none$5 instanceof Some) {
                bl = true;
                some = (Some)none$5;
                Throwable singlePassEx = (Throwable)some.value();
                if (singlePassEx instanceof ExplicitlyUnsupportedResolverFeature && this.checkSupportedSinglePassFeatures) {
                    return (LogicalPlan)fixedPointResult.get();
                }
            }
            if (bl) {
                Throwable singlePassEx = (Throwable)some.value();
                throw singlePassEx;
            }
            if (None$.MODULE$.equals(none$5)) {
                this.validateLogicalPlans((LogicalPlan)fixedPointResult.get(), (LogicalPlan)singlePassResult.get());
                if (BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ANALYZER_DUAL_RUN_RETURN_SINGLE_PASS_RESULT()))) {
                    return (LogicalPlan)singlePassResult.get();
                }
                return (LogicalPlan)fixedPointResult.get();
            }
            throw new MatchError((Object)none$5);
        }
        throw new MatchError((Object)none$3);
    }

    private LogicalPlan resolveInSinglePass(LogicalPlan plan2) {
        return this.resolverRunner().resolve(plan2, AnalysisContext$.MODULE$.get().getSinglePassResolverBridgeState());
    }

    private LogicalPlan resolveInFixedPoint(LogicalPlan plan2, QueryPlanningTracker tracker) {
        LogicalPlan resolvedPlan = this.legacyAnalyzer.executeAndTrack(plan2, tracker);
        QueryPlanningTracker$.MODULE$.withTracker(tracker, (JFunction0.mcV.sp & Serializable)() -> $this.legacyAnalyzer.checkAnalysis(resolvedPlan));
        return resolvedPlan;
    }

    private void validateLogicalPlans(LogicalPlan fixedPointResult, LogicalPlan singlePassResult) {
        StructType structType = fixedPointResult.schema();
        StructType structType2 = singlePassResult.schema();
        if (structType == null ? structType2 != null : !structType.equals(structType2)) {
            throw QueryCompilationErrors$.MODULE$.hybridAnalyzerOutputSchemaComparisonMismatch(fixedPointResult.schema(), singlePassResult.schema());
        }
        LogicalPlan logicalPlan = this.normalizePlan(fixedPointResult);
        LogicalPlan logicalPlan2 = this.normalizePlan(singlePassResult);
        if (logicalPlan == null ? logicalPlan2 != null : !logicalPlan.equals(logicalPlan2)) {
            throw QueryCompilationErrors$.MODULE$.hybridAnalyzerLogicalPlanComparisonMismatch(fixedPointResult, singlePassResult);
        }
    }

    private LogicalPlan normalizePlan(LogicalPlan plan2) {
        return (LogicalPlan)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0 & Serializable)() -> NormalizePlan$.MODULE$.apply(plan2));
    }

    private boolean checkResolverGuard(LogicalPlan plan2) {
        return !this.checkSupportedSinglePassFeatures || this.resolverGuard.apply(plan2);
    }

    private <T> Tuple2<Object, T> recordDuration(Function0<T> thunk) {
        long start = System.nanoTime();
        Object res = thunk.apply();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.nanoTime() - start)), res);
    }

    public HybridAnalyzer(Analyzer legacyAnalyzer, ResolverGuard resolverGuard, Resolver resolver, Seq<Function1<LogicalPlan, BoxedUnit>> extendedResolutionChecks, boolean checkSupportedSinglePassFeatures) {
        this.legacyAnalyzer = legacyAnalyzer;
        this.resolverGuard = resolverGuard;
        this.checkSupportedSinglePassFeatures = checkSupportedSinglePassFeatures;
        SQLConfHelper.$init$(this);
        this.singlePassResolutionDuration = None$.MODULE$;
        this.fixedPointResolutionDuration = None$.MODULE$;
        this.resolverRunner = new ResolverRunner(resolver, extendedResolutionChecks);
    }
}

