/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.sql.artifact.ArtifactManager$;
import org.apache.spark.sql.connect.service.ExecuteEventsManager;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.utils.ErrorUtils$;
import org.apache.spark.sql.util.ArtifactUtils$;
import org.apache.spark.util.Utils$;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.guava.io.CountingOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tmh\u0001\u0002%J\u0001YC\u0001\u0002\u001d\u0001\u0003\u0006\u0004%\t!\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005e\")q\u000f\u0001C\u0001q\"9A\u0010\u0001b\u0001\n#i\bbBA\u0007\u0001\u0001\u0006IA \u0005\n\u0003\u001f\u0001!\u0019!C\t\u0003#A\u0001Ba\u0013\u0001A\u0003%\u00111\u0003\u0005\f\u0005\u001b\u0002\u0001\u0019!a\u0001\n\u0013\u0011y\u0005C\u0006\u0003\u0014\u0002\u0001\r\u00111A\u0005\n\tU\u0005b\u0003BM\u0001\u0001\u0007\t\u0011)Q\u0005\u0005#B1Ba'\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u001e\"Y!Q\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002BT\u0011-\u0011Y\u000b\u0001a\u0001\u0002\u0003\u0006KAa(\t\u000f\t5\u0006\u0001\"\u0011\u00030\"9!Q\u0017\u0001\u0005B\t]\u0006b\u0002Bh\u0001\u0011E!\u0011\u001b\u0005\b\u0005/\u0004A\u0011\u0003Bm\u0011\u001d\u0011\t\u000f\u0001C\t\u0005\u000bBqAa9\u0001\t\u0003\u0012)\u0005C\u0004\u0003f\u0002!IAa:\t\u000f\t\u0015\b\u0001\"\u0003\u0003r\u001a1\u00111\u0006\u0001\u0001\u0003[A!\"a\u000e\u0017\u0005\u000b\u0007I\u0011AA\u001d\u0011)\t\tF\u0006B\u0001B\u0003%\u00111\b\u0005\u0007oZ!\t!a\u0015\t\u0019\u0005]c\u0003%A\u0001\u0004\u0003\u0006I!!\u0017\t\u0013\u0005%dC1A\u0005\u0002\u0005e\u0002\u0002CA6-\u0001\u0006I!a\u000f\t\u0013\u00055dC1A\u0005\u0002\u0005=\u0004\u0002CA:-\u0001\u0006I!!\u001d\t\u0011\u0005UdC1A\u0005\u0002uDq!a\u001e\u0017A\u0003%a\u0010\u0003\u0005\u0002zY\u0011\r\u0011\"\u0001~\u0011\u001d\tYH\u0006Q\u0001\nyD\u0011\"! \u0017\u0005\u0004%I!a \t\u0011\u0005-e\u0003)A\u0005\u0003\u0003C\u0011\"!$\u0017\u0005\u0004%I!a$\t\u0011\u0005\u001df\u0003)A\u0005\u0003#C\u0011\"!+\u0017\u0005\u0004%I!a+\t\u0011\u0005uf\u0003)A\u0005\u0003[C\u0011\"a0\u0017\u0005\u0004%I!!1\t\u0011\u00055h\u0003)A\u0005\u0003\u0007D1\"a<\u0017\u0001\u0004\u0005\r\u0011\"\u0003\u0002r\"Y\u0011\u0011 \fA\u0002\u0003\u0007I\u0011BA~\u0011-\u00119A\u0006a\u0001\u0002\u0003\u0006K!a=\t\u0017\t%a\u00031AA\u0002\u0013E!1\u0002\u0005\f\u0005'1\u0002\u0019!a\u0001\n#\u0011)\u0002C\u0006\u0003\u001aY\u0001\r\u0011!Q!\n\t5\u0001b\u0002B\u000e-\u0011E!Q\u0004\u0005\b\u0005G1B\u0011\u0001B\u0013\u0011\u001d\u0011IC\u0006C\u0001\u0005WAqAa\u0011\u0017\t\u0003\u0011)\u0005C\u0004\u0003HY!\tA!\u0013\u0007\r\tM\u0003\u0001\u0001B+\u0011-\t9D\u000eB\u0001B\u0003%\u00111H\f\t\u0015\t]cG!A!\u0002\u0013\u0011I\u0006\u0003\u0006\u0003`Y\u0012\t\u0011)A\u0005\u00053Baa\u001e\u001c\u0005\u0002\t\u0005\u0004\"\u0003B5m\u0001\u0007I\u0011\u0002B6\u0011%\u0011iG\u000ea\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003tY\u0002\u000b\u0015\u0002B-\u0011%\u0011)H\u000ea\u0001\n\u0013\u0011Y\u0007C\u0005\u0003xY\u0002\r\u0011\"\u0003\u0003z!A!Q\u0010\u001c!B\u0013\u0011I\u0006C\u0005\u0003\u0000Y\u0002\r\u0011\"\u0003\u0003\f!I!\u0011\u0011\u001cA\u0002\u0013%!1\u0011\u0005\t\u0005\u000f3\u0004\u0015)\u0003\u0003\u000e!9!\u0011\u0012\u001c\u0005\u0002\t-\u0001b\u0002B\u000em\u0011E#1\u0012\u0005\b\u0005S1D\u0011\tBH\u0011\u001d\u0011\u0019E\u000eC!\u0005\u000b\u0012qd\u00159be.\u001cuN\u001c8fGR\fE\rZ!si&4\u0017m\u0019;t\u0011\u0006tG\r\\3s\u0015\tQ5*A\u0004tKJ4\u0018nY3\u000b\u00051k\u0015aB2p]:,7\r\u001e\u0006\u0003\u001d>\u000b1a]9m\u0015\t\u0001\u0016+A\u0003ta\u0006\u00148N\u0003\u0002S'\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0001\u0004_J<7\u0001A\n\u0004\u0001]{\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0011a\u0017M\\4\u000b\u0003q\u000bAA[1wC&\u0011a,\u0017\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\u0001<\u0017.D\u0001b\u0015\t\u00117-\u0001\u0003tiV\u0014'B\u00013f\u0003\u00119'\u000f]2\u000b\u0003\u0019\f!![8\n\u0005!\f'AD*ue\u0016\fWn\u00142tKJ4XM\u001d\t\u0003U:l\u0011a\u001b\u0006\u0003Y6\fQ\u0001\u001d:pi>T!\u0001T(\n\u0005=\\'aE!eI\u0006\u0013H/\u001b4bGR\u001c(+Z9vKN$\u0018\u0001\u0005:fgB|gn]3PEN,'O^3s+\u0005\u0011\bc\u00011hgB\u0011!\u000e^\u0005\u0003k.\u0014A#\u00113e\u0003J$\u0018NZ1diN\u0014Vm\u001d9p]N,\u0017!\u0005:fgB|gn]3PEN,'O^3sA\u00051A(\u001b8jiz\"\"!_>\u0011\u0005i\u0004Q\"A%\t\u000bA\u001c\u0001\u0019\u0001:\u0002\u0015M$\u0018mZ5oO\u0012K'/F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!a-\u001b7f\u0015\r\t9aW\u0001\u0004]&|\u0017\u0002BA\u0006\u0003\u0003\u0011A\u0001U1uQ\u0006Y1\u000f^1hS:<G)\u001b:!\u0003=\u0019H/Y4fI\u0006\u0013H/\u001b4bGR\u001cXCAA\n!\u0019\t)\"a\t\u0002(5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0004nkR\f'\r\\3\u000b\t\u0005u\u0011qD\u0001\u000bG>dG.Z2uS>t'BAA\u0011\u0003\u0015\u00198-\u00197b\u0013\u0011\t)#a\u0006\u0003\r\t+hMZ3s!\r\tICF\u0007\u0002\u0001\tq1\u000b^1hK\u0012\f%\u000f^5gC\u000e$8c\u0001\f\u00020A!\u0011\u0011GA\u001a\u001b\t\ty\"\u0003\u0003\u00026\u0005}!AB!osJ+g-\u0001\u0003oC6,WCAA\u001e!\u0011\ti$a\u0013\u000f\t\u0005}\u0012q\t\t\u0005\u0003\u0003\ny\"\u0004\u0002\u0002D)\u0019\u0011QI+\u0002\rq\u0012xn\u001c;?\u0013\u0011\tI%a\b\u0002\rA\u0013X\rZ3g\u0013\u0011\ti%a\u0014\u0003\rM#(/\u001b8h\u0015\u0011\tI%a\b\u0002\u000b9\fW.\u001a\u0011\u0015\t\u0005\u001d\u0012Q\u000b\u0005\b\u0003oI\u0002\u0019AA\u001e\u0003\rAHe\r\t\t\u0003c\tY&a\u0018\u0002d%!\u0011QLA\u0010\u0005\u0019!V\u000f\u001d7feA\u0019\u0001,!\u0019\n\u0007\u00055\u0013\f\u0005\u0004\u00022\u0005\u0015\u0014qL\u0005\u0005\u0003O\nyB\u0001\u0004PaRLwN\\\u0001\u0012G\u0006twN\\5dC24\u0015\u000e\\3OC6,\u0017AE2b]>t\u0017nY1m\r&dWMT1nK\u0002\n\u0001B\u001a:bO6,g\u000e^\u000b\u0003\u0003c\u0002b!!\r\u0002f\u0005m\u0012!\u00034sC\u001elWM\u001c;!\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u0015M$\u0018mZ3e!\u0006$\b.A\u0006ti\u0006<W\r\u001a)bi\"\u0004\u0013a\u00024jY\u0016|U\u000f^\u000b\u0003\u0003\u0003\u0003B!a!\u0002\b6\u0011\u0011Q\u0011\u0006\u0003MnKA!!#\u0002\u0006\naq*\u001e;qkR\u001cFO]3b[\u0006Aa-\u001b7f\u001fV$\b%A\u0006d_VtG/\u001b8h\u001fV$XCAAI!\u0011\t\u0019*a)\u000e\u0005\u0005U%b\u00014\u0002\u0018*!\u0011\u0011TAN\u0003\u0019\u0019w.\\7p]*!\u0011QTAP\u0003\u00199wn\\4mK*\u0011\u0011\u0011U\u0001\u0004G>l\u0017\u0002BAS\u0003+\u0013AcQ8v]RLgnZ(viB,Ho\u0015;sK\u0006l\u0017\u0001D2pk:$\u0018N\\4PkR\u0004\u0013aC2iK\u000e\\7/^7PkR,\"!!,\u0011\t\u0005=\u0016\u0011X\u0007\u0003\u0003cSA!a-\u00026\u0006\u0019!0\u001b9\u000b\u0007\u0005]6,\u0001\u0003vi&d\u0017\u0002BA^\u0003c\u00131c\u00115fG.,GmT;uaV$8\u000b\u001e:fC6\fAb\u00195fG.\u001cX/\\(vi\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002DB!\u0011QYAt\u001d\u0011\t9-!9\u000f\t\u0005%\u0017Q\u001c\b\u0005\u0003\u0017\fYN\u0004\u0003\u0002N\u0006eg\u0002BAh\u0003/tA!!5\u0002V:!\u0011\u0011IAj\u0013\u0005!\u0016B\u0001*T\u0013\t\u0001\u0016+\u0003\u0002M\u001f&\u0011A.\\\u0005\u0004\u0003?\\\u0017\u0001F!eI\u0006\u0013H/\u001b4bGR\u001c(+Z:q_:\u001cX-\u0003\u0003\u0002d\u0006\u0015\u0018aD!si&4\u0017m\u0019;Tk6l\u0017M]=\u000b\u0007\u0005}7.\u0003\u0003\u0002j\u0006-(a\u0002\"vS2$WM\u001d\u0006\u0005\u0003G\f)/\u0001\u0005ck&dG-\u001a:!\u0003=\t'\u000f^5gC\u000e$8+^7nCJLXCAAz!\u0011\t9-!>\n\t\u0005]\u0018Q\u001d\u0002\u0010\u0003J$\u0018NZ1diN+X.\\1ss\u0006\u0019\u0012M\u001d;jM\u0006\u001cGoU;n[\u0006\u0014\u0018p\u0018\u0013fcR!\u0011Q B\u0002!\u0011\t\t$a@\n\t\t\u0005\u0011q\u0004\u0002\u0005+:LG\u000fC\u0005\u0003\u00061\n\t\u00111\u0001\u0002t\u0006\u0019\u0001\u0010J\u0019\u0002!\u0005\u0014H/\u001b4bGR\u001cV/\\7bef\u0004\u0013\u0001D5t\u0007J\u001c7+^2dKN\u001cXC\u0001B\u0007!\u0011\t\tDa\u0004\n\t\tE\u0011q\u0004\u0002\b\u0005>|G.Z1o\u0003AI7o\u0011:d'V\u001c7-Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002~\n]\u0001\"\u0003B\u0003_\u0005\u0005\t\u0019\u0001B\u0007\u00035I7o\u0011:d'V\u001c7-Z:tA\u0005IQ\u000f\u001d3bi\u0016\u001c%o\u0019\u000b\u0005\u0003{\u0014y\u0002C\u0004\u0003\"E\u0002\rA!\u0004\u0002\u0013%\u001c8+^2dKN\u001c\u0018\u0001D4fi\u000e\u00138m\u0015;biV\u001cXC\u0001B\u0014!\u0019\t\t$!\u001a\u0003\u000e\u0005)qO]5uKR!\u0011Q B\u0017\u0011\u001d\u0011yc\ra\u0001\u0005c\t\u0011\u0002Z1uC\u000eCWO\\6\u0011\t\tM\"Q\b\b\u0005\u0005k\u0011ID\u0004\u0003\u00038\u0005mW\"A7\n\u0007\tm2.A\nBI\u0012\f%\u000f^5gC\u000e$8OU3rk\u0016\u001cH/\u0003\u0003\u0003@\t\u0005#!D!si&4\u0017m\u0019;DQVt7NC\u0002\u0003<-\fQa\u00197pg\u0016$\"!!@\u0002\u000fM,X.\\1ssR\u0011\u00111_\u0001\u0011gR\fw-\u001a3BeRLg-Y2ug\u0002\nqb\u00195v].,G-\u0011:uS\u001a\f7\r^\u000b\u0003\u0005#\u00022!!\u000b7\u0005U\u0019F/Y4fI\u000eCWO\\6fI\u0006\u0013H/\u001b4bGR\u001c2ANA\u0014\u0003%qW/\\\"ik:\\7\u000f\u0005\u0003\u00022\tm\u0013\u0002\u0002B/\u0003?\u0011A\u0001T8oO\u0006QAo\u001c;bY\nKH/Z:\u0015\u0011\tE#1\rB3\u0005OBq!a\u000e;\u0001\u0004\tY\u0004C\u0004\u0003Xi\u0002\rA!\u0017\t\u000f\t}#\b1\u0001\u0003Z\u0005y!/Z7bS:LgnZ\"ik:\\7/\u0006\u0002\u0003Z\u0005\u0019\"/Z7bS:LgnZ\"ik:\\7o\u0018\u0013fcR!\u0011Q B9\u0011%\u0011)\u0001PA\u0001\u0002\u0004\u0011I&\u0001\tsK6\f\u0017N\\5oO\u000eCWO\\6tA\u0005\u0019Bo\u001c;bY\nKH/Z:Qe>\u001cWm]:fI\u00069Bo\u001c;bY\nKH/Z:Qe>\u001cWm]:fI~#S-\u001d\u000b\u0005\u0003{\u0014Y\bC\u0005\u0003\u0006}\n\t\u00111\u0001\u0003Z\u0005!Bo\u001c;bY\nKH/Z:Qe>\u001cWm]:fI\u0002\n\u0001#[:GSJ\u001cHo\u0011:d+B$\u0017\r^3\u0002)%\u001ch)\u001b:ti\u000e\u00138-\u00169eCR,w\fJ3r)\u0011\tiP!\"\t\u0013\t\u0015!)!AA\u0002\t5\u0011!E5t\r&\u00148\u000f^\"sGV\u0003H-\u0019;fA\u0005Q\u0011n\u001d$j]&\u001c\b.\u001a3\u0015\t\u0005u(Q\u0012\u0005\b\u0005C)\u0005\u0019\u0001B\u0007)\u0011\tiP!%\t\u000f\t=b\t1\u0001\u00032\u0005\u00192\r[;oW\u0016$\u0017I\u001d;jM\u0006\u001cGo\u0018\u0013fcR!\u0011Q BL\u0011%\u0011)!CA\u0001\u0002\u0004\u0011\t&\u0001\tdQVt7.\u001a3BeRLg-Y2uA\u00051\u0001n\u001c7eKJ,\"Aa(\u0011\u0007i\u0014\t+C\u0002\u0003$&\u0013QbU3tg&|g\u000eS8mI\u0016\u0014\u0018A\u00035pY\u0012,'o\u0018\u0013fcR!\u0011Q BU\u0011%\u0011)\u0001DA\u0001\u0002\u0004\u0011y*A\u0004i_2$WM\u001d\u0011\u0002\r=tg*\u001a=u)\u0011\tiP!-\t\r\tMf\u00021\u0001j\u0003\r\u0011X-]\u0001\b_:,%O]8s)\u0011\tiP!/\t\u000f\tmv\u00021\u0001\u0003>\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005\u007f\u0013IM\u0004\u0003\u0003B\n\u0015g\u0002BA!\u0005\u0007L!!!\t\n\t\t\u001d\u0017qD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YM!4\u0003\u0013QC'o\\<bE2,'\u0002\u0002Bd\u0003?\t!%\u00193e'R\fw-\u001a3BeRLg-Y2u)>\f%\u000f^5gC\u000e$X*\u00198bO\u0016\u0014H\u0003BA\u007f\u0005'DqA!6\u0011\u0001\u0004\t9#\u0001\u0005beRLg-Y2u\u0003Q1G.^:i'R\fw-\u001a3BeRLg-Y2ugR\u0011!1\u001c\t\u0007\u0005\u007f\u0013i.a=\n\t\t}'Q\u001a\u0002\u0004'\u0016\f\u0018AF2mK\u0006tW\u000b]*uC\u001e,G-\u0011:uS\u001a\f7\r^:\u0002\u0017=t7i\\7qY\u0016$X\rZ\u0001\u0014oJLG/Z!si&4\u0017m\u0019;U_\u001aKG.\u001a\u000b\u0005\u0003O\u0011I\u000fC\u0004\u0003VR\u0001\rAa;\u0011\t\tM\"Q^\u0005\u0005\u0005_\u0014\tEA\nTS:<G.Z\"ik:\\\u0017I\u001d;jM\u0006\u001cG\u000f\u0006\u0003\u0003R\tM\bb\u0002Bk+\u0001\u0007!Q\u001f\t\u0005\u0005g\u001190\u0003\u0003\u0003z\n\u0005#\u0001\u0006\"fO&t7\t[;oW\u0016$\u0017I\u001d;jM\u0006\u001cG\u000f")
public class SparkConnectAddArtifactsHandler
implements StreamObserver<AddArtifactsRequest> {
    private final StreamObserver<AddArtifactsResponse> responseObserver;
    private final Path stagingDir;
    private final Buffer<StagedArtifact> stagedArtifacts;
    private StagedChunkedArtifact chunkedArtifact;
    private SessionHolder holder;

    public StreamObserver<AddArtifactsResponse> responseObserver() {
        return this.responseObserver;
    }

    public Path stagingDir() {
        return this.stagingDir;
    }

    public Buffer<StagedArtifact> stagedArtifacts() {
        return this.stagedArtifacts;
    }

    private StagedChunkedArtifact chunkedArtifact() {
        return this.chunkedArtifact;
    }

    private void chunkedArtifact_$eq(StagedChunkedArtifact x$1) {
        this.chunkedArtifact = x$1;
    }

    private SessionHolder holder() {
        return this.holder;
    }

    private void holder_$eq(SessionHolder x$1) {
        this.holder = x$1;
    }

    @Override
    public void onNext(AddArtifactsRequest req) {
        block12: {
            try {
                if (this.holder() == null) {
                    Some some;
                    boolean bl = req.hasClientObservedServerSideSessionId();
                    if (bl) {
                        some = new Some((Object)req.getClientObservedServerSideSessionId());
                    } else if (!bl) {
                        some = None$.MODULE$;
                    } else {
                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                    }
                    Some previousSessionId = some;
                    this.holder_$eq(SparkConnectService$.MODULE$.getOrCreateIsolatedSession(req.getUserContext().getUserId(), req.getSessionId(), (Option<String>)previousSessionId));
                }
                if (req.hasBeginChunk()) {
                    Predef$.MODULE$.require(this.chunkedArtifact() == null);
                    this.chunkedArtifact_$eq(this.writeArtifactToFile(req.getBeginChunk()));
                    break block12;
                }
                if (req.hasChunk()) {
                    Predef$.MODULE$.require(this.chunkedArtifact() != null && !this.chunkedArtifact().isFinished());
                    this.chunkedArtifact().write(req.getChunk());
                    if (this.chunkedArtifact().isFinished()) {
                        this.chunkedArtifact().close();
                        this.chunkedArtifact_$eq(null);
                    }
                    break block12;
                }
                if (req.hasBatch()) {
                    req.getBatch().getArtifactsList().forEach(artifact -> this.writeArtifactToFile((AddArtifactsRequest.SingleChunkArtifact)artifact).close());
                    break block12;
                }
                throw new UnsupportedOperationException("Unsupported data transfer request: " + req);
            }
            catch (Throwable x$6) {
                PartialFunction<Throwable, BoxedUnit> catchExpr$1 = ErrorUtils$.MODULE$.handleError("addArtifacts.onNext", this.responseObserver(), req.getUserContext().getUserId(), req.getSessionId(), (Option<ExecuteEventsManager>)None$.MODULE$, false, (Option<Function0<BoxedUnit>>)new Some((JFunction0.mcV.sp & Serializable)() -> this.cleanUpStagedArtifacts()));
                if (catchExpr$1.isDefinedAt((Object)x$6)) {
                    catchExpr$1.apply((Object)x$6);
                }
                throw x$6;
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.cleanUpStagedArtifacts();
        this.responseObserver().onError(throwable);
    }

    public void addStagedArtifactToArtifactManager(StagedArtifact artifact) {
        Predef$.MODULE$.require(this.holder() != null);
        this.holder().addArtifact(artifact.path(), artifact.stagedPath(), artifact.fragment());
    }

    public Seq<AddArtifactsResponse.ArtifactSummary> flushStagedArtifacts() {
        return ((IterableOnceOps)this.stagedArtifacts().map((Function1 & Serializable)artifact -> {
            block2: {
                if (!artifact.getCrcStatus().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) break block2;
                if (artifact.path().startsWith(ArtifactManager$.MODULE$.forwardToFSPrefix() + File.separator)) {
                    this.holder().artifactManager().uploadArtifactToFs(artifact.path(), artifact.stagedPath());
                } else {
                    this.addStagedArtifactToArtifactManager((StagedArtifact)artifact);
                }
            }
            return artifact.summary();
        })).toSeq();
    }

    public void cleanUpStagedArtifacts() {
        Utils$.MODULE$.deleteRecursively(this.stagingDir().toFile());
    }

    @Override
    public void onCompleted() {
        try {
            Seq<AddArtifactsResponse.ArtifactSummary> artifactSummaries = this.flushStagedArtifacts();
            AddArtifactsResponse.Builder builder = AddArtifactsResponse.newBuilder();
            builder.setSessionId(this.holder().sessionId());
            builder.setServerSideSessionId(this.holder().serverSessionId());
            artifactSummaries.foreach((Function1 & Serializable)summary -> builder.addArtifacts((AddArtifactsResponse.ArtifactSummary)summary));
            this.cleanUpStagedArtifacts();
            this.responseObserver().onNext(builder.build());
            this.responseObserver().onCompleted();
        }
        catch (Throwable x$7) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$2 = ErrorUtils$.MODULE$.handleError("addArtifacts.onComplete", this.responseObserver(), this.holder().userId(), this.holder().sessionId(), (Option<ExecuteEventsManager>)None$.MODULE$, false, (Option<Function0<BoxedUnit>>)new Some((JFunction0.mcV.sp & Serializable)() -> this.cleanUpStagedArtifacts()));
            if (catchExpr$2.isDefinedAt((Object)x$7)) {
                catchExpr$2.apply((Object)x$7);
            }
            throw x$7;
        }
    }

    private StagedArtifact writeArtifactToFile(AddArtifactsRequest.SingleChunkArtifact artifact) {
        StagedArtifact stagedDep = new StagedArtifact(this, artifact.getName());
        this.stagedArtifacts().$plus$eq((Object)stagedDep);
        stagedDep.write(artifact.getData());
        return stagedDep;
    }

    private StagedChunkedArtifact writeArtifactToFile(AddArtifactsRequest.BeginChunkedArtifact artifact) {
        StagedChunkedArtifact stagedChunkedArtifact = new StagedChunkedArtifact(this, artifact.getName(), artifact.getNumChunks(), artifact.getTotalBytes());
        this.stagedArtifacts().$plus$eq((Object)stagedChunkedArtifact);
        stagedChunkedArtifact.write(artifact.getInitialChunk());
        return stagedChunkedArtifact;
    }

    public SparkConnectAddArtifactsHandler(StreamObserver<AddArtifactsResponse> responseObserver) {
        this.responseObserver = responseObserver;
        this.stagingDir = Utils$.MODULE$.createTempDir().toPath();
        this.stagedArtifacts = (Buffer)Buffer$.MODULE$.empty();
    }

    public class StagedArtifact {
        private final String name;
        private final /* synthetic */ Tuple2 x$3;
        private final String canonicalFileName;
        private final Option<String> fragment;
        private final Path path;
        private final Path stagedPath;
        private final OutputStream fileOut;
        private final CountingOutputStream countingOut;
        private final CheckedOutputStream checksumOut;
        private final AddArtifactsResponse.ArtifactSummary.Builder builder;
        private AddArtifactsResponse.ArtifactSummary artifactSummary;
        private boolean isCrcSuccess;
        public final /* synthetic */ SparkConnectAddArtifactsHandler $outer;

        public String name() {
            return this.name;
        }

        public String canonicalFileName() {
            return this.canonicalFileName;
        }

        public Option<String> fragment() {
            return this.fragment;
        }

        public Path path() {
            return this.path;
        }

        public Path stagedPath() {
            return this.stagedPath;
        }

        private OutputStream fileOut() {
            return this.fileOut;
        }

        private CountingOutputStream countingOut() {
            return this.countingOut;
        }

        private CheckedOutputStream checksumOut() {
            return this.checksumOut;
        }

        private AddArtifactsResponse.ArtifactSummary.Builder builder() {
            return this.builder;
        }

        private AddArtifactsResponse.ArtifactSummary artifactSummary() {
            return this.artifactSummary;
        }

        private void artifactSummary_$eq(AddArtifactsResponse.ArtifactSummary x$1) {
            this.artifactSummary = x$1;
        }

        public boolean isCrcSuccess() {
            return this.isCrcSuccess;
        }

        public void isCrcSuccess_$eq(boolean x$1) {
            this.isCrcSuccess = x$1;
        }

        public void updateCrc(boolean isSuccess) {
            this.isCrcSuccess_$eq(isSuccess);
        }

        public Option<Object> getCrcStatus() {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.isCrcSuccess()));
        }

        public void write(AddArtifactsRequest.ArtifactChunk dataChunk) {
            try {
                dataChunk.getData().writeTo(this.checksumOut());
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    this.close();
                    throw throwable2;
                }
                throw throwable;
            }
            this.updateCrc(this.checksumOut().getChecksum().getValue() == dataChunk.getCrc());
            this.checksumOut().getChecksum().reset();
        }

        public void close() {
            if (this.artifactSummary() == null) {
                this.checksumOut().close();
                this.artifactSummary_$eq(this.builder().setName(this.name()).setIsCrcSuccessful(BoxesRunTime.unboxToBoolean((Object)this.getCrcStatus().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))).build());
                return;
            }
        }

        public AddArtifactsResponse.ArtifactSummary summary() {
            Predef$.MODULE$.require(this.artifactSummary() != null);
            return this.artifactSummary();
        }

        public /* synthetic */ SparkConnectAddArtifactsHandler org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedArtifact$$$outer() {
            return this.$outer;
        }

        private final /* synthetic */ Path liftedTree1$1() {
            Path path;
            try {
                path = ArtifactUtils$.MODULE$.concatenatePaths(this.org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedArtifact$$$outer().stagingDir(), this.path());
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 instanceof IllegalArgumentException) {
                    throw new IllegalArgumentException("Artifact with name: " + this.name() + " is invalid. The `name` must be a relative path and cannot reference parent/sibling/nephew directories.");
                }
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw throwable2;
                }
                throw throwable;
            }
            return path;
        }

        public StagedArtifact(SparkConnectAddArtifactsHandler $outer, String name) {
            String string;
            Option fragment;
            block7: {
                Tuple2 tuple2;
                block6: {
                    this.name = name;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    if (name.startsWith("archives" + File.separator)) {
                        String[] splits = name.split("#");
                        Predef$.MODULE$.assert(splits.length <= 2, (Function0 & Serializable)() -> "'#' in the path is not supported for adding an archive.");
                        v0 = splits.length == 2 ? new Tuple2((Object)splits[0], (Object)new Some((Object)splits[1])) : new Tuple2((Object)splits[0], (Object)None$.MODULE$);
                    } else {
                        v0 = tuple2 = new Tuple2((Object)name, (Object)None$.MODULE$);
                    }
                    if (tuple2 == null) break block6;
                    String canonicalFileName = (String)tuple2._1();
                    fragment = (Option)tuple2._2();
                    if (canonicalFileName == null) break block6;
                    string = canonicalFileName;
                    if (fragment != null) break block7;
                }
                throw new MatchError((Object)tuple2);
            }
            Option option = fragment;
            this.x$3 = new Tuple2((Object)string, (Object)option);
            this.canonicalFileName = (String)this.x$3._1();
            this.fragment = (Option)this.x$3._2();
            this.path = Paths.get(this.canonicalFileName(), new String[0]);
            this.stagedPath = this.liftedTree1$1();
            Files.createDirectories(this.stagedPath().getParent(), new FileAttribute[0]);
            this.fileOut = Files.newOutputStream(this.stagedPath(), new OpenOption[0]);
            this.countingOut = new CountingOutputStream(this.fileOut());
            this.checksumOut = new CheckedOutputStream(this.countingOut(), new CRC32());
            this.builder = AddArtifactsResponse.ArtifactSummary.newBuilder().setName(name);
        }
    }

    public class StagedChunkedArtifact
    extends StagedArtifact {
        private final long numChunks;
        private final long totalBytes;
        private long remainingChunks;
        private long totalBytesProcessed;
        private boolean isFirstCrcUpdate;

        private long remainingChunks() {
            return this.remainingChunks;
        }

        private void remainingChunks_$eq(long x$1) {
            this.remainingChunks = x$1;
        }

        private long totalBytesProcessed() {
            return this.totalBytesProcessed;
        }

        private void totalBytesProcessed_$eq(long x$1) {
            this.totalBytesProcessed = x$1;
        }

        private boolean isFirstCrcUpdate() {
            return this.isFirstCrcUpdate;
        }

        private void isFirstCrcUpdate_$eq(boolean x$1) {
            this.isFirstCrcUpdate = x$1;
        }

        public boolean isFinished() {
            return this.remainingChunks() == 0L;
        }

        @Override
        public void updateCrc(boolean isSuccess) {
            this.isCrcSuccess_$eq(isSuccess && (this.isCrcSuccess() || this.isFirstCrcUpdate()));
            this.isFirstCrcUpdate_$eq(false);
        }

        @Override
        public void write(AddArtifactsRequest.ArtifactChunk dataChunk) {
            if (this.remainingChunks() == 0L) {
                throw new RuntimeException("Excessive data chunks for artifact: " + super.name() + ", expected " + this.numChunks + " chunks in total. Processed " + this.totalBytesProcessed() + " bytes out of " + this.totalBytes + " bytes.");
            }
            super.write(dataChunk);
            this.totalBytesProcessed_$eq(this.totalBytesProcessed() + (long)dataChunk.getData().size());
            this.remainingChunks_$eq(this.remainingChunks() - 1L);
        }

        @Override
        public void close() {
            if (this.remainingChunks() != 0L || this.totalBytesProcessed() != this.totalBytes) {
                throw new RuntimeException("Missing data chunks for artifact: " + super.name() + ". Expected " + this.numChunks + " chunks and received " + (this.numChunks - this.remainingChunks()) + " chunks. Processed " + this.totalBytesProcessed() + " bytes out of " + this.totalBytes + " bytes.");
            }
            super.close();
        }

        public /* synthetic */ SparkConnectAddArtifactsHandler org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedChunkedArtifact$$$outer() {
            return this.$outer;
        }

        public StagedChunkedArtifact(SparkConnectAddArtifactsHandler $outer, String name, long numChunks, long totalBytes) {
            this.numChunks = numChunks;
            this.totalBytes = totalBytes;
            super($outer, name);
            this.remainingChunks = numChunks;
            this.totalBytesProcessed = 0L;
            this.isFirstCrcUpdate = true;
        }
    }
}

