/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NullIf;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract;
import org.apache.spark.sql.catalyst.expressions.RegExpSubStr$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp) - Returns the substring that matches the regular expression `regexp` within the string `str`. If the regular expression is not found, the result is null.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a Java regular expression.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Steven Jones and Stephen Smith are the best players', 'Ste(v|ph)en');\n       Steven\n      > SELECT _FUNC_('Steven Jones and Stephen Smith are the best players', 'Jeck');\n       NULL\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u000e\u001d\u0001&B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005U!A\u0001\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005B\u0001\tE\t\u0015!\u0003+\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011!9\u0005\u0001#b\u0001\n\u0003r\u0004\"\u0002%\u0001\t\u0003J\u0005\"B+\u0001\t\u00032\u0006\"\u00021\u0001\t\u0003\n\u0007\"B5\u0001\t#R\u0007b\u00029\u0001\u0003\u0003%\t!\u001d\u0005\bi\u0002\t\n\u0011\"\u0001v\u0011!\t\t\u0001AI\u0001\n\u0003)\b\"CA\u0002\u0001\u0005\u0005I\u0011IA\u0003\u0011%\t)\u0002AA\u0001\n\u0003\t9\u0002C\u0005\u0002 \u0001\t\t\u0011\"\u0001\u0002\"!I\u0011Q\u0006\u0001\u0002\u0002\u0013\u0005\u0013q\u0006\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\b\u0013\u0005UD$!A\t\u0002\u0005]d\u0001C\u000e\u001d\u0003\u0003E\t!!\u001f\t\r\t+B\u0011AAD\u0011%\tI)FA\u0001\n\u000b\nY\tC\u0005\u0002\u000eV\t\t\u0011\"!\u0002\u0010\"I\u0011QS\u000b\u0002\u0002\u0013\u0005\u0015q\u0013\u0005\n\u0003S+\u0012\u0011!C\u0005\u0003W\u0013ABU3h\u000bb\u00048+\u001e2TiJT!!\b\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0007\u0001)r\u0013\u0007\u000e\u001e\u0011\u0005-bS\"\u0001\u000f\n\u00055b\"AC#yaJ,7o]5p]B\u00111fL\u0005\u0003aq\u0011!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u00111FM\u0005\u0003gq\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\b!J|G-^2u!\t)4(\u0003\u0002=m\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005Q\u0013!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u00163\u0005CA\u0016\u0001\u0011\u0015iT\u00011\u0001+\u0011\u0015\u0001U\u00011\u0001+\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001K!\tY%K\u0004\u0002M!B\u0011QJN\u0007\u0002\u001d*\u0011q\nK\u0001\u0007yI|w\u000e\u001e \n\u0005E3\u0014A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\u001c\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012a\u0016\t\u00041vScBA-\\\u001d\ti%,C\u00018\u0013\taf'A\u0004qC\u000e\\\u0017mZ3\n\u0005y{&aA*fc*\u0011ALN\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00012\u0011\u0007ak6\r\u0005\u0002eO6\tQM\u0003\u0002gA\u0005)A/\u001f9fg&\u0011\u0001.\u001a\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0005\u0011[\u0007\"\u00027\u000b\u0001\u0004i\u0017a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u00042\u0001\u00178+\u0013\tywL\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsR\u0019AI]:\t\u000fuZ\u0001\u0013!a\u0001U!9\u0001i\u0003I\u0001\u0002\u0004Q\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0002m*\u0012!f^\u0016\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\nk:\u001c\u0007.Z2lK\u0012T!! \u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u0000u\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u00198h\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017bA*\u0002\f\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0004\t\u0004k\u0005m\u0011bAA\u000fm\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111EA\u0015!\r)\u0014QE\u0005\u0004\u0003O1$aA!os\"I\u00111\u0006\t\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0002CBA\u001a\u0003s\t\u0019#\u0004\u0002\u00026)\u0019\u0011q\u0007\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005U\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0011\u0002HA\u0019Q'a\u0011\n\u0007\u0005\u0015cGA\u0004C_>dW-\u00198\t\u0013\u0005-\"#!AA\u0002\u0005\r\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002B\u00055\u0003\"CA\u0016'\u0005\u0005\t\u0019AA\u0012Q]\u0001\u0011\u0011KA,\u00033\ni&a\u0018\u0002d\u0005\u0015\u0014\u0011NA6\u0003_\n\t\bE\u0002,\u0003'J1!!\u0016\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0017\u0002\u0003WR\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016D\b/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011tk\n\u001cHO]5oO\u0002\"\b.\u0019;![\u0006$8\r[3tAQDW\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:\u0004\u0003M]3hKb\u0004\b\rI<ji\"Lg\u000e\t;iK\u0002\u001aHO]5oO\u0002\u00027\u000f\u001e:a]\u0001Je\r\t;iK\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!SN\u0004cn\u001c;!M>,h\u000e\u001a\u0017!i\",\u0007E]3tk2$\b%[:!]VdGN\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003C\n\u0011\u0011\u000b\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AI,w-\u001a=qA5\u0002\u0013\rI:ue&tw\r\t:faJ,7/\u001a8uS:<\u0007%\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>tg\u0006\t+iK\u0002\u0012XmZ3yAM$(/\u001b8hAMDw.\u001e7eA\t,\u0007%\u0019\u0011KCZ\f\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qM\u0001\u0002>*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u0015;fm\u0016t\u0007ES8oKN\u0004\u0013M\u001c3!'R,\u0007\u000f[3oAMk\u0017\u000e\u001e5!CJ,\u0007\u0005\u001e5fA\t,7\u000f\u001e\u0011qY\u0006LXM]:(Y\u0001:3\u000b^3)mr\u0004\b.K3oO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0015;fm\u0016t'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ti\u00164XM\u001c\u0011K_:,7\u000fI1oI\u0002\u001aF/\u001a9iK:\u00043+\\5uQ\u0002\n'/\u001a\u0011uQ\u0016\u0004#-Z:uAAd\u0017-_3sg\u001eb\u0003e\n&fG.<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0014!B\u001a/i9\u0002\u0014!B4s_V\u0004\u0018EAA:\u00031\u0019HO]5oO~3WO\\2t\u00031\u0011VmZ#yaN+(m\u0015;s!\tYSc\u0005\u0003\u0016\u0003wR\u0004cBA?\u0003\u0007S#\u0006R\u0007\u0003\u0003\u007fR1!!!7\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\"\u0002\u0000\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0011!B1qa2LH#\u0002#\u0002\u0012\u0006M\u0005\"B\u001f\u0019\u0001\u0004Q\u0003\"\u0002!\u0019\u0001\u0004Q\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u00033\u000b)\u000bE\u00036\u00037\u000by*C\u0002\u0002\u001eZ\u0012aa\u00149uS>t\u0007#B\u001b\u0002\"*R\u0013bAARm\t1A+\u001e9mKJB\u0001\"a*\u001a\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!,\u0011\t\u0005%\u0011qV\u0005\u0005\u0003c\u000bYA\u0001\u0004PE*,7\r\u001e")
public class RegExpSubStr
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegExpSubStr regExpSubStr) {
        return RegExpSubStr$.MODULE$.unapply(regExpSubStr);
    }

    public static Function1<Tuple2<Expression, Expression>, RegExpSubStr> tupled() {
        return RegExpSubStr$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegExpSubStr>> curried() {
        return RegExpSubStr$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        RegExpSubStr regExpSubStr = this;
        synchronized (regExpSubStr) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    private Expression replacement$lzycompute() {
        RegExpSubStr regExpSubStr = this;
        synchronized (regExpSubStr) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new NullIf(new RegExpExtract(this.left(), this.right(), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0))), Literal$.MODULE$.apply(""));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "regexp_substr";
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public RegExpSubStr withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public RegExpSubStr copy(Expression left, Expression right) {
        return new RegExpSubStr(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegExpSubStr";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpSubStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpSubStr)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpSubStr regExpSubStr = (RegExpSubStr)x$1;
        Expression expression = this.left();
        Expression expression2 = regExpSubStr.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regExpSubStr.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regExpSubStr.canEqual(this)) return false;
        return true;
    }

    public RegExpSubStr(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

