/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RPadExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, right-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n      If `pad` is not specified, `str` will be padded to the right with space characters if it is\n      a character string, and with zeros if it is a binary string.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       hi???\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n       hi\n      > SELECT hex(_FUNC_(unhex('aabb'), 5));\n       AABB000000\n      > SELECT hex(_FUNC_(unhex('aabb'), 5, unhex('1122')));\n       AABB112211\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001u:Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQaH\u0001\u0005\u0002\u0001BQ!I\u0001\u0005B\t\nQC\u0015)bI\u0016C\bO]3tg&|gNQ;jY\u0012,'O\u0003\u0002\u0007\u000f\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tA\u0011\"\u0001\u0005dCR\fG._:u\u0015\tQ1\"A\u0002tc2T!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001!\t\u0019\u0012!D\u0001\u0006\u0005U\u0011\u0006+\u00193FqB\u0014Xm]:j_:\u0014U/\u001b7eKJ\u001c2!\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u00111#H\u0005\u0003=\u0015\u0011\u0001\u0004U1e\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014()Y:f\u0003\u0019a\u0014N\\5u}Q\t!#A\bde\u0016\fG/Z*ue&tw\rU1e)\u0011\u0019c\u0005\u000b\u0016\u0011\u0005M!\u0013BA\u0013\u0006\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006O\r\u0001\raI\u0001\u0004gR\u0014\b\"B\u0015\u0004\u0001\u0004\u0019\u0013a\u00017f]\")1f\u0001a\u0001G\u0005\u0019\u0001/\u00193)\u0015\u0005i\u0003'M\u001a5m]J$\b\u0005\u0002\u0014]%\u0011q&\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\u0005\u0011\u0014Aa.\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001bWM\\.-AA\fG-X\u0015![\u0001\u0012V\r^;s]N\u0004\u0003m\u001d;sA2\u0002#/[4ii6\u0002\u0018\r\u001a3fI\u0002:\u0018\u000e\u001e5!AB\fG\r\u0019\u0011u_\u0002\n\u0007\u0005\\3oORD\u0007e\u001c4!A2,g\u000e\u0019\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011JM\u0002\u00027\u000f\u001e:aA%\u001c\b\u0005\\8oO\u0016\u0014\b\u0005\u001e5b]\u0002\u0002G.\u001a8aY\u0001\"\b.\u001a\u0011sKR,(O\u001c\u0011wC2,X\rI5tAMDwN\u001d;f]\u0016$\u0007\u0005^8!A2,g\u000e\u0019\u0011dQ\u0006\u0014\u0018m\u0019;feNt#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011aa\u0006$\u0007\rI5tA9|G\u000fI:qK\u000eLg-[3eY\u0001\u00027\u000f\u001e:aA]LG\u000e\u001c\u0011cK\u0002\u0002\u0018\r\u001a3fI\u0002\"x\u000e\t;iK\u0002\u0012\u0018n\u001a5uA]LG\u000f\u001b\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u0002Jg\rI5uA%\u001c(\u0002\t\u0011!A\u0001\u0002\u0013\rI2iCJ\f7\r^3sAM$(/\u001b8hY\u0001\ng\u000e\u001a\u0011xSRD\u0007E_3s_N\u0004\u0013N\u001a\u0011ji\u0002J7\u000fI1!E&t\u0017M]=!gR\u0014\u0018N\\4/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0003U\n!\u0011\f\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!Lw\u0005\f\u00116Y\u0001:shP\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001B\u0017nP @\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003.[\u0014-AEb\u0003eJ @O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001b\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!Lw\u0005\f\u00116SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003.\u001b\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!Q\u0016D\bf\u0018$V\u001d\u000e{\u0006&\u001e8iKbDs%Y1cE\u001eJC\u0006I\u001b*SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013)\u0011\"CaA\u0002\u0004\u0007\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA!,\u0007\u0010K0G+:\u001bu\fK;oQ\u0016D\bfJ1bE\n<\u0013\u0006\f\u00116Y\u0001*h\u000e[3yQ\u001d\n\u0014G\r\u001a(S%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!B\u0005\n\u000b\u0014G\r\u001a2c)\u0001\u0003%A\u0003tS:\u001cW-I\u00019\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\u0005Y\u0014\u0001D:ue&twm\u00184v]\u000e\u001c\bF\u0003\u0001.aE\u001aDGN\u001c:u\u0001")
public final class RPadExpressionBuilder {
    public static Expression createStringPad(Expression expression, Expression expression2, Expression expression3) {
        return RPadExpressionBuilder$.MODULE$.createStringPad(expression, expression2, expression3);
    }

    public static Expression build(String string, Seq<Expression> seq) {
        return RPadExpressionBuilder$.MODULE$.build(string, (Seq)seq);
    }

    public static boolean supportsLambda() {
        return RPadExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature functionSignature, Seq<Expression> seq, String string) {
        return RPadExpressionBuilder$.MODULE$.rearrange(functionSignature, seq, string);
    }

    public static Option<FunctionSignature> functionSignature() {
        return RPadExpressionBuilder$.MODULE$.functionSignature();
    }
}

