/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.visitors;

import java.lang.reflect.Field;
import java.util.List;
import org.sparkproject.dmg.pmml.FieldName;
import org.sparkproject.dmg.pmml.OutputField;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.ResultFeature;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.jpmml.model.ReflectionUtil;
import org.sparkproject.jpmml.model.visitors.AbstractVisitor;

public abstract class FieldNameFilterer
extends AbstractVisitor {
    public abstract FieldName filter(FieldName var1);

    @Override
    public VisitorAction visit(PMMLObject object) {
        List<Field> fields = ReflectionUtil.getInstanceFields(object.getClass());
        for (Field field : fields) {
            if (!FieldName.class.equals(field.getType())) continue;
            FieldName name = (FieldName)ReflectionUtil.getFieldValue(field, object);
            name = this.filter(name);
            ReflectionUtil.setFieldValue(field, object, name);
        }
        return super.visit(object);
    }

    @Override
    public VisitorAction visit(OutputField outputField) {
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case TRANSFORMED_VALUE: 
            case DECISION: {
                String segmentId = outputField.getSegmentId();
                if (segmentId == null) break;
                outputField.setValue(this.filter(outputField.getValue()));
                break;
            }
        }
        return super.visit(outputField);
    }

    private String filter(String value) {
        FieldName name = value != null ? FieldName.create(value) : null;
        name = this.filter(name);
        return name != null ? name.getValue() : null;
    }
}

