/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.gymnastics.NotGiven$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.operators.HasOps$;
import breeze.storage.Zero$;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.ExpectationSum;
import org.apache.spark.mllib.clustering.ExpectationSum$;
import org.apache.spark.mllib.clustering.GaussianMixture$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001\u0002\u0016,\u0001YB\u0001\u0002\u0011\u0001\u0003\u0002\u0004%I!\u0011\u0005\t\u000b\u0002\u0011\t\u0019!C\u0005\r\"AA\n\u0001B\u0001B\u0003&!\t\u0003\u0005N\u0001\t\u0005\r\u0011\"\u0003O\u0011!\u0011\u0006A!a\u0001\n\u0013\u0019\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0015B(\t\u0011Y\u0003!\u00111A\u0005\n\u0005C\u0001b\u0016\u0001\u0003\u0002\u0004%I\u0001\u0017\u0005\t5\u0002\u0011\t\u0011)Q\u0005\u0005\"A1\f\u0001BA\u0002\u0013%A\f\u0003\u0005a\u0001\t\u0005\r\u0011\"\u0003b\u0011!\u0019\u0007A!A!B\u0013i\u0006\"\u00023\u0001\t\u0013)\u0007\"\u00023\u0001\t\u0003a\u0007b\u0002<\u0001\u0005\u0004%I!\u0011\u0005\u0007o\u0002\u0001\u000b\u0011\u0002\"\t\u000fa\u0004\u0001\u0019!C\u0005s\"I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111\u0001\u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003{\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aa!!\u0006\u0001\t\u0003I\bbBA\r\u0001\u0011\u0005\u00111\u0004\u0005\u0007\u0003C\u0001A\u0011A!\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!1\u0011Q\u0006\u0001\u0005\u0002\u0005Cq!!\r\u0001\t\u0003\t\u0019\u0004\u0003\u0004\u0002:\u0001!\tA\u0014\u0005\b\u0003{\u0001A\u0011AA \u0011\u0019\t)\u0005\u0001C\u00019\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA%\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003Dq!a9\u0001\t\u0013\t)o\u0002\u0005\u0002l.B\taKAw\r\u001dQ3\u0006#\u0001,\u0003_Da\u0001\u001a\u0013\u0005\u0002\u0005E\b\"CAzI\t\u0007I\u0011A\u0016B\u0011\u001d\t)\u0010\nQ\u0001\n\tCq!a>%\t\u0003\tI\u0010C\u0005\u0003\b\u0011\n\t\u0011\"\u0003\u0003\n\tyq)Y;tg&\fg.T5yiV\u0014XM\u0003\u0002-[\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u00059z\u0013!B7mY&\u0014'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g!\tAd(\u0003\u0002@s\ta1+\u001a:jC2L'0\u00192mK\u0006\t1.F\u0001C!\tA4)\u0003\u0002Es\t\u0019\u0011J\u001c;\u0002\u000b-|F%Z9\u0015\u0005\u001dS\u0005C\u0001\u001dI\u0013\tI\u0015H\u0001\u0003V]&$\bbB&\u0003\u0003\u0003\u0005\rAQ\u0001\u0004q\u0012\n\u0014AA6!\u00039\u0019wN\u001c<fe\u001e,gnY3U_2,\u0012a\u0014\t\u0003qAK!!U\u001d\u0003\r\u0011{WO\u00197f\u0003I\u0019wN\u001c<fe\u001e,gnY3U_2|F%Z9\u0015\u0005\u001d#\u0006bB&\u0006\u0003\u0003\u0005\raT\u0001\u0010G>tg/\u001a:hK:\u001cW\rV8mA\u0005iQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\f\u0011#\\1y\u0013R,'/\u0019;j_:\u001cx\fJ3r)\t9\u0015\fC\u0004L\u0011\u0005\u0005\t\u0019\u0001\"\u0002\u001d5\f\u00070\u0013;fe\u0006$\u0018n\u001c8tA\u0005!1/Z3e+\u0005i\u0006C\u0001\u001d_\u0013\ty\u0016H\u0001\u0003M_:<\u0017\u0001C:fK\u0012|F%Z9\u0015\u0005\u001d\u0013\u0007bB&\f\u0003\u0003\u0005\r!X\u0001\u0006g\u0016,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0019D\u0017N[6\u0011\u0005\u001d\u0004Q\"A\u0016\t\u000b\u0001k\u0001\u0019\u0001\"\t\u000b5k\u0001\u0019A(\t\u000bYk\u0001\u0019\u0001\"\t\u000bmk\u0001\u0019A/\u0015\u0003\u0019D3A\u00048u!\ty'/D\u0001q\u0015\t\tx&\u0001\u0006b]:|G/\u0019;j_:L!a\u001d9\u0003\u000bMKgnY3\"\u0003U\fQ!\r\u00184]A\n\u0001B\\*b[BdWm]\u0001\n]N\u000bW\u000e\u001d7fg\u0002\nA\"\u001b8ji&\fG.T8eK2,\u0012A\u001f\t\u0004qml\u0018B\u0001?:\u0005\u0019y\u0005\u000f^5p]B\u0011qM`\u0005\u0003\u007f.\u0012AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d\u0017\u0001E5oSRL\u0017\r\\'pI\u0016dw\fJ3r)\r9\u0015Q\u0001\u0005\b\u0017J\t\t\u00111\u0001{\u00035Ig.\u001b;jC2lu\u000eZ3mA\u0005y1/\u001a;J]&$\u0018.\u00197N_\u0012,G\u000e\u0006\u0003\u0002\u000e\u0005=Q\"\u0001\u0001\t\r\u0005EA\u00031\u0001~\u0003\u0015iw\u000eZ3mQ\r!b\u000e^\u0001\u0010O\u0016$\u0018J\\5uS\u0006dWj\u001c3fY\"\u001aQC\u001c;\u0002\tM,Go\u0013\u000b\u0005\u0003\u001b\ti\u0002C\u0003A-\u0001\u0007!\tK\u0002\u0017]R\fAaZ3u\u0017\"\u001aqC\u001c;\u0002!M,G/T1y\u0013R,'/\u0019;j_:\u001cH\u0003BA\u0007\u0003SAQA\u0016\rA\u0002\tC3\u0001\u00078u\u0003A9W\r^'bq&#XM]1uS>t7\u000fK\u0002\u001a]R\f\u0011c]3u\u0007>tg/\u001a:hK:\u001cW\rV8m)\u0011\ti!!\u000e\t\u000b5S\u0002\u0019A()\u0007iqG/A\thKR\u001cuN\u001c<fe\u001e,gnY3U_2D3a\u00078u\u0003\u001d\u0019X\r^*fK\u0012$B!!\u0004\u0002B!)1\f\ba\u0001;\"\u001aAD\u001c;\u0002\u000f\u001d,GoU3fI\"\u001aQD\u001c;\u0002\u0007I,h\u000eF\u0002~\u0003\u001bBq!a\u0014\u001f\u0001\u0004\t\t&\u0001\u0003eCR\f\u0007CBA*\u00033\ni&\u0004\u0002\u0002V)\u0019\u0011qK\u0018\u0002\u0007I$G-\u0003\u0003\u0002\\\u0005U#a\u0001*E\tB!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d5\na\u0001\\5oC2<\u0017\u0002BA4\u0003C\u0012aAV3di>\u0014\bf\u0001\u0010oiR\u0019Q0!\u001c\t\u000f\u0005=s\u00041\u0001\u0002pA1\u0011\u0011OA>\u0003;j!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0005U\u00064\u0018MC\u0002\u0002z=\n1!\u00199j\u0013\u0011\ti(a\u001d\u0003\u000f)\u000bg/\u0019*E\t\"\u001aqD\u001c;\u00023U\u0004H-\u0019;f/\u0016Lw\r\u001b;t\u0003:$w)Y;tg&\fgn\u001d\u000b\u000b\u0003\u000b\u000bY*!,\u00028\u0006m\u0006C\u0002\u001d\u0002\b>\u000bY)C\u0002\u0002\nf\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\rI&\u001cHO]5ckRLwN\u001c\u0006\u0004\u0003+k\u0013\u0001B:uCRLA!!'\u0002\u0010\n!R*\u001e7uSZ\f'/[1uK\u001e\u000bWo]:jC:Dq!!(!\u0001\u0004\ty*\u0001\u0003nK\u0006t\u0007#BAQ\u0003S{UBAAR\u0015\u0011\t\u0019'!*\u000b\u0005\u0005\u001d\u0016A\u00022sK\u0016TX-\u0003\u0003\u0002,\u0006\r&a\u0003#f]N,g+Z2u_JDq!a,!\u0001\u0004\t\t,A\u0003tS\u001el\u0017\rE\u0003\u0002\"\u0006Mv*\u0003\u0003\u00026\u0006\r&a\u0003#f]N,W*\u0019;sSbDa!!/!\u0001\u0004y\u0015AB<fS\u001eDG\u000f\u0003\u0004\u0002>\u0002\u0002\raT\u0001\u000bgVlw+Z5hQR\u001c\u0018A\u0003<fGR|'/T3b]R!\u0011qTAb\u0011\u001d\t)-\ta\u0001\u0003\u000f\f\u0011\u0001\u001f\t\u0007\u0003\u0013\fI.a8\u000f\t\u0005-\u0017Q\u001b\b\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011[\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014bAAls\u00059\u0001/Y2lC\u001e,\u0017\u0002BAn\u0003;\u00141aU3r\u0015\r\t9.\u000f\t\u0006\u0003C\u000b\toT\u0005\u0005\u0003O\n\u0019+\u0001\bj]&$8i\u001c<be&\fgnY3\u0015\t\u0005E\u0016q\u001d\u0005\b\u0003\u000b\u0014\u0003\u0019AAdQ\r\u0001a\u000e^\u0001\u0010\u000f\u0006,8o]5b]6K\u0007\u0010^;sKB\u0011q\rJ\n\u0004I]jDCAAw\u0003Ai\u0015\tW0O+6{f)R!U+J+5+A\tN\u0003b{f*V'`\r\u0016\u000bE+\u0016*F'\u0002\n\u0011d\u001d5pk2$G)[:ue&\u0014W\u000f^3HCV\u001c8/[1ogR1\u00111 B\u0001\u0005\u0007\u00012\u0001OA\u007f\u0013\r\ty0\u000f\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\u0005\u00061\u0001C\u0011\u0019\u0011)\u0001\u000ba\u0001\u0005\u0006\tA-A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0006!\u0011\u0011iA!\u0006\u000e\u0005\t=!\u0002\u0002B\t\u0005'\tA\u0001\\1oO*\u0011\u0011QO\u0005\u0005\u0005/\u0011yA\u0001\u0004PE*,7\r\u001e")
public class GaussianMixture
implements scala.Serializable {
    private int k;
    private double convergenceTol;
    private int maxIterations;
    private long seed;
    private final int nSamples;
    private Option<GaussianMixtureModel> initialModel;

    public static boolean shouldDistributeGaussians(int n, int n2) {
        return GaussianMixture$.MODULE$.shouldDistributeGaussians(n, n2);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int nSamples() {
        return this.nSamples;
    }

    private Option<GaussianMixtureModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<GaussianMixtureModel> x$1) {
        this.initialModel = x$1;
    }

    public GaussianMixture setInitialModel(GaussianMixtureModel model) {
        Predef$.MODULE$.require(model.k() == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Mismatched cluster count (model.k ").append(model.k()).append(" != k ").append(this.k()).append(")").toString());
        this.initialModel_$eq((Option<GaussianMixtureModel>)new Some((Object)model));
        return this;
    }

    public Option<GaussianMixtureModel> getInitialModel() {
        return this.initialModel();
    }

    public GaussianMixture setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Number of Gaussians must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public GaussianMixture setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public GaussianMixture setConvergenceTol(double convergenceTol) {
        Predef$.MODULE$.require(convergenceTol >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Convergence tolerance must be nonnegative but got ").append(convergenceTol).toString());
        this.convergenceTol_$eq(convergenceTol);
        return this;
    }

    public double getConvergenceTol() {
        return this.convergenceTol();
    }

    public GaussianMixture setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public GaussianMixtureModel run(RDD<Vector> data) {
        Tuple2 tuple2;
        SparkContext sc = data.sparkContext();
        RDD breezeData = data.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asBreeze(), ClassTag$.MODULE$.apply(breeze.linalg.Vector.class)).cache();
        int d = ((breeze.linalg.Vector)breezeData.first()).length();
        Predef$.MODULE$.require(d < GaussianMixture$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(131).append("GaussianMixture cannot handle more ").append("than ").append(GaussianMixture$.MODULE$.MAX_NUM_FEATURES()).append(" features because the size of the covariance").append(" matrix is quadratic in the number of features.").toString());
        boolean shouldDistributeGaussians = GaussianMixture$.MODULE$.shouldDistributeGaussians(this.k(), d);
        Option<GaussianMixtureModel> option = this.initialModel();
        if (option instanceof Some) {
            Some some = (Some)option;
            GaussianMixtureModel gmm = (GaussianMixtureModel)some.value();
            tuple2 = new Tuple2((Object)gmm.weights(), (Object)gmm.gaussians());
        } else if (None$.MODULE$.equals(option)) {
            breeze.linalg.Vector[] samples = (breeze.linalg.Vector[])breezeData.takeSample(true, this.k() * this.nSamples(), this.seed());
            tuple2 = new Tuple2(Array$.MODULE$.fill(this.k(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0 / (double)this.k(), ClassTag$.MODULE$.Double()), Array$.MODULE$.tabulate(this.k(), (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$run$4(this, samples, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        double[] weights = (double[])tuple22._1();
        MultivariateGaussian[] gaussians = (MultivariateGaussian[])tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)weights, (Object)gaussians);
        double[] weights2 = (double[])tuple23._1();
        MultivariateGaussian[] gaussians2 = (MultivariateGaussian[])tuple23._2();
        double llh = Double$.MODULE$.MinValue();
        double llhp = 0.0;
        for (int iter = 0; iter < this.maxIterations() && package$.MODULE$.abs(llh - llhp) > this.convergenceTol(); ++iter) {
            Broadcast compute = sc.broadcast((Function2 & Serializable & scala.Serializable)(sums, x) -> ExpectationSum$.MODULE$.add(weights2, gaussians2, (ExpectationSum)sums, (breeze.linalg.Vector<Object>)x), ClassTag$.MODULE$.apply(Function2.class));
            ExpectationSum x$12 = ExpectationSum$.MODULE$.zero(this.k(), d);
            Function2 x$2 = (Function2)compute.value();
            Function2 & Serializable & scala.Serializable x$32 = (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$plus$eq((ExpectationSum)x$4);
            int x$42 = breezeData.treeAggregate$default$4((Object)x$12);
            ExpectationSum sums2 = (ExpectationSum)breezeData.treeAggregate((Object)x$12, x$2, (Function2)x$32, x$42, ClassTag$.MODULE$.apply(ExpectationSum.class));
            double sumWeights = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sums2.weights())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            if (shouldDistributeGaussians) {
                int numPartitions = package$.MODULE$.min(this.k(), 1024);
                Seq tuples = (Seq)Seq$.MODULE$.tabulate(this.k(), (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$run$7(sums2, BoxesRunTime.unboxToInt((Object)i)));
                Tuple2 tuple24 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sc.parallelize(tuples, numPartitions, ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 != null) {
                        DenseVector mean = (DenseVector)tuple3._1();
                        breeze.linalg.DenseMatrix sigma = (breeze.linalg.DenseMatrix)tuple3._2();
                        double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        return this.updateWeightsAndGaussians((DenseVector<Object>)mean, (breeze.linalg.DenseMatrix<Object>)sigma, weight, sumWeights);
                    }
                    throw new MatchError((Object)tuple3);
                }, ClassTag$.MODULE$.apply(Tuple2.class)).collect())).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(MultivariateGaussian.class));
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                double[] ws = (double[])tuple24._1();
                MultivariateGaussian[] gs = (MultivariateGaussian[])tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)ws, (Object)gs);
                double[] ws2 = (double[])tuple25._1();
                MultivariateGaussian[] gs2 = (MultivariateGaussian[])tuple25._2();
                Array$.MODULE$.copy((Object)ws2, 0, (Object)weights2, 0, ws2.length);
                Array$.MODULE$.copy((Object)gs2, 0, (Object)gaussians2, 0, gs2.length);
            } else {
                for (int i2 = 0; i2 < this.k(); ++i2) {
                    Tuple2<Object, MultivariateGaussian> tuple26 = this.updateWeightsAndGaussians(sums2.means()[i2], sums2.sigmas()[i2], sums2.weights()[i2], sumWeights);
                    if (tuple26 == null) {
                        throw new MatchError(tuple26);
                    }
                    double weight = tuple26._1$mcD$sp();
                    MultivariateGaussian gaussian = (MultivariateGaussian)tuple26._2();
                    Tuple2 tuple27 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)weight), (Object)gaussian);
                    double weight2 = tuple27._1$mcD$sp();
                    MultivariateGaussian gaussian2 = (MultivariateGaussian)tuple27._2();
                    weights2[i2] = weight2;
                    gaussians2[i2] = gaussian2;
                }
            }
            llhp = llh;
            llh = sums2.logLikelihood();
            compute.destroy();
        }
        breezeData.unpersist(breezeData.unpersist$default$1());
        return new GaussianMixtureModel(weights2, gaussians2);
    }

    public GaussianMixtureModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    private Tuple2<Object, MultivariateGaussian> updateWeightsAndGaussians(DenseVector<Object> mean, breeze.linalg.DenseMatrix<Object> sigma, double weight, double sumWeights) {
        DenseVector mu = (DenseVector)mean.$div$eq((Object)BoxesRunTime.boxToDouble((double)weight), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpDiv());
        BLAS$.MODULE$.syr(-weight, Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), (DenseMatrix)Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma));
        double newWeight = weight / sumWeights;
        MultivariateGaussian newGaussian = new MultivariateGaussian((DenseVector<Object>)mu, (breeze.linalg.DenseMatrix<Object>)((breeze.linalg.DenseMatrix)sigma.$div((Object)BoxesRunTime.boxToDouble((double)weight), HasOps$.MODULE$.op_DM_S_Double_OpDiv())));
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)newWeight), (Object)newGaussian);
    }

    private DenseVector<Object> vectorMean(Seq<breeze.linalg.Vector<Object>> x) {
        DenseVector v = DenseVector$.MODULE$.zeros$mDc$sp(((breeze.linalg.Vector)x.apply(0)).length(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        x.foreach((Function1 & Serializable & scala.Serializable)xi -> (DenseVector)v.$plus$eq(xi, (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_DV_V_zero_idempotent_Double_OpAdd()));
        return (DenseVector)v.$div((Object)BoxesRunTime.boxToDouble((double)x.length()), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv());
    }

    private breeze.linalg.DenseMatrix<Object> initCovariance(Seq<breeze.linalg.Vector<Object>> x) {
        DenseVector<Object> mu = this.vectorMean(x);
        DenseVector ss = DenseVector$.MODULE$.zeros$mDc$sp(((breeze.linalg.Vector)x.apply(0)).length(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        x.foreach((Function1 & Serializable & scala.Serializable)xi -> {
            breeze.linalg.Vector d = (breeze.linalg.Vector)xi.$minus((Object)mu, HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.castUpdateOps_V_V(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), NotGiven$.MODULE$.neq(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_V_Idempotent_Double_OpSub()), Vector$.MODULE$.canCopy()));
            return (DenseVector)ss.$plus$eq(d.$up$colon$up((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpPow()), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_DV_V_zero_idempotent_Double_OpAdd());
        });
        return (breeze.linalg.DenseMatrix)diag$.MODULE$.apply(ss.$div((Object)BoxesRunTime.boxToDouble((double)x.length()), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv()), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()));
    }

    public static final /* synthetic */ MultivariateGaussian $anonfun$run$4(GaussianMixture $this, breeze.linalg.Vector[] samples$1, int i) {
        IndexedSeqView slice = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])samples$1)).view().slice(i * $this.nSamples(), (i + 1) * $this.nSamples());
        return new MultivariateGaussian($this.vectorMean((Seq<breeze.linalg.Vector<Object>>)slice.toSeq()), $this.initCovariance((Seq<breeze.linalg.Vector<Object>>)slice.toSeq()));
    }

    public static final /* synthetic */ Tuple3 $anonfun$run$7(ExpectationSum sums$1, int i) {
        return new Tuple3(sums$1.means()[i], sums$1.sigmas()[i], (Object)BoxesRunTime.boxToDouble((double)sums$1.weights()[i]));
    }

    private GaussianMixture(int k, double convergenceTol, int maxIterations, long seed) {
        this.k = k;
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
        this.seed = seed;
        this.nSamples = 5;
        this.initialModel = None$.MODULE$;
    }

    public GaussianMixture() {
        this(2, 0.01, 100, Utils$.MODULE$.random().nextLong());
    }
}

