/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.CSCMatrix;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$mcD$sp;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.SparseVector$mcD$sp;
import breeze.linalg.View;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import java.util.Arrays;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag;

public class CSCMatrix$mcD$sp
extends CSCMatrix<Object>
implements Matrix$mcD$sp {
    public double[] _data$mcD$sp;
    public final Zero<Object> evidence$1$mcD$sp;
    private final int[] _rowIndices;

    @Override
    public double[] _data$mcD$sp() {
        return this._data$mcD$sp;
    }

    public double[] _data() {
        return this._data$mcD$sp();
    }

    @Override
    public void _data$mcD$sp_$eq(double[] x$1) {
        this._data$mcD$sp = x$1;
    }

    public void _data_$eq(double[] x$1) {
        this._data$mcD$sp_$eq(x$1);
    }

    public double[] data() {
        return this.data$mcD$sp();
    }

    @Override
    public double[] data$mcD$sp() {
        return this._data();
    }

    @Override
    public double apply(int row, int col) {
        return this.apply$mcD$sp(row, col);
    }

    @Override
    public double apply$mcD$sp(int row, int col) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.breeze$linalg$CSCMatrix$$locate(row, col);
        return ind < 0 ? this.zero$mcD$sp() : this.data$mcD$sp()[ind];
    }

    @Override
    public void update(int row, int col, double v) {
        this.update$mcD$sp(row, col, v);
    }

    @Override
    public void update$mcD$sp(int row, int col, double v) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.breeze$linalg$CSCMatrix$$locate(row, col);
        if (ind >= 0) {
            this.data$mcD$sp()[ind] = v;
        } else if (v != this.zero$mcD$sp()) {
            int insertPos = ~ind;
            this.used_$eq(this.used() + 1);
            if (this.used() > this.data$mcD$sp().length) {
                int newLength = this.data$mcD$sp().length == 0 ? 4 : (this.data$mcD$sp().length < 1024 ? this.data$mcD$sp().length * 2 : (this.data$mcD$sp().length < 2048 ? this.data$mcD$sp().length + 1024 : (this.data$mcD$sp().length < 4096 ? this.data$mcD$sp().length + 2048 : (this.data$mcD$sp().length < 8192 ? this.data$mcD$sp().length + 4096 : (this.data$mcD$sp().length < 16384 ? this.data$mcD$sp().length + 8192 : this.data$mcD$sp().length + 16384)))));
                int[] newIndex = Arrays.copyOf(this.rowIndices(), newLength);
                double[] newData = (double[])ArrayUtil$.MODULE$.copyOf(this.data$mcD$sp(), newLength);
                System.arraycopy(this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos, newIndex, insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data$mcD$sp(), insertPos, newData, insertPos + 1, this.used() - insertPos - 1);
                this.breeze$linalg$CSCMatrix$$_rowIndices_$eq(newIndex);
                this._data_$eq(newData);
            } else if (this.used() - insertPos > 1) {
                System.arraycopy(this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos, this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data$mcD$sp(), insertPos, this.data$mcD$sp(), insertPos + 1, this.used() - insertPos - 1);
            }
            this.rowIndices()[insertPos] = row;
            this.data$mcD$sp()[insertPos] = v;
            int end$macro$3 = this.cols();
            for (int index$macro$2 = col + 1; index$macro$2 <= end$macro$3; ++index$macro$2) {
                this.colPtrs()[index$macro$2] = this.colPtrs()[index$macro$2] + 1;
            }
        }
    }

    @Override
    public CSCMatrix<Object> repr() {
        return this.repr$mcD$sp();
    }

    @Override
    public CSCMatrix<Object> repr$mcD$sp() {
        return this;
    }

    @Override
    public double zero() {
        return this.zero$mcD$sp();
    }

    @Override
    public double zero$mcD$sp() {
        return ((Zero)Predef$.MODULE$.implicitly(this.evidence$1$mcD$sp)).zero$mcD$sp();
    }

    @Override
    public void use(CSCMatrix<Object> matrix) {
        this.use$mcD$sp(matrix);
    }

    @Override
    public void use$mcD$sp(CSCMatrix<Object> matrix) {
        this.use$mcD$sp(matrix.data$mcD$sp(), matrix.colPtrs(), matrix.rowIndices(), matrix.used());
    }

    public void use(double[] data, int[] colPtrs, int[] rowIndices, int used) {
        this.use$mcD$sp(data, colPtrs, rowIndices, used);
    }

    @Override
    public void use$mcD$sp(double[] data, int[] colPtrs, int[] rowIndices, int used) {
        boolean cond$macro$5;
        boolean cond$macro$4;
        boolean cond$macro$3;
        int left$macro$1 = colPtrs.length;
        int right$macro$2 = this.colPtrs().length;
        if (left$macro$1 != right$macro$2) {
            throw new IllegalArgumentException(new StringBuilder(64).append("requirement failed: ").append("colPtrs.length == this.colPtrs.length (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString());
        }
        boolean bl = cond$macro$3 = used >= 0;
        if (!cond$macro$3) {
            throw new IllegalArgumentException("requirement failed: used.>=(0)");
        }
        boolean bl2 = cond$macro$4 = data.length >= used;
        if (!cond$macro$4) {
            throw new IllegalArgumentException("requirement failed: data.length.>=(used)");
        }
        boolean bl3 = cond$macro$5 = rowIndices.length >= used;
        if (!cond$macro$5) {
            throw new IllegalArgumentException("requirement failed: rowIndices.length.>=(used)");
        }
        this._data_$eq(data);
        System.arraycopy(colPtrs, 0, this.colPtrs(), 0, colPtrs.length);
        this.breeze$linalg$CSCMatrix$$_rowIndices_$eq(rowIndices);
        this.used_$eq(used);
    }

    @Override
    public CSCMatrix<Object> copy() {
        return this.copy$mcD$sp();
    }

    @Override
    public CSCMatrix<Object> copy$mcD$sp() {
        return new CSCMatrix$mcD$sp((double[])ArrayUtil$.MODULE$.copyOf(this._data(), this.activeSize()), this.rows(), this.cols(), (int[])this.colPtrs().clone(), this.activeSize(), (int[])this.breeze$linalg$CSCMatrix$$_rowIndices().clone(), this.evidence$1$mcD$sp);
    }

    @Override
    public SparseVector<Object> flatten(View view) {
        return this.flatten$mcD$sp(view);
    }

    @Override
    public SparseVector<Object> flatten$mcD$sp(View view) {
        SparseVector<Object> sparseVector;
        View view2 = view;
        if (View$Require$.MODULE$.equals(view2)) {
            int[] indices = new int[this.data$mcD$sp().length];
            int ind = 0;
            for (int j = 0; j < this.cols(); ++j) {
                int ip = this.colPtrs()[j];
                while (ip < this.colPtrs()[j + 1]) {
                    int i = this.rowIndices()[ip];
                    indices[ind] = i * this.rows() + j;
                    ++ip;
                    ++ind;
                }
            }
            sparseVector = new SparseVector$mcD$sp(indices, this.data$mcD$sp(), this.activeSize(), this.rows() * this.cols(), this.evidence$1$mcD$sp);
        } else if (View$Copy$.MODULE$.equals(view2)) {
            ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data$mcD$sp());
            SparseVector<Object> sv = SparseVector$.MODULE$.zeros$mDc$sp(this.rows() * this.cols(), man, this.evidence$1$mcD$sp);
            for (int j = 0; j < this.cols(); ++j) {
                for (int ip = this.colPtrs()[j]; ip < this.colPtrs()[j + 1]; ++ip) {
                    int i = this.rowIndices()[ip];
                    sv.update$mcD$sp(i * this.cols() + j, this.data$mcD$sp()[ip]);
                }
            }
            sparseVector = sv;
        } else if (View$Prefer$.MODULE$.equals(view2)) {
            sparseVector = this.flatten$mcD$sp(View$Require$.MODULE$);
        } else {
            throw new MatchError((Object)view2);
        }
        return sparseVector;
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDenseMatrix$mcD$sp(cm, zero);
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix$mcD$sp(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDense$mcD$sp();
    }

    @Override
    public DenseMatrix<Object> toDense() {
        return this.toDense$mcD$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toDense$mcD$sp() {
        void var2_2;
        ClassTag ctg = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data$mcD$sp());
        Matrix res = DenseMatrix$.MODULE$.zeros$mDc$sp(this.rows(), this.cols(), ctg, (Zero)this.evidence$1$mcD$sp);
        for (int i = 0; i < this.cols(); ++i) {
            for (int j = this.colPtrs()[i]; j < this.colPtrs()[i + 1]; ++j) {
                ((DenseMatrix)res).update$mcD$sp(this.rowIndices()[j], i, this.data$mcD$sp()[j]);
            }
        }
        return var2_2;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public CSCMatrix$mcD$sp(double[] _data$mcD$sp, int rows, int cols, int[] colPtrs, int used, int[] _rowIndices, Zero<Object> evidence$1$mcD$sp) {
        this._data$mcD$sp = _data$mcD$sp;
        this.evidence$1$mcD$sp = evidence$1$mcD$sp;
        this._rowIndices = _rowIndices;
        super(_data$mcD$sp, rows, cols, colPtrs, used, _rowIndices, evidence$1$mcD$sp);
    }

    public CSCMatrix$mcD$sp(double[] data$mcD$sp, int rows, int cols, int[] colPtrs, int[] rowIndices, Zero<Object> evidence$2$mcD$sp) {
        this(data$mcD$sp, rows, cols, colPtrs, data$mcD$sp.length, rowIndices, evidence$2$mcD$sp);
    }
}

