/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.catalyst.optimizer.NormalizeFloatingNumbers$;
import org.apache.spark.sql.catalyst.util.HyperLogLogPlusPlusHelper$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0012%\u0001EB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\r\t\u0002!\t\u0011!B\u0001\u0002\u0003\u0006I!\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B#\t\r%\u0003\u0001\u0015!\u0003K\u00111i\u0005\u0001\"A\u0001\u0006\u0003\u0005\t\u0015!\u0003F\u0011\u0019q\u0005\u0001)A\u0005y!9q\n\u0001b\u0001\n\u0003\u0001\u0006BB)\u0001A\u0003%Q\tC\u0003S\u0001\u0011\u00051\u000bC\u0003m\u0001\u0011\u0005Q\u000eC\u0003w\u0001\u0011\u0005q\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0003\u007f\u0001\u0011\u0005qpB\u0004\u0002\u0002\u0011B\t!a\u0001\u0007\r\r\"\u0003\u0012AA\u0003\u0011\u0019y\u0004\u0003\"\u0001\u0002\b!A\u0011\u0011\u0002\tC\u0002\u0013\u0005\u0001\u000bC\u0004\u0002\fA\u0001\u000b\u0011B#\t\u0011\u00055\u0001C1A\u0005\u0002ACq!a\u0004\u0011A\u0003%Q\tC\u0005\u0002\u0012A\u0011\r\u0011\"\u0001\u0002\u0014!9\u0011Q\u0003\t!\u0002\u0013Q\u0005\u0002CA\f!\t\u0007I\u0011\u0001)\t\u000f\u0005e\u0001\u0003)A\u0005\u000b\"A\u00111\u0004\tC\u0002\u0013\u0005\u0001\u000bC\u0004\u0002\u001eA\u0001\u000b\u0011B#\t\u0013\u0005}\u0001C1A\u0005\u0002\u0005\u0005\u0002\u0002CA\u0015!\u0001\u0006I!a\t\t\u0013\u0005-\u0002C1A\u0005\u0002\u00055\u0002\u0002CA\u0019!\u0001\u0006I!a\f\t\u0013\u0005M\u0002C1A\u0005\u0002\u00055\u0002\u0002CA\u001b!\u0001\u0006I!a\f\t\u0013\u0005]\u0002#!A\u0005\n\u0005e\"!\u0007%za\u0016\u0014Hj\\4M_\u001e\u0004F.^:QYV\u001c\b*\u001a7qKJT!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0004\u0001IB\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u00024s%\u0011!\b\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000be\u0016d\u0017\r^5wKN#\u0005CA\u001a>\u0013\tqDG\u0001\u0004E_V\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001b\u0005C\u0001\"\u0001\u001b\u0005!\u0003\"B\u001e\u0003\u0001\u0004a\u0014aP8sO\u0012\n\u0007/Y2iK\u0012\u001a\b/\u0019:lIM\fH\u000eJ2bi\u0006d\u0017p\u001d;%kRLG\u000e\n%za\u0016\u0014Hj\\4M_\u001e\u0004F.^:QYV\u001c\b*\u001a7qKJ$C\u0005\u001d\t\u0003g\u0019K!a\u0012\u001b\u0003\u0007%sG/\u0001\u0005jIb\u001c\u0006.\u001b4u\u0003!9\b+\u00193eS:<\u0007CA\u001aL\u0013\taEG\u0001\u0003M_:<\u0017aP8sO\u0012\n\u0007/Y2iK\u0012\u001a\b/\u0019:lIM\fH\u000eJ2bi\u0006d\u0017p\u001d;%kRLG\u000e\n%za\u0016\u0014Hj\\4M_\u001e\u0004F.^:QYV\u001c\b*\u001a7qKJ$C%\\\u0001\bC2\u0004\b.Y'3\u0003!qW/\\,pe\u0012\u001cX#A#\u0002\u00139,XnV8sIN\u0004\u0013AB;qI\u0006$X\rF\u0003U/v{F\r\u0005\u00024+&\u0011a\u000b\u000e\u0002\u0005+:LG\u000fC\u0003Y\u0015\u0001\u0007\u0011,\u0001\u0004ck\u001a4WM\u001d\t\u00035nk\u0011AJ\u0005\u00039\u001a\u00121\"\u00138uKJt\u0017\r\u001c*po\")aL\u0003a\u0001\u000b\u0006a!-\u001e4gKJ|eMZ:fi\")\u0001M\u0003a\u0001C\u00061qL^1mk\u0016\u0004\"a\r2\n\u0005\r$$aA!os\")QM\u0003a\u0001M\u0006AA-\u0019;b)f\u0004X\r\u0005\u0002hU6\t\u0001N\u0003\u0002jQ\u0005)A/\u001f9fg&\u00111\u000e\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006)Q.\u001a:hKR)AK\u001c9si\")qn\u0003a\u00013\u00069!-\u001e4gKJ\f\u0004\"B9\f\u0001\u0004I\u0016a\u00022vM\u001a,'O\r\u0005\u0006g.\u0001\r!R\u0001\b_\u001a47/\u001a;2\u0011\u0015)8\u00021\u0001F\u0003\u001dygMZ:fiJ\nA\"Z:uS6\fG/\u001a\"jCN$\"\u0001\u0010=\t\u000bed\u0001\u0019\u0001\u001f\u0002\u0003\u0015\fQ!];fef$2A\u0013?~\u0011\u0015AV\u00021\u0001Z\u0011\u0015qV\u00021\u0001F\u0003\u001d!(/^3Sg\u0012,\u0012\u0001P\u0001\u001a\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d%fYB,'\u000f\u0005\u0002C!M\u0019\u0001C\r\u001d\u0015\u0005\u0005\r\u0011!C,P%\u0012{6+\u0013.F\u0003)9vJ\u0015#`'&SV\tI\u0001\u000e%\u0016;\u0015j\u0015+F%~\u001b\u0016JW#\u0002\u001dI+u)S*U\u000bJ{6+\u0013.FA\u0005\u0011\"+R$J'R+%kX,P%\u0012{V*Q*L+\u0005Q\u0015a\u0005*F\u000f&\u001bF+\u0012*`/>\u0013FiX'B'.\u0003\u0013A\u0005*F\u000f&\u001bF+\u0012*T?B+%kX,P%\u0012\u000b1CU#H\u0013N#VIU*`!\u0016\u0013vlV(S\t\u0002\n\u0011aS\u0001\u0003\u0017\u0002\n!\u0002\u0016%S\u000bNCu\n\u0014#T+\t\t\u0019\u0003\u0005\u00034\u0003Ka\u0014bAA\u0014i\t)\u0011I\u001d:bs\u0006YA\u000b\u0013*F'\"{E\nR*!\u0003E\u0011\u0016iV0F'RKU*\u0011+F?\u0012\u000bE+Q\u000b\u0003\u0003_\u0001RaMA\u0013\u0003G\t!CU!X?\u0016\u001bF+S'B)\u0016{F)\u0011+BA\u0005I!)S!T?\u0012\u000bE+Q\u0001\u000b\u0005&\u000b5k\u0018#B)\u0006\u0003\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!A.\u00198h\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA%\u0003\u007f\u0011aa\u00142kK\u000e$\b")
public class HyperLogLogPlusPlusHelper
implements Serializable {
    public final int org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p;
    private final int idxShift;
    private final long wPadding;
    public final int org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m;
    private final double alphaM2;
    private final int numWords;

    public static double[][] BIAS_DATA() {
        return HyperLogLogPlusPlusHelper$.MODULE$.BIAS_DATA();
    }

    public static double[][] RAW_ESTIMATE_DATA() {
        return HyperLogLogPlusPlusHelper$.MODULE$.RAW_ESTIMATE_DATA();
    }

    public static double[] THRESHOLDS() {
        return HyperLogLogPlusPlusHelper$.MODULE$.THRESHOLDS();
    }

    public static int K() {
        return HyperLogLogPlusPlusHelper$.MODULE$.K();
    }

    public static int REGISTERS_PER_WORD() {
        return HyperLogLogPlusPlusHelper$.MODULE$.REGISTERS_PER_WORD();
    }

    public static long REGISTER_WORD_MASK() {
        return HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_WORD_MASK();
    }

    public static int REGISTER_SIZE() {
        return HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_SIZE();
    }

    public static int WORD_SIZE() {
        return HyperLogLogPlusPlusHelper$.MODULE$.WORD_SIZE();
    }

    public int numWords() {
        return this.numWords;
    }

    public void update(InternalRow buffer, int bufferOffset, Object _value, DataType dataType) {
        DataType dataType2 = dataType;
        Object value = FloatType$.MODULE$.equals(dataType2) ? NormalizeFloatingNumbers$.MODULE$.FLOAT_NORMALIZER().apply(_value) : (DoubleType$.MODULE$.equals(dataType2) ? NormalizeFloatingNumbers$.MODULE$.DOUBLE_NORMALIZER().apply(_value) : _value);
        long x = XxHash64Function$.MODULE$.hash(value, dataType, 42L);
        int idx = (int)(x >>> this.idxShift);
        long pw = (long)Long.numberOfLeadingZeros(x << this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p | this.wPadding) + 1L;
        int wordOffset = idx / HyperLogLogPlusPlusHelper$.MODULE$.REGISTERS_PER_WORD();
        long word = buffer.getLong(bufferOffset + wordOffset);
        int shift = HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_SIZE() * (idx - wordOffset * HyperLogLogPlusPlusHelper$.MODULE$.REGISTERS_PER_WORD());
        long mask = HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_WORD_MASK() << shift;
        long Midx = (word & mask) >>> shift;
        if (pw > Midx) {
            buffer.setLong(bufferOffset + wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL) | pw << shift);
            return;
        }
    }

    public void merge(InternalRow buffer1, InternalRow buffer2, int offset1, int offset2) {
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords(); ++wordOffset) {
            long word1 = buffer1.getLong(offset1 + wordOffset);
            long word2 = buffer2.getLong(offset2 + wordOffset);
            long word = 0L;
            long mask = HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m && i < HyperLogLogPlusPlusHelper$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_SIZE();
            }
            buffer1.setLong(offset1 + wordOffset, word);
        }
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HyperLogLogPlusPlusHelper$.MODULE$.RAW_ESTIMATE_DATA()[this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HyperLogLogPlusPlusHelper$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HyperLogLogPlusPlusHelper$.MODULE$.K(), numEstimates); high < numEstimates && HyperLogLogPlusPlusHelper.distance$1(high, e, estimates) < HyperLogLogPlusPlusHelper.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HyperLogLogPlusPlusHelper$.MODULE$.BIAS_DATA()[this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    public long query(InternalRow buffer, int bufferOffset) {
        double d;
        double zInverse = 0.0;
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords(); ++wordOffset) {
            long word = buffer.getLong(bufferOffset + wordOffset);
            int shift = 0;
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m && i < HyperLogLogPlusPlusHelper$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_WORD_MASK();
                zInverse += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HyperLogLogPlusPlusHelper$.MODULE$.REGISTER_SIZE();
            }
        }
        double E = this.alphaM2 / zInverse;
        if (V > 0.0) {
            double H = (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m * Math.log((double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m / V);
            d = this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p < 19 && H <= HyperLogLogPlusPlusHelper$.MODULE$.THRESHOLDS()[this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p - 4] || E <= 2.5 * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m ? H : this.EBiasCorrected$1(E);
        } else {
            d = this.EBiasCorrected$1(E);
        }
        double estimate = d;
        return Math.round(estimate);
    }

    public double trueRsd() {
        return 1.04 / package$.MODULE$.sqrt((double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m);
    }

    private static final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff = e$1 - estimates$1[i];
        return diff * diff;
    }

    private final double EBiasCorrected$1(double E$1) {
        double d = E$1;
        if (this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p < 19 && d < 5.0 * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m) {
            return d - this.estimateBias(d);
        }
        return d;
    }

    public HyperLogLogPlusPlusHelper(double relativeSD) {
        double d;
        this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p = (int)Math.ceil(2.0 * Math.log(1.106 / relativeSD) / Math.log(2.0));
        Predef$.MODULE$.require(this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p >= 4, (Function0 & java.io.Serializable & Serializable)() -> "HLL++ requires at least 4 bits for addressing. Use a lower error, at most 39%.");
        this.idxShift = 64 - this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p;
        this.wPadding = 1L << this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p - 1;
        this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m = 1 << this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p;
        int n = this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$p;
        switch (n) {
            case 4: {
                d = 0.673 * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m;
                break;
            }
            case 5: {
                d = 0.697 * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m;
                break;
            }
            case 6: {
                d = 0.709 * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m;
                break;
            }
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m) * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m * (double)this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m;
                break;
            }
        }
        this.alphaM2 = d;
        this.numWords = this.org$apache$spark$sql$catalyst$util$HyperLogLogPlusPlusHelper$$m / HyperLogLogPlusPlusHelper$.MODULE$.REGISTERS_PER_WORD() + 1;
    }
}

