/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import org.apache.datasketches.QuantilesHelper;

final class KllDoublesQuantileCalculator {
    private final long n_;
    private final double[] items_;
    private final long[] weights_;
    private final int[] levels_;
    private int numLevels_;

    KllDoublesQuantileCalculator(double[] items, int[] levels, int numLevels, long n) {
        this.n_ = n;
        int numItems = levels[numLevels] - levels[0];
        this.items_ = new double[numItems];
        this.weights_ = new long[numItems + 1];
        this.levels_ = new int[numLevels + 1];
        this.populateFromSketch(items, levels, numLevels, numItems);
        KllDoublesQuantileCalculator.blockyTandemMergeSort(this.items_, this.weights_, this.levels_, this.numLevels_);
        QuantilesHelper.convertToPrecedingCummulative(this.weights_);
    }

    KllDoublesQuantileCalculator(double[] items, long[] weights, long n) {
        this.n_ = n;
        this.items_ = items;
        this.weights_ = weights;
        this.levels_ = null;
        this.numLevels_ = 0;
    }

    private static void blockyTandemMergeSort(double[] items, long[] weights, int[] levels, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        double[] itemsTmp = Arrays.copyOf(items, items.length);
        long[] weightsTmp = Arrays.copyOf(weights, items.length);
        KllDoublesQuantileCalculator.blockyTandemMergeSortRecursion(itemsTmp, weightsTmp, items, weights, levels, 0, numLevels);
    }

    private static void blockyTandemMergeSortRecursion(double[] itemsSrc, long[] weightsSrc, double[] itemsDst, long[] weightsDst, int[] levels, int startingLevel, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        int numLevels1 = numLevels / 2;
        int numLevels2 = numLevels - numLevels1;
        assert (numLevels1 >= 1);
        assert (numLevels2 >= numLevels1);
        int startingLevel1 = startingLevel;
        int startingLevel2 = startingLevel + numLevels1;
        KllDoublesQuantileCalculator.blockyTandemMergeSortRecursion(itemsDst, weightsDst, itemsSrc, weightsSrc, levels, startingLevel1, numLevels1);
        KllDoublesQuantileCalculator.blockyTandemMergeSortRecursion(itemsDst, weightsDst, itemsSrc, weightsSrc, levels, startingLevel2, numLevels2);
        KllDoublesQuantileCalculator.tandemMerge(itemsSrc, weightsSrc, itemsDst, weightsDst, levels, startingLevel1, numLevels1, startingLevel2, numLevels2);
    }

    private static void tandemMerge(double[] itemsSrc, long[] weightsSrc, double[] itemsDst, long[] weightsDst, int[] levelStarts, int startingLevel1, int numLevels1, int startingLevel2, int numLevels2) {
        int fromIndex1 = levelStarts[startingLevel1];
        int toIndex1 = levelStarts[startingLevel1 + numLevels1];
        int fromIndex2 = levelStarts[startingLevel2];
        int toIndex2 = levelStarts[startingLevel2 + numLevels2];
        int iSrc1 = fromIndex1;
        int iSrc2 = fromIndex2;
        int iDst = fromIndex1;
        while (iSrc1 < toIndex1 && iSrc2 < toIndex2) {
            if (itemsSrc[iSrc1] < itemsSrc[iSrc2]) {
                itemsDst[iDst] = itemsSrc[iSrc1];
                weightsDst[iDst] = weightsSrc[iSrc1];
                ++iSrc1;
            } else {
                itemsDst[iDst] = itemsSrc[iSrc2];
                weightsDst[iDst] = weightsSrc[iSrc2];
                ++iSrc2;
            }
            ++iDst;
        }
        if (iSrc1 < toIndex1) {
            System.arraycopy(itemsSrc, iSrc1, itemsDst, iDst, toIndex1 - iSrc1);
            System.arraycopy(weightsSrc, iSrc1, weightsDst, iDst, toIndex1 - iSrc1);
        } else if (iSrc2 < toIndex2) {
            System.arraycopy(itemsSrc, iSrc2, itemsDst, iDst, toIndex2 - iSrc2);
            System.arraycopy(weightsSrc, iSrc2, weightsDst, iDst, toIndex2 - iSrc2);
        }
    }

    double getQuantile(double rank) {
        long pos = QuantilesHelper.posOfRank(rank, this.n_);
        return this.approximatelyAnswerPositonalQuery(pos);
    }

    private double approximatelyAnswerPositonalQuery(long pos) {
        assert (pos >= 0L);
        assert (pos < this.n_);
        int index = QuantilesHelper.chunkContainingPos(this.weights_, pos);
        return this.items_[index];
    }

    private void populateFromSketch(double[] srcItems, int[] srcLevels, int numLevels, int numItems) {
        int offset = srcLevels[0];
        System.arraycopy(srcItems, offset, this.items_, 0, numItems);
        int srcLevel = 0;
        int dstLevel = 0;
        long weight = 1L;
        while (srcLevel < numLevels) {
            int fromIndex = srcLevels[srcLevel] - offset;
            int toIndex = srcLevels[srcLevel + 1] - offset;
            if (fromIndex < toIndex) {
                Arrays.fill(this.weights_, fromIndex, toIndex, weight);
                this.levels_[dstLevel] = fromIndex;
                this.levels_[dstLevel + 1] = toIndex;
                ++dstLevel;
            }
            ++srcLevel;
            weight *= 2L;
        }
        this.weights_[numItems] = 0L;
        this.numLevels_ = dstLevel;
    }
}

