/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001\u0002!B\u0005)C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0007E\u0002!\t!Q2\t\u000f\u0019\u0004!\u0019!C\u0005O\"1q\u000e\u0001Q\u0001\n!DQ\u0001\u001d\u0001\u0005\u0002EDQ\u0001\u001d\u0001\u0005\u0002]Dq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005%\u0002bBA\t\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t\t\u0005\u0001C\u0001\u0003'Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAQ\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005]\u0007\u0001\"\u0003\u0002`\"9\u0011q\u001b\u0001\u0005\n\u0005u\bb\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005oAqA!\u0010\u0001\t\u0013\u0011y\u0004C\u0004\u0003D\u0001!\tA!\u0012\t\u000f\t\r\u0003\u0001\"\u0003\u0003J!9!1\t\u0001\u0005\n\tm\u0003b\u0002B0\u0001\u0011%!\u0011\r\u0005\b\u0005K\u0002A\u0011\u0002B4\u0011\u001d\u00119\b\u0001C\u0005\u0005sBqA!\"\u0001\t\u0003\u00119\tC\u0004\u0003\u001c\u0002!\tA!(\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\"9!q\u0015\u0001\u0005\u0002\t%\u0006b\u0002BW\u0001\u0011\u0005!q\u0016\u0005\b\u0005g\u0003A\u0011\u0001B[\u0011\u001d\u0011I\f\u0001C\u0005\u0005wCqA!8\u0001\t\u0013\u0011y\u000eC\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0003j\"I!1\u001e\u0001A\u0002\u0013%!Q\u001e\u0005\b\u0005g\u0004\u0001\u0015)\u0003z\u0011!\u0001\b\u00011A\u0005\n\tU\b\"\u0003B|\u0001\u0001\u0007I\u0011\u0002B}\u0011\u001d\u0011i\u0010\u0001Q!\nQD\u0011Ba@\u0001\u0001\u0004%Ia!\u0001\t\u0013\r\r\u0001\u00011A\u0005\n\r\u0015\u0001\u0002CB\u0005\u0001\u0001\u0006K!!1\t\u0013\r-\u0001\u00011A\u0005\n\r5\u0001\"CB\t\u0001\u0001\u0007I\u0011BB\n\u0011!\u00199\u0002\u0001Q!\n\r=\u0001\"CB\r\u0001\u0001\u0007I\u0011BB\u0007\u0011%\u0019Y\u0002\u0001a\u0001\n\u0013\u0019i\u0002\u0003\u0005\u0004\"\u0001\u0001\u000b\u0015BB\b\u0011%\t9\t\u0001a\u0001\n\u0013\u0019\u0019\u0003C\u0005\u0004(\u0001\u0001\r\u0011\"\u0003\u0004*!A1Q\u0006\u0001!B\u0013\u0019)\u0003C\u0005\u00040\u0001\u0001\r\u0011\"\u0003\u0004\u000e!I1\u0011\u0007\u0001A\u0002\u0013%11\u0007\u0005\t\u0007o\u0001\u0001\u0015)\u0003\u0004\u0010\tyA)\u0019;b\rJ\fW.Z,sSR,'O\u0003\u0002C\u0007\u0006\u00191/\u001d7\u000b\u0005\u0011+\u0015!B:qCJ\\'B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001e\u001c\u0001!\u0006\u0002L3N\u0011\u0001\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\u0005\u0011\u001c\bc\u0001+V/6\t\u0011)\u0003\u0002W\u0003\n9A)\u0019;bg\u0016$\bC\u0001-Z\u0019\u0001!QA\u0017\u0001C\u0002m\u0013\u0011\u0001V\t\u00039~\u0003\"!T/\n\u0005ys%a\u0002(pi\"Lgn\u001a\t\u0003\u001b\u0002L!!\u0019(\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0016\u00042\u0001\u0016\u0001X\u0011\u0015\u0011&\u00011\u0001T\u0003\t!g-F\u0001i!\tIGN\u0004\u0002UU&\u00111.Q\u0001\ba\u0006\u001c7.Y4f\u0013\tigNA\u0005ECR\fgI]1nK*\u00111.Q\u0001\u0004I\u001a\u0004\u0013\u0001B7pI\u0016$\"\u0001\u001a:\t\u000bM,\u0001\u0019\u0001;\u0002\u0011M\fg/Z'pI\u0016\u0004\"\u0001V;\n\u0005Y\f%\u0001C*bm\u0016lu\u000eZ3\u0015\u0005\u0011D\b\"B:\u0007\u0001\u0004I\bc\u0001>\u0002\u00049\u00111p \t\u0003y:k\u0011! \u0006\u0003}&\u000ba\u0001\u0010:p_Rt\u0014bAA\u0001\u001d\u00061\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u0001O\u0003\u00191wN]7biR\u0019A-!\u0004\t\r\u0005=q\u00011\u0001z\u0003\u0019\u0019x.\u001e:dK\u00061q\u000e\u001d;j_:$R\u0001ZA\u000b\u00033Aa!a\u0006\t\u0001\u0004I\u0018aA6fs\"1\u00111\u0004\u0005A\u0002e\fQA^1mk\u0016$R\u0001ZA\u0010\u0003CAa!a\u0006\n\u0001\u0004I\bbBA\u000e\u0013\u0001\u0007\u00111\u0005\t\u0004\u001b\u0006\u0015\u0012bAA\u0014\u001d\n9!i\\8mK\u0006tG#\u00023\u0002,\u00055\u0002BBA\f\u0015\u0001\u0007\u0011\u0010C\u0004\u0002\u001c)\u0001\r!a\f\u0011\u00075\u000b\t$C\u0002\u000249\u0013A\u0001T8oOR)A-a\u000e\u0002:!1\u0011qC\u0006A\u0002eDq!a\u0007\f\u0001\u0004\tY\u0004E\u0002N\u0003{I1!a\u0010O\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHc\u00013\u0002F!9\u0011\u0011\t\u0007A\u0002\u0005\u001d\u0003CBA%\u0003\u001fJ\u00180\u0004\u0002\u0002L)\u0019\u0011Q\n(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0005-#aA'baR\u0019A-!\u0016\t\u000f\u0005\u0005S\u00021\u0001\u0002XA1\u0011\u0011LA2sfl!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005kRLGN\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t\t&a\u0017\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0004I\u0006%\u0004bBA6\u001d\u0001\u0007\u0011QN\u0001\tG>dg*Y7fgB!Q*a\u001cz\u0013\r\t\tH\u0014\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\b\u0002vA!\u0011qOA?\u001b\t\tIHC\u0002\u0002|9\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty(!\u001f\u0003\u000fY\f'/\u0019:hg\u0006A!-^2lKR\u0014\u0015\u0010F\u0004e\u0003\u000b\u000by)a%\t\u000f\u0005\u001du\u00021\u0001\u0002\n\u0006Qa.^7Ck\u000e\\W\r^:\u0011\u00075\u000bY)C\u0002\u0002\u000e:\u00131!\u00138u\u0011\u0019\t\tj\u0004a\u0001s\u000691m\u001c7OC6,\u0007bBA6\u001f\u0001\u0007\u0011Q\u000e\u0015\u0004\u001f\u0005U\u0014AB:peR\u0014\u0015\u0010F\u0003e\u00037\u000bi\n\u0003\u0004\u0002\u0012B\u0001\r!\u001f\u0005\b\u0003W\u0002\u0002\u0019AA7Q\r\u0001\u0012QO\u0001\u0005g\u00064X\r\u0006\u0003\u0002&\u0006-\u0006cA'\u0002(&\u0019\u0011\u0011\u0016(\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003[\u000b\u0002\u0019A=\u0002\tA\fG\u000f\u001b\u000b\u0003\u0003K\u000bAb]1wK&sG/\u001a:oC2$B!!*\u00026\"9\u0011QV\nA\u0002\u0005]\u0006\u0003B'\u0002:fL1!a/O\u0005\u0019y\u0005\u000f^5p]\u0006\u0011r-\u001a;PaRLwN\\:XSRD\u0007+\u0019;i)\u0011\t\t-a4\u0011\u000b\u0005\r\u00171Z=\u000e\u0005\u0005\u0015'\u0002BA/\u0003\u000fT1!!3B\u0003!\u0019\u0017\r^1msN$\u0018\u0002BAg\u0003\u000b\u0014!cQ1tK&s7/\u001a8tSRLg/Z'ba\"9\u0011Q\u0016\u000bA\u0002\u0005]\u0016AD:bm\u0016$vNV\u0019T_V\u00148-\u001a\u000b\u0005\u0003K\u000b)\u000eC\u0004\u0002.V\u0001\r!a.\u0002\u0015%t7/\u001a:u\u0013:$x\u000e\u0006\u0003\u0002&\u0006m\u0007BBAo-\u0001\u0007\u00110A\u0005uC\ndWMT1nKR1\u0011QUAq\u0003gDq!a9\u0018\u0001\u0004\t)/A\u0004dCR\fGn\\4\u0011\t\u0005\u001d\u0018q^\u0007\u0003\u0003STA!a9\u0002l*\u0019\u0011Q^!\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BAy\u0003S\u0014QbQ1uC2|w\r\u00157vO&t\u0007bBA{/\u0001\u0007\u0011q_\u0001\u0006S\u0012,g\u000e\u001e\t\u0005\u0003O\fI0\u0003\u0003\u0002|\u0006%(AC%eK:$\u0018NZ5feR!\u0011QUA\u0000\u0011\u001d\u0011\t\u0001\u0007a\u0001\u0005\u0007\t!\u0002^1cY\u0016LE-\u001a8u!\u0011\u0011)Aa\u0002\u000e\u0005\u0005\u001d\u0017\u0002\u0002B\u0005\u0003\u000f\u0014q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u0013O\u0016$xK]5uKB\u0013\u0018N^5mK\u001e,7/\u0006\u0002\u0003\u0010A1!\u0011\u0003B\r\u0005?qAAa\u0005\u0003\u00189\u0019AP!\u0006\n\u0003=K!a\u001b(\n\t\tm!Q\u0004\u0002\u0004'\u0016\f(BA6O!\u0011\t9O!\t\n\t\t\r\u0012\u0011\u001e\u0002\u0014)\u0006\u0014G.Z,sSR,\u0007K]5wS2,w-Z\u0001\u000eO\u0016$()^2lKR\u001c\u0006/Z2\u0016\u0005\t%\u0002#B'\u0002:\n-\u0002\u0003\u0002B\u0017\u0005ci!Aa\f\u000b\t\u0005\r\u0018qY\u0005\u0005\u0005g\u0011yC\u0001\u0006Ck\u000e\\W\r^*qK\u000e\f\u0011#Y:tKJ$hj\u001c;Ck\u000e\\W\r^3e)\u0011\t)K!\u000f\t\r\tm2\u00041\u0001z\u0003%y\u0007/\u001a:bi&|g.\u0001\u000bbgN,'\u000f\u001e(piB\u000b'\u000f^5uS>tW\r\u001a\u000b\u0005\u0003K\u0013\t\u0005\u0003\u0004\u0003<q\u0001\r!_\u0001\fg\u00064X-Q:UC\ndW\r\u0006\u0003\u0002&\n\u001d\u0003BBAo;\u0001\u0007\u0011\u0010\u0006\u0005\u0002&\n-#1\u000bB+\u0011\u001d\t\u0019O\ba\u0001\u0005\u001b\u0002B!a:\u0003P%!!\u0011KAu\u00051!\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0011\u001d\t)P\ba\u0001\u0003oDqAa\u0016\u001f\u0001\u0004\u0011I&A\u0005oC6,\u0007+\u0019:ugB)!\u0011\u0003B\rsR!\u0011Q\u0015B/\u0011\u001d\u0011\ta\ba\u0001\u0005\u0007\t1b\u0019:fCR,G+\u00192mKR!\u0011Q\u0015B2\u0011\u001d\u0011\t\u0001\ta\u0001\u0005\u0007\t\u0001\u0003]1si&$\u0018n\u001c8j]\u001e\f5O\u0016\u001a\u0016\u0005\t%\u0004C\u0002B\t\u00053\u0011Y\u0007\u0005\u0003\u0003n\tMTB\u0001B8\u0015\u0011\u0011\t(a;\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0005k\u0012yGA\u0005Ue\u0006t7OZ8s[\u0006y2\r[3dWB\u000b'\u000f^5uS>t\u0017N\\4NCR\u001c\u0007.Z:WeQ\u000b'\r\\3\u0015\t\u0005\u0015&1\u0010\u0005\b\u0005{\u0012\u0003\u0019\u0001B@\u00035)\u00070[:uS:<G+\u00192mKB!\u0011q\u001dBA\u0013\u0011\u0011\u0019)!;\u0003\u000bQ\u000b'\r\\3\u0002\t)$'m\u0019\u000b\t\u0003K\u0013II!$\u0003\u0012\"1!1R\u0012A\u0002e\f1!\u001e:m\u0011\u0019\u0011yi\ta\u0001s\u0006)A/\u00192mK\"9!1S\u0012A\u0002\tU\u0015\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000f\u0005\u0003\u0002Z\t]\u0015\u0002\u0002BM\u00037\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0011Q7o\u001c8\u0015\t\u0005\u0015&q\u0014\u0005\u0007\u0003[#\u0003\u0019A=\u0002\u000fA\f'/];fiR!\u0011Q\u0015BS\u0011\u0019\ti+\na\u0001s\u0006\u0019qN]2\u0015\t\u0005\u0015&1\u0016\u0005\u0007\u0003[3\u0003\u0019A=\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003K\u0013\t\f\u0003\u0004\u0002.\u001e\u0002\r!_\u0001\u0004GN4H\u0003BAS\u0005oCa!!,)\u0001\u0004I\u0018A\u0003:v]\u000e{W.\\1oIR!!Q\u0018Bj)\u0011\t)Ka0\t\u000f\t\u0005\u0017\u00061\u0001\u0003D\u000691m\\7nC:$\u0007\u0003\u0002Bc\u0005\u001fl!Aa2\u000b\t\t%'1Z\u0001\bY><\u0017nY1m\u0015\u0011\u0011i-a2\u0002\u000bAd\u0017M\\:\n\t\tE'q\u0019\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u0004\u0003V&\u0002\rAa6\u0002\u000fM,7o]5p]B\u0019AK!7\n\u0007\tm\u0017I\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\tm_>\\W\u000f\u001d,3!J|g/\u001b3feR\u0011!\u0011\u001d\t\u0006\u001b\u0006e&1\u001d\t\u0005\u0003O\u0014)/\u0003\u0003\u0003h\u0006%(!\u0004+bE2,\u0007K]8wS\u0012,'/F\u0001z\u0003)\u0019x.\u001e:dK~#S-\u001d\u000b\u0005\u0003K\u0013y\u000f\u0003\u0005\u0003r2\n\t\u00111\u0001z\u0003\rAH%M\u0001\bg>,(oY3!+\u0005!\u0018\u0001C7pI\u0016|F%Z9\u0015\t\u0005\u0015&1 \u0005\t\u0005c|\u0013\u0011!a\u0001i\u0006)Qn\u001c3fA\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011\u0011\u0011Y\u0001\u0011Kb$(/Y(qi&|gn]0%KF$B!!*\u0004\b!I!\u0011\u001f\u001a\u0002\u0002\u0003\u0007\u0011\u0011Y\u0001\u000eKb$(/Y(qi&|gn\u001d\u0011\u0002'A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:\u0016\u0005\r=\u0001#B'\u0002:\ne\u0013a\u00069beRLG/[8oS:<7i\u001c7v[:\u001cx\fJ3r)\u0011\t)k!\u0006\t\u0013\tEX'!AA\u0002\r=\u0011\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b%A\tck\u000e\\W\r^\"pYVlgNT1nKN\fQCY;dW\u0016$8i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002&\u000e}\u0001\"\u0003Byq\u0005\u0005\t\u0019AB\b\u0003I\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm\u001d\u0011\u0016\u0005\r\u0015\u0002#B'\u0002:\u0006%\u0015A\u00048v[\n+8m[3ug~#S-\u001d\u000b\u0005\u0003K\u001bY\u0003C\u0005\u0003rn\n\t\u00111\u0001\u0004&\u0005Ya.^7Ck\u000e\\W\r^:!\u0003=\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001c\u0018aE:peR\u001cu\u000e\\;n]:\u000bW.Z:`I\u0015\fH\u0003BAS\u0007kA\u0011B!=?\u0003\u0003\u0005\raa\u0004\u0002!M|'\u000f^\"pYVlgNT1nKN\u0004\u0003f\u0001\u0001\u0004<A!1QHB!\u001b\t\u0019yDC\u0002\u0002|\rKAaa\u0011\u0004@\t11\u000b^1cY\u0016\u0004")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            return this.mode(SaveMode.Overwrite);
        }
        if ("append".equals(string)) {
            return this.mode(SaveMode.Append);
        }
        if ("ignore".equals(string)) {
            return this.mode(SaveMode.Ignore);
        }
        if ("error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string))) {
            return this.mode(SaveMode.ErrorIfExists);
        }
        throw new IllegalArgumentException(new StringBuilder(114).append("Unknown save mode: ").append(saveMode).append(". Accepted ").append("save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.").toString());
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenWritingError();
        }
        this.saveInternal((Option<String>)new Some((Object)path));
    }

    public void save() {
        this.saveInternal((Option<String>)None$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveInternal(Option<String> path) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
            CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
            scala.collection.immutable.Map finalOptions = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataFrameWriter.$anonfun$saveInternal$1(optionsWithPath, x$3))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
            CatalogManager catalogManager = this.df().sparkSession().sessionState().catalogManager();
            SaveMode saveMode = this.mode();
            if (SaveMode.Append.equals(saveMode) ? true : SaveMode.Overwrite.equals(saveMode)) {
                Tuple3 tuple3;
                TableProvider tableProvider = provider;
                if (tableProvider instanceof SupportsCatalogOptions) {
                    SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                    Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                    TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                    tuple3 = new Tuple3((Object)catalog.loadTable(ident), (Object)new Some((Object)catalog), (Object)new Some((Object)ident));
                } else {
                    if (tableProvider == null) throw new MatchError((Object)tableProvider);
                    Table t = this.getTable$1(provider, dsOptions);
                    if (DataSourceV2Implicits$.MODULE$.TableHelper(t).supports(TableCapability.BATCH_WRITE)) {
                        tuple3 = new Tuple3((Object)t, (Object)None$.MODULE$, (Object)None$.MODULE$);
                    } else {
                        this.saveToV1Source(path);
                        return;
                    }
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                Table table = (Table)tuple32._1();
                Option catalog = (Option)tuple32._2();
                Option ident = (Option)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)table, (Object)catalog, (Object)ident);
                Table table2 = (Table)tuple33._1();
                Option catalog2 = (Option)tuple33._2();
                Option ident2 = (Option)tuple33._3();
                DataSourceV2Relation relation = DataSourceV2Relation$.MODULE$.create(table2, catalog2, ident2, dsOptions);
                this.checkPartitioningMatchesV2Table(table2);
                SaveMode saveMode2 = this.mode();
                SaveMode saveMode3 = SaveMode.Append;
                if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                    this.runCommand(this.df().sparkSession(), (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), finalOptions));
                    return;
                }
                this.runCommand(this.df().sparkSession(), (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)relation, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), finalOptions));
                return;
            }
            TableProvider tableProvider = provider;
            if (tableProvider instanceof SupportsCatalogOptions) {
                SupportsCatalogOptions supportsCatalogOptions = (SupportsCatalogOptions)tableProvider;
                Identifier ident = supportsCatalogOptions.extractIdentifier(dsOptions);
                TableCatalog catalog = CatalogV2Util$.MODULE$.getTableProviderCatalog(supportsCatalogOptions, catalogManager, dsOptions);
                UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)Nil$.MODULE$), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
                String string3 = catalog.name();
                SaveMode saveMode4 = saveMode;
                SaveMode saveMode5 = SaveMode.Ignore;
                this.runCommand(this.df().sparkSession(), (LogicalPlan)new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier((Seq)((SeqLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).toSeq().$plus$colon((Object)string3, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)ident.name(), Seq$.MODULE$.canBuildFrom()), UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, finalOptions, !(saveMode4 != null ? !saveMode4.equals(saveMode5) : saveMode5 != null), CreateTableAsSelect$.MODULE$.apply$default$7()));
                return;
            } else {
                if (tableProvider == null) throw new MatchError((Object)tableProvider);
                if (DataSourceV2Implicits$.MODULE$.TableHelper(this.getTable$1(provider, dsOptions)).supports(TableCapability.BATCH_WRITE)) {
                    throw QueryCompilationErrors$.MODULE$.writeWithSaveModeUnsupportedBySourceError(this.source(), saveMode.name());
                }
                this.saveToV1Source(path);
            }
            return;
        }
        this.saveToV1Source(path);
    }

    private CaseInsensitiveMap<String> getOptionsWithPath(Option<String> path) {
        if (path.isEmpty()) {
            return this.extraOptions();
        }
        return this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
    }

    private void saveToV1Source(Option<String> path) {
        this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> {
            this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
            return BoxedUnit.UNIT;
        });
        CaseInsensitiveMap<String> optionsWithPath = this.getOptionsWithPath(path);
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = optionsWithPath.originalMap();
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    public void insertInto(String tableName) {
        Option option;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.partitionByDoesNotAllowedWhenUsingInsertIntoError();
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.insertInto(catalog, ident);
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                return;
            }
        }
        if (!(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.insertInto(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getWritePrivileges().toSet()).asJava());
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(TableIdentifier$.MODULE$.apply(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
                        return;
                    }
                    table = DataSourceV2Relation$.MODULE$.create(var7_3, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
                    var9_5 = this.mode();
                    if (!(SaveMode.Append.equals(var9_5) != false ? true : (SaveMode.ErrorIfExists.equals(var9_5) != false ? true : SaveMode.Ignore.equals(var9_5) != false))) break block3;
                    v0 /* !! */  = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap());
                    break block4;
                }
                if (!SaveMode.Overwrite.equals(var9_5)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.table().partitioning())).size() <= 0) ** GOTO lbl-1000
                v1 = conf.partitionOverwriteMode();
                var12_7 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v1 != null ? v1.equals(var12_7) == false : var12_7 != null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = dynamicPartitionOverwrite = false;
                }
                v0 /* !! */  = dynamicPartitionOverwrite ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap()) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap());
                break block4;
            }
            throw new MatchError((Object)var9_5);
        }
        command = v0 /* !! */ ;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent).requireWritePrivileges(this.getWritePrivileges()), Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$, this.df().logicalPlan(), !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null), false, InsertIntoStatement$.MODULE$.apply$default$7()));
    }

    private Seq<TableWritePrivilege> getWritePrivileges() {
        SaveMode saveMode = this.mode();
        if (SaveMode.Overwrite.equals(saveMode)) {
            return (Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)new .colon.colon((Object)TableWritePrivilege.DELETE, (List)Nil$.MODULE$));
        }
        return (Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)Nil$.MODULE$);
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.sortByWithoutBucketingError();
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.bucketByUnsupportedByOperationError(operation);
            }
            throw QueryCompilationErrors$.MODULE$.bucketByAndSortByUnsupportedByOperationError(operation);
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    public void saveAsTable(String tableName) {
        Option option;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined() || this.df().sparkSession().sessionState().conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).isDefined() && !(this.df().sparkSession().sessionState().catalogManager().catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()) instanceof CatalogExtension);
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option2 = this.df().sparkSession().sessionState().analyzer().NonSessionCatalogAndIdentifier().unapply(seq);
        if (!option2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
            Identifier ident = (Identifier)((Tuple2)option2.get())._2();
            this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
            return;
        }
        Option option3 = this.df().sparkSession().sessionState().analyzer().SessionCatalogAndIdentifier().unapply(seq);
        if (!option3.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
            Identifier ident = (Identifier)((Tuple2)option3.get())._2();
            if (canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident, (Seq<String>)seq);
                return;
            }
        }
        if (!(option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) {
            TableIdentifier tableIdentifier = (TableIdentifier)option.get();
            this.saveAsTable(tableIdentifier);
            return;
        }
        throw QueryCompilationErrors$.MODULE$.cannotFindCatalogToHandleIdentifierError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted());
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident, Seq<String> nameParts) {
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getWritePrivileges().toSet()).asJava()));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var7_5 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var7_5 != null && (var8_6 = (Option)var7_5._2()) instanceof Some && (var9_7 = (Some)var8_6).value() instanceof V1Table) {
            this.saveAsTable(TableIdentifier$.MODULE$.apply(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
            return;
        }
        if (var7_5 == null) ** GOTO lbl-1000
        var10_8 = (SaveMode)var7_5._1();
        var11_9 = (Option)var7_5._2();
        if (SaveMode.Append.equals(var10_8) && var11_9 instanceof Some) {
            var12_10 = (Some)var11_9;
            table = (Table)var12_10.value();
            this.checkPartitioningMatchesV2Table(table);
            v2Relation = DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident));
            v2 = AppendData$.MODULE$.byName((NamedRelation)v2Relation, this.df().logicalPlan(), this.extraOptions().toMap());
        } else if (var7_5 != null && SaveMode.Overwrite.equals(var15_13 = (SaveMode)var7_5._1())) {
            tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)Nil$.MODULE$), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v2 = new ReplaceTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, this.extraOptions().toMap(), true, ReplaceTableAsSelect$.MODULE$.apply$default$7());
        } else if (var7_5 != null) {
            other = (SaveMode)var7_5._1();
            tableSpec = new UnresolvedTableSpec(Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), new OptionList((Seq)Nil$.MODULE$), this.extraOptions().get("path"), this.extraOptions().get("comment"), (Option)None$.MODULE$, false);
            v3 = other;
            var19_17 = SaveMode.Ignore;
            v4 = !(v3 != null ? v3.equals(var19_17) == false : var19_17 != null);
            v2 = new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier(nameParts, UnresolvedIdentifier$.MODULE$.apply$default$2()), this.partitioningAsV2(), this.df().queryExecution().analyzed(), (TableSpecBase)tableSpec, this.extraOptions().toMap(), v4, CreateTableAsSelect$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)var7_5);
        }
        command = v2;
        this.runCommand(this.df().sparkSession(), (LogicalPlan)command);
    }

    private void saveAsTable(TableIdentifier tableIdent) {
        TableIdentifier qualifiedIdent;
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(qualifiedIdent = catalog.qualifyIdentifier(tableIdent));
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.Ignore.equals(saveMode)) {
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.ErrorIfExists.equals(saveMode)) {
                throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(qualifiedIdent);
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)tuple2._2();
            if (bl && SaveMode.Overwrite.equals(saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            return (B1)baseRelation;
                        }
                        if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            return (B1)hiveTableRelation.tableMeta().identifier();
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null) {
                            return true;
                        }
                        return logicalPlan2 instanceof HiveTableRelation;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(qualifiedIdent).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(qualifiedIdent);
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw QueryCompilationErrors$.MODULE$.cannotOverwriteTableThatIsBeingReadFromError(qualifiedIdent);
                }
                catalog.dropTable(qualifiedIdent, true, false);
                this.createTable(qualifiedIdent);
                catalog.refreshTable(qualifiedIdent);
                return;
            }
        }
        this.createTable(qualifiedIdent);
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap());
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        this.runCommand(this.df().sparkSession(), new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    private Seq<Transform> partitioningAsV2() {
        Seq partitioning2 = (Seq)this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)colNames -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Seq bucketing = Option$.MODULE$.option2Iterable(this.getBucketSpec().map((Function1 & Serializable & scala.Serializable)spec -> CatalogV2Implicits$.MODULE$.BucketSpecHelper(spec).asTransform())).toSeq();
        return (Seq)partitioning2.$plus$plus((GenTraversableOnce)bucketing, Seq$.MODULE$.canBuildFrom());
    }

    private void checkPartitioningMatchesV2Table(Table existingTable) {
        Seq<Transform> v2Partitions = this.partitioningAsV2();
        if (v2Partitions.isEmpty()) {
            return;
        }
        Predef$.MODULE$.require(v2Partitions.sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])existingTable.partitioning())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("The provided partitioning does not match of the table.\n").append(" - provided: ").append(v2Partitions.mkString(", ")).append("\n").append(" - table: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingTable.partitioning())).mkString(", ")).toString());
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (List)Nil$.MODULE$))));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, LogicalPlan command) {
        QueryExecution qe = new QueryExecution(session, command, this.df().queryExecution().tracker(), QueryExecution$.MODULE$.$lessinit$greater$default$4());
        qe.assertCommandExecuted();
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        Option<TableProvider> option = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        if (option instanceof Some && (some = (Some)option).value() instanceof FileDataSourceV2) {
            return None$.MODULE$;
        }
        return option;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$saveInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$3) {
        return !optionsWithPath$1.contains(x$3);
    }

    private final Table getTable$1(TableProvider provider$1, CaseInsensitiveStringMap dsOptions$1) {
        if (provider$1.supportsExternalMetadata()) {
            return provider$1.getTable(this.df().schema().asNullable(), (Transform[])this.partitioningAsV2().toArray(ClassTag$.MODULE$.apply(Transform.class)), dsOptions$1.asCaseSensitiveMap());
        }
        return DataSourceV2Utils$.MODULE$.getTableFromProvider(provider$1, dsOptions$1, (Option<StructType>)None$.MODULE$);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

