/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.regression.StreamingLinearRegressionWithSGD;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StreamingLinearRegressionExample$ {
    public static StreamingLinearRegressionExample$ MODULE$;

    static {
        new StreamingLinearRegressionExample$();
    }

    public void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: StreamingLinearRegressionExample <trainingDir> <testDir>");
            System.exit(1);
        }
        SparkConf conf = new SparkConf().setAppName("StreamingLinearRegressionExample");
        StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(1L));
        DStream trainingData = ssc.textFileStream(args[0]).map((Function1 & java.io.Serializable & Serializable)s -> LabeledPoint$.MODULE$.parse(s), ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
        DStream testData = ssc.textFileStream(args[1]).map((Function1 & java.io.Serializable & Serializable)s -> LabeledPoint$.MODULE$.parse(s), ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numFeatures = 3;
        StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.zeros(numFeatures));
        model.trainOn(trainingData);
        model.predictOnValues(testData.map((Function1 & java.io.Serializable & Serializable)lp -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)lp.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()).print();
        ssc.start();
        ssc.awaitTermination();
        ssc.stop(ssc.stop$default$1());
    }

    private StreamingLinearRegressionExample$() {
        MODULE$ = this;
    }
}

