/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.metrics.source.DoubleAccumulatorSource$;
import org.apache.spark.metrics.source.LongAccumulatorSource$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.LongAccumulator;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class AccumulatorMetricsTest$ {
    public static AccumulatorMetricsTest$ MODULE$;

    static {
        new AccumulatorMetricsTest$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().config("spark.metrics.conf.*.sink.console.class", "org.apache.spark.metrics.sink.ConsoleSink").getOrCreate();
        SparkContext sc = spark.sparkContext();
        LongAccumulator acc = sc.longAccumulator("my-long-metric");
        LongAccumulatorSource$.MODULE$.register(sc, new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"my-long-metric"), (Object)acc), (List)Nil$.MODULE$).toMap(Predef$.MODULE$.$conforms()));
        DoubleAccumulator acc2 = sc.doubleAccumulator("my-double-metric");
        DoubleAccumulatorSource$.MODULE$.register(sc, new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"my-double-metric"), (Object)acc2), (List)Nil$.MODULE$).toMap(Predef$.MODULE$.$conforms()));
        int num = args.length > 0 ? new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt() : 1000000;
        long startTime = System.nanoTime();
        sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), num), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
            acc.add(1L);
            acc2.add(1.1);
        });
        BoxedUnit accumulatorTest = BoxedUnit.UNIT;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Test took %.0f milliseconds")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - startTime) / 1000000.0))})));
        Predef$.MODULE$.println((Object)"Accumulator values:");
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("*** Long accumulator (my-long-metric): ").append(acc.value()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(43).append("*** Double accumulator (my-double-metric): ").append(acc2.value()).toString());
        spark.stop();
    }

    private AccumulatorMetricsTest$() {
        MODULE$ = this;
    }
}

