/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;

public class SubQueryUtils {
    static final CommonTreeAdaptor adaptor = new CommonTreeAdaptor();

    static void extractConjuncts(ASTNode node, List<ASTNode> conjuncts) {
        if (node.getType() != 33) {
            conjuncts.add(node);
            return;
        }
        SubQueryUtils.extractConjuncts((ASTNode)node.getChild(0), conjuncts);
        SubQueryUtils.extractConjuncts((ASTNode)node.getChild(1), conjuncts);
    }

    static ASTNode rewriteParentQueryWhere(ASTNode whereCond, ASTNode subQuery) throws SemanticException {
        ParentQueryWhereClauseRewrite rewrite = new ParentQueryWhereClauseRewrite(whereCond, subQuery);
        return rewrite.remove();
    }

    static ASTNode constructTrueCond() {
        ASTNode eq = (ASTNode)ParseDriver.adaptor.create(18, "=");
        ASTNode lhs = (ASTNode)ParseDriver.adaptor.create(340, "1");
        ASTNode rhs = (ASTNode)ParseDriver.adaptor.create(340, "1");
        ParseDriver.adaptor.addChild((Object)eq, (Object)lhs);
        ParseDriver.adaptor.addChild((Object)eq, (Object)rhs);
        return eq;
    }

    static ASTNode andAST(ASTNode left, ASTNode right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Object o = ParseDriver.adaptor.create(33, "AND");
        ParseDriver.adaptor.addChild(o, (Object)left);
        ParseDriver.adaptor.addChild(o, (Object)right);
        return (ASTNode)o;
    }

    static ASTNode orAST(ASTNode left, ASTNode right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Object o = ParseDriver.adaptor.create(202, "OR");
        ParseDriver.adaptor.addChild(o, (Object)left);
        ParseDriver.adaptor.addChild(o, (Object)right);
        return (ASTNode)o;
    }

    static ASTNode isNull(ASTNode expr) {
        ASTNode node = (ASTNode)ParseDriver.adaptor.create(763, "TOK_FUNCTION");
        node.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(798, "TOK_ISNULL")));
        node.addChild((Tree)expr);
        return node;
    }

    static List<ASTNode> findSubQueries(ASTNode node) throws SemanticException {
        ArrayList<ASTNode> subQueries = new ArrayList<ASTNode>();
        SubQueryUtils.findSubQueries(node, subQueries);
        return subQueries;
    }

    private static void findSubQueries(ASTNode node, List<ASTNode> subQueries) {
        ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
        stack.push(node);
        block3: while (!stack.isEmpty()) {
            ASTNode next = (ASTNode)stack.pop();
            switch (next.getType()) {
                case 942: {
                    subQueries.add(next);
                    continue block3;
                }
            }
            int childCount = next.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                stack.push((ASTNode)next.getChild(i));
            }
        }
    }

    static QBSubQuery buildSubQuery(String outerQueryId, int sqIdx, ASTNode sqAST, ASTNode originalSQAST, Context ctx) throws SemanticException {
        ASTNode sqOp = (ASTNode)sqAST.getChild(0);
        ASTNode sq = (ASTNode)sqAST.getChild(1);
        ASTNode outerQueryExpr = (ASTNode)sqAST.getChild(2);
        if (outerQueryExpr != null && outerQueryExpr.getType() == 942) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(originalSQAST.getChild(1), "Only 1 SubQuery expression is supported."));
        }
        return new QBSubQuery(outerQueryId, sqIdx, sq, outerQueryExpr, SubQueryUtils.buildSQOperator(sqOp), originalSQAST, ctx);
    }

    static QBSubQuery.SubQueryTypeDef buildSQOperator(ASTNode astSQOp) throws SemanticException {
        ASTNode opAST = (ASTNode)astSQOp.getChild(0);
        QBSubQuery.SubQueryType type = QBSubQuery.SubQueryType.get(opAST);
        return new QBSubQuery.SubQueryTypeDef(opAST, type);
    }

    static int checkAggOrWindowing(ASTNode expressionTree) throws SemanticException {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 763 || exprTokenType == 764 || exprTokenType == 765) {
            String functionName;
            GenericUDAFResolver udafResolver;
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(expressionTree.getChildCount() - 1).getType() == 1016) {
                return 3;
            }
            if (expressionTree.getChild(0).getType() == 24 && (udafResolver = FunctionRegistry.getGenericUDAFResolver(functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText()))) != null) {
                if (udafResolver instanceof GenericUDAFCount) {
                    return 2;
                }
                return 1;
            }
        }
        int r = 0;
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            int c = SubQueryUtils.checkAggOrWindowing((ASTNode)expressionTree.getChild(i));
            r = Math.max(r, c);
        }
        return r;
    }

    static List<String> getTableAliasesInSubQuery(ASTNode fromClause) {
        ArrayList<String> aliases = new ArrayList<String>();
        SubQueryUtils.getTableAliasesInSubQuery((ASTNode)fromClause.getChild(0), aliases);
        return aliases;
    }

    private static void getTableAliasesInSubQuery(ASTNode joinNode, List<String> aliases) {
        if (joinNode.getToken().getType() == 977 || joinNode.getToken().getType() == 941 || joinNode.getToken().getType() == 875) {
            String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)joinNode.getChild(0)).toLowerCase();
            String alias = joinNode.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(joinNode.getChild(joinNode.getChildCount() - 1).getText().toLowerCase());
            alias = joinNode.getToken().getType() == 875 ? SemanticAnalyzer.unescapeIdentifier(joinNode.getChild(1).getText().toLowerCase()) : alias;
            aliases.add(alias);
        } else {
            ASTNode left = (ASTNode)joinNode.getChild(0);
            ASTNode right = (ASTNode)joinNode.getChild(1);
            SubQueryUtils.getTableAliasesInSubQuery(left, aliases);
            SubQueryUtils.getTableAliasesInSubQuery(right, aliases);
        }
    }

    static ASTNode hasUnQualifiedColumnReferences(ASTNode ast) {
        int type = ast.getType();
        if (type == 16) {
            return null;
        }
        if (type == 973) {
            return ast;
        }
        for (int i = 0; i < ast.getChildCount(); ++i) {
            ASTNode c = SubQueryUtils.hasUnQualifiedColumnReferences((ASTNode)ast.getChild(i));
            if (c == null) continue;
            return c;
        }
        return null;
    }

    static ASTNode setQualifiedColumnReferences(ASTNode ast, String tableAlias) {
        int type = ast.getType();
        if (type == 16) {
            return ast;
        }
        if (type == 973) {
            if (tableAlias == null) {
                return null;
            }
            String colName = SemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
            return SubQueryUtils.createColRefAST(tableAlias, colName);
        }
        for (int i = 0; i < ast.getChildCount(); ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            ASTNode c = SubQueryUtils.setQualifiedColumnReferences(child, tableAlias);
            if (c == null) {
                return null;
            }
            if (c == child) continue;
            ast.setChild(i, (Tree)c);
        }
        return ast;
    }

    static ASTNode subQueryWhere(ASTNode insertClause) {
        if (insertClause.getChildCount() > 2 && insertClause.getChild(2).getType() == 1013) {
            return (ASTNode)insertClause.getChild(2);
        }
        return null;
    }

    static ASTNode buildOuterQryToSQJoinCond(ASTNode outerQueryExpr, String sqAlias, RowResolver sqRR) {
        ASTNode node = (ASTNode)ParseDriver.adaptor.create(18, "=");
        node.addChild((Tree)outerQueryExpr);
        node.addChild((Tree)SubQueryUtils.buildSQJoinExpr(sqAlias, sqRR));
        return node;
    }

    static ASTNode buildSQJoinExpr(String sqAlias, RowResolver sqRR) {
        ArrayList<ColumnInfo> signature = sqRR.getRowSchema().getSignature();
        ColumnInfo joinColumn = (ColumnInfo)signature.get(0);
        String[] joinColName = sqRR.reverseLookup(joinColumn.getInternalName());
        return SubQueryUtils.createColRefAST(sqAlias, joinColName[1]);
    }

    static ASTNode buildOuterJoinPostCond(String sqAlias, RowResolver sqRR) {
        return SubQueryUtils.isNull(SubQueryUtils.buildSQJoinExpr(sqAlias, sqRR));
    }

    static String getAlias(Operator o, Map<String, Operator> aliasToOpInfo) {
        for (Map.Entry<String, Operator> e : aliasToOpInfo.entrySet()) {
            if (e.getValue() != o) continue;
            return e.getKey();
        }
        return null;
    }

    static ASTNode createColRefAST(String tabAlias, String colName) {
        ASTNode dot = (ASTNode)ParseDriver.adaptor.create(16, ".");
        ASTNode tabAst = SubQueryUtils.createTabRefAST(tabAlias);
        ASTNode colAst = (ASTNode)ParseDriver.adaptor.create(24, colName);
        dot.addChild((Tree)tabAst);
        dot.addChild((Tree)colAst);
        return dot;
    }

    static ASTNode createAliasAST(String colName) {
        return (ASTNode)ParseDriver.adaptor.create(24, colName);
    }

    static ASTNode createTabRefAST(String tabAlias) {
        ASTNode tabAst = (ASTNode)ParseDriver.adaptor.create(973, "TOK_TABLE_OR_COL");
        ASTNode tabName = (ASTNode)ParseDriver.adaptor.create(24, tabAlias);
        tabAst.addChild((Tree)tabName);
        return tabAst;
    }

    static ASTNode buildSelectExpr(ASTNode expression) {
        ASTNode selAst = (ASTNode)ParseDriver.adaptor.create(901, "TOK_SELEXPR");
        selAst.addChild((Tree)expression);
        return selAst;
    }

    static ASTNode buildGroupBy() {
        ASTNode gBy = (ASTNode)ParseDriver.adaptor.create(772, "TOK_GROUPBY");
        return gBy;
    }

    static ASTNode createSelectItem(ASTNode expr, ASTNode alias) {
        ASTNode selectItem = (ASTNode)ParseDriver.adaptor.create(901, "TOK_SELEXPR");
        selectItem.addChild((Tree)expr);
        selectItem.addChild((Tree)alias);
        return selectItem;
    }

    static ASTNode alterCorrelatedPredicate(ASTNode correlatedExpr, ASTNode sqAlias, boolean left) {
        if (left) {
            correlatedExpr.setChild(0, (Tree)sqAlias);
        } else {
            correlatedExpr.setChild(1, (Tree)sqAlias);
        }
        return correlatedExpr;
    }

    static void addGroupExpressionToFront(ASTNode gBy, ASTNode expr) {
        ASTNode grpExpr = (ASTNode)ParseDriver.adaptor.create(774, "TOK_GROUPING_SETS_EXPRESSION");
        grpExpr.addChild((Tree)expr);
        ArrayList<ASTNode> newChildren = new ArrayList<ASTNode>();
        newChildren.add(expr);
        for (int i = gBy.getChildCount() - 1; i >= 0; --i) {
            newChildren.add((ASTNode)gBy.deleteChild(i));
        }
        for (ASTNode child : newChildren) {
            gBy.addChild((Tree)child);
        }
    }

    static ASTNode buildPostJoinNullCheck(List<ASTNode> subQueryJoinAliasExprs) {
        ASTNode check = null;
        for (ASTNode expr : subQueryJoinAliasExprs) {
            check = SubQueryUtils.orAST(check, SubQueryUtils.isNull(expr));
        }
        return check;
    }

    static ASTNode buildNotInNullCheckQuery(ASTNode subQueryAST, String subQueryAlias, String cntAlias, List<ASTNode> corrExprs, RowResolver sqRR) {
        subQueryAST = (ASTNode)ParseDriver.adaptor.dupTree((Object)subQueryAST);
        ASTNode qry = (ASTNode)ParseDriver.adaptor.create(876, "TOK_QUERY");
        qry.addChild((Tree)SubQueryUtils.buildNotInNullCheckFrom(subQueryAST, subQueryAlias));
        ASTNode insertAST = SubQueryUtils.buildNotInNullCheckInsert();
        qry.addChild((Tree)insertAST);
        insertAST.addChild((Tree)SubQueryUtils.buildNotInNullCheckSelect(cntAlias));
        insertAST.addChild((Tree)SubQueryUtils.buildNotInNullCheckWhere(subQueryAST, subQueryAlias, corrExprs, sqRR));
        return qry;
    }

    static ASTNode buildNotInNullCheckFrom(ASTNode subQueryAST, String subQueryAlias) {
        ASTNode from = (ASTNode)ParseDriver.adaptor.create(761, "TOK_FROM");
        ASTNode sqExpr = (ASTNode)ParseDriver.adaptor.create(941, "TOK_SUBQUERY");
        sqExpr.addChild((Tree)subQueryAST);
        sqExpr.addChild((Tree)SubQueryUtils.createAliasAST(subQueryAlias));
        from.addChild((Tree)sqExpr);
        return from;
    }

    static ASTNode buildNotInNullCheckInsert() {
        ASTNode insert = (ASTNode)ParseDriver.adaptor.create(782, "TOK_INSERT");
        ASTNode dest = (ASTNode)ParseDriver.adaptor.create(734, "TOK_DESTINATION");
        ASTNode dir = (ASTNode)ParseDriver.adaptor.create(736, "TOK_DIR");
        ASTNode tfile = (ASTNode)ParseDriver.adaptor.create(986, "TOK_TMP_FILE");
        insert.addChild((Tree)dest);
        dest.addChild((Tree)dir);
        dir.addChild((Tree)tfile);
        return insert;
    }

    static ASTNode buildNotInNullCheckSelect(String cntAlias) {
        ASTNode select = (ASTNode)ParseDriver.adaptor.create(899, "TOK_SELECT");
        ASTNode selectExpr = (ASTNode)ParseDriver.adaptor.create(901, "TOK_SELEXPR");
        ASTNode countStar = (ASTNode)ParseDriver.adaptor.create(765, "TOK_FUNCTIONSTAR");
        ASTNode alias = SubQueryUtils.createAliasAST(cntAlias);
        countStar.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(24, "count")));
        select.addChild((Tree)selectExpr);
        selectExpr.addChild((Tree)countStar);
        selectExpr.addChild((Tree)alias);
        return select;
    }

    static ASTNode buildNotInNullCheckWhere(ASTNode subQueryAST, String sqAlias, List<ASTNode> corrExprs, RowResolver sqRR) {
        ASTNode sqSelect = (ASTNode)subQueryAST.getChild(1).getChild(1);
        ASTNode selExpr = (ASTNode)sqSelect.getChild(0);
        String colAlias = null;
        if (selExpr.getChildCount() == 2) {
            colAlias = selExpr.getChild(1).getText();
        } else if (selExpr.getChild(0).getType() != 651) {
            colAlias = sqAlias + "_ninc_col0";
            selExpr.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(24, colAlias)));
        } else {
            ArrayList<ColumnInfo> signature = sqRR.getRowSchema().getSignature();
            ColumnInfo joinColumn = (ColumnInfo)signature.get(0);
            String[] joinColName = sqRR.reverseLookup(joinColumn.getInternalName());
            colAlias = joinColName[1];
        }
        ASTNode searchCond = SubQueryUtils.isNull(SubQueryUtils.createColRefAST(sqAlias, colAlias));
        for (ASTNode e : corrExprs) {
            ASTNode p = (ASTNode)ParseDriver.adaptor.dupTree((Object)e);
            p = SubQueryUtils.isNull(p);
            searchCond = SubQueryUtils.orAST(searchCond, p);
        }
        ASTNode where = (ASTNode)ParseDriver.adaptor.create(1013, "TOK_WHERE");
        where.addChild((Tree)searchCond);
        return where;
    }

    static ASTNode buildNotInNullJoinCond(String subqueryAlias, String cntAlias) {
        ASTNode eq = (ASTNode)ParseDriver.adaptor.create(18, "=");
        eq.addChild((Tree)SubQueryUtils.createColRefAST(subqueryAlias, cntAlias));
        eq.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(340, "0")));
        return eq;
    }

    static void checkForSubqueries(ASTNode node) throws SemanticException {
        if (node.getType() == 942 && node.getParent().getType() != 192) {
            throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Invalid subquery. Subquery in SELECT could only be top-level expression"));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            SubQueryUtils.checkForSubqueries((ASTNode)node.getChild(i));
        }
    }

    public static void checkForTopLevelSubqueries(ASTNode selExprList) throws SemanticException {
        assert (selExprList.getType() == 899 || selExprList.getType() == 900);
        for (int i = 0; i < selExprList.getChildCount(); ++i) {
            ASTNode selExpr = (ASTNode)selExprList.getChild(i);
            assert (selExpr.getType() == 901 || selExpr.getType() == 343);
            if (selExpr.getType() == 343) continue;
            if (selExpr.getChildCount() == 1 && selExpr.getChild(0).getType() == 942) {
                if (selExprList.getType() != 900) continue;
                throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Invalid subquery. Subquery with DISTINCT clause is not supported!"));
            }
            for (int j = 0; j < selExpr.getChildCount(); ++j) {
                SubQueryUtils.checkForSubqueries((ASTNode)selExpr.getChild(j));
            }
        }
    }

    public static interface ISubQueryJoinInfo {
        public String getAlias();

        public JoinType getJoinType();

        public ASTNode getJoinConditionAST();

        public QBSubQuery getSubQuery();

        public ASTNode getSubQueryAST();

        public String getOuterQueryId();
    }

    static class ParentQueryWhereClauseRewrite {
        ASTNode root;
        ASTNode subQuery;

        ParentQueryWhereClauseRewrite(ASTNode root, ASTNode subQuery) {
            this.root = root;
            this.subQuery = subQuery;
        }

        ASTNode getParentInWhereClause(ASTNode node) {
            if (node == null || node == this.root) {
                return null;
            }
            return (ASTNode)node.getParent();
        }

        boolean removeSubQuery(ASTNode node) {
            if (node.getType() == 33) {
                boolean r = this.removeSubQuery((ASTNode)node.getChild(0));
                if (!r) {
                    r = this.removeSubQuery((ASTNode)node.getChild(1));
                }
                return r;
            }
            if (node.getType() == 192) {
                ASTNode child = (ASTNode)node.getChild(0);
                if (child == this.subQuery) {
                    ASTNode sqOpType = (ASTNode)this.subQuery.getChild(0).getChild(0);
                    if (sqOpType.getType() == 110) {
                        sqOpType.getToken().setType(944);
                    } else {
                        sqOpType.getToken().setType(945);
                    }
                    ASTNode parent = this.getParentInWhereClause(node);
                    if (parent == null) {
                        this.root = this.subQuery;
                    } else {
                        int nodeIdx = node.getChildIndex();
                        parent.setChild(nodeIdx, (Tree)this.subQuery);
                    }
                    return this.removeSubQuery(this.subQuery);
                }
                return false;
            }
            if (node == this.subQuery) {
                ASTNode parent = this.getParentInWhereClause(node);
                ASTNode gParent = this.getParentInWhereClause(parent);
                ASTNode sibling = null;
                if (parent != null) {
                    sibling = this.subQuery.getChildIndex() == 0 ? (ASTNode)parent.getChild(1) : (ASTNode)parent.getChild(0);
                }
                if (sibling == null) {
                    this.root = SubQueryUtils.constructTrueCond();
                } else if (gParent == null) {
                    this.root = sibling;
                } else {
                    int pIdx = parent.getChildIndex();
                    gParent.setChild(pIdx, (Tree)sibling);
                }
                return true;
            }
            return false;
        }

        ASTNode remove() throws SemanticException {
            boolean r = this.removeSubQuery(this.root);
            if (r) {
                return this.root;
            }
            throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(this.subQuery, "Only SubQuery expressions that are top level conjuncts are allowed"));
        }
    }
}

