/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;

public class DefaultWhiteboard
implements Whiteboard {
    private final Map<Class<?>, Set<Service>> registry = new HashMap();

    private synchronized <T> void registered(Class<T> type, Service service) {
        Set<Service> services = this.registry.get(type);
        if (services == null) {
            services = SetUtils.newIdentityHashSet();
            this.registry.put(type, services);
        }
        services.add(service);
    }

    private synchronized <T> void unregistered(Class<T> type, Service service) {
        Set<Service> services = this.registry.get(type);
        if (services != null) {
            services.remove(service);
        }
    }

    private synchronized <T> List<T> lookup(Class<T> type) {
        Set<Service> services = this.registry.get(type);
        if (services != null) {
            return services.stream().map(rec$ -> ((Service)rec$).getService()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private synchronized <T> List<T> lookup(Class<T> type, Map<String, String> filterProperties) {
        Set<Service> services = this.registry.get(type);
        if (services != null) {
            return services.stream().filter(s -> s.matches(filterProperties)).map(rec$ -> ((Service)rec$).getService()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public <T> Registration register(final Class<T> type, T service, Map<?, ?> properties) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(service);
        Validate.checkArgument(type.isInstance(service));
        final Service s = new Service(service, properties);
        this.registered(type, s);
        return new Registration(){

            @Override
            public void unregister() {
                DefaultWhiteboard.this.unregistered(type, s);
            }
        };
    }

    @Override
    public <T> Tracker<T> track(final Class<T> type) {
        Objects.requireNonNull(type);
        return new Tracker<T>(){

            @Override
            public List<T> getServices() {
                return DefaultWhiteboard.this.lookup(type);
            }

            @Override
            public void stop() {
            }
        };
    }

    @Override
    public <T> Tracker<T> track(final Class<T> type, final Map<String, String> filterProperties) {
        Objects.requireNonNull(type);
        return new Tracker<T>(){

            @Override
            public List<T> getServices() {
                return DefaultWhiteboard.this.lookup(type, filterProperties);
            }

            @Override
            public void stop() {
            }
        };
    }

    private static class Service {
        private final Object service;
        private final Map<?, ?> properties;

        private Service(@NotNull Object service, Map<?, ?> properties) {
            Objects.requireNonNull(service);
            this.service = service;
            this.properties = properties;
        }

        private Object getService() {
            return this.service;
        }

        private boolean matches(Map<String, String> properties) {
            return properties.entrySet().stream().allMatch(this::propertyMatches);
        }

        private boolean propertyMatches(Map.Entry<String, String> filterEntry) {
            String key = filterEntry.getKey();
            String expectedValue = filterEntry.getValue();
            if (this.properties == null || !this.properties.containsKey(key)) {
                return expectedValue == null;
            }
            Object value = this.properties.get(key);
            if (value == null) {
                return expectedValue == null;
            }
            return value.toString().equals(expectedValue);
        }
    }
}

