/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.AbstractRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ConflictAnnotatingRebaseDiff
extends AbstractRebaseDiff {
    public static final String CONFLICT = ":conflict";
    public static final String BASE = ":base";
    public static final String OURS = ":ours";

    public ConflictAnnotatingRebaseDiff(NodeBuilder builder) {
        super(builder);
    }

    @Override
    protected ConflictAnnotatingRebaseDiff createDiff(NodeBuilder builder, String name) {
        return new ConflictAnnotatingRebaseDiff(builder.child(name));
    }

    @Override
    protected void addExistingProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.ADD_EXISTING_PROPERTY);
        cb.child(BASE).setProperty(before);
        cb.child(OURS).setProperty(after);
    }

    @Override
    protected void changeDeletedProperty(NodeBuilder builder, PropertyState after, PropertyState base) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.CHANGE_DELETED_PROPERTY);
        cb.child(BASE).setProperty(base);
        cb.child(OURS).setProperty(after);
    }

    @Override
    protected void changeChangedProperty(NodeBuilder builder, PropertyState before, PropertyState after) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.CHANGE_CHANGED_PROPERTY);
        cb.child(BASE).setProperty(before);
        cb.child(OURS).setProperty(after);
    }

    @Override
    protected void deleteDeletedProperty(NodeBuilder builder, PropertyState before) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_DELETED_PROPERTY);
        cb.child(BASE).setProperty(before);
    }

    @Override
    protected void deleteChangedProperty(NodeBuilder builder, PropertyState before) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_CHANGED_PROPERTY);
        cb.child(BASE).setProperty(before);
    }

    @Override
    protected void addExistingNode(NodeBuilder builder, String name, NodeState before, NodeState after) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.ADD_EXISTING_NODE);
        cb.child(BASE).setChildNode(name, before);
        cb.child(OURS).setChildNode(name, after);
    }

    @Override
    protected void changeDeletedNode(NodeBuilder builder, String name, NodeState after, NodeState base) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.CHANGE_DELETED_NODE);
        cb.child(BASE).setChildNode(name, base);
        cb.child(OURS).setChildNode(name, after);
    }

    @Override
    protected void deleteDeletedNode(NodeBuilder builder, String name, NodeState before) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_DELETED_NODE);
        cb.child(BASE).setChildNode(name, before);
    }

    @Override
    protected void deleteChangedNode(NodeBuilder builder, String name, NodeState before) {
        NodeBuilder cb = ConflictAnnotatingRebaseDiff.conflictMarker(builder, ConflictType.DELETE_CHANGED_NODE);
        cb.child(BASE).setChildNode(name, before);
    }

    private static NodeBuilder conflictMarker(NodeBuilder builder, ConflictType ct) {
        return builder.child(CONFLICT).child(ct.getName());
    }
}

