/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class PathImpl
extends DynamicOperandImpl {
    private final String selectorName;
    private SelectorImpl selector;

    public PathImpl(String selectorName) {
        this.selectorName = selectorName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "path(" + PathImpl.quote(this.selectorName) + ")";
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return null;
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public PropertyValue currentProperty() {
        String path = this.selector.currentPath();
        if (path == null) {
            return null;
        }
        return PropertyValues.newString(path);
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (v == null) {
            return;
        }
        if (operator == Operator.NOT_EQUAL) {
            return;
        }
        if (f.getSelector().equals(this.selector)) {
            String path = v.getValue(Type.STRING);
            String fn = this.getFunction(f.getSelector());
            f.restrictProperty("function*" + fn, operator, PropertyValues.newString(path));
        }
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
        if (!f.getQueryLimits().getOptimizeInRestrictionsForFunctions()) {
            return;
        }
        String fn = this.getFunction(f.getSelector());
        if (fn != null) {
            f.restrictPropertyAsList("function*" + fn, list);
        }
    }

    @Override
    public String getFunction(SelectorImpl s) {
        if (!s.equals(this.selector)) {
            return null;
        }
        return "@:path";
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return s.equals(this.selector);
    }

    @Override
    int getPropertyType() {
        return 1;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new PathImpl(this.selectorName);
    }

    @Override
    public QueryIndex.OrderEntry getOrderEntry(SelectorImpl s, OrderingImpl o) {
        if (!s.equals(this.selector)) {
            return null;
        }
        return new QueryIndex.OrderEntry("function*" + this.getFunction(s), Type.STRING, o.isDescending() ? QueryIndex.OrderEntry.Order.DESCENDING : QueryIndex.OrderEntry.Order.ASCENDING);
    }
}

