/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

public class LongPropertyState
extends SinglePropertyState<Long> {
    private final long value;

    public LongPropertyState(@NotNull String name, long value) {
        super(name);
        this.value = value;
    }

    public static PropertyState createLongProperty(@NotNull String name, long value) {
        return new LongPropertyState(name, value);
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    @Override
    public Type<?> getType() {
        return Type.LONG;
    }
}

