/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlob
implements Blob {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBlob.class);
    private static final boolean DEBUG_BLOB_EQUAL_LOG = SystemPropertySupplier.create("oak.abstractblob.equal.log", false).loggingTo(LOG).formatSetMessage((name, value) -> String.format("%s set to: %s", name, value)).get();
    private static final long DEBUG_BLOB_EQUAL_LOG_LIMIT = SystemPropertySupplier.create("oak.abstractblob.equal.log.limit", 100000000L).loggingTo(LOG).formatSetMessage((name, value) -> String.format("%s set to: %s", name, value)).get();
    private ByteBuffer hashCode;

    public static boolean equal(Blob a, Blob b) {
        long al = a.length();
        long bl = b.length();
        if (al != -1L && bl != -1L && al != bl) {
            return false;
        }
        String ai = a.getContentIdentity();
        String bi = b.getContentIdentity();
        if (ai != null && ai.equals(bi)) {
            return true;
        }
        if (DEBUG_BLOB_EQUAL_LOG && al > DEBUG_BLOB_EQUAL_LOG_LIMIT) {
            LOG.debug("Blobs have the same length of {} and we're falling back to byte-wise comparison.", (Object)al);
        }
        try {
            return IOUtils.contentEquals((InputStream)a.getNewStream(), (InputStream)b.getNewStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Blob equality check failed", e);
        }
    }

    protected AbstractBlob(ByteBuffer hashCode) {
        this.hashCode = hashCode;
    }

    protected AbstractBlob() {
        this(null);
    }

    private synchronized ByteBuffer getSha256() {
        if (this.hashCode == null) {
            try {
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                this.hashCode = ByteBuffer.wrap(sha256.digest(this.getNewStream().readAllBytes()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Hash calculation failed", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.hashCode;
    }

    @Override
    @Nullable
    public String getReference() {
        return null;
    }

    @Override
    public String getContentIdentity() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AbstractBlob) {
            AbstractBlob that = (AbstractBlob)other;
            AbstractBlob abstractBlob = this;
            synchronized (abstractBlob) {
                if (this.hashCode != null) {
                    AbstractBlob abstractBlob2 = that;
                    synchronized (abstractBlob2) {
                        if (that.hashCode != null) {
                            return this.hashCode.equals(that.hashCode);
                        }
                    }
                }
            }
        }
        return other instanceof Blob && AbstractBlob.equal(this, (Blob)other);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        byte[] bytes = this.getSha256().array();
        BigInteger bigInteger = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "x", bigInteger);
    }
}

